#include <SPAD/AC.H>
#include <SPAD/LIBC.H>
#include <MALLOC.H>
#include <SPAD/BIO_KRNL.H>

#include "RAID.H"

DECL_AST(RAID_DONE, SPL_RAID, BIORQ)
{
	RAID_BIORQ *rq = GET_STRUCT(RQ, RAID_BIORQ, b);
	RAID *raid;
	BIORQ *caller;
	if (rq->desc1.next_to_free) {
		RAID_BIODESC *d = rq->desc1.next_to_free;
		RAID_BIODESC *n;
		do {
			n = d->next_to_free;
			free(d);
		} while ((d = n));
		rq->desc1.next_to_free = NULL;
	}
	raid = rq->raid;
	caller = rq->caller;
	if (__unlikely(rq->b.status < 0)) {
		if (!caller->tmp2) {
			caller->tmp2 = rq->b.status;
		}
	}
	KERNEL$SLAB_CHECK(&raid->biorq, "raid done");
	__slfree(rq);
	WQ_WAKE_ALL(&raid->biorq_wait);
#if __DEBUG >= 1
	if (!caller->tmp3)
		KERNEL$SUICIDE("RAID_DONE: REQUEST COUNT UNDERFLOW");
#endif
	if (__unlikely(--caller->tmp3))
		RETURN;
	if (__unlikely(caller->nsec) && __likely(!caller->tmp2)) {
		BIO_UNDO_PARTITION(caller);
		BIO_CHECK_REQUEST("RAID_DONE", caller);
		RETURN_IORQ_LSTAT(caller, KERNEL$WAKE_BIO);
	}
	caller->status = caller->tmp2;
	RETURN_BIO(caller);
}

void RAID_CTOR(struct __slhead *g, void *o)
{
	RAID *raid = GET_STRUCT(g, RAID, biorq);
	RAID_BIORQ *rq = o;
	rq->raid = raid;
	rq->desc1.next_to_free = NULL;
}

void RAID_SPECIAL(RAID *raid, BIORQ *RQ)
{
	if (__unlikely(RQ->flags & ~BIO_FLAG_MASK))
		KERNEL$SUICIDE("RAID_SPECIAL: BAD REQUEST, FLAGS %08X", RQ->flags);
	BIO_CHECK_REQUEST("RAID_SPECIAL", RQ);
	if (__likely(RQ->flags & BIO_FLUSH)) {
		RAID_BIORQ *rq;
		if (__unlikely(raid->ro)) {
			RQ->status = 0;
			goto call_bio_ret;
		}
		rq = __slalloc(&raid->biorq);
		if (__unlikely(!rq)) {
			WQ_WAIT(&raid->biorq_wait, RQ, KERNEL$WAKE_BIO);
			return;
		}
		if (__unlikely(((unsigned)RQ->nsec - 1) >= raid->n_devices))
			KERNEL$SUICIDE("RAID_SPECIAL: INVALID NUMBER OF SECTORS FOR FLUSH: %d, FLAGS %d", RQ->nsec, RQ->flags);
		rq_allocated:
		rq->b.sec = 0;
		rq->b.nsec = 1;
		rq->caller = RQ;
		rq->b.proc = RQ->proc;
		rq->b.flags = RQ->flags;
		rq->b.desc = NULL;
		rq->b.fault_sec = -1;
		rq->b.fn = RAID_DONE;
		rq->b.h = raid->devices[RQ->nsec - 1].h;
		CALL_IORQ(&rq->b, KERNEL$BIO);
		RQ->nsec++;
		if (__likely(RQ->nsec - 1 != raid->n_devices)) {
			rq = __slalloc(&raid->biorq);
			if (__unlikely(!rq)) return;
			RQ->tmp3++;
			goto rq_allocated;
		}
		RQ->nsec = 0;
		return;
	}
	RQ->status = -EACCES;
	call_bio_ret:
	CALL_BIO(RQ);
}

