#include <SPAD/AC.H>
#include <SPAD/SYNC.H>
#include <SPAD/LIBC.H>
#include <SPAD/DEV_KRNL.H>
#include <SPAD/SLAB.H>
#include <STRING.H>
#include <UNISTD.H>
#include <VALUES.H>
#include <SPAD/BIO_KRNL.H>

#include "RAID.H"

static IO_STUB RAIDLN_FN;

const HANDLE_OPERATIONS RAIDLN_OPERATIONS = {
	SPL_X(SPL_RAID),
	KERNEL$NO_VSPACE_GET,
	KERNEL$NO_VSPACE_PUT,
	KERNEL$NO_VSPACE_MAP,
	KERNEL$NO_VSPACE_DMALOCK,
	KERNEL$NO_VSPACE_DMA64LOCK,
	KERNEL$NO_VSPACE_PHYSLOCK,
	KERNEL$NO_VSPACE_GET_PAGEIN_RQ,
	KERNEL$NO_VSPACE_GET_PAGE,
	KERNEL$NO_VSPACE_SWAP_OP,
	NULL,			/* clone */
	BIO$LOOKUP_PARTITION,	/* lookup */
	NULL,			/* create */
	NULL,			/* delete */
	NULL,			/* rename */
	NULL,			/* lookup_io */
	BIO$INSTANTIATE_PARTITION,	/* instantiate */
	NULL,			/* leave */
	BIO$DETACH,		/* detach */
	NULL,			/* close */
	BIO$READ,		/* READ */
	BIO$WRITE,		/* WRITE */
	BIO$AREAD,		/* AREAD */
	BIO$AWRITE,		/* AWRITE */
	BIO$IOCTL,		/* IOCTL */
	RAIDLN_FN,		/* BIO */
	KERNEL$NO_OPERATION,	/* PKTIO */
};

static void RAIDLN_SPLIT(RAID_BIORQ *rq, unsigned idx);

static DECL_IOCALL(RAIDLN_FN, SPL_RAID, BIORQ)
{
	unsigned idx, idx_last;
	RAID *raid;
	RAID_BIORQ *rq;
	HANDLE *h = RQ->handle;
	if (__unlikely(h->op != &RAIDLN_OPERATIONS)) RETURN_IORQ_LSTAT(RQ, KERNEL$WAKE_BIO);
	SWITCH_PROC_ACCOUNT(RQ->proc, SPL_X(SPL_RAID));
	RQ->tmp2 = 0;	/* future status */
	RQ->tmp3 = 1;	/* number of outstanding requests */
	raid = ((PARTITION *)h->fnode)->dev;
	if (__unlikely(RQ->flags & (raid->ro | BIO_FLUSH | ~BIO_FLAG_MASK))) {
		RAID_SPECIAL(raid, RQ);
		RETURN;
	}
	BIO_TRANSLATE_PARTITION;
	rq = __slalloc(&raid->biorq);
	if (__unlikely(!rq)) {
		WQ_WAIT(&raid->biorq_wait, RQ, KERNEL$WAKE_BIO);
		RETURN;
	}
	rq->caller = RQ;
	rq->b.flags = RQ->flags;
	rq->b.proc = RQ->proc;
	rq->b.desc = RQ->desc;
	rq->b.nsec = RQ->nsec;
	RQ->nsec = 0;
	rq->b.fault_sec = -1;
	rq->b.fn = RAID_DONE;
	idx = 0;
	idx_last = raid->n_devices;
	while (idx_last != idx + 1) {
		unsigned idx_half = (idx + idx_last) >> 1;
		if (raid->devices[idx_half].sector <= RQ->sec) idx = idx_half;
		else idx_last = idx_half;
	}
	rq->b.h = raid->devices[idx].h;
	rq->b.sec = RQ->sec - raid->devices[idx].sector;
	if (__unlikely(RQ->sec + rq->b.nsec > raid->devices[idx + 1].sector)) RAIDLN_SPLIT(rq, idx);
	RETURN_IORQ(&rq->b, KERNEL$BIO);

	out:
	out2:
	RQ->status = -ERANGE;
	RETURN_BIO(RQ);
}

static void RAIDLN_SPLIT(RAID_BIORQ *rq, unsigned idx)
{
	RAID *raid = rq->raid;
	BIORQ *RQ = rq->caller;
	unsigned new_size;
	BIODESC **bdp, *bd;
	if (__unlikely(idx == raid->n_devices - 1))
		/* this should be failed by the partition remapping code */
		KERNEL$SUICIDE("RAID_SPLIT: ACCESS BEYOND END OF LAST DEVICE, SECTOR %"__sec_t_format"X, SIZE %"__sec_t_format"X", RQ->sec, raid->devices[raid->n_devices].sector);
	new_size = raid->devices[idx + 1].sector - RQ->sec;
	RQ->nsec = rq->b.nsec - new_size;
	RQ->sec += new_size;
	rq->b.nsec = new_size;
	bdp = &rq->b.desc;
	next_bd:
	bd = *bdp;
	if (bd->v.len >> BIO_SECTOR_SIZE_BITS < new_size) {
		new_size -= bd->v.len >> BIO_SECTOR_SIZE_BITS;
		bdp = &bd->next;
		goto next_bd;
	}
	if (bd->v.len >> BIO_SECTOR_SIZE_BITS == new_size) {
		RQ->desc = bd->next;
		bd->next = NULL;
	} else {
		rq->desc1.desc.v.vspace = bd->v.vspace;
		rq->desc1.desc.next = NULL;
		rq->desc1.desc.v.len = (unsigned long)new_size << BIO_SECTOR_SIZE_BITS;
		rq->desc1.desc.v.ptr = bd->v.ptr;
		bd->v.ptr += (unsigned long)new_size << BIO_SECTOR_SIZE_BITS;
		bd->v.len -= (unsigned long)new_size << BIO_SECTOR_SIZE_BITS;
		RQ->desc = bd;
		*bdp = &rq->desc1.desc;
	}
	BIO_CHECK_REQUEST("RAIDLN_SPLIT", RQ);
}

__COLD_ATTR__ __sec_t RAIDLN_INIT(RAID *raid)
{
	unsigned dev_n;
	__usec_t size = 0;
	for (dev_n = 0; dev_n < raid->n_devices; dev_n++) {
		long rs, ws, bs;
		__usec_t c;

		GET_DEVICE_PARAMS(raid->devices[dev_n].h, &rs, &ws, &bs);
		if (rs > 0 && rs < MAXINT && rs > raid->read_request_size)
			raid->read_request_size = rs;
		if (ws > 0 && ws < MAXINT && ws > raid->write_request_size)
			raid->write_request_size = ws;
		if (bs > 0 && !(bs & (bs - 1))) {
			while (size & (bs - 1))
				bs >>= 1;
			if (bs > raid->physical_block_size)
				raid->physical_block_size = bs;
		}

		c = raid->devices[dev_n].sector;
		raid->devices[dev_n].sector = size;
		size += c;
		if ((__sec_t)size < 0) {
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "RAID: COMBINED DEVICE IS TOO LARGE");
			return -EFBIG;
		}
	}
	raid->devices[dev_n].sector = size;
	return size;
}
