#ifndef __SCSI_HOST_INIAREG_H
#define __SCSI_HOST_INIAREG_H

#include <SYS/TYPES.H>
#include <SPAD/DEV_KRNL.H>
#include <SPAD/SCSI.H>

#define ORC_REGSPACE		256
#define ORC_FW_SIZE		0x1000
#define ORC_NVRAM_SIZE		64

#define ORC_BIOS_SEGMENT	0x50
#define ORC_GINTS		0xa0
#define ORC_GIMSK		0xa1
#define  ORC_GIMSK_RPFIFO		0x04
#define ORC_GCFG		0xa2
#define  ORC_GCFG_EEPRG			0x01
#define ORC_GSTAT		0xa3
#define ORC_HDATA		0xa4
#define ORC_HCTRL		0xa5
#define  ORC_HCTRL_DEVRST		0x01
#define  ORC_HCTRL_HOSTSTOP		0x02
#define  ORC_HCTRL_HDO			0x40
#define  ORC_HCTRL_SCSIRST		0x80
#define ORC_HSTUS		0xa6
#define  ORC_HSTUS_RREADY		0x01
#define  ORC_HSTUS_HDI			0x02
#define ORC_NVRAM		0xa7
#define ORC_PQUEUE		0xa8
#define ORC_PQCNT		0xa9
#define ORC_RQUEUE		0xaa
#define ORC_RQCNT		0xab
#define ORC_FWBASEADR		0xac
#define ORC_EBIOSADDR0		0xb0
#define ORC_EBIOSADDR1		0xb1
#define ORC_EBIOSADDR2		0xb2
#define ORC_EBIOSDATA		0xb3
#define ORC_SCBSIZE		0xb7
#define ORC_SCBBASE0		0xb8
#define ORC_SCBBASE1		0xbc
#define ORC_RISCCTL		0xe0
#define  ORC_RISCCTL_DOWNLOAD		0x01
#define  ORC_RISCCTL_PRGMRST		0x02
#define ORC_PRGMCTR0		0xe2
#define ORC_PRGMCTR1		0xe3
#define ORC_RISCRAM		0xec

#define ORC_CMD_NOP		0x00
#define ORC_CMD_VERSION		0x01
#define ORC_CMD_ECHO		0x02
#define ORC_CMD_SET_NVM		0x03
#define ORC_CMD_GET_NVM		0x04
#define ORC_CMD_GET_BUS_STATUS	0x05
#define ORC_CMD_ABORT_SCB	0x06
#define ORC_CMD_ISSUE_SCB	0x07

#define ORC_NVRAM_SUBSYS_VENDOR_0	0x00
#define ORC_NVRAM_SUBSYS_VENDOR_1	0x01
#define ORC_NVRAM_SUBSYS_0		0x02
#define ORC_NVRAM_SUBSYS_1		0x03
#define ORC_NVRAM_SUBCLASS		0x04
#define ORC_NVRAM_VENDOR_0		0x05
#define ORC_NVRAM_VENDOR_1		0x06
#define ORC_NVRAM_0			0x07
#define ORC_NVRAM_1			0x08
#define ORC_NVRAM_REVISION		0x0b
#define ORC_NVRAM_CHANNEL		0x0c
#define ORC_NVRAM_BIOS_CFG_1		0x0d
#define ORC_NVRAM_BIOS_CFG_2		0x0e
#define ORC_NVRAM_BIOS_CFG_3		0x0f
#define ORC_NVRAM_CH0_HA_ID		0x10
#define ORC_NVRAM_CH0_CFG_1		0x11
#define ORC_NVRAM_CH0_MAX_TAGS_PER_TGT	0x12
#define ORC_NVRAM_CH0_RESET_RECOVERY	0x13
#define ORC_NVRAM_CH0_CFG_4		0x14
#define ORC_NVRAM_CH0_CFG_5		0x15
#define ORC_NVRAM_CH0_TGT_CFG		0x16
#define ORC_NVRAM_CH1_HA_ID		0x26
#define ORC_NVRAM_CH1_CFG_1		0x27
#define ORC_NVRAM_CH1_MAX_TAGS_PER_TGT	0x28
#define ORC_NVRAM_CH1_RESET_RECOVERY	0x29
#define ORC_NVRAM_CH1_CFG_4		0x2a
#define ORC_NVRAM_CH1_CFG_5		0x2b
#define ORC_NVRAM_CH1_TGT_CFG		0x2c
#define ORC_NVRAM_CHECKSUM		0x3f

#define ORC_MAX_IDS		16
#define ORC_MAX_LUNS		16
#define ORC_MAX_CDB		15
#define ORC_MAX_SGENT		32
#define ORC_MAX_SENSE		14
#define ORC_MAX_QUEUE		245
#define ORC_MAX_QUEUE_LIMITED	16

typedef struct {
	__u32 base;
	__u32 len;
} ORC_SGENT;

typedef struct {
	ORC_SGENT sgent[ORC_MAX_SGENT];
	__u32 sgent_phys_le;
	unsigned n_sgents;
	char state;
	char need_unmap;
	SCSIRQ *scsirq;
	struct {
		vspace_dmaunlock_t *dmaunlock;
		__u32 dmaaddr;
	} dma[ORC_MAX_SGENT];
	u_jiffies_lo_t abort_time;
	__u8 sense[ORC_MAX_SENSE];
} ORC_ESCB;

#define ESCB_STATE_FREE		0
#define ESCB_STATE_POSTED	1
#define ESCB_STATE_ABORTING	2

typedef struct {
	__u8 opcode;
	__u8 flags;
	__u8 target;
	__u8 lun;
	__u32 reserved0;
	__u32 xferlen;
	__u32 reserved1;
	__u32 sg_len;
	__u32 sg_addr;
	__u32 sg_addrhigh;
	__u8 hastat;
	__u8 tastat;
	__u8 status;
	__u8 link;
	__u8 sense_len;
	__u8 cdb_len;
	__u8 ident;
	__u8 tag_msg;
	__u8 cdb[ORC_MAX_CDB];
	__u8 scbidx;
	__u32 sense_addr;
	union {
		ORC_ESCB *escb;
		__u64 pad;
	} u;
} ORC_SCB;

#define FREELIST_PTR(scb) (*(ORC_SCB **)((char *)(scb) + __offsetof(ORC_SCB, cdb[4])))

#define ORC_OPCODE_EXECSCSI	0x00
#define ORC_OPCODE_BUSDEVRST	0x01

#define ORC_STATUS_COMPLETE	0x00
#define ORC_STATUS_POST		0x01

#define ORC_FLAGS_DISINT	0x01
#define ORC_FLAGS_DIR_MASK	0x18
#define ORC_FLAGS_DIR_NO_DCHK	0x00
#define ORC_FLAGS_DIR_IN	0x08
#define ORC_FLAGS_DIR_OUT	0x10
#define ORC_FLAGS_DIR_NO_XF	0x18
#define ORC_FLAGS_POLL		0x40

#define ORC_HASTAT_SEL_TOUT	0x11
#define ORC_HASTAT_DO_DU	0x12
#define ORC_HASTAT_BUS_FREE	0x13
#define ORC_HASTAT_BAD_PHAS	0x14
#define ORC_HASTAT_INV_CMD	0x16
#define ORC_HASTAT_ABORTED	0x1a
#define ORC_HASTAT_SCSI_RST	0x1b
#define ORC_HASTAT_DEV_RST	0x1c

#define ORC_IDENT_DISC_DISALLOW	0x80
#define ORC_IDENT_DISC_ALLOW	0xc0

#endif
