#include <SPAD/SYSLOG.H>
#include <STRING.H>
#include <ARCH/BSF.H>

#include "MPT.H"
#include "MPTREG.H"

/* This is not needed now, I leave it here in case someone needs it later */

#if 0
static int MPT_CFG_HEADER(MPT *mpt, __u8 page_type, __u8 page_number, __u32 page_address, MPT_CONFIG_PAGE_HEADER *cfg_hdr)
{
	int r;
	MPT_MSG_CONFIG_REQUEST req;
	MPT_MSG_CONFIG_REPLY rpl;
	memset(&req, 0, sizeof(req));
	req.function = MPT_FUNCTION_CONFIG;
	req.action = MPT_CONFIG_REQ_ACTION_PAGE_HEADER;
	req.header.page_type = page_type;
	req.header.page_number = page_number;
	req.page_address = __32CPU2LE(page_address);
	req.page_buffer_sge.sge_hdr = __32CPU2LE(SGE_HDR_TYPE_SIMPLE | SGE_HDR_EOL | SGE_HDR_EOB | SGE_HDR_LAST);
	if ((r = MPT_SYNC_REQUEST_REPLY(mpt, &req, sizeof(req), &rpl, sizeof(rpl), MPT_CFG_TIMEOUT))) return r;
	if (rpl.ioc_status != __16CPU2LE(MPT_IOCSTATUS_SUCCESS)) {
		KERNEL$SYSLOG(__SYSLOG_HW_BUG, mpt->dev_name, "BAD STATUS WHEN READING PAGE HEADER: %04X", __16LE2CPU(rpl.ioc_status));
		return -EIO;
	}
	memcpy(cfg_hdr, &rpl.header, sizeof(MPT_CONFIG_PAGE_HEADER));
	return 0;
}

static int MPT_CFG_PAGE(MPT *mpt, __u8 action, __u32 page_address, MPT_CONFIG_PAGE_HEADER *cfg_hdr, void *page, size_t len)
{
	int r;
	int dir;
	MPT_MSG_CONFIG_REQUEST req;
	MPT_MSG_CONFIG_REPLY rpl;
	VDESC vdesc;
	VDMA64 vdma64;
	vspace_dma64unlock_t *unlock;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_VSPACE), vdma64.spl = KERNEL$SPL)))
		KERNEL$SUICIDE("MPT_CFG_PAGE AT SPL %08X", vdma64.spl);
	if (len < cfg_hdr->page_length * 4) {
		KERNEL$SYSLOG(__SYSLOG_HW_INCOMPATIBILITY, mpt->dev_name, "PAGE IS TOO BIG, %u > %u", cfg_hdr->page_length * 4, (unsigned)len);
		return -ERANGE;
	}
	memset(&req, 0, sizeof(req));
	req.function = MPT_FUNCTION_CONFIG;
	req.action = action;
	memcpy(&req.header, cfg_hdr, sizeof(MPT_CONFIG_PAGE_HEADER));
	req.header.page_type &= MPT_CONFIG_PAGE_TYPE_MASK;
	req.page_address = __32CPU2LE(page_address);
	switch (action) {
		case MPT_CONFIG_REQ_ACTION_PAGE_READ_CURRENT:
		case MPT_CONFIG_REQ_ACTION_PAGE_READ_DEFAULT:
		case MPT_CONFIG_REQ_ACTION_PAGE_READ_NVRAM:
			memset(page, 0, len);
			dir = PF_WRITE;
			break;
		case MPT_CONFIG_REQ_ACTION_PAGE_WRITE_CURRENT:
		case MPT_CONFIG_REQ_ACTION_PAGE_WRITE_NVRAM:
			dir = PF_READ;
			break;
		default:
			KERNEL$SUICIDE("MPT_CFG_PAGE: INVALID ACTION %02X", action);
	}
	req.page_buffer_sge.sge_hdr = __32CPU2LE(SGE_HDR_TYPE_SIMPLE | SGE_HDR_EOL | SGE_HDR_EOB | SGE_HDR_LAST | (cfg_hdr->page_length * 4) | ((dir & PF_READ) << __BSF_CONST(SGE_HDR_DIR_OUT / PF_READ)));
	vdesc.ptr = (unsigned long)page;
	vdesc.len = cfg_hdr->page_length * 4;
	vdesc.vspace = &KERNEL$VIRTUAL;
	RAISE_SPL(SPL_VSPACE);
	unlock = KERNEL$VIRTUAL.op->vspace_dma64lock(&vdesc, dir, &vdma64);
	if (__unlikely(vdma64.len != vdesc.len))
		KERNEL$SUICIDE("MPT_CFG_PAGE: UNABLE TO LOCK DMA FOR PAGE: %u != %lu", vdma64.len, vdesc.len);
	req.page_buffer_sge.sge_lo_addr = __32CPU2LE(vdma64.ptr);
	req.page_buffer_sge.sge_hi_addr = __32CPU2LE(vdma64.ptr >> 32);
	r = MPT_SYNC_REQUEST_REPLY(mpt, &req, sizeof(req), &rpl, sizeof(rpl), MPT_CFG_TIMEOUT);
	unlock(vdma64.ptr);
	if (r) return r;
	if (rpl.ioc_status != __16CPU2LE(MPT_IOCSTATUS_SUCCESS)) {
		KERNEL$SYSLOG(__SYSLOG_HW_BUG, mpt->dev_name, "BAD STATUS WHEN ACCESSING PAGE: %04X", __16LE2CPU(rpl.ioc_status));
		return -EIO;
	}
	return 0;
}
#endif

void MPT_INIT_SPI_PORT(MPT *mpt)
{
#if 0
	MPT_CONFIG_PAGE_HEADER cfg_hdr;
	MPT_CFG_SPI_PORT_1 port1;
	if (MPT_CFG_HEADER(mpt, MPT_CONFIG_PAGE_TYPE_SCSI_SPI_PORT, 1, 0, &cfg_hdr)) {
		return;
	}
	/*__debug_printf("cfg hdr: %x %x %x %x\n", cfg_hdr.page_version, cfg_hdr.page_length, cfg_hdr.page_number, cfg_hdr.page_type);*/
	if (MPT_CFG_PAGE(mpt, MPT_CONFIG_REQ_ACTION_PAGE_READ_CURRENT, 0, &cfg_hdr, &port1, sizeof(port1))) {
		return;
	}
	/*__debug_printf("cfg page: %x %x %x %x %x %x %x\n", port1.port_scsi_id, port1.reserved1, port1.port_resp_ids, port1.on_bus_timer, port1.target_config, port1.reserved2, port1.id_config);*/
	/* A hack from OpenBSD, I don't really know what it does.
	   Neither do OpenBSD developers ... */
	port1.on_bus_timer = __32CPU2LE(0x07000000);
	if (MPT_CFG_PAGE(mpt, MPT_CONFIG_REQ_ACTION_PAGE_WRITE_CURRENT, 0, &cfg_hdr, &port1, sizeof(port1))) {
		return;
	}
#endif
}

