#include <ARCH/BSF.H>
#include <ERRNO.H>
#include <SPAD/SCSI.H>
#include <SPAD/LIBC.H>
#include <SPAD/SYSLOG.H>

#include "MPT.H"
#include "MPTREG.H"

void MPT_UNMAP_CDB(MPT_CDB *cdb)
{
	unsigned idx;
	__u32 hdr;
	idx = 0;
	do {
		cdb->unlock[idx](__make64(__32LE2CPU(cdb->sge[idx].sge_lo_addr), __32LE2CPU(cdb->sge[idx].sge_hi_addr)));
		hdr = cdb->sge[idx].sge_hdr;
		idx++;
	} while (!(hdr & __32CPU2LE(SGE_HDR_EOL)));
}

DECL_IRQ_AST(MPT_IRQ, SPL_ATA_SCSI, AST)
{
	MPT *mpt = GET_STRUCT(RQ, MPT, irq_ast);
	__u32 reply;
	if (__unlikely((reply = MPT_READ(mpt, MPT_REPLY_FIFO)) == MPT_REPLY_FIFO_EMPTY))
		goto ret;
	do {
		/*__debug_printf("MPT IRQ: %08x\n", reply);*/
		if (__unlikely(reply >= mpt->max_cdbs)) {
			if (__unlikely(MPT_SLOW_REPLY(mpt, reply)))
				goto bad_reply;
			if (__unlikely(mpt->udelay_val))
				KERNEL$UDELAY_PREPARE(&mpt->udelay_cookie);
		} else {
			MPT_CDB *cdb = (MPT_CDB *)((char *)mpt->cdbs + reply * MPT_CDB_SIZE);
			SCSIRQ *scsirq = cdb->scsirq;
			if (__unlikely(!scsirq)) {
				KERNEL$SYSLOG(__SYSLOG_HW_BUG, mpt->dev_name, "FREE COMMAND BLOCK RETURNED: %08X", reply);
				goto bad_reply;
			}
			if (__unlikely(mpt->udelay_val))
				KERNEL$UDELAY_PREPARE(&mpt->udelay_cookie);
			if (__unlikely(cdb->need_unmap))
				MPT_UNMAP_CDB(cdb);
			FREE_CDB(mpt, cdb);
			scsirq->scsi_status = SCSI_GOOD;
			/*{
			int i;
			__debug_printf("command:");
			for (i = 0; i < scsirq->cmdlen; i++)
				__debug_printf(" %02x", scsirq->cmd[i]);
			__debug_printf("\n");
			}*/
			DONE_RQ(mpt, scsirq);
		}
	} while (__unlikely((reply = MPT_READ(mpt, MPT_REPLY_FIFO)) != MPT_REPLY_FIFO_EMPTY));
	bad_reply:
	ret:
	KERNEL$UNMASK_IRQ(mpt->irq_ctrl);
	RETURN;
}

int MPT_POST(SCSIRQ *rq)
{
	MPT *mpt;
	MPT_CDB *cdb;
	BIODESC *desc;
	unsigned idx;

#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_ATA_SCSI)))
		KERNEL$SUICIDE("MPT_POST AT SPL %08X", KERNEL$SPL);
	if (__unlikely(rq->internal != 0))
		KERNEL$SUICIDE("MPT_POST: UNINITIALIZED REQUEST, INTERNAL %lX", rq->internal);
#endif
	if (__unlikely(rq->cmdlen > MSG_CDB_LEN))
		return -EOPNOTSUPP;
	
	mpt = rq->adapter;

	rq->host_aux = __unlikely(rq->tagging == SCSI_TAGGING_NONE) ? MPT_TAGS_PER_DEV : 1;
	if (__unlikely(mpt->used_tags[rq->ch_id] + rq->host_aux > MPT_TAGS_PER_DEV)) {
		eagain:
		mpt->need_dequeue = 1;
		return -EAGAIN;
	}
	cdb = mpt->free_cdbs;
	if (__unlikely(!cdb))
		goto eagain;
	mpt->free_cdbs = cdb->next;

	cdb->need_unmap = 0;
	cdb->aborting = 0;
	cdb->scsirq = rq;
	rq->internal = (unsigned long)cdb;

	*(__u16 *)(void *)&cdb->msg.target_id = __16CPU2LE(rq->ch_id);
	cdb->msg.lun[0] = __32CPU2LE(rq->lun);
	cdb->msg.lun[1] = __32CPU2LE(rq->lun >> 32);
	cdb->msg.cdb_length = rq->cmdlen;
	cdb->msg.tagging =
	 __likely(rq->tagging == SCSI_TAGGING_SIMPLE) ? MSG_TAGGING_SIMPLE_Q :
	 __likely(rq->tagging == SCSI_TAGGING_HEAD) ? MSG_TAGGING_HEAD_OF_Q :
	 __likely(rq->tagging == SCSI_TAGGING_ORDERED) ? MSG_TAGGING_ORDERED_Q :
	 MSG_TAGGING_UNTAGGED;
	cdb->msg.direction =
		__likely(rq->direction == PF_WRITE) ? MSG_DIRECTION_READ :
		__likely(rq->direction == PF_READ) ? MSG_DIRECTION_WRITE :
		MSG_DIRECTION_NONE;
	memcpy(cdb->msg.cdb, rq->cmd, rq->cmdlen);
	cdb->msg.data_length = 0;
	desc = rq->desc;
	if (__unlikely(!desc)) {
		cdb->sge[0].sge_hdr = __32CPU2LE(SGE_HDR_EOL | SGE_HDR_TYPE_SIMPLE | SGE_HDR_EOB | SGE_HDR_LAST);
		cdb->sge[0].sge_lo_addr = __32CPU2LE(0);
		cdb->sge[0].sge_hi_addr = __32CPU2LE(0);
		cdb->unlock[0] = KERNEL$NULL_VSPACE_DMA64UNLOCK;
	} else {
		idx = 0;
		do {
			VDMA64 vdma64;
			VDESC vdesc = desc->v;
			unsigned long ll;
			vdma64.spl = SPL_X(SPL_ATA_SCSI);
			again:
			if (__unlikely(cdb->sge[idx].sge_hdr & __32CPU2LE(SGE_HDR_TYPE_CHAIN_TEST_BIT))) {
				cdb->sge[idx - 1].sge_hdr |= __32CPU2LE(SGE_HDR_LAST);
				idx++;
			}
			if (__unlikely((ll = vdesc.len) > SGE_HDR_LENGTH + 1 - BIO_SECTOR_SIZE))
				vdesc.len = SGE_HDR_LENGTH + 1 - BIO_SECTOR_SIZE;
			RAISE_SPL(SPL_VSPACE);
			cdb->unlock[idx] = vdesc.vspace->op->vspace_dma64lock(&vdesc, rq->direction, &vdma64);
			vdesc.len = ll;
			if (__unlikely(!cdb->unlock[idx])) {
				while (idx--) {
					cdb->unlock[idx](__make64(__32LE2CPU(cdb->sge[idx].sge_lo_addr), __32LE2CPU(cdb->sge[idx].sge_hi_addr)));
				}
				FREE_CDB(mpt, cdb);
				return -EVSPACEFAULT;
			}
			if (__unlikely(cdb->unlock[idx] != KERNEL$NULL_VSPACE_DMA64UNLOCK))
				cdb->need_unmap = 1;
			if (__unlikely(idx >= MPT_MAX_SG))
				KERNEL$SUICIDE("MPT_POST: RAN OUT OF SG SEGMENTS");
			cdb->msg.data_length += vdma64.len;
			cdb->sge[idx].sge_hdr = __32CPU2LE(vdma64.len | SGE_HDR_SIZE_64 | SGE_HDR_TYPE_SIMPLE | ((rq->direction & PF_READ) << __BSF_CONST(SGE_HDR_DIR_OUT / PF_READ)));
			cdb->sge[idx].sge_lo_addr = __32CPU2LE(vdma64.ptr);
			cdb->sge[idx].sge_hi_addr = __32CPU2LE(vdma64.ptr >> 32);
			idx++;
			if (__unlikely(vdesc.len != vdma64.len)) {
				vdesc.len -= vdma64.len;
				vdesc.ptr += vdma64.len;
				goto again;
			}
		} while ((desc = desc->next));
		cdb->sge[idx - 1].sge_hdr |= __32CPU2LE(SGE_HDR_EOL | SGE_HDR_EOB | SGE_HDR_LAST);
	}
	rq->status = cdb->msg.data_length;
	cdb->msg.data_length = __32CPU2LE(cdb->msg.data_length);
	mpt->used_tags[rq->ch_id] += rq->host_aux;
	/*{
	int i;
	__debug_printf("sending: [");
	for (i = 0; i < rq->cmdlen; i++)
		__debug_printf(" %02x", rq->cmd[i]);
	__debug_printf(" ]\n");
	}*/
	__barrier();
	if (__likely(!mpt->udelay_val)) {
		MPT_WRITE(mpt, MPT_REQUEST_FIFO, cdb->paddr);
	} else {
		KERNEL$UDELAY_WAIT(&mpt->udelay_cookie, mpt->udelay_val);
		MPT_WRITE(mpt, MPT_REQUEST_FIFO, cdb->paddr);
		MPT_READ(mpt, MPT_DOORBELL); /* flush the write */
		KERNEL$UDELAY_PREPARE(&mpt->udelay_cookie);
	}
	return 0;
}

