#ifndef __SCSI_HOST_MPTREG_H
#define __SCSI_HOST_MPTREG_H

#include <SYS/TYPES.H>

/*
 * Partially taken from Linux MPT Fusion driver, (C) 2000-2008 LSI Corporation.
 */

#define MPT_REGSPACE		0x2000

#define MPT_DOORBELL		0x0000
#define  MPT_DOORBELL_DATA		0x0000ffff
#define  MPT_DOORBELL_DWORDS		0x00ff0000
#define  MPT_DOORBELL_FUNCTION		0xff000000
#define  MPT_DOORBELL_WHO_INIT		0x07000000
#define  MPT_DOORBELL_ACTIVE		0x08000000
#define  MPT_DOORBELL_IOC_STATE		0xf0000000
#define   MPT_DOORBELL_IOC_STATE_MPI_IOC_STATE_RESET		0x00000000
#define   MPT_DOORBELL_IOC_STATE_MPI_IOC_STATE_READY		0x10000000
#define   MPT_DOORBELL_IOC_STATE_MPI_IOC_STATE_OPERATIONAL	0x20000000
#define   MPT_DOORBELL_IOC_STATE_MPI_IOC_STATE_FAULT		0x40000000
#define MPT_WRITE_SEQUENCE	0x0004
#define MPT_DIAGNOSTIC		0x0008
#define MPT_TEST_BASE		0x000c
#define MPT_DIAG_RW_DATA	0x0010
#define MPT_DIAG_RW_ADDRESS	0x0014
#define MPT_INT_STATUS		0x0030
#define  MPT_INT_STATUS_DOORBELL	0x00000001
#define  MPT_INT_STATUS_REPLY		0x00000008
#define  MPT_INT_STATUS_IOCDOORBELL	0x80000000
#define MPT_INT_MASK		0x0034
#define  MPT_INT_MASK_DOORBELL		0x00000001
#define  MPT_INT_MASK_REPLY		0x00000008
#define MPT_REQUEST_FIFO	0x0040
#define MPT_REPLY_FIFO		0x0044
#define  MPT_REPLY_FIFO_CONTEXT		0x1fffffff
#define  MPT_REPLY_FIFO_TYPE		0x60000000
#define   MPT_REPLY_FIFO_TYPE_INITIATOR		0x00000000
#define   MPT_REPLY_FIFO_TYPE_TARGET		0x10000000
#define   MPT_REPLY_FIFO_TYPE_LAN		0x20000000
#define  MPT_REPLY_FIFO_ADDRESS_MASK	0x7fffffff
#define  MPT_REPLY_FIFO_ADDRESS		0x80000000
#define  MPT_REPLY_FIFO_EMPTY		0xffffffff
#define MPT_REQUEST_HI_PRI_FIFO	0x0048
#define MPT_HOST_INDEX		0x0050
#define MPT_FUBAR		0x0090
#define MPT_RESET_1078		0x10FC

#define MPT_FUNCTION_SCSI_IO_REQUEST			0x00
#define MPT_FUNCTION_SCSI_TASK_MGMT			0x01
#define MPT_FUNCTION_IOC_INIT				0x02
#define MPT_FUNCTION_IOC_FACTS				0x03
#define MPT_FUNCTION_CONFIG				0x04
#define MPT_FUNCTION_PORT_FACTS				0x05
#define MPT_FUNCTION_PORT_ENABLE			0x06
#define MPT_FUNCTION_EVENT_NOTIFICATION			0x07
#define MPT_FUNCTION_EVENT_ACK				0x08
#define MPT_FUNCTION_FW_DOWNLOAD			0x09
#define MPT_FUNCTION_TARGET_CMD_BUFFER_POST		0x0a
#define MPT_FUNCTION_TARGET_ASSIST			0x0b
#define MPT_FUNCTION_TARGET_STATUS_SEND			0x0c
#define MPT_FUNCTION_TARGET_MODE_ABORT			0x0d
#define MPT_FUNCTION_TARGET_FC_BUF_POST_LINK_SRVC	0x0e
#define MPT_FUNCTION_TARGET_FC_RSP_LINK_SRVC		0x0f
#define MPT_FUNCTION_TARGET_FC_EX_SEND_LINK_SRVC	0x10
#define MPT_FUNCTION_TARGET_FC_ABORT			0x11
#define MPT_FUNCTION_FC_LINK_SRVC_BUF_POST		0x0e
#define MPT_FUNCTION_FC_LINK_SRVC_RSP			0x0f
#define MPT_FUNCTION_FC_EX_LINK_SRVC_SEND		0x10
#define MPT_FUNCTION_FC_ABORT				0x11
#define MPT_FUNCTION_FW_UPLOAD				0x12
#define MPT_FUNCTION_FC_COMMON_TRANSPORT_SEND		0x13
#define MPT_FUNCTION_FC_PRIMITIVE_SEND			0x14
#define MPT_FUNCTION_RAID_ACTION			0x15
#define MPT_FUNCTION_RAID_SCSI_IO_PASSTHROUGH		0x16
#define MPT_FUNCTION_TOOLBOX				0x17
#define MPT_FUNCTION_SCSI_ENCLOSURE_PROCESSOR		0x18
#define MPT_FUNCTION_MAILBOX				0x19
#define MPT_FUNCTION_LAN_SEND				0x20
#define MPT_FUNCTION_LAN_RECEIVE			0x21
#define MPT_FUNCTION_LAN_RESET				0x22
#define MPT_FUNCTION_IOC_MESSAGE_UNIT_RESET		0x40
#define MPT_FUNCTION_IO_UNIT_RESET			0x41
#define MPT_FUNCTION_HANDSHAKE				0x42
#define MPT_FUNCTION_REPLY_FRAME_REMOVAL		0x43

	/* Common IOCStatus values for all replies */
#define MPT_IOCSTATUS_SUCCESS				0x0000
#define MPT_IOCSTATUS_INVALID_FUNCTION			0x0001
#define MPT_IOCSTATUS_BUSY				0x0002
#define MPT_IOCSTATUS_INVALID_SGL			0x0003
#define MPT_IOCSTATUS_INTERNAL_ERROR			0x0004
#define MPT_IOCSTATUS_RESERVED				0x0005
#define MPT_IOCSTATUS_INSUFFICIENT_RESOURCES		0x0006
#define MPT_IOCSTATUS_INVALID_FIELD			0x0007
#define MPT_IOCSTATUS_INVALID_STATE			0x0008
#define MPT_IOCSTATUS_OP_STATE_NOT_SUPPORTED		0x0009
	/* Config IOCStatus values */
#define MPT_IOCSTATUS_CONFIG_INVALID_ACTION		0x0020
#define MPT_IOCSTATUS_CONFIG_INVALID_TYPE		0x0021
#define MPT_IOCSTATUS_CONFIG_INVALID_PAGE		0x0022
#define MPT_IOCSTATUS_CONFIG_INVALID_DATA		0x0023
#define MPT_IOCSTATUS_CONFIG_NO_DEFAULTS		0x0024
#define MPT_IOCSTATUS_CONFIG_CANT_COMMIT		0x0025
	/* SCSIIO Reply (SPI & FCP) initiator values */
#define MPT_IOCSTATUS_SCSI_RECOVERED_ERROR		0x0040
#define MPT_IOCSTATUS_SCSI_INVALID_BUS			0x0041
#define MPT_IOCSTATUS_SCSI_INVALID_TARGETID		0x0042
#define MPT_IOCSTATUS_SCSI_DEVICE_NOT_THERE		0x0043
#define MPT_IOCSTATUS_SCSI_DATA_OVERRUN			0x0044
#define MPT_IOCSTATUS_SCSI_DATA_UNDERRUN		0x0045
#define MPT_IOCSTATUS_SCSI_IO_DATA_ERROR		0x0046
#define MPT_IOCSTATUS_SCSI_PROTOCOL_ERROR		0x0047
#define MPT_IOCSTATUS_SCSI_TASK_TERMINATED		0x0048
#define MPT_IOCSTATUS_SCSI_RESIDUAL_MISMATCH		0x0049
#define MPT_IOCSTATUS_SCSI_TASK_MGMT_FAILED		0x004a
#define MPT_IOCSTATUS_SCSI_IOC_TERMINATED		0x004b
#define MPT_IOCSTATUS_SCSI_EXT_TERMINATED		0x004c
      /* For use by SCSI Initiator and SCSI Target end-to-end data protection */
#define MPT_IOCSTATUS_EEDP_GUARD_ERROR			0x004d
#define MPT_IOCSTATUS_EEDP_REF_TAG_ERROR		0x004e
#define MPT_IOCSTATUS_EEDP_APP_TAG_ERROR		0x004f
	/* SCSI Target values */
#define MPT_IOCSTATUS_TARGET_PRIORITY_IO		0x0060
#define MPT_IOCSTATUS_TARGET_INVALID_PORT		0x0061
#define MPT_IOCSTATUS_TARGET_INVALID_IOCINDEX		0x0062	/* obsolete name */
#define MPT_IOCSTATUS_TARGET_INVALID_IO_INDEX		0x0062
#define MPT_IOCSTATUS_TARGET_ABORTED			0x0063
#define MPT_IOCSTATUS_TARGET_NO_CONN_RETRYABLE		0x0064
#define MPT_IOCSTATUS_TARGET_NO_CONNECTION		0x0065
#define MPT_IOCSTATUS_TARGET_XFER_COUNT_MISMATCH 0x006A
#define MPT_IOCSTATUS_TARGET_STS_DATA_NOT_SENT		0x006b
#define MPT_IOCSTATUS_TARGET_DATA_OFFSET_ERROR		0x006d
#define MPT_IOCSTATUS_TARGET_TOO_MUCH_WRITE_DATA 0x006E
#define MPT_IOCSTATUS_TARGET_IU_TOO_SHORT		0x006f
#define MPT_IOCSTATUS_TARGET_ACK_NAK_TIMEOUT		0x0070
#define MPT_IOCSTATUS_TARGET_NAK_RECEIVED		0x0071
	/* Additional FCP target values (obsolete) */
#define MPT_IOCSTATUS_TARGET_FC_ABORTED			0x0066	/* obsolete */
#define MPT_IOCSTATUS_TARGET_FC_RX_ID_INVALID		0x0067	/* obsolete */
#define MPT_IOCSTATUS_TARGET_FC_DID_INVALID		0x0068	/* obsolete */
#define MPT_IOCSTATUS_TARGET_FC_NODE_LOGGED_OUT		0x0069	/* obsolete */
	/* Fibre Channel Direct Access values */
#define MPT_IOCSTATUS_FC_ABORTED			0x0066
#define MPT_IOCSTATUS_FC_RX_ID_INVALID			0x0067
#define MPT_IOCSTATUS_FC_DID_INVALID			0x0068
#define MPT_IOCSTATUS_FC_NODE_LOGGED_OUT		0x0069
#define MPT_IOCSTATUS_FC_EXCHANGE_CANCELED		0x006c
	/* LAN values */
#define MPT_IOCSTATUS_LAN_DEVICE_NOT_FOUND		0x0080
#define MPT_IOCSTATUS_LAN_DEVICE_FAILURE		0x0081
#define MPT_IOCSTATUS_LAN_TRANSMIT_ERROR		0x0082
#define MPT_IOCSTATUS_LAN_TRANSMIT_ABORTED		0x0083
#define MPT_IOCSTATUS_LAN_RECEIVE_ERROR			0x0084
#define MPT_IOCSTATUS_LAN_RECEIVE_ABORTED		0x0085
#define MPT_IOCSTATUS_LAN_PARTIAL_PACKET		0x0086
#define MPT_IOCSTATUS_LAN_CANCELED			0x0087
	/* Serial Attached SCSI values */
#define MPT_IOCSTATUS_SAS_SMP_REQUEST_FAILED		0x0090
#define MPT_IOCSTATUS_SAS_SMP_DATA_OVERRUN		0x0091
	/* Inband values */
#define MPT_IOCSTATUS_INBAND_ABORTED			0x0098
#define MPT_IOCSTATUS_INBAND_NO_CONNECTION		0x0099
	/* Diagnostic Tools values */
#define MPT_IOCSTATUS_DIAGNOSTIC_RELEASED		0x00a0
	/* IOCStatus flag to indicate that log info is available */
#define MPT_IOCSTATUS_FLAG_LOG_INFO_AVAILABLE		0x8000
#define MPT_IOCSTATUS_MASK				0x7fff


#define SGE_HDR_LENGTH			0x00ffffff
#define SGE_HDR_CHAIN_OFFSET		0x00ff0000
#define SGE_HDR_EOL			0x01000000
#define SGE_HDR_SIZE_64			0x02000000
#define SGE_HDR_DIR_OUT			0x04000000
#define SGE_HDR_LOCAL			0x08000000
#define SGE_HDR_TYPE			0x30000000
#define  SGE_HDR_TYPE_TX_CTX			0x00000000
#define  SGE_HDR_TYPE_SIMPLE			0x10000000
#define  SGE_HDR_TYPE_CHAIN			0x30000000
#define  SGE_HDR_TYPE_CHAIN_TEST_BIT		0x20000000
#define SGE_HDR_EOB			0x40000000
#define SGE_HDR_LAST			0x80000000

typedef struct {
	__u32 sge_hdr;
	__u32 sge_lo_addr;
	__u32 sge_hi_addr;
} MPT_SGE;

typedef struct {
	__u8 target_id;
	__u8 bus;
	__u8 chain_offset;
	__u8 function;

	__u8 cdb_length;
	__u8 sense_buf_length;
	__u8 reserved1;
#define MSG_FLAGS_SENSE_BUF_ADDR_WIDTH_64	0x01
#define MSG_FLAGS_SENSE_BUF_LOC			0x02
#define MSG_FLAGS_CMD_DATA_DIR			0x04
#define MSG_FLAGS_EEDP				0xf0
	__u8 msg_flags;
	__u32 msg_context;
	__u32 lun[2];
	__u8 reserved2;
#define MSG_TAGGING_SIMPLE_Q			0x00
#define MSG_TAGGING_HEAD_OF_Q			0x01
#define MSG_TAGGING_ORDERED_Q			0x02
#define MSG_TAGGING_ACA_Q			0x04
#define MSG_TAGGING_UNTAGGED			0x05
#define MSG_TAGGING_NO_DISCONNECT		0x07
	__u8 tagging;
	__u8 reserved3;
#define MSG_DIRECTION_NONE			0x00
#define MSG_DIRECTION_WRITE			0x01
#define MSG_DIRECTION_READ			0x02
	__u8 direction;
#define MSG_CDB_LEN				0x10
	__u8 cdb[MSG_CDB_LEN];
	__u32 data_length;
	__u32 sense_lo_addr;
} MPT_MSG_SCSI_IO;

typedef struct {
	__u8 target;
	__u8 bus;
	__u8 msg_length;
	__u8 function;
	__u8 cdb_length;
	__u8 sense_buf_length;
	__u8 reserved1;
	__u8 msg_flags;
	__u32 msg_context;
	__u8 scsi_status;
/* OpenBSD and Linux definitions differ. Go with the Linux one */
#define REPLY_SCSI_STATE_AUTOSENSE_VALID	0x01
#define REPLY_SCSI_STATE_AUTOSENSE_FAILED	0x02
#define REPLY_SCSI_STATE_NO_SCSI_STATUS		0x04
#define REPLY_SCSI_STATE_TERMINATED		0x08
#define REPLY_SCSI_STATE_RESPONSE_INFO_VALID	0x10
#define REPLY_SCSI_STATE_QUEUE_TAG_REJECTED	0x20
	__u8 scsi_state;
	__u16 ioc_status;
	__u32 ioc_loginfo;
	__u32 transfer_count;
	__u32 sense_count;
	__u32 response_info;
	__u16 tag;
	__u8 reserved2[2];
} MPT_REPLY_SCSI_IO_ERROR;

typedef struct {
	__u8 reserved1[2];
	__u8 chain_offset;
	__u8 function;
	__u8 reserved2[3];
	__u8 msg_flags;
	__u32 msg_context;
} MPT_IOCFACTS_REQUEST;

typedef struct {
	__u16 msg_version;
	__u8 msg_length;
	__u8 function;
	__u16 header_version;
	__u8 ioc_number;
	__u8 msg_flags;
	__u32 msg_context;
	__u16 ioc_exceptions;
#define IOFACTS_IOC_EXCEPTIONS_CONFIG_CHECKSUM_FAIL	0x0001
#define IOFACTS_IOC_EXCEPTIONS_RAID_CONFIG_INVALID	0x0002
#define IOFACTS_IOC_EXCEPTIONS_FW_CHECKSUM_FAIL		0x0004
#define IOFACTS_IOC_EXCEPTIONS_PERSISTENT_TABLE_FULL	0x0008
	__u16 ioc_status;
	__u32 ioc_log_info;
	__u8 max_chain_depth;
	__u8 who_init;
	__u8 block_size;
	__u8 flags;
#define IOFACTS_FLAGS_FW_DOWNLOAD_BOOT			0x01
#define IOFACTS_FLAGS_REPLY_FIFO_HOST_SIGNAL		0x02
#define IOFACTS_FLAGS_HOST_PAGE_BUFFER_PERSISTENT	0x04
	__u16 reply_queue_depth;
	__u16 request_frame_size;
	__u16 fw_version_16;
	__u16 product_id;
	__u32 current_host_mfa_hi_addr;
	__u16 global_credits;
	__u8 number_of_ports;
	__u8 event_state;
	__u32 current_sense_buffer_hi_addr;
	__u16 current_reply_frame_size;
	__u8 max_devices;
	__u8 max_buses;
	__u32 fw_image_size;
	__u32 ioc_capabilities;
	__u32 fw_version;
	__u16 high_priority_queue_depth;
	__u8 reserved1[2];
	MPT_SGE host_page_buffer_sge;
	__u32 reply_fifo_host_signaling_addr;
} MPT_IOCFACTS_REPLY;

typedef struct {
	__u8 reserved1[2];
	__u8 chain_offset;
	__u8 function;
	__u8 reserved2[2];
	__u8 port_number;
	__u8 msg_flags;
	__u32 msg_context;
} MPT_PORTFACTS_REQUEST;

typedef struct {
	__u8 reserved1[2];
	__u8 msg_length;
	__u8 function;
	__u8 reserved2[2];
	__u8 port_number;
	__u8 msg_flags;
	__u32 msg_context;
	__u8 reserved3[2];
	__u16 ioc_status;
	__u32 ioc_loginfo;
	__u8 reserved4;
#define PORTFACTS_PORT_TYPE_INACTIVE		0x00
#define PORTFACTS_PORT_TYPE_SCSI		0x01
#define PORTFACTS_PORT_TYPE_FC			0x10
#define PORTFACTS_PORT_TYPE_ISCSI		0x20
#define PORTFACTS_PORT_TYPE_SAS			0x30
	__u8 port_type;
	__u16 max_devices;
	__u16 port_scsi_id;
#define PORTFACTS_PROTOCOL_FLAGS_LOGBUSADDR	0x0001
#define PORTFACTS_PROTOCOL_FLAGS_LAN		0x0002
#define PORTFACTS_PROTOCOL_FLAGS_TARGET		0x0004
#define PORTFACTS_PROTOCOL_FLAGS_INITIATOR	0x0008
	__u16 protocol_flags;
	__u16 max_posted_cmd_buffers;
	__u16 max_persistent_ids;
	__u16 max_lan_buckets;
	__u8 reserved5[6];
} MPT_PORTFACTS_REPLY;

typedef struct {
	__u8 whoinit;
	__u8 reserved1;
	__u8 chain_offset;
	__u8 function;
	__u8 flags;
	__u8 max_devices;
	__u8 max_buses;
	__u8 msg_flags;
	__u32 msg_context;
	__u16 reply_frame_size;
	__u8 reserved2[2];
	__u32 host_mfa_hi_addr;
	__u32 sense_buffer_hi_addr;
	__u32 reply_hi_addr;
	MPT_SGE host_page_buffer_sge;
	__u8 msg_version_maj;
	__u8 msg_version_min;
	__u8 hdr_version_unit;
	__u8 hdr_version_dev;
} MPT_IOCINIT_REQUEST;

typedef struct {
#define IOCINIT_WHOINIT_NO_ONE			0x00
#define IOCINIT_WHOINIT_SYSTEM_BIOS		0x01
#define IOCINIT_WHOINIT_ROM_BIOS		0x02
#define IOCINIT_WHOINIT_PCI_PEER		0x03
#define IOCINIT_WHOINIT_HOST_DRIVER		0x04
#define IOCINIT_WHOINIT_MANUFACTURER		0x05
	__u8 whoinit;
	__u8 reserved1;
	__u8 chain_offset;
	__u8 function;
	__u8 flags;
	__u8 max_devices;
	__u8 max_buses;
	__u8 msg_flags;
	__u32 msg_context;
	__u8 reserved2[2];
	__u16 ioc_status;
	__u32 ioc_loginfo;
} MPT_IOCINIT_REPLY;

typedef struct {
	__u8 reserved1[2];
	__u8 chain_offset;
	__u8 function;
	__u8 reserved2[2];
	__u8 port_number;
	__u8 msg_flags;
	__u32 msg_context;
} MPT_PORTENABLE_REQUEST;

typedef struct {
	__u8 reserved1[2];
	__u8 msg_length;
	__u8 function;
	__u8 reserved2[2];
	__u8 port_number;
	__u8 msg_flags;
	__u32 msg_context;
	__u8 reserved3[2];
	__u16 ioc_status;
	__u32 ioc_loginfo;
} MPT_PORTENABLE_REPLY;

typedef struct {
	__u8 page_version;
	__u8 page_length;
	__u8 page_number;
#define MPT_CONFIG_PAGE_TYPE_ATTRIBUTE		0xf0
#define MPT_CONFIG_PAGE_TYPE_MASK		0x0f
#define MPT_CONFIG_PAGE_TYPE_IO_UNIT		0x00
#define MPT_CONFIG_PAGE_TYPE_IOC		0x01
#define MPT_CONFIG_PAGE_TYPE_BIOS		0x02
#define MPT_CONFIG_PAGE_TYPE_SCSI_SPI_PORT	0x03
#define MPT_CONFIG_PAGE_TYPE_SCSI_SPI_DEV	0x04
#define MPT_CONFIG_PAGE_TYPE_FC_PORT		0x05
#define MPT_CONFIG_PAGE_TYPE_FC_DEV		0x06
#define MPT_CONFIG_PAGE_TYPE_LAN		0x07
#define MPT_CONFIG_PAGE_TYPE_RAID_VOL		0x08
#define MPT_CONFIG_PAGE_TYPE_MANUFACTURING	0x09
#define MPT_CONFIG_PAGE_TYPE_RAID_PD		0x0a
#define MPT_CONFIG_PAGE_TYPE_INBAND		0x0b
#define MPT_CONFIG_PAGE_TYPE_EXTENDED		0x0f
	__u8 page_type;
} MPT_CONFIG_PAGE_HEADER;

typedef struct {
#define MPT_CONFIG_REQ_ACTION_PAGE_HEADER	0x00
#define MPT_CONFIG_REQ_ACTION_PAGE_READ_CURRENT	0x01
#define MPT_CONFIG_REQ_ACTION_PAGE_WRITE_CURRENT 0x02
#define MPT_CONFIG_REQ_ACTION_PAGE_DEFAULT	0x03
#define MPT_CONFIG_REQ_ACTION_PAGE_WRITE_NVRAM	0x04
#define MPT_CONFIG_REQ_ACTION_PAGE_READ_DEFAULT	0x05
#define MPT_CONFIG_REQ_ACTION_PAGE_READ_NVRAM	0x06
	__u8 action;
	__u8 reserved1;
	__u8 chain_offset;
	__u8 function;
	__u16 ext_page_len;
	__u8 ext_page_type;
	__u8 msg_flags;
	__u32 msg_context;
	__u8 reserved2[8];
	MPT_CONFIG_PAGE_HEADER header;
	__u32 page_address;
	MPT_SGE page_buffer_sge;
} MPT_MSG_CONFIG_REQUEST;

typedef struct {
	__u8 action;
	__u8 reserved1;
	__u8 msg_length;
	__u8 function;
	__u16 ext_page_len;
	__u8 ext_page_type;
	__u8 msg_flags;
	__u32 msg_context;
	__u8 reserved2[2];
	__u16 ioc_status;
	__u32 ioc_loginfo;
	MPT_CONFIG_PAGE_HEADER header;
} MPT_MSG_CONFIG_REPLY;

typedef struct {
	MPT_CONFIG_PAGE_HEADER header;
#define MPT_CFG_SPI_PORT_0_CAPABILITIES1_PACKETIZED	0x01
#define MPT_CFG_SPI_PORT_0_CAPABILITIES1_DT		0x02
#define MPT_CFG_SPI_PORT_0_CAPABILITIES1_QAS		0x04
	__u8 capabilities1;
	__u8 min_period;
	__u8 max_offset;
#define MPT_CFG_SPI_PORT_0_CAPABILITIES2_IDP		0x08
#define MPT_CFG_SPI_PORT_0_CAPABILITIES2_WIDTH_WIDE	0x20
#define MPT_CFG_SPI_PORT_0_CAPABILITIES2_AIP		0x80
	__u8 capabilities2;
#define MPT_CFG_SPI_PORT_0_SIGNALLING_HVD		0x01
#define MPT_CFG_SPI_PORT_0_SIGNALLING_SE		0x02
#define MPT_CFG_SPI_PORT_0_SIGNALLING_LVD		0x03
	__u8 signalling;
	__u8 reserved1[2];
	__u8 connected_id;
#define MPT_CFG_SPI_PORT_0_CONNECTEDID_BUSFREE		0xfe
#define MPT_CFG_SPI_PORT_0_CONNECTEDID_UNKNOWN		0xff
} MPT_CFG_SPI_PORT_0;

typedef struct {
	MPT_CONFIG_PAGE_HEADER header;
	__u8 port_scsi_id;
	__u8 reserved1;
	__u16 port_resp_ids;
	__u32 on_bus_timer;
#define MPT_CFG_SPI_PORT_1_TARGET_CONFIG_TARGET_ONLY	0x01
#define MPT_CFG_SPI_PORT_1_TARGET_CONFIG_INIT_TARGET	0x02
	__u8 target_config;
	__u8 reserved2;
	__u16 id_config;
} MPT_CFG_SPI_PORT_1;

typedef struct {
	MPT_CONFIG_PAGE_HEADER header;
#define MPT_CFG_SPI_PORT_2_PORT_FLAGS_SCAN_HI2LOW	0x01
#define MPT_CFG_SPI_PORT_2_PORT_FLAGS_AVOID_RESET	0x04
#define MPT_CFG_SPI_PORT_2_PORT_FLAGS_ALT_CHS		0x08
#define MPT_CFG_SPI_PORT_2_PORT_FLAGS_TERM_DISABLED	0x10
#define MPT_CFG_SPI_PORT_2_PORT_FLAGS_DV_CTL		0x60
#define  MPT_CFG_SPI_PORT_2_PORT_FLAGS_DV_HOST_BE		0x00
#define  MPT_CFG_SPI_PORT_2_PORT_FLAGS_DV_HOST_B		0x20
#define  MPT_CFG_SPI_PORT_2_PORT_FLAGS_DV_HOST_NONE		0x60
	__u32 port_flags;
#define MPT_CFG_SPI_PORT_2_PORT_SETTINGS_HOST_ID	0x0007
#define MPT_CFG_SPI_PORT_2_PORT_SETTINGS_INIT_HBA	0x0030
#define  MPT_CFG_SPI_PORT_2_PORT_SETTINGS_INIT_HBA_DISABLED	0x0000
#define  MPT_CFG_SPI_PORT_2_PORT_SETTINGS_INIT_HBA_BIOS		0x0010
#define  MPT_CFG_SPI_PORT_2_PORT_SETTINGS_INIT_HBA_OS		0x0020
#define  MPT_CFG_SPI_PORT_2_PORT_SETTINGS_INIT_HBA_BIOS_OS	0x0030
#define MPT_CFG_SPI_PORT_2_PORT_SETTINGS_REMOVABLE	0x00c0
#define MPT_CFG_SPI_PORT_2_PORT_SETTINGS_SPINUP_DELAY	0x0f00
#define MPT_CFG_SPI_PORT_2_PORT_SETTINGS_SYNC		0x3000
#define  MPT_CFG_SPI_PORT_2_PORT_SETTINGS_NEG_SUPPORTED		0x0000
#define  MPT_CFG_SPI_PORT_2_PORT_SETTINGS_NEG_NONE		0x1000
#define  MPT_CFG_SPI_PORT_2_PORT_SETTINGS_NEG_ALL		0x3000
	__u32 port_settings;
	struct {
		__u8 timeout;
		__u8 sync_factor;
#define MPT_CFG_SPI_PORT_2_DEV_FLAG_DISCONNECT_EN	0x01
#define MPT_CFG_SPI_PORT_2_DEV_FLAG_SCAN_ID_EN		0x02
#define MPT_CFG_SPI_PORT_2_DEV_FLAG_SCAN_LUN_EN		0x04
#define MPT_CFG_SPI_PORT_2_DEV_FLAG_TAQ_Q_EN		0x08
#define MPT_CFG_SPI_PORT_2_DEV_FLAG_WIDE_DIS		0x10
#define MPT_CFG_SPI_PORT_2_DEV_FLAG_BOOT_CHOICE		0x20
		__u16 device_flags;
	} device_settings[16];
} MPT_CFG_SPI_PORT_2;

#endif
