#include <SPAD/LIST.H>
#include <SPAD/SCSI.H>
#include <SPAD/BIO_KRNL.H>

void SCSI$HOST_DEQUEUE(LIST_HEAD *list)
{
	int r;
	SCSI_ATTACH_PARAM *ap, *last_posted;
	last_posted = LIST_STRUCT(list->prev, SCSI_ATTACH_PARAM, u.h.client_list);
	if (__unlikely(last_posted == LIST_STRUCT(list, SCSI_ATTACH_PARAM, u.h.client_list)))
		return;
	try_next:
	ap = LIST_STRUCT(list->next, SCSI_ATTACH_PARAM, u.h.client_list);
	r = ap->dequeue(ap);
	if (__likely(r != BIO_DEQUEUE_FULL)) {
		if (__unlikely(r != BIO_DEQUEUE_EMPTY)) {
			last_posted = ap;
		} else {
			if (__likely(ap == last_posted))
				return;
		}
		DEL_FROM_LIST(&ap->u.h.client_list);
		ADD_TO_LIST_END(list, &ap->u.h.client_list);
		goto try_next;
	}
}

__COLD_ATTR__ int SCSI$HOST_IS_LUN_DUPLICATE(LIST_HEAD *list, SCSI_ATTACH_PARAM *ap)
{
	SCSI_ATTACH_PARAM *app;
	int r;
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_ATA_SCSI), spl)))
		KERNEL$SUICIDE("SCSI$HOST_IS_LUN_DUPLICATE AT SPL %08X", spl);
	RAISE_SPL(SPL_ATA_SCSI);
	LIST_FOR_EACH(app, list, SCSI_ATTACH_PARAM, u.h.client_list)
		if (__unlikely(app != ap) && app->ch_id == ap->ch_id && app->lun == ap->lun) {
			r = -EBUSY;
			goto ret;
		}
	r = 0;
	ret:
	LOWER_SPLX(spl);
	return r;
}

__COLD_ATTR__ void SCSI$HOST_PRINT_NAME(SCSI_ATTACH_PARAM *ap, char *dev_name, unsigned channel, unsigned max_channels, unsigned id, unsigned max_ids)
{
	char ch_str[14];
	char id_str[14];
	char lun_str[20];
	int lun8;
	__u64 lun64;
	if (max_channels > 1)
		_snprintf(ch_str, sizeof ch_str, "_CH%d", channel);
	else
		ch_str[0] = 0;
	if (max_ids > 1)
		_snprintf(id_str, sizeof id_str, "_ID%d", id);
	else
		id_str[0] = 0;
	if (ap->lun == LUN_NONE)
		strlcpy(lun_str, "_INIT", sizeof lun_str);
	else if (__likely(!ap->lun))
		lun_str[0] = 0;
	else if ((lun8 = SCSI$LUN_CONVERT_INTERNAL_TO_8(ap->lun)) >= 0)
		_snprintf(lun_str, sizeof lun_str, "LUN%d", lun8);
	else {
		int n;
		lun64 = SCSI$LUN_CONVERT_INTERNAL_TO_64(ap->lun);
		if (lun64 < (__u64)1 << 16) n = 2;
		else if (lun64 < (__u64)1 << 32) n = 4;
		else if (lun64 < (__u64)1 << 48) n = 6;
		else n = 8;
		_snprintf(lun_str, sizeof lun_str, "LUN%0*"__64_format"X", n, lun64);
	}
	
	_snprintf(*ap->dev_name, sizeof *ap->dev_name, "%s%s%s%s@%s", ap->dev_prefix, ch_str, id_str, lun_str, dev_name);
}

/*
 * There may be at least two segments in a page.
 * 1 - 1
 * 2 - 2
 * 3 - 3
 * 4 - 4
 * 5 - __SECTORS_PER_PAGE_CLUSTER * 1 + 3
 * 6 - __SECTORS_PER_PAGE_CLUSTER * 1 + 4
 * 7 - __SECTORS_PER_PAGE_CLUSTER * 2 + 3
 * 8 - __SECTORS_PER_PAGE_CLUSTER * 2 + 4
 * 9 - __SECTORS_PER_PAGE_CLUSTER * 3 + 3
 * 10 - __SECTORS_PER_PAGE_CLUSTER * 3 + 4
 */

__COLD_ATTR__ unsigned SCSI$HOST_SGENTS_TO_SECTORS(unsigned sgents)
{
	if (sgents <= 2)
		return sgents;
	return (((sgents - 3) / 2) << __SECTORS_PER_PAGE_CLUSTER_BITS) + 4 - (sgents & 1);
}

