#include <SYS/TYPES.H>

#include <SPAD/SCSI.H>

__u8 SCSI$VERSION(const SCSI_INQUIRY_DATA *inq)
{
	if (__likely((inq->version & 7) >= 1) && (inq->version & 7) <= 3) return inq->version & 7;
	if (__likely(inq->version >= 1) && __likely(inq->version <= 7)) return inq->version;
	return 0;
}

int SCSI$SUPPORTS_STD(const SCSI_INQUIRY_DATA *inq, ...)
{
	unsigned i;
	if (SCSI$VERSION(inq) < 4) return 0;
	for (i = 0; i < sizeof(inq->standard_descs) / sizeof(*inq->standard_descs); i++) {
		unsigned std;
		va_list va;
		va_start(va, inq);
		while ((std = va_arg(va, unsigned))) {
			if (std == inq->standard_descs[i]) {
				va_end(va);
				return 1;
			}
		}
		va_end(va);
	}
	return 0;
}

