#ifndef __SCSI_TARGET_SD_H
#define __SCSI_TARGET_SD_H

#include <SPAD/AC.H>
#include <SPAD/TIMER.H>
#include <SPAD/DEV.H>
#include <SPAD/THREAD.H>
#include <SPAD/BIO.H>
#include <SPAD/BIO_KRNL.H>
#include <SPAD/SLAB.H>
#include <SPAD/SCSI.H>
#include <SPAD/SCHED.H>

/* test read-modify-write on 512-sector devices */
/*#define SD_TEST_RMW*/

#define SD_TIMEOUT		(JIFFIES_PER_SECOND * 30)
#define SD_OPTICAL_TIMEOUT	(JIFFIES_PER_SECOND * 75)
#define SD_EXTENDED_TIMEOUT	(JIFFIES_PER_SECOND * 120)
#define SD_MAX_TIMEOUT		(JIFFIES_PER_SECOND * 120)
#define SD_UNCHOKE_TIME		(JIFFIES_PER_SECOND * 30)
#define SD_UNCHOKE_STEPS	8
#define SD_RETRIES		5
#define SD_MAX_SECSIZE		__PAGE_CLUSTER_SIZE

typedef struct {
	SCSI_ATTACH_PARAM ap;
	__s8 std;
	__u8 lun_byte;
	__u16 flags;
	BIOQUEUE *q;
	PARTITIONS *p;
	unsigned max_sectors;
	unsigned char used_tags;
	unsigned char limit_tags;
	__u8 secsize_shift;
	__u8 errorlevel;
	TIMER timer;
	XLIST_HEAD in_progress;
	struct __slhead tag_slab;
	__u8 scsi_version;
	__u8 tagging;
	unsigned char controller_tags;
	unsigned char waiting_tags;
	int timeout;
	int extended_timeout;
	int probe_timeout;
	__sec_t capacity;
	LIST_HEAD waiting_list;

	TIMER unchoke_tags;

	int user_flags;
	unsigned user_max_transfer;

	IOCTLRQ *pass_through;
	WQ pass_through_wait;
	TIMER pass_through_timer;
	__p_addr pass_through_phys;
	vspace_physunlock_t *pass_through_physunlock;
	DECL_SCSIRQ(SCSI_PASS_THROUGH_CMD_LEN) pass_through_cmd;
	BIODESC pass_through_desc;
	u_jiffies_t pass_through_posted_time;
	__u8 pass_through_sense[SCSI_PASS_THROUGH_SENSE_LEN];
	__u8 pass_through_posted;
	__u8 pass_through_xform;

	char vendor[9];
	char product[17];
	char revision[5];
	__u8 errorlevel_set;
	char dev_name[__MAX_STR_LEN];
	char ctrl[__MAX_STR_LEN];
	void *dlrq;
	void *lnte;
	void *dummy_tag;
	SCSI_INQUIRY_DATA inq;
	THREAD_RQ media_thread;
	WQ media_wq;
	WQ media_wq_noerror;
	void *write_buffer;
	void *pad_ptr;
} SD;

#define STD_MMC_5		-6
#define STD_MMC_4		-5
#define STD_MMC_3		-4
#define STD_MMC_2		-3
#define STD_MMC_1		-2
#define STD_MMC_SCSI_2		-1
	/* CDs STD numbers should grow down ... */
#define STD_SCSI_1		1
#define STD_SCSI_2		2
#define STD_RBC			3
#define STD_SBC_1		4
#define STD_SBC_2		5

#define STD_IS_DISK(std)	((std) >= 0)
#define STD_IS_CD(std)		((std) < 0)

#define FLAGS_NO_MEDIA			0x0001
#define FLAGS_MEDIA_PROBING		0x0002
#define FLAGS_LARGER_SECSIZE		0x0004
#define FLAGS_SMALLER_SECSIZE		0x0008
#define FLAGS_WP			0x0010
#define FLAGS_COMMAND_SIZE_10		0x0020
#define FLAGS_COMMAND_SIZE_16		0x0040
#define FLAGS_NO_SYNCHRONIZE_CACHE	0x0080
#define FLAGS_BLOCK_WRITES		0x8000

#define USER_FLAGS_RCACHE		0x00000001
#define USER_FLAGS_RCACHE_SET		0x00000002
#define USER_FLAGS_WCACHE		0x00000004
#define USER_FLAGS_WCACHE_SET		0x00000008

#define SD_SECTOR_SIZE(sd)	(__unlikely((sd)->flags & FLAGS_LARGER_SECSIZE) ? BIO_SECTOR_SIZE << (sd)->secsize_shift : BIO_SECTOR_SIZE)

#define SD_REMOVABLE_MEDIA(sd)	(sd->inq.rmb & INQ_RMB_RMB)

typedef struct {
	LIST_ENTRY list;
	SD *sd;
	BIORQ *brq;
	unsigned expected_xfer;
	int retries;
	sched_unsigned t;
	DECL_SCSIRQ(10) cmd;
	SCSI_SENSE_DATA sense;
	BIODESC split_desc;
	u_jiffies_lo_t start_time;
	__usec_t lba;
	BIODESC pad_desc1;
	BIODESC pad_desc2;
	BIORQ *real_rq;
	BIORQ pw_rq;
	BIODESC pw_desc;
} SD_TAG;

#define TAG_RQ(tag)	(__likely((tag)->brq != &(tag)->pw_rq) ? (tag)->brq : (tag)->real_rq)

/* SD.C */
extern const HANDLE_OPERATIONS SD_OPERATIONS;

/* SDMEDIA.C */

long SD_MEDIA_THREAD(void *sd_);
void SD_MEDIA_PROBE(SD *sd);
int SD_MEDIA_CHANGE_ACTION(SCSIRQ *cmd);
void SD_RESET_FSTAT(SD *sd);

/* SDBIO.C */
void SD_TAG_CTOR(struct __slhead *sd_, void *tag_);
void SD_FREE_TAG(SD_TAG *tag);
int SD_RETRY_REQUEST(SD_TAG *tag);
int SD_POST_REQUEST(SD_TAG *tag, BIORQ *RQ);
extern IO_STUB SD_REQUEST;
void SD_DEQUEUE_LOOP(SD *sd);
int SD_DEQUEUE(SCSI_ATTACH_PARAM *ap);
BIORQ *SD_PROBE_QUEUE(SCSI_ATTACH_PARAM *ap);
void SD_DEQUEUE_ERROR(SD *sd, int error);
void SD_TIMER_FN(TIMER *t);
void SD_UNCHOKE_TAGS(TIMER *t);
int SD_IOCTL(IOCTLRQ *rq, PARTITION *pa, IORQ *rq_to_queue);

/* SDLSEC.C */

void SD_PAD_READ_REQUEST(SD_TAG *tag, BIORQ *RQ);
void SD_UNPAD_READ_REQUEST(SD_TAG *tag, BIORQ *RQ);
void SD_UNPAD_READ_REQUEST_END(SD_TAG *tag, BIORQ *RQ);
int SD_WRITES_IN_PROGRESS(SD *sd);
int SD_PARTIAL_WRITE(SD_TAG *tag, BIORQ *RQ);
void SD_PARTIAL_WRITE_DONE(SD_TAG *tag);

/* SDPSTHRU.C */
void SCSI_QUEUE_PASS_THROUGH(SD *sd, IOCTLRQ *rq);
int SCSI_PROCESS_PASS_THROUGH(SD *sd);
void SCSI_PASS_THROUGH_DONE(SCSIRQ *cmd);
void SCSI_PASS_THROUGH_TIMER_FN(TIMER *t);

#endif
