#include <SPAD/DEV_KRNL.H>
#include <SPAD/BIO.H>
#include <SPAD/BIO_KRNL.H>

#include "SD.H"

void SD_PAD_READ_REQUEST(SD_TAG *tag, BIORQ *RQ)
{
	SD *sd = tag->sd;
	unsigned start_pad, end_pad;
	start_pad = (unsigned)RQ->sec & ((1 << sd->secsize_shift) - 1);
	if (start_pad) {
#if __DEBUG >= 1
		if (__unlikely(RQ->desc == &tag->pad_desc1))
			KERNEL$SUICIDE("SD_PAD_READ_REQUEST: BEGINNING ALREADY PADDED");
#endif
		tag->pad_desc1.v.ptr = (unsigned long)sd->pad_ptr;
		tag->pad_desc1.v.len = start_pad << BIO_SECTOR_SIZE_BITS;
		tag->pad_desc1.v.vspace = &KERNEL$VIRTUAL;
		tag->pad_desc1.next = RQ->desc;
		RQ->desc = &tag->pad_desc1;
		RQ->sec -= start_pad;
		RQ->nsec += start_pad;
	}
	end_pad = RQ->nsec & ((1 << sd->secsize_shift) - 1);
	if (end_pad) {
		BIODESC *desc;
		end_pad = (1 << sd->secsize_shift) - end_pad;
		tag->pad_desc2.v.ptr = (unsigned long)sd->pad_ptr;
		tag->pad_desc2.v.len = end_pad << BIO_SECTOR_SIZE_BITS;
		tag->pad_desc2.v.vspace = &KERNEL$VIRTUAL;
		tag->pad_desc2.next = NULL;
		desc = RQ->desc;
		while (desc->next) desc = desc->next;
#if __DEBUG >= 1
		if (desc->v.vspace == &KERNEL$VIRTUAL && desc->v.ptr == (unsigned long)sd->pad_ptr)
			KERNEL$SUICIDE("SD_PAD_READ_REQUEST: END ALREADY PADDED");
#endif
		desc->next = &tag->pad_desc2;
		RQ->nsec += end_pad;
	}
}

void SD_UNPAD_READ_REQUEST(SD_TAG *tag, BIORQ *RQ)
{
	if (tag && __unlikely(RQ->desc == &tag->pad_desc1)) {
		RQ->sec += tag->pad_desc1.v.len >> BIO_SECTOR_SIZE_BITS;
		RQ->nsec -= tag->pad_desc1.v.len >> BIO_SECTOR_SIZE_BITS;
		RQ->desc = tag->pad_desc1.next;
	}
	SD_UNPAD_READ_REQUEST_END(tag, RQ);
}

void SD_UNPAD_READ_REQUEST_END(SD_TAG *tag, BIORQ *RQ)
{
	BIODESC *desc = RQ->desc;
	if (!desc->next) return;
	while (desc->next->next) desc = desc->next;
	if (desc->next == &tag->pad_desc2) {
		RQ->nsec -= desc->next->v.len >> BIO_SECTOR_SIZE_BITS;
		desc->next = NULL;
	}
}

int SD_WRITES_IN_PROGRESS(SD *sd)
{
	SD_TAG *test_tag;
	XLIST_FOR_EACH(test_tag, &sd->in_progress, SD_TAG, list) if (__unlikely(TAG_RQ(test_tag)->flags & BIO_WRITE)) return 1;
	LIST_FOR_EACH_UNLIKELY(test_tag, &sd->waiting_list, SD_TAG, list) if (__unlikely(TAG_RQ(test_tag)->flags & BIO_WRITE)) return 1;
	return 0;
}

int SD_PARTIAL_WRITE(SD_TAG *tag, BIORQ *RQ)
{
	SD *sd = tag->sd;
#if __DEBUG >= 1
	if (__unlikely(RQ == &tag->pw_rq)) KERNEL$SUICIDE("SD_PARTIAL_WRITE: ALREADY ACTIVE");
#endif
	sd->flags |= FLAGS_BLOCK_WRITES;
	if (__unlikely(SD_WRITES_IN_PROGRESS(sd))) {
		sd->used_tags--;
		__slow_slfree(tag);
		return 1;
	}
	tag->real_rq = RQ;
#if __DEBUG >= 1
	memset(&tag->pw_rq, 0, sizeof tag->pw_rq);
#endif
	tag->pw_rq.sec = RQ->sec & ~(__sec_t)((1 << sd->secsize_shift) - 1);
	tag->pw_rq.nsec = 1 << sd->secsize_shift;
	tag->pw_rq.flags = BIO_READ;
	tag->pw_rq.desc = &tag->pw_desc;
	tag->pw_rq.proc = RQ->proc;
	tag->pw_rq.partition = RQ->partition;
	tag->pw_desc.v.ptr = (unsigned long)sd->write_buffer;
	tag->pw_desc.v.len = BIO_SECTOR_SIZE << sd->secsize_shift;
	tag->pw_desc.v.vspace = &KERNEL$VIRTUAL;
	tag->pw_desc.next = NULL;
	return SD_POST_REQUEST(tag, &tag->pw_rq);
}

void SD_PARTIAL_WRITE_DONE(SD_TAG *tag)
{
	SD *sd = tag->sd;
	BIORQ *RQ = tag->real_rq;
	if (!(tag->pw_rq.flags & BIO_WRITE)) {
		VBUF buf;
		long s;
		unsigned res;
		unsigned start_pad = (((unsigned)RQ->sec & ((1 << sd->secsize_shift) - 1)) << BIO_SECTOR_SIZE_BITS);
		buf.ptr = (__u8 *)sd->write_buffer + start_pad;
		buf.len = (BIO_SECTOR_SIZE << sd->secsize_shift) - start_pad;
		buf.spl = SPL_X(SPL_ATA_SCSI);
		if (buf.len >> BIO_SECTOR_SIZE_BITS > RQ->nsec) buf.len = RQ->nsec << BIO_SECTOR_SIZE_BITS;
		again:
		RAISE_SPL(SPL_VSPACE);
		s = RQ->desc->v.vspace->op->vspace_get(&RQ->desc->v, &buf);
		res = s & (BIO_SECTOR_SIZE - 1);
		if (__unlikely(res)) {
			RQ->desc->v.ptr -= res;
			RQ->desc->v.len += res;
			s &= ~(long)(BIO_SECTOR_SIZE - 1);
		}
		if (__unlikely(!s)) {
			BIO$FAULT(RQ, RQ->sec);
			goto free_this;
		}
		buf.ptr = (__u8 *)buf.ptr + s;
		buf.len -= s;
		RQ->sec += s >> BIO_SECTOR_SIZE_BITS;
		RQ->nsec -= s >> BIO_SECTOR_SIZE_BITS;
		if (!RQ->desc->v.len) RQ->desc = RQ->desc->next;
#if __DEBUG >= 1
		if (RQ->nsec) {
			if (__unlikely(!RQ->desc))
				KERNEL$SUICIDE("SD_PARTIAL_WRITE_DONE: %d SECTORS LEAKED", RQ->nsec);
		} else {
			if (__unlikely(RQ->desc != NULL))
				KERNEL$SUICIDE("SD_PARTIAL_WRITE_DONE: DESCRIPTORS EXHAUSTED");
		}
#endif
		if (__unlikely(buf.len != 0) && RQ->nsec) goto again;

		tag->pw_rq.flags = BIO_WRITE;
		tag->cmd.direction = PF_READ;
		tag->cmd.cmd[0] += SCMD_WRITE_6 - SCMD_READ_6;
		tag->retries = SD_RETRIES;
		SD_RETRY_REQUEST(tag);
	} else {
		if (RQ->nsec) {
			if (SD_POST_REQUEST(tag, RQ) == 1) BIOQUE$ENQUEUE_REQUEST(sd->q, RQ);
			return;
		}
#if __DEBUG >= 1
		if (__unlikely(!RQ->tmp3))
			KERNEL$SUICIDE("SD_PARTIAL_WRITE_DONE: REFERENCE COUNT UNDERFLOW");
#endif
		free_this:
		if (__likely(!--RQ->tmp3)) CALL_BIO(RQ);
		SD_FREE_TAG(tag);
	}
}
