#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <SPAD/PCI.H>
#include <SPAD/SYSLOG.H>
#include <SPAD/TTY.H>
#include <SPAD/DEV_KRNL.H>
#include <ARCH/BSF.H>
#include <VALUES.H>
#include <STDLIB.H>

#include <VGA.H>
#include "ATIREG.H"

/*
 * Parts are copied from XFree86 driver
 *
 * Copyright 2000 ATI Technologies Inc., Markham, Ontario, and
 *                VA Linux Systems Inc., Fremont, California.
 *
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation on the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT.  IN NO EVENT SHALL ATI, VA LINUX SYSTEMS AND/OR
 * THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#define RADEON_TIMEOUT		TIMEOUT_JIFFIES(JIFFIES_PER_SECOND / 10)

#define CHIP_FAMILY_MASK	0x000000ff
#define CHIP_FAMILY_RADEON	0x00000001
#define CHIP_FAMILY_RV100	0x00000002
#define CHIP_FAMILY_RS100	0x00000003
#define CHIP_FAMILY_RV200	0x00000004
#define CHIP_FAMILY_RS200	0x00000005
#define CHIP_FAMILY_R200	0x00000006
#define CHIP_FAMILY_RV250	0x00000007
#define CHIP_FAMILY_RS300	0x00000008
#define CHIP_FAMILY_RV280	0x00000009
#define CHIP_FAMILY_R300	0x0000000a
#define CHIP_FAMILY_R350	0x0000000b
#define CHIP_FAMILY_RV350	0x0000000c
#define CHIP_FAMILY_RV380	0x0000000d
#define CHIP_FAMILY_R420	0x0000000e
#define CHIP_FAMILY_RV410	0x0000000f
#define CHIP_FAMILY_RS400	0x00000010
#define CHIP_FAMILY_RS480	0x00000011
#define CHIP_FAMILY_RV515	0x00000012
#define CHIP_FAMILY_R520	0x00000013
#define CHIP_FAMILY_RV530	0x00000014
#define CHIP_FAMILY_R580	0x00000015
#define CHIP_FAMILY_RV560	0x00000016
#define CHIP_FAMILY_RV570	0x00000017
#define CHIP_FAMILY_RS600	0x00000018
#define CHIP_FAMILY_RS690	0x00000019
#define CHIP_FAMILY_RS740	0x0000001a
#define CHIP_FAMILY_R600	0x0000001b
#define CHIP_FAMILY_R630	0x0000001c
#define CHIP_FAMILY_RV610	0x0000001d
#define CHIP_FAMILY_RV630	0x0000001e
#define CHIP_FAMILY_RV670	0x0000001f
#define CHIP_FAMILY_RV620	0x00000020
#define CHIP_FAMILY_RV635	0x00000021
#define CHIP_FAMILY_RS780	0x00000022
#define CHIP_FAMILY_RS880	0x00000023
#define CHIP_FAMILY_RV770	0x00000024
#define CHIP_FAMILY_RV730	0x00000025
#define CHIP_FAMILY_RV710	0x00000026

#define CHIP_MOBILE		0x00000100
#define CHIP_IGP		0x00000200
#define CHIP_NOCRTC2		0x00000400
#define CHIP_NOINTTVOUT		0x00000800
#define CHIP_SINGLEDAC		0x00001000

static const struct pci_id_s ati_cards[] = {
{ 0x1002, 0x3150, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility X600 (M24) 3150 (PCIE)", CHIP_FAMILY_RV380 | CHIP_MOBILE },
{ 0x1002, 0x3151, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireMV 2400 (PCI)", CHIP_FAMILY_RV380 },
{ 0x1002, 0x3152, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility X300 (M24) 3152 (PCIE)", CHIP_FAMILY_RV380 | CHIP_MOBILE },
{ 0x1002, 0x3154, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL M24 GL 3154 (PCIE)", CHIP_FAMILY_RV380 | CHIP_MOBILE },
{ 0x1002, 0x3E50, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X600 (RV380) 3E50 (PCIE)", CHIP_FAMILY_RV380 },
{ 0x1002, 0x3E54, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V3200 (RV380) 3E54 (PCIE)", CHIP_FAMILY_RV380 },
{ 0x1002, 0x4136, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon IGP320 (A3) 4136", CHIP_FAMILY_RS100 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x4137, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon IGP330/340/350 (A4) 4137", CHIP_FAMILY_RS200 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x4144, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9500 AD (AGP)", CHIP_FAMILY_R300 },
{ 0x1002, 0x4145, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9500 AE (AGP)", CHIP_FAMILY_R300 },
{ 0x1002, 0x4146, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9600TX AF (AGP)", CHIP_FAMILY_R300 },
{ 0x1002, 0x4147, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL Z1 AG (AGP)", CHIP_FAMILY_R300 },
{ 0x1002, 0x4148, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9800SE AH (AGP)", CHIP_FAMILY_R350 },
{ 0x1002, 0x4149, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9800 AI (AGP)", CHIP_FAMILY_R350 },
{ 0x1002, 0x414A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9800 AJ (AGP)", CHIP_FAMILY_R350 },
{ 0x1002, 0x414B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL X2 AK (AGP)", CHIP_FAMILY_R350 },
{ 0x1002, 0x4150, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9600 AP (AGP)", CHIP_FAMILY_RV350 },
{ 0x1002, 0x4151, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9600SE AQ (AGP)", CHIP_FAMILY_RV350 },
{ 0x1002, 0x4152, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9600XT AR (AGP)", CHIP_FAMILY_RV350 },
{ 0x1002, 0x4153, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9600 AS (AGP)", CHIP_FAMILY_RV350 },
{ 0x1002, 0x4154, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL T2 AT (AGP)", CHIP_FAMILY_RV350 },
{ 0x1002, 0x4155, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9650", CHIP_FAMILY_RV350 },
{ 0x1002, 0x4156, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL RV360 AV (AGP)", CHIP_FAMILY_RV350 },
{ 0x1002, 0x4237, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 7000 IGP (A4+) 4237", CHIP_FAMILY_RS200 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x4242, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 8500 AIW BB (AGP)", CHIP_FAMILY_R200 | CHIP_NOINTTVOUT },
{ 0x1002, 0x4243, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 8500 AIW BC (AGP)", CHIP_FAMILY_R200 | CHIP_NOINTTVOUT },
{ 0x1002, 0x4336, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon IGP320M (U1) 4336", CHIP_FAMILY_RS100 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x4337, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon IGP330M/340M/350M (U2) 4337", CHIP_FAMILY_RS200 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x4437, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 7000 IGP 4437", CHIP_FAMILY_RS200 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x4966, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9000/PRO If (AGP/PCI)", CHIP_FAMILY_RV250 },
{ 0x1002, 0x4967, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9000 Ig (AGP/PCI)", CHIP_FAMILY_RV250 },
{ 0x1002, 0x4A48, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800 (R420) JH (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4A49, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800PRO (R420) JI (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4A4A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800SE (R420) JJ (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4A4B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800 (R420) JK (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4A4C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800 (R420) JL (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4A4D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL X3 (R420) JM (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4A4E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9800 (M18) JN (AGP)", CHIP_FAMILY_R420 | CHIP_MOBILE },
{ 0x1002, 0x4A4F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800 SE (R420) (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4A50, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800XT (R420) JP (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4B49, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X850 XT (R480) (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4B4A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X850 SE (R480) (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4B4B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X850 PRO (R480) (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4B4C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X850 XT PE (R480) (AGP)", CHIP_FAMILY_R420 },
{ 0x1002, 0x4C57, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility M7 LW (AGP)", CHIP_FAMILY_RV200 | CHIP_MOBILE },
{ 0x1002, 0x4C58, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL 7800 M7 LX (AGP)", CHIP_FAMILY_RV200 | CHIP_MOBILE },
{ 0x1002, 0x4C59, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility M6 LY (AGP)", CHIP_FAMILY_RV100 | CHIP_MOBILE },
{ 0x1002, 0x4C5A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility M6 LZ (AGP)", CHIP_FAMILY_RV100 | CHIP_MOBILE },
{ 0x1002, 0x4C64, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL Mobility 9000 (M9) Ld (AGP)", CHIP_FAMILY_RV250 | CHIP_MOBILE },
{ 0x1002, 0x4C66, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9000 (M9) Lf (AGP)", CHIP_FAMILY_RV250 | CHIP_MOBILE },
{ 0x1002, 0x4C67, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9000 (M9) Lg (AGP)", CHIP_FAMILY_RV250 | CHIP_MOBILE },
{ 0x1002, 0x4E44, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9700 Pro ND (AGP)", CHIP_FAMILY_R300 },
{ 0x1002, 0x4E45, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9700/9500Pro NE (AGP)", CHIP_FAMILY_R300 },
{ 0x1002, 0x4E46, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9600TX NF (AGP)", CHIP_FAMILY_R300 },
{ 0x1002, 0x4E47, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL X1 NG (AGP)", CHIP_FAMILY_R300 },
{ 0x1002, 0x4E48, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9800PRO NH (AGP)", CHIP_FAMILY_R350 },
{ 0x1002, 0x4E49, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9800 NI (AGP)", CHIP_FAMILY_R350 },
{ 0x1002, 0x4E4A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL X2 NK (AGP)", CHIP_FAMILY_R350 },
{ 0x1002, 0x4E4B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9800XT NJ (AGP)", CHIP_FAMILY_R350 },
{ 0x1002, 0x4E50, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9600/9700 (M10/M11) NP (AGP)", CHIP_FAMILY_RV350 | CHIP_MOBILE },
{ 0x1002, 0x4E51, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9600 (M10) NQ (AGP)", CHIP_FAMILY_RV350 | CHIP_MOBILE },
{ 0x1002, 0x4E52, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9600 (M11) NR (AGP)", CHIP_FAMILY_RV350 | CHIP_MOBILE },
{ 0x1002, 0x4E53, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9600 (M10) NS (AGP)", CHIP_FAMILY_RV350 | CHIP_MOBILE },
{ 0x1002, 0x4E54, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL Mobility T2 (M10) NT (AGP)", CHIP_FAMILY_RV350 | CHIP_MOBILE },
{ 0x1002, 0x4E56, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL Mobility T2e (M11) NV (AGP)", CHIP_FAMILY_RV350 | CHIP_MOBILE },
{ 0x1002, 0x5144, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon QD (AGP)", CHIP_FAMILY_RADEON | CHIP_NOCRTC2 | CHIP_NOINTTVOUT },
{ 0x1002, 0x5145, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon QE (AGP)", CHIP_FAMILY_RADEON | CHIP_NOCRTC2 | CHIP_NOINTTVOUT },
{ 0x1002, 0x5146, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon QF (AGP)", CHIP_FAMILY_RADEON | CHIP_NOCRTC2 | CHIP_NOINTTVOUT },
{ 0x1002, 0x5147, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon QG (AGP)", CHIP_FAMILY_RADEON | CHIP_NOCRTC2 | CHIP_NOINTTVOUT },
{ 0x1002, 0x5148, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL 8700/8800 QH (AGP)", CHIP_FAMILY_R200 | CHIP_NOINTTVOUT },
{ 0x1002, 0x514C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 8500 QL (AGP)", CHIP_FAMILY_R200 | CHIP_NOINTTVOUT },
{ 0x1002, 0x514D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9100 QM (AGP)", CHIP_FAMILY_R200 | CHIP_NOINTTVOUT },
{ 0x1002, 0x5157, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 7500 QW (AGP/PCI)", CHIP_FAMILY_RV200 },
{ 0x1002, 0x5158, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 7500 QX (AGP/PCI)", CHIP_FAMILY_RV200 },
{ 0x1002, 0x5159, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon VE/7000 QY (AGP/PCI)", CHIP_FAMILY_RV100 },
{ 0x1002, 0x515A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon VE/7000 QZ (AGP/PCI)", CHIP_FAMILY_RV100 },
{ 0x1002, 0x515E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI ES1000 515E (PCI)", CHIP_FAMILY_RV100 | CHIP_NOCRTC2 },
{ 0x1002, 0x5460, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility X300 (M22) 5460 (PCIE)", CHIP_FAMILY_RV380 | CHIP_MOBILE },
{ 0x1002, 0x5462, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility X600 SE (M24C) 5462 (PCIE)", CHIP_FAMILY_RV380 | CHIP_MOBILE },
{ 0x1002, 0x5464, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL M22 GL 5464 (PCIE)", CHIP_FAMILY_RV380 | CHIP_MOBILE },
{ 0x1002, 0x5548, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800 (R423) UH (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5549, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800PRO (R423) UI (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x554A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800LE (R423) UJ (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x554B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800SE (R423) UK (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x554C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800 XTP (R430) (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x554D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800 XL (R430) (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x554E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800 SE (R430) (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x554F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800 (R430) (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5550, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V7100 (R423) (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5551, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V5100 (R423) UQ (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5552, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL unknown (R423) UR (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5554, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL unknown (R423) UT (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x564A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL V5000 (M26) (PCIE)", CHIP_FAMILY_RV410 | CHIP_MOBILE },
{ 0x1002, 0x564B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL V5000 (M26) (PCIE)", CHIP_FAMILY_RV410 | CHIP_MOBILE },
{ 0x1002, 0x564F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X700 XL (M26) (PCIE)", CHIP_FAMILY_RV410 | CHIP_MOBILE },
{ 0x1002, 0x5652, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X700 (M26) (PCIE)", CHIP_FAMILY_RV410 | CHIP_MOBILE },
{ 0x1002, 0x5653, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X700 (M26) (PCIE)", CHIP_FAMILY_RV410 | CHIP_MOBILE },
{ 0x1002, 0x5657, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X550XTX 5657 (PCIE)", CHIP_FAMILY_RV410 },
{ 0x1002, 0x5834, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9100 IGP (A5) 5834", CHIP_FAMILY_RS300 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x5835, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9100 IGP (U3) 5835", CHIP_FAMILY_RS300 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x5954, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon XPRESS 200 5954 (PCIE)", CHIP_FAMILY_RS480 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x5955, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon XPRESS 200M 5955 (PCIE)", CHIP_FAMILY_RS480 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x5960, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9250 5960 (AGP)", CHIP_FAMILY_RV280 },
{ 0x1002, 0x5961, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9200 5961 (AGP)", CHIP_FAMILY_RV280 },
{ 0x1002, 0x5962, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9200 5962 (AGP)", CHIP_FAMILY_RV280 },
{ 0x1002, 0x5964, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9200SE 5964 (AGP)", CHIP_FAMILY_RV280 },
{ 0x1002, 0x5965, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireMV 2200 (PCI)", CHIP_FAMILY_RV280 },
{ 0x1002, 0x5969, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI ES1000 5969 (PCI)", CHIP_FAMILY_RV100 | CHIP_NOCRTC2 },
{ 0x1002, 0x5974, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon XPRESS 200 5974 (PCIE)", CHIP_FAMILY_RS480 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x5975, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon XPRESS 200M 5975 (PCIE)", CHIP_FAMILY_RS480 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x5A41, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon XPRESS 200 5A41 (PCIE)", CHIP_FAMILY_RS400 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x5A42, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon XPRESS 200M 5A42 (PCIE)", CHIP_FAMILY_RS400 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x5A61, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon XPRESS 200 5A61 (PCIE)", CHIP_FAMILY_RS400 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x5A62, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon XPRESS 200M 5A62 (PCIE)", CHIP_FAMILY_RS400 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x5B60, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X300 (RV370) 5B60 (PCIE)", CHIP_FAMILY_RV380 },
{ 0x1002, 0x5B62, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X600 (RV370) 5B62 (PCIE)", CHIP_FAMILY_RV380 },
{ 0x1002, 0x5B63, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X550 (RV370) 5B63 (PCIE)", CHIP_FAMILY_RV380 },
{ 0x1002, 0x5B64, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V3100 (RV370) 5B64 (PCIE)", CHIP_FAMILY_RV380 },
{ 0x1002, 0x5B65, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireMV 2200 PCIE (RV370) 5B65 (PCIE)", CHIP_FAMILY_RV380 },
{ 0x1002, 0x5C61, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9200 (M9+) 5C61 (AGP)", CHIP_FAMILY_RV280 | CHIP_MOBILE },
{ 0x1002, 0x5C63, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9200 (M9+) 5C63 (AGP)", CHIP_FAMILY_RV280 | CHIP_MOBILE },
{ 0x1002, 0x5D48, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X800 XT (M28) (PCIE)", CHIP_FAMILY_R420 | CHIP_MOBILE },
{ 0x1002, 0x5D49, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL V5100 (M28) (PCIE)", CHIP_FAMILY_R420 | CHIP_MOBILE },
{ 0x1002, 0x5D4A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X800 (M28) (PCIE)", CHIP_FAMILY_R420 | CHIP_MOBILE },
{ 0x1002, 0x5D4C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X850 5D4C (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5D4D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X850 XT PE (R480) (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5D4E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X850 SE (R480) (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5D4F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X850 PRO (R480) (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5D50, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI unknown Radeon / FireGL (R480) 5D50 (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5D52, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X850 XT (R480) (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5D57, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X800XT (R423) 5D57 (PCIE)", CHIP_FAMILY_R420 },
{ 0x1002, 0x5E48, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V5000 (RV410) (PCIE)", CHIP_FAMILY_RV410 },
{ 0x1002, 0x5E4A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X700 XT (RV410) (PCIE)", CHIP_FAMILY_RV410 },
{ 0x1002, 0x5E4B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X700 PRO (RV410) (PCIE)", CHIP_FAMILY_RV410 },
{ 0x1002, 0x5E4C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X700 SE (RV410) (PCIE)", CHIP_FAMILY_RV410 },
{ 0x1002, 0x5E4D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X700 (RV410) (PCIE)", CHIP_FAMILY_RV410 },
{ 0x1002, 0x5E4F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X700 SE (RV410) (PCIE)", CHIP_FAMILY_RV410 },
{ 0x1002, 0x7100, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1800", CHIP_FAMILY_R520 },
{ 0x1002, 0x7101, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1800 XT", CHIP_FAMILY_R520 | CHIP_MOBILE },
{ 0x1002, 0x7102, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1800", CHIP_FAMILY_R520 | CHIP_MOBILE },
{ 0x1002, 0x7103, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL V7200", CHIP_FAMILY_R520 | CHIP_MOBILE },
{ 0x1002, 0x7104, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V7200", CHIP_FAMILY_R520 },
{ 0x1002, 0x7105, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V5300", CHIP_FAMILY_R520 },
{ 0x1002, 0x7106, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL V7100", CHIP_FAMILY_R520 | CHIP_MOBILE },
{ 0x1002, 0x7108, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1800", CHIP_FAMILY_R520 },
{ 0x1002, 0x7109, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1800", CHIP_FAMILY_R520 },
{ 0x1002, 0x710A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1800", CHIP_FAMILY_R520 },
{ 0x1002, 0x710B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1800", CHIP_FAMILY_R520 },
{ 0x1002, 0x710C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1800", CHIP_FAMILY_R520 },
{ 0x1002, 0x710E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V7300", CHIP_FAMILY_R520 },
{ 0x1002, 0x710F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V7350", CHIP_FAMILY_R520 },
{ 0x1002, 0x7140, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1600", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7141, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV505", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7142, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1300/X1550", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7143, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1550", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7144, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI M54-GL", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x7145, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1400", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x7146, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1300/X1550", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7147, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1550 64-bit", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7149, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1300", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x714A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1300", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x714B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1300", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x714C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1300", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x714D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1300", CHIP_FAMILY_RV515 },
{ 0x1002, 0x714E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1300", CHIP_FAMILY_RV515 },
{ 0x1002, 0x714F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV505", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7151, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV505", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7152, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V3300", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7153, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V3350", CHIP_FAMILY_RV515 },
{ 0x1002, 0x715E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1300", CHIP_FAMILY_RV515 },
{ 0x1002, 0x715F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1550 64-bit", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7180, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1300/X1550", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7181, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1600", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7183, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1300/X1550", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7186, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1450", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x7187, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1300/X1550", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7188, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X2300", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x718A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X2300", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x718B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1350", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x718C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1350", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x718D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1450", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x718F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1300", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7193, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1550", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7196, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1350", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x719B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireMV 2250", CHIP_FAMILY_RV515 },
{ 0x1002, 0x719F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1550 64-bit", CHIP_FAMILY_RV515 },
{ 0x1002, 0x71C0, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1600", CHIP_FAMILY_RV530 },
{ 0x1002, 0x71C1, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1650", CHIP_FAMILY_RV530 },
{ 0x1002, 0x71C2, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1600", CHIP_FAMILY_RV530 },
{ 0x1002, 0x71C3, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1600", CHIP_FAMILY_RV530 },
{ 0x1002, 0x71C4, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL V5200", CHIP_FAMILY_RV530 | CHIP_MOBILE },
{ 0x1002, 0x71C5, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1600", CHIP_FAMILY_RV530 | CHIP_MOBILE },
{ 0x1002, 0x71C6, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1650", CHIP_FAMILY_RV530 },
{ 0x1002, 0x71C7, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1650", CHIP_FAMILY_RV530 },
{ 0x1002, 0x71CD, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1600", CHIP_FAMILY_RV530 },
{ 0x1002, 0x71CE, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1300 XT/X1600 Pro", CHIP_FAMILY_RV530 },
{ 0x1002, 0x71D2, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V3400", CHIP_FAMILY_RV530 },
{ 0x1002, 0x71D4, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL V5250", CHIP_FAMILY_RV530 | CHIP_MOBILE },
{ 0x1002, 0x71D5, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1700", CHIP_FAMILY_RV530 | CHIP_MOBILE },
{ 0x1002, 0x71D6, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1700 XT", CHIP_FAMILY_RV530 | CHIP_MOBILE },
{ 0x1002, 0x71DA, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V5200", CHIP_FAMILY_RV530 },
{ 0x1002, 0x71DE, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1700", CHIP_FAMILY_RV530 | CHIP_MOBILE },
{ 0x1002, 0x7200, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X2300HD", CHIP_FAMILY_RV515 },
{ 0x1002, 0x7210, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 2300", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x7211, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 2300", CHIP_FAMILY_RV515 | CHIP_MOBILE },
{ 0x1002, 0x7240, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1950", CHIP_FAMILY_R580 },
{ 0x1002, 0x7243, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x7244, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1950", CHIP_FAMILY_R580 },
{ 0x1002, 0x7245, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x7246, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x7247, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x7248, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x7249, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x724A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x724B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x724C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x724D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x724E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI AMD Stream Processor", CHIP_FAMILY_R580 },
{ 0x1002, 0x724F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1900", CHIP_FAMILY_R580 },
{ 0x1002, 0x7280, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1950", CHIP_FAMILY_RV570 },
{ 0x1002, 0x7281, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV560", CHIP_FAMILY_RV560 },
{ 0x1002, 0x7283, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV560", CHIP_FAMILY_RV560 },
{ 0x1002, 0x7284, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon X1900", CHIP_FAMILY_R580 | CHIP_MOBILE },
{ 0x1002, 0x7287, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV560", CHIP_FAMILY_RV560 },
{ 0x1002, 0x7288, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1950 GT", CHIP_FAMILY_RV570 },
{ 0x1002, 0x7289, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV570", CHIP_FAMILY_RV570 },
{ 0x1002, 0x728B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV570", CHIP_FAMILY_RV570 },
{ 0x1002, 0x728C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V7400", CHIP_FAMILY_RV570 },
{ 0x1002, 0x7290, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV560", CHIP_FAMILY_RV560 },
{ 0x1002, 0x7291, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1650", CHIP_FAMILY_RV560 },
{ 0x1002, 0x7293, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1650", CHIP_FAMILY_RV560 },
{ 0x1002, 0x7297, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV560", CHIP_FAMILY_RV560 },
{ 0x1002, 0x7834, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 9100 PRO IGP 7834", CHIP_FAMILY_RS300 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x7835, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Mobility 9200 IGP 7835", CHIP_FAMILY_RS300 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x791E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1200", CHIP_FAMILY_RS690 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x791F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1200", CHIP_FAMILY_RS690 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x793F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1200", CHIP_FAMILY_RS600 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x7941, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1200", CHIP_FAMILY_RS600 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x7942, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon X1200", CHIP_FAMILY_RS600 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x796C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RS740", CHIP_FAMILY_RS740 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x796D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RS740M", CHIP_FAMILY_RS740 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x796E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RS740", CHIP_FAMILY_RS740 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x796F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RS740M", CHIP_FAMILY_RS740 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9400, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2900 XT", CHIP_FAMILY_R600 },
{ 0x1002, 0x9401, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2900 XT", CHIP_FAMILY_R600 },
{ 0x1002, 0x9402, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2900 XT", CHIP_FAMILY_R600 },
{ 0x1002, 0x9403, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2900 Pro", CHIP_FAMILY_R600 },
{ 0x1002, 0x9405, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2900 GT", CHIP_FAMILY_R600 },
{ 0x1002, 0x940A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V8650", CHIP_FAMILY_R600 },
{ 0x1002, 0x940B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V8600", CHIP_FAMILY_R600 },
{ 0x1002, 0x940F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V7600", CHIP_FAMILY_R600 },
{ 0x1002, 0x9440, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 4800 Series", CHIP_FAMILY_RV770 },
{ 0x1002, 0x9441, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 4870 X2", CHIP_FAMILY_RV770 },
{ 0x1002, 0x9442, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 4800 Series", CHIP_FAMILY_RV770 },
{ 0x1002, 0x9444, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FirePro V8750 (FireGL)", CHIP_FAMILY_RV770 },
{ 0x1002, 0x9446, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FirePro V7760 (FireGL)", CHIP_FAMILY_RV770 },
{ 0x1002, 0x944A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility RADEON HD 4850", CHIP_FAMILY_RV770 | CHIP_MOBILE },
{ 0x1002, 0x944B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility RADEON HD 4850 X2", CHIP_FAMILY_RV770 | CHIP_MOBILE },
{ 0x1002, 0x944C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 4800 Series", CHIP_FAMILY_RV770 },
{ 0x1002, 0x944E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FirePro RV770", CHIP_FAMILY_RV770 },
{ 0x1002, 0x9450, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "AMD FireStream 9270", CHIP_FAMILY_RV770 },
{ 0x1002, 0x9452, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "AMD FireStream 9250", CHIP_FAMILY_RV770 },
{ 0x1002, 0x9456, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FirePro V8700 (FireGL)", CHIP_FAMILY_RV770 },
{ 0x1002, 0x945A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility RADEON HD 4870", CHIP_FAMILY_RV770 | CHIP_MOBILE },
{ 0x1002, 0x945B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility RADEON M98", CHIP_FAMILY_RV770 | CHIP_MOBILE },
{ 0x1002, 0x9460, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 4800 Series", CHIP_FAMILY_RV770 },
{ 0x1002, 0x9462, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 4800 Series", CHIP_FAMILY_RV770 },
{ 0x1002, 0x946A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FirePro M7750", CHIP_FAMILY_RV770 | CHIP_MOBILE },
{ 0x1002, 0x946B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI M98", CHIP_FAMILY_RV770 | CHIP_MOBILE },
{ 0x1002, 0x947A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI M98", CHIP_FAMILY_RV770 | CHIP_MOBILE },
{ 0x1002, 0x947B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI M98", CHIP_FAMILY_RV770 | CHIP_MOBILE },
{ 0x1002, 0x9487, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon RV730 (AGP)", CHIP_FAMILY_RV730 },
{ 0x1002, 0x9489, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FirePro M5750", CHIP_FAMILY_RV730 | CHIP_MOBILE },
{ 0x1002, 0x948F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon RV730 (AGP)", CHIP_FAMILY_RV730 },
{ 0x1002, 0x9490, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV730XT [Radeon HD 4670]", CHIP_FAMILY_RV730 },
{ 0x1002, 0x9491, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon E4600", CHIP_FAMILY_RV730 },
{ 0x1002, 0x9498, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV730 PRO [Radeon HD 4650]", CHIP_FAMILY_RV730 },
{ 0x1002, 0x949C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FirePro V7750 (FireGL)", CHIP_FAMILY_RV730 },
{ 0x1002, 0x949E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FirePro V5700 (FireGL)", CHIP_FAMILY_RV730 },
{ 0x1002, 0x949F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FirePro V3750 (FireGL)", CHIP_FAMILY_RV730 },
{ 0x1002, 0x94C0, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV610", CHIP_FAMILY_RV610 },
{ 0x1002, 0x94C1, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2400 XT", CHIP_FAMILY_RV610 },
{ 0x1002, 0x94C3, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2400 Pro", CHIP_FAMILY_RV610 },
{ 0x1002, 0x94C4, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2400 PRO AGP", CHIP_FAMILY_RV610 },
{ 0x1002, 0x94C5, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V4000", CHIP_FAMILY_RV610 },
{ 0x1002, 0x94C6, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV610", CHIP_FAMILY_RV610 },
{ 0x1002, 0x94C7, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2350", CHIP_FAMILY_RV610 },
{ 0x1002, 0x94C8, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 2400 XT", CHIP_FAMILY_RV610 | CHIP_MOBILE },
{ 0x1002, 0x94C9, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 2400", CHIP_FAMILY_RV610 | CHIP_MOBILE },
{ 0x1002, 0x94CB, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon E2400", CHIP_FAMILY_RV610 | CHIP_MOBILE },
{ 0x1002, 0x94CC, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV610", CHIP_FAMILY_RV610 },
{ 0x1002, 0x94CD, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireMV 2260", CHIP_FAMILY_RV610 },
{ 0x1002, 0x9500, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV670", CHIP_FAMILY_RV670 },
{ 0x1002, 0x9501, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD3870", CHIP_FAMILY_RV670 },
{ 0x1002, 0x9504, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 3850", CHIP_FAMILY_RV670 | CHIP_MOBILE },
{ 0x1002, 0x9505, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD3850", CHIP_FAMILY_RV670 },
{ 0x1002, 0x9506, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 3850 X2", CHIP_FAMILY_RV670 | CHIP_MOBILE },
{ 0x1002, 0x9507, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV670", CHIP_FAMILY_RV670 },
{ 0x1002, 0x9508, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 3870", CHIP_FAMILY_RV670 | CHIP_MOBILE },
{ 0x1002, 0x9509, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 3870 X2", CHIP_FAMILY_RV670 | CHIP_MOBILE },
{ 0x1002, 0x950F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD3870 X2", CHIP_FAMILY_RV670 },
{ 0x1002, 0x9511, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V7700", CHIP_FAMILY_RV670 },
{ 0x1002, 0x9515, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD3850", CHIP_FAMILY_RV670 },
{ 0x1002, 0x9517, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD3690", CHIP_FAMILY_RV670 },
{ 0x1002, 0x9519, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "AMD Firestream 9170", CHIP_FAMILY_RV670 },
{ 0x1002, 0x9540, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 4550", CHIP_FAMILY_RV710 },
{ 0x1002, 0x9541, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon RV710", CHIP_FAMILY_RV710 },
{ 0x1002, 0x9542, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon RV710", CHIP_FAMILY_RV710 },
{ 0x1002, 0x954E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon RV710", CHIP_FAMILY_RV710 },
{ 0x1002, 0x954F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 4350", CHIP_FAMILY_RV710 },
{ 0x1002, 0x9552, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon 4300 Series", CHIP_FAMILY_RV710 | CHIP_MOBILE },
{ 0x1002, 0x9553, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon 4500 Series", CHIP_FAMILY_RV710 | CHIP_MOBILE },
{ 0x1002, 0x9555, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon 4500 Series", CHIP_FAMILY_RV710 | CHIP_MOBILE },
{ 0x1002, 0x9580, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI RV630", CHIP_FAMILY_RV630 },
{ 0x1002, 0x9581, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 2600", CHIP_FAMILY_RV630 | CHIP_MOBILE },
{ 0x1002, 0x9583, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 2600 XT", CHIP_FAMILY_RV630 | CHIP_MOBILE },
{ 0x1002, 0x9586, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2600 XT AGP", CHIP_FAMILY_RV630 },
{ 0x1002, 0x9587, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2600 Pro AGP", CHIP_FAMILY_RV630 },
{ 0x1002, 0x9588, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2600 XT", CHIP_FAMILY_RV630 },
{ 0x1002, 0x9589, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2600 Pro", CHIP_FAMILY_RV630 },
{ 0x1002, 0x958A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Gemini RV630", CHIP_FAMILY_RV630 },
{ 0x1002, 0x958B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Gemini Mobility Radeon HD 2600 XT", CHIP_FAMILY_RV630 | CHIP_MOBILE },
{ 0x1002, 0x958C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V5600", CHIP_FAMILY_RV630 },
{ 0x1002, 0x958D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireGL V3600", CHIP_FAMILY_RV630 },
{ 0x1002, 0x958E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 2600 LE", CHIP_FAMILY_RV630 },
{ 0x1002, 0x958F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL Graphics Processor", CHIP_FAMILY_RV630 | CHIP_MOBILE },
{ 0x1002, 0x95C0, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3470", CHIP_FAMILY_RV620 },
{ 0x1002, 0x95C2, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 3430", CHIP_FAMILY_RV620 | CHIP_MOBILE },
{ 0x1002, 0x95C4, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 3400 Series", CHIP_FAMILY_RV620 | CHIP_MOBILE },
{ 0x1002, 0x95C5, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3450", CHIP_FAMILY_RV620 },
{ 0x1002, 0x95C6, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3450", CHIP_FAMILY_RV620 },
{ 0x1002, 0x95C7, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3430", CHIP_FAMILY_RV620 },
{ 0x1002, 0x95C9, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3450", CHIP_FAMILY_RV620 },
{ 0x1002, 0x95CC, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FirePro V3700", CHIP_FAMILY_RV620 },
{ 0x1002, 0x95CD, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireMV 2450", CHIP_FAMILY_RV620 },
{ 0x1002, 0x95CE, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireMV 2260", CHIP_FAMILY_RV620 },
{ 0x1002, 0x95CF, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI FireMV 2260", CHIP_FAMILY_RV620 },
{ 0x1002, 0x9590, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3600 Series", CHIP_FAMILY_RV635 },
{ 0x1002, 0x9591, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 3650", CHIP_FAMILY_RV635 | CHIP_MOBILE },
{ 0x1002, 0x9593, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD 3670", CHIP_FAMILY_RV635 | CHIP_MOBILE },
{ 0x1002, 0x9595, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL V5700", CHIP_FAMILY_RV635 | CHIP_MOBILE },
{ 0x1002, 0x9596, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3650 AGP", CHIP_FAMILY_RV635 },
{ 0x1002, 0x9597, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3600 PRO", CHIP_FAMILY_RV635 },
{ 0x1002, 0x9598, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3600 XT", CHIP_FAMILY_RV635 },
{ 0x1002, 0x9599, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3600 PRO", CHIP_FAMILY_RV635 },
{ 0x1002, 0x959B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility FireGL V5725", CHIP_FAMILY_RV635 | CHIP_MOBILE },
{ 0x1002, 0x9610, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3200 Graphics", CHIP_FAMILY_RS780 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9611, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 3100 Graphics", CHIP_FAMILY_RS780 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9612, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3200 Graphics", CHIP_FAMILY_RS780 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9613, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 3100 Graphics", CHIP_FAMILY_RS780 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9614, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3300 Graphics", CHIP_FAMILY_RS780 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9615, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD 3200 Graphics", CHIP_FAMILY_RS780 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9616, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon 3000 Graphics", CHIP_FAMILY_RS780 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9710, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon HD Graphics", CHIP_FAMILY_RS880 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9711, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Graphics", CHIP_FAMILY_RS880 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9712, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon HD Graphics", CHIP_FAMILY_RS880 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9713, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Mobility Radeon Graphics", CHIP_FAMILY_RS880 | CHIP_MOBILE | CHIP_IGP | CHIP_SINGLEDAC },
{ 0x1002, 0x9714, PCI_ANY_ID, PCI_ANY_ID, 0, 0, "ATI Radeon Graphics", CHIP_FAMILY_RS880 | CHIP_IGP | CHIP_SINGLEDAC },
{ 0 },
};

static char *cons = "PCCONS@MEM_B8000:";
static const char dev_name[] = "VIDEO$ATI";
static pci_id_t pci_id;
static unsigned long chip_flags;
static __u8 *pci_regs;
#define chip_family (chip_flags & CHIP_FAMILY_MASK)
static void *dlrq, *lnte;

#define IS_FAMILY_R300()	(			\
	(chip_family == CHIP_FAMILY_R300) ||		\
	(chip_family == CHIP_FAMILY_RV350) ||		\
	(chip_family == CHIP_FAMILY_R350) ||		\
	(chip_family == CHIP_FAMILY_RV380) ||		\
	(chip_family == CHIP_FAMILY_R420) ||		\
	(chip_family == CHIP_FAMILY_RV410) ||		\
	(chip_family == CHIP_FAMILY_RS400) ||		\
	(chip_family == CHIP_FAMILY_RS480)		\
				)

#define IS_FAMILY_R300_3D()	(			\
	(chip_family == CHIP_FAMILY_RV350) ||		\
	(chip_family == CHIP_FAMILY_R350) ||		\
	(chip_family == CHIP_FAMILY_RV380) ||		\
	(chip_family == CHIP_FAMILY_R420) ||		\
	(chip_family == CHIP_FAMILY_RV410) ||		\
	(chip_family == CHIP_FAMILY_RS690) ||		\
	(chip_family == CHIP_FAMILY_RS600) ||		\
	(chip_family == CHIP_FAMILY_RS740) ||		\
	(chip_family == CHIP_FAMILY_RS400) ||		\
	(chip_family == CHIP_FAMILY_RS480)		\
				)

#define IS_FAMILY_R500_3D()	(			\
	(chip_family == CHIP_FAMILY_RV515) ||		\
	(chip_family == CHIP_FAMILY_R520) ||		\
	(chip_family == CHIP_FAMILY_RV530) ||		\
	(chip_family == CHIP_FAMILY_R580) ||		\
	(chip_family == CHIP_FAMILY_RV560) ||		\
	(chip_family == CHIP_FAMILY_RV570)		\
				)

static const struct __param_table params[2] = {
	"CONSOLE", __PARAM_STRING, 1, __MAX_STR_LEN,
	NULL, 0, 0, 0,
};

static void *const vars[2] = {
	&cons,
	NULL,
};

static void ati_set_timing(struct video_mode *v, struct tty_videomode_params *p);
static long ati_get_pixel_clock(struct video_mode *v, unsigned dot_clock);

static long radeon_accel_avail(struct video_mode *v, int ac);
static void radeon_accel_init(struct video_mode *v);
static void radeon_accel_exit(struct video_mode *v);
static void *radeon_accel_do(struct video_mode *v, unsigned op, union accel_param *ap);

static const struct driver_function ati_functions[] = {
	"SET_VIDEO_TIMING", ati_set_timing,
	"GET_PIXEL_CLOCK", ati_get_pixel_clock,
	"ACCEL_AVAIL", radeon_accel_avail,
	"ACCEL_INIT", radeon_accel_init,
	"ACCEL_EXIT", radeon_accel_exit,
	"ACCEL_DO", radeon_accel_do,
	NULL, NULL
};

struct {
	unsigned ref_freq;
	unsigned ref_div;
	unsigned min_freq;
	unsigned max_freq;
	char mode;
} pll;

#define PLL_R		1
#define PLL_R300	2

#define ATI_IN_8(addr)		(mmio_inb(pci_regs + (addr)))
#define ATI_IN_16(addr)		(mmio_inw(pci_regs + (addr)))
#define ATI_IN_32(addr)		(mmio_inl(pci_regs + (addr)))
#define ATI_OUT_8(addr, val)	(mmio_outb(pci_regs + (addr), val))
#define ATI_OUT_16(addr, val)	(mmio_outw(pci_regs + (addr), val))
#define ATI_OUT_32(addr, val)	(mmio_outl(pci_regs + (addr), val))

static void PLL_ERRATA_AFTER_INDEX(void)
{
	if (__unlikely(chip_family == CHIP_FAMILY_RV200) ||
	    __unlikely(chip_family == CHIP_FAMILY_RS200)) {
		ATI_IN_32(R_PLL_DATA);
		ATI_IN_32(R_CRTC_GEN_CNTL);
	}
}

static void PLL_ERRATA_AFTER_DATA(void)
{
	if (__unlikely(chip_family == CHIP_FAMILY_RV100) ||
	    __unlikely(chip_family == CHIP_FAMILY_RS100) ||
	    __unlikely(chip_family == CHIP_FAMILY_RS200)) {
		KERNEL$UDELAY(5000);
	}
	if (__unlikely(chip_family == CHIP_FAMILY_R300)) {
		__u32 x = ATI_IN_32(R_PLL_INDEX);
		ATI_OUT_32(R_PLL_INDEX, x & ~(R_PLL_INDEX_ADDR | R_PLL_INDEX_WR_EN));
		ATI_IN_32(R_PLL_DATA);
		ATI_OUT_32(R_PLL_INDEX, x);
	}
}

static __u32 ATI_PLL_IN(unsigned addr)
{
	__u32 x;
	ATI_OUT_8(R_PLL_INDEX, addr);
	PLL_ERRATA_AFTER_INDEX();
	x = ATI_IN_32(R_PLL_DATA);
	PLL_ERRATA_AFTER_DATA();
	return x;
}

static void ATI_PLL_OUT(unsigned addr, unsigned val)
{
	ATI_OUT_8(R_PLL_INDEX, addr | R_PLL_INDEX_WR_EN);
	PLL_ERRATA_AFTER_INDEX();
	ATI_OUT_32(R_PLL_DATA, val);
	PLL_ERRATA_AFTER_DATA();
}

#define PLL_WRITE_TIMEOUT	(JIFFIES_PER_SECOND / 10)

static void ATI_PLL_WRITE_UPDATE(void)
{
	u_jiffies_lo_t j = KERNEL$GET_JIFFIES_LO();
	u_jiffies_lo_t jj = j;
	__u32 x;
	while ((x = ATI_PLL_IN(PLL_REF_DIV)) & PLL_REF_DIV_ATOMIC_UPDATE) {
		if (__unlikely(jj - j > PLL_WRITE_TIMEOUT)) {
			KERNEL$SYSLOG(__SYSLOG_HW_BUG, dev_name, "TIMEOUT WAITING FOR PLL WRITE UPDATE");
			break;
		}
		jj = KERNEL$GET_JIFFIES_LO();
	}
	ATI_PLL_OUT(PLL_REF_DIV, x | PLL_REF_DIV_ATOMIC_UPDATE);
}

static void ATI_PLL_READ_UPDATE(void)
{
	int i = 10000;
	while (ATI_PLL_IN(PLL_REF_DIV) & PLL_REF_DIV_ATOMIC_UPDATE) {
		if (!--i) break;
	}
}

static unsigned div_round(unsigned a, unsigned b)
{
	return (a + b / 2) / b;
}

static int ati_get_timing(unsigned dot_clock, unsigned *p_real_dot_clock, __u32 *p_pll_ref_div, __u32 *p_pll_div_3)
{
	unsigned d;
	static const __u8 dividers[8] = { 1, 2, 4, 8, 3, 16, 6, 12 };
	int best_diff = MAXINT;
	if (__unlikely(dot_clock / 10000 >= pll.max_freq))
		dot_clock = pll.max_freq * 10000;
	if (__unlikely(dot_clock / 10000 * 12 < pll.min_freq))
		dot_clock = pll.min_freq * 10000 / 12 + 1;
	for (d = 0; d < sizeof dividers; d++) {
		unsigned output_freq = dividers[d] * dot_clock / 10000;
		if (output_freq >= pll.min_freq && output_freq <= pll.max_freq) {
			unsigned feedback_div = div_round(pll.ref_div * output_freq, pll.ref_freq);
			unsigned real_dot_clock = (unsigned long long)pll.ref_freq * (unsigned long long)feedback_div * 10000 / (dividers[d] * pll.ref_div);
			if (abs(real_dot_clock - dot_clock) < best_diff) {
				best_diff = abs(real_dot_clock - dot_clock);
				if (p_real_dot_clock)
					*p_real_dot_clock = real_dot_clock;
				if (p_pll_ref_div)
					*p_pll_ref_div = pll.ref_div;
				if (p_pll_div_3)
					*p_pll_div_3 = (feedback_div << __BSF_CONST(PLL_DIV_3_FEEDBACK)) | (d << __BSF_CONST(PLL_DIV_3_POST_DIV));
			}
		}
	}
	if (__unlikely(best_diff == MAXINT))
		return -EINVAL;
	return 0;
}

static void ati_set_timing(struct video_mode *v, struct tty_videomode_params *p)
{
	int r;
	__u32 ppl_ref_div, ppl_div_3;
	__u32 x;
	unsigned f, w, il;
	r = ati_get_timing(p->pixel_clock, NULL, &ppl_ref_div, &ppl_div_3);
	if (__unlikely(r < 0))
		return;

	x = ATI_PLL_IN(PLL_VCLK_ECP_CNTL);
	x &= ~PLL_VCLK_ECP_CNTL_SEL_MASK;
	x |= PLL_VCLK_ECP_CNTL_SEL_CPUCLK;
	ATI_PLL_OUT(PLL_VCLK_ECP_CNTL, x);

	x = ATI_PLL_IN(PLL_CNTL);
	x |= PLL_CNTL_RESET | PLL_CNTL_ATOMIC_UPDATE | PLL_CNTL_VGA_ATOMIC_UPDATE;
	ATI_PLL_OUT(PLL_CNTL, x);

	x = ATI_IN_32(R_PLL_INDEX);
	x |= R_PLL_INDEX_DIV_SEL;
	ATI_OUT_32(R_PLL_INDEX, x);
	PLL_ERRATA_AFTER_INDEX();

	if (pll.mode == PLL_R300) {
		x = ATI_PLL_IN(PLL_REF_DIV);
		x &= ~PLL_REF_DIV_MASK_2;
		x |= pll.ref_div << __BSF_CONST(PLL_REF_DIV_MASK_2);
		ATI_PLL_OUT(PLL_REF_DIV, x);
	} else {
		x = ATI_PLL_IN(PLL_REF_DIV);
		x &= ~PLL_REF_DIV_MASK;
		x |= pll.ref_div << __BSF_CONST(PLL_REF_DIV_MASK);
		ATI_PLL_OUT(PLL_REF_DIV, x);
	}

	x = ATI_PLL_IN(PLL_DIV_3);
	x &= ~PLL_DIV_3_FEEDBACK;
	x |= ppl_div_3 & PLL_DIV_3_FEEDBACK;
	ATI_PLL_OUT(PLL_DIV_3, x);
	x = ATI_PLL_IN(PLL_DIV_3);
	x &= ~PLL_DIV_3_POST_DIV;
	x |= ppl_div_3 & PLL_DIV_3_POST_DIV;
	ATI_PLL_OUT(PLL_DIV_3, x);

	ATI_PLL_WRITE_UPDATE();
	ATI_PLL_READ_UPDATE();

	ATI_PLL_OUT(PLL_HTOTAL_CNTL, 0);

	x = ATI_PLL_IN(PLL_CNTL);
	x &= ~(PLL_CNTL_RESET | PLL_CNTL_SLEEP | PLL_CNTL_ATOMIC_UPDATE | PLL_CNTL_VGA_ATOMIC_UPDATE);
	ATI_PLL_OUT(PLL_CNTL, x);

	KERNEL$UDELAY(50000);

	x = ATI_PLL_IN(PLL_VCLK_ECP_CNTL);
	x &= ~PLL_VCLK_ECP_CNTL_SEL_MASK;
	x |= PLL_VCLK_ECP_CNTL_SEL_PPLLCLK;
	ATI_PLL_OUT(PLL_VCLK_ECP_CNTL, x);

	switch (v->bpp) {
		case 8: f = 2; break;
		case 15: f = 3; break;
		case 16: f = 4; break;
		case 24: f = 5; break;
		case 32: f = 6; break;
		default: return;
	}

	ATI_OUT_32(R_CRTC_GEN_CNTL,
		R_CRTC_GEN_CNTL_EN |
		R_CRTC_GEN_CNTL_EXT_DISP_EN |
		(f << __BSF_CONST(R_CRTC_GEN_CNTL_FORMAT_MASK)) |
		(p->flags & VIDEO_PARAMS_DOUBLE_SCAN ? R_CRTC_GEN_CNTL_DBL_SCAN_EN : 0) |
		(p->flags & VIDEO_PARAMS_INTERLACED ? R_CRTC_GEN_CNTL_INTERLACE_EN : 0));
	x = ATI_IN_32(R_CRTC_EXT_CNTL);
	x |= R_CRTC_EXT_CNTL_VGA_ATI_LINEAR | R_CRTC_EXT_CNTL_XCRT_CNT_EN | R_CRTC_EXT_CNTL_CRT_ON;
	ATI_OUT_32(R_CRTC_EXT_CNTL, x);

	ATI_OUT_32(R_H_TOTAL_DISP, ((p->h_total / 8 - 1) & 0xffff) | (((p->h / 8 - 1) & 0xffff) << 16));
	w = (p->h_sync_end - p->h_sync_start) / 8;
	if (w < 1) w = 1;
	if (w > 0x3f) w = 0x3f;
	ATI_OUT_32(R_H_SYNC_START_WIDTH, (p->h_sync_start & 0xffff) | (w << 16) | (p->flags & VIDEO_PARAMS_HSYNC_NEG ? R_H_SYNC_START_WIDTH_POL : 0));

	il = p->flags & VIDEO_PARAMS_INTERLACED ? 1 : 0;

	ATI_OUT_32(R_V_TOTAL_DISP, (((p->v_total << il) - 1) & 0xffff) | ((((p->v << il) - 1) & 0xffff) << 16));
	w = p->v_sync_end - p->v_sync_start;
	if (w < 1) w = 1;
	if (w > 0x1f) w = 0x1f;
	ATI_OUT_32(R_V_SYNC_START_WIDTH, ((p->v_sync_start << il) & 0xffff) | (w << 16) | (p->flags & VIDEO_PARAMS_VSYNC_NEG ? R_V_SYNC_START_WIDTH_POL : 0));

	x = ATI_IN_32(R_CONFIG_CNTL);
	x |= R_CONFIG_VGA_RAM_EN;
	ATI_OUT_32(R_CONFIG_CNTL, x);
}

static long ati_get_pixel_clock(struct video_mode *v, unsigned dot_clock)
{
	unsigned real_dot_clock;
	int r;
	r = ati_get_timing(dot_clock, &real_dot_clock, NULL, NULL);
	if (__unlikely(r < 0))
		return r;
	return real_dot_clock;
}

static void ati_init(void)
{
	__u32 ref_div;
	pll.ref_freq = chip_flags & CHIP_IGP ? 1432 : 2700;
	pll.min_freq = 20000;
	pll.max_freq = 35000;

	if (chip_family == CHIP_FAMILY_RV410 ||
	    chip_family == CHIP_FAMILY_R420)
		pll.max_freq = 50000;
	
	ref_div = ATI_PLL_IN(PLL_REF_DIV);

	if (IS_FAMILY_R300() || chip_family == CHIP_FAMILY_RS300)
		pll.ref_div = (ref_div & PLL_REF_DIV_MASK_2) >> __BSF_CONST(PLL_REF_DIV_MASK_2),
		pll.mode = PLL_R300;
	else
		pll.ref_div = (ref_div & PLL_REF_DIV_MASK) >> __BSF_CONST(PLL_REF_DIV_MASK),
		pll.mode = PLL_R;
}

static __finline__ unsigned ati_pitch(struct video_mode *v)
{
	return v->scanline;
}


static char accel_initialized = 0;

static char mult_3_hack;

static __u32 dp_gui_master_cntl;

static int radeon_wait_for_register(unsigned reg, __u32 mask, __u32 want, int (*test)(__u32 val, __u32 mask, __u32 want))
{
	__u32 val;
	u_jiffies_lo_t j, jj = j = KERNEL$GET_JIFFIES_LO();
	again:
	val = ATI_IN_32(reg);
	if (__likely(test(val, mask, want)))
		return 0;
	if (__unlikely(jj - j > RADEON_TIMEOUT)) {
		accel_initialized = 0;
		KERNEL$SYSLOG(__SYSLOG_HW_BUG, dev_name, "ACCELERATION TIMEOUT WHEN WAITING FOR %04X, VAL %08X, MASK %08X, WANT %08X", reg, val, mask, want);
		return -ETIMEDOUT;
	}
	jj = KERNEL$GET_JIFFIES_LO();
	goto again;
}

static int mask_equal(__u32 val, __u32 mask, __u32 want)
{
	return (val & mask) == want;
}

static int mask_greater_or_equal(__u32 val, __u32 mask, __u32 want)
{
	return (val & mask) >= want;
}

static int radeon_wait_for_fifo_space(int n)
{
	return radeon_wait_for_register(R_RBBM_STATUS, R_RBBM_STATUS_FIFO_FREE, n, mask_greater_or_equal);
}

static int radeon_accel_sync(void)
{
	int r;
	r = radeon_wait_for_fifo_space(R_RBBM_STATUS_FIFO_FREE_MAX);
	if (__unlikely(r)) return r;
	return radeon_wait_for_register(R_RBBM_STATUS, R_RBBM_STATUS_ACTIVE, 0, mask_equal);
}

static void radeon_accel_engine_flush(void)
{
	if (__unlikely(chip_family < CHIP_FAMILY_R300)) {
		ATI_OUT_32(R_RB3D_DSTCACHE_CTLSTAT, ATI_IN_32(R_RB3D_DSTCACHE_CTLSTAT) | R_RB3D_DSTCACHE_CTLSTAT_FLUSH_ALL);
		radeon_wait_for_register(R_RB3D_DSTCACHE_CTLSTAT, R_RB3D_DSTCACHE_CTLSTAT_BUSY, 0, mask_equal);
	} else {
		ATI_OUT_32(R_DSTCACHE_CTLSTAT, ATI_IN_32(R_DSTCACHE_CTLSTAT) | R_DSTCACHE_CTLSTAT_FLUSH_ALL);
		radeon_wait_for_register(R_DSTCACHE_CTLSTAT, R_DSTCACHE_CTLSTAT_BUSY, 0, mask_equal);
	}
}

static void radeon_accel_engine_reset(void)
{
	__u32 rbbm_soft_reset, host_path_cntl, mclk_cntl;

	rbbm_soft_reset = ATI_IN_32(R_RBBM_SOFT_RESET);
	ATI_OUT_32(R_RBBM_SOFT_RESET, rbbm_soft_reset | R_RBBM_SOFT_RESET_CP | R_RBBM_SOFT_RESET_HI | R_RBBM_SOFT_RESET_SE | R_RBBM_SOFT_RESET_RE | R_RBBM_SOFT_RESET_PP | R_RBBM_SOFT_RESET_E2 | R_RBBM_SOFT_RESET_RB);
	ATI_IN_32(R_RBBM_SOFT_RESET);
	ATI_OUT_32(R_RBBM_SOFT_RESET, rbbm_soft_reset & ~(R_RBBM_SOFT_RESET_CP | R_RBBM_SOFT_RESET_HI | R_RBBM_SOFT_RESET_SE | R_RBBM_SOFT_RESET_RE | R_RBBM_SOFT_RESET_PP | R_RBBM_SOFT_RESET_E2 | R_RBBM_SOFT_RESET_RB));
	ATI_IN_32(R_RBBM_SOFT_RESET);
	ATI_OUT_32(R_RBBM_SOFT_RESET, rbbm_soft_reset);

	radeon_accel_engine_flush();

	mclk_cntl = ATI_PLL_IN(PLL_MCLK_CNTL);

	host_path_cntl = ATI_IN_32(R_HOST_PATH_CNTL);
	rbbm_soft_reset = ATI_IN_32(R_RBBM_SOFT_RESET);

	if (IS_FAMILY_R300() || chip_family >= CHIP_FAMILY_RV515) {
		ATI_OUT_32(R_RBBM_SOFT_RESET, rbbm_soft_reset | R_RBBM_SOFT_RESET_CP | R_RBBM_SOFT_RESET_HI | R_RBBM_SOFT_RESET_E2);
		ATI_IN_32(R_RBBM_SOFT_RESET);
		ATI_OUT_32(R_RBBM_SOFT_RESET, 0);
		ATI_IN_32(R_RBBM_SOFT_RESET);
		ATI_OUT_32(R_RB3D_DSTCACHE_MODE, ATI_IN_32(R_RB3D_DSTCACHE_MODE) | 0x00020000);
	} else {
		ATI_OUT_32(R_RBBM_SOFT_RESET, rbbm_soft_reset | R_RBBM_SOFT_RESET_CP | R_RBBM_SOFT_RESET_SE | R_RBBM_SOFT_RESET_RE | R_RBBM_SOFT_RESET_PP | R_RBBM_SOFT_RESET_E2 | R_RBBM_SOFT_RESET_RB);
		ATI_IN_32(R_RBBM_SOFT_RESET);
		ATI_OUT_32(R_RBBM_SOFT_RESET, rbbm_soft_reset & ~(R_RBBM_SOFT_RESET_CP | R_RBBM_SOFT_RESET_SE | R_RBBM_SOFT_RESET_RE | R_RBBM_SOFT_RESET_PP | R_RBBM_SOFT_RESET_E2 | R_RBBM_SOFT_RESET_RB));
		ATI_IN_32(R_RBBM_SOFT_RESET);
	}

	ATI_OUT_32(R_HOST_PATH_CNTL, host_path_cntl | R_HOST_PATH_CNTL_SOFT_RESET);
	ATI_IN_32(R_HOST_PATH_CNTL);
	ATI_OUT_32(R_HOST_PATH_CNTL, host_path_cntl);

	if (!(IS_FAMILY_R300() || chip_family >= CHIP_FAMILY_RV515)) {
		ATI_OUT_32(R_RBBM_SOFT_RESET, rbbm_soft_reset);
	}

	ATI_PLL_OUT(PLL_MCLK_CNTL, mclk_cntl);
}

static void radeon_accel_engine_restore(struct video_mode *v)
{
	__u32 pitch;
	if (!accel_initialized) return;
	if (radeon_wait_for_fifo_space(2)) return;
	pitch = (ati_pitch(v) / 64) << __BSF_CONST(R_DST_PITCH_OFFSET_WIDTH);
	ATI_OUT_32(R_DST_PITCH_OFFSET, pitch);
	ATI_OUT_32(R_SRC_PITCH_OFFSET, pitch);
	if (radeon_wait_for_fifo_space(1)) return;
	ATI_OUT_32(R_DP_DATATYPE, ATI_IN_32(R_DP_DATATYPE) & ~R_DP_DATATYPE_BIG_ENDIAN);
	ATI_OUT_32(R_SURFACE_CNTL, 0);
	if (radeon_wait_for_fifo_space(2)) return;
	ATI_OUT_32(R_DEFAULT_SC_TOP_LEFT, 0);
	ATI_OUT_32(R_DEFAULT_SC_BOTTOM_RIGHT, R_DEFAULT_SC_BOTTOM_RIGHT_RIGHT | R_DEFAULT_SC_BOTTOM_RIGHT_BOTTOM);
	dp_gui_master_cntl = R_DP_GUI_MASTER_CNTL_DST_PITCH_OFFSET | R_DP_GUI_MASTER_CNTL_CLR_CMP_CNTL_DIS;
	mult_3_hack = 0;
	switch (v->bpp) {
		case 8:
			dp_gui_master_cntl |= R_DP_GUI_MASTER_CNTL_DST_DATATYPE_8BPP_CI;
			break;
		case 15:
			dp_gui_master_cntl |= R_DP_GUI_MASTER_CNTL_DST_DATATYPE_15BPP;
			break;
		case 16:
			dp_gui_master_cntl |= R_DP_GUI_MASTER_CNTL_DST_DATATYPE_16BPP;
			break;
		case 24:
			/* The engine doesn't support 24bpp, but we will pretend
			   that we're in 8bpp.
			   We can at least do screen copies and grayscale fills 
			   then. */
			dp_gui_master_cntl |= R_DP_GUI_MASTER_CNTL_DST_DATATYPE_8BPP_CI;
			mult_3_hack = 1;
			break;
		case 32:
			dp_gui_master_cntl |= R_DP_GUI_MASTER_CNTL_DST_DATATYPE_32BPP;
			break;
	}
	if (radeon_wait_for_fifo_space(1)) return;
	ATI_OUT_32(R_DP_GUI_MASTER_CNTL, dp_gui_master_cntl | R_DP_GUI_MASTER_CNTL_BRUSH_SOLID_COLOR | R_DP_GUI_MASTER_CNTL_SRC_DATATYPE_COLOR);

	if (radeon_wait_for_fifo_space(7)) return;
	ATI_OUT_32(R_DP_BRUSH_FRGD_CLR, 0xffffffff);
	ATI_OUT_32(R_DP_BRUSH_BKGD_CLR, 0x00000000);
	ATI_OUT_32(R_DP_SRC_FRGD_CLR, 0xffffffff);
	ATI_OUT_32(R_DP_SRC_BKGD_CLR, 0x00000000);
	ATI_OUT_32(R_DP_WRITE_MASK, 0xffffffff);

	radeon_accel_sync();
}

static long radeon_accel_avail(struct video_mode *v, int ac)
{
	if (chip_family >= CHIP_FAMILY_R600)
		return 0;
	if (v->bpp != 8 &&
	    v->bpp != 15 &&
	    v->bpp != 16 &&
	    v->bpp != 24 &&
	    v->bpp != 32)
		return 0;
	if (__unlikely(ati_pitch(v) % 64))
		return 0;
	switch (ac) {
		case VGA_AVAIL_ACCEL:
			return ACCELFLAG_FILLBOX | ACCELFLAG_SETFGCOLOR | ACCELFLAG_SCREENCOPY | ACCELFLAG_SETRASTEROP | ACCELFLAG_SETMODE | ACCELFLAG_SYNC;
		case VGA_AVAIL_ROP:
			return ACCELFLAG_FILLBOX | ACCELFLAG_SCREENCOPY;
		case VGA_AVAIL_ROPMODES:
			return 0xffff;
		default:
			return 0;
	}
}

static void radeon_accel_init(struct video_mode *v)
{
	unsigned num_gb_pipes;

	accel_initialized = 0;
	if (__unlikely(!radeon_accel_avail(v, VGA_AVAIL_ACCEL)))
		return;

	accel_initialized = 1;

	if (
	    chip_family == CHIP_FAMILY_RV410 ||
	    chip_family == CHIP_FAMILY_R420 ||
	    chip_family == CHIP_FAMILY_RS600 ||
	    chip_family == CHIP_FAMILY_RS690 ||
	    chip_family == CHIP_FAMILY_RS740 ||
	    chip_family == CHIP_FAMILY_RS400 ||
	    chip_family == CHIP_FAMILY_RS480 ||
	    IS_FAMILY_R500_3D()) {
		__u32 gb_pipe_sel = ATI_IN_32(R400_GB_PIPE_SELECT);
		num_gb_pipes = ((gb_pipe_sel >> 12) & 0x3) + 1;
		if (IS_FAMILY_R500_3D())
			ATI_PLL_OUT(PLL_R500_DYN_SCLK_PWMEM, (1 | ((gb_pipe_sel >> 8) & 0xf) << 4));
	} else {
		if (chip_family == CHIP_FAMILY_R300 ||
		    chip_family == CHIP_FAMILY_R350)
			num_gb_pipes = 2;
		else
			num_gb_pipes = 1;
	}

	if (IS_FAMILY_R300_3D() || IS_FAMILY_R500_3D()) {
		__u32 tile_config = R300_GB_TILE_CONFIG_EN_TILING | R300_GB_TILE_CONFIG_SIZE_16 | R300_GB_TILE_CONFIG_SUBPX_1_16;
		switch (num_gb_pipes) {
			default:
			case 1:
				tile_config |= R300_GB_TILE_CONFIG_PIPE_COUNT_1;
				break;
			case 2:
				tile_config |= R300_GB_TILE_CONFIG_PIPE_COUNT_2;
				break;
			case 3:
				tile_config |= R300_GB_TILE_CONFIG_PIPE_COUNT_3;
				break;
			case 4:
				tile_config |= R300_GB_TILE_CONFIG_PIPE_COUNT_4;
				break;
		}
		ATI_OUT_32(R300_GB_TILE_CONFIG, tile_config);
		ATI_OUT_32(R_WAIT_UNTIL, R_WAIT_UNTIL_2D_IDLECLEAN | R_WAIT_UNTIL_3D_IDLECLEAN);
		ATI_OUT_32(R_DST_PIPE_CONFIG, ATI_IN_32(R_DST_PIPE_CONFIG) | R_DST_PIPE_CONFIG_AUTO);
		ATI_OUT_32(R300_RB2D_DSTCACHE_MODE, ATI_IN_32(R300_RB2D_DSTCACHE_MODE) | R300_RB2D_DSTCACHE_MODE_AUTOFLUSH | R300_RB2D_DSTCACHE_MODE_DIS_IGN_PE);
	} else {
		ATI_OUT_32(R_RB3D_CNTL, 0);
	}
	radeon_accel_engine_reset();
	radeon_accel_engine_restore(v);
}

static void radeon_accel_exit(struct video_mode *v)
{
	if (accel_initialized)
		radeon_accel_engine_reset();
	accel_initialized = 0;
}

static const __u32 RADEON_PATTERN[16] = {
	0x00000000, 0x00a00000, 0x00500000, 0x00f00000,
	0x000a0000, 0x00aa0000, 0x005a0000, 0x00fa0000,
	0x00050000, 0x00a50000, 0x00550000, 0x00f50000,
	0x000f0000, 0x00af0000, 0x005f0000, 0x00ff0000,
};

static const __u32 RADEON_ROP[16] = {
	0x00000000, 0x00880000, 0x00440000, 0x00cc0000,
	0x00220000, 0x00aa0000, 0x00660000, 0x00ee0000,
	0x00110000, 0x00990000, 0x00550000, 0x00dd0000,
	0x00330000, 0x00bb0000, 0x00770000, 0x00ff0000,
};

static void *radeon_accel_do(struct video_mode *v, unsigned op, union accel_param *ap)
{
	if (__unlikely(!accel_initialized))
		return __ERR_PTR(-EOPNOTSUPP);
	__write_barrier2();
	if (__likely((op & _ACCEL_OP) == ACCEL_FILLBOX)) {
		if (__unlikely(mult_3_hack)) {
			if ((ap->fillbox.c & 0xff) != ((ap->fillbox.c >> 8) & 0xff) ||
			    (ap->fillbox.c & 0xff) != ((ap->fillbox.c >> 16) & 0xff)) {
				return __ERR_PTR(-EINVAL);
			}
			ap->fillbox.x *= 3;
			ap->fillbox.w *= 3;
		}
		if (radeon_wait_for_fifo_space(7)) return __ERR_PTR(-EIO);
		ATI_OUT_32(R_DP_GUI_MASTER_CNTL, dp_gui_master_cntl | R_DP_GUI_MASTER_CNTL_BRUSH_SOLID_COLOR | R_DP_GUI_MASTER_CNTL_SRC_DATATYPE_COLOR | RADEON_PATTERN[__GET_FIELD(op, _ACCEL_ROP)]);
		ATI_OUT_32(R_DP_BRUSH_FRGD_CLR, ap->fillbox.c);
		ATI_OUT_32(R_DP_CNTL, R_DP_CNTL_DST_X_LEFT_TO_RIGHT | R_DP_CNTL_DST_Y_TOP_TO_BOTTOM);
		ATI_OUT_32(R_DSTCACHE_CTLSTAT, 0x0f);
		ATI_OUT_32(R_WAIT_UNTIL, R_WAIT_UNTIL_2D_IDLECLEAN | R_WAIT_UNTIL_DMA_GUI_IDLE);
		ATI_OUT_32(R_DST_Y_X, (ap->fillbox.y << 16) | ap->fillbox.x);
		ATI_OUT_32(R_DST_WIDTH_HEIGHT, (ap->fillbox.w << 16) | ap->fillbox.h);
	} else if ((op & _ACCEL_OP) == ACCELFLAG_SCREENCOPY) {
		__u32 dp_cntl;
		if (__unlikely(mult_3_hack)) {
			ap->screencopy.x1 *= 3;
			ap->screencopy.x2 *= 3;
			ap->screencopy.w *= 3;
		}
		if (radeon_wait_for_fifo_space(7)) return __ERR_PTR(-EIO);
		ATI_OUT_32(R_DP_GUI_MASTER_CNTL, dp_gui_master_cntl | R_DP_GUI_MASTER_CNTL_BRUSH_NONE | R_DP_GUI_MASTER_CNTL_SRC_DATATYPE_COLOR | R_DP_GUI_MASTER_CNTL_SRC_MEMORY | R_DP_GUI_MASTER_CNTL_SRC_PITCH_OFFSET | RADEON_ROP[__GET_FIELD(op, _ACCEL_ROP)]);
		dp_cntl = R_DP_CNTL_DST_X_LEFT_TO_RIGHT | R_DP_CNTL_DST_Y_TOP_TO_BOTTOM;
		if (ap->screencopy.x1 < ap->screencopy.x2) {
			ap->screencopy.x1 += ap->screencopy.w - 1;
			ap->screencopy.x2 += ap->screencopy.w - 1;
			dp_cntl &= ~R_DP_CNTL_DST_X_LEFT_TO_RIGHT;
		}
		if (ap->screencopy.y1 < ap->screencopy.y2) {
			ap->screencopy.y1 += ap->screencopy.h - 1;
			ap->screencopy.y2 += ap->screencopy.h - 1;
			dp_cntl &= ~R_DP_CNTL_DST_Y_TOP_TO_BOTTOM;
		}
		ATI_OUT_32(R_DP_CNTL, dp_cntl);
		ATI_OUT_32(R_DSTCACHE_CTLSTAT, 0x0f);
		ATI_OUT_32(R_WAIT_UNTIL, R_WAIT_UNTIL_2D_IDLECLEAN | R_WAIT_UNTIL_DMA_GUI_IDLE);
		ATI_OUT_32(R_SRC_Y_X, (ap->screencopy.y1 << 16) | ap->screencopy.x1);
		ATI_OUT_32(R_DST_Y_X, (ap->screencopy.y2 << 16) | ap->screencopy.x2);
		ATI_OUT_32(R_DST_WIDTH_HEIGHT, (ap->screencopy.w << 16) | ap->screencopy.h);
	} else if (__likely((op & _ACCEL_OP) == ACCEL_SYNC)) {
		radeon_accel_sync();
		return NULL;
	} else {
		return __ERR_PTR(-EOPNOTSUPP);
	}
	if (!(op & _ACCEL_ASYNC)) {
		radeon_accel_sync();
	}
	return NULL;
}

static int ati_unload(void *p, void **release, const char * const argv[]);

int main(int argc, const char * const argv[])
{
	int r;
	const char * const *arg = argv;
	int state = 0;
	char *chip_name;
	char gstr[__MAX_STR_LEN];
	if (__parse_params(&arg, &state, params, vars, NULL, NULL, NULL)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ATI: SYNTAX ERROR");
		r = -EBADSYN;
		goto ret0;
	}

	if (PCI$FIND_DEVICE(ati_cards, 0, 0, 0, PCI$TEST_LIST, &pci_id, &chip_name, &chip_flags, 0)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ATI: ATI CARD NOT FOUND");
		r = -ENODEV;
		goto ret0;
	}

	PCI$ENABLE_DEVICE(pci_id, PCI_COMMAND_IO | PCI_COMMAND_MEMORY);

	pci_regs = PCI$MAP_MEM_RESOURCE(pci_id, 2, R_SIZE);
	if (!pci_regs) {
		KERNEL$SYSLOG(__SYSLOG_HW_BUG, dev_name, "NO MEM RESOURCE");
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "%s: NO MEM RESOURCE", dev_name);
		r = -ENXIO;
		goto ret1;
	}
	if (__IS_ERR(pci_regs)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "%s: COULD NOT MAP MEM RESOURCE: %s", dev_name, strerror(-__PTR_ERR(pci_regs)));
		r = __PTR_ERR(pci_regs);
		goto ret1;
	}

	ati_init();

	_printf("%s: %s ON PCI: %s\n", dev_name, chip_name, PCI$ID(gstr, pci_id));

	r = KERNEL$DCALL(cons, "CONSOLE", CONSOLE_CMD_INSTALL_DRIVER, (void *)ati_functions);
	if (r < 0) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ATI: CAN'T ATTACH TO CONSOLE DEVICE %s", cons);
		goto ret2;
	}

	r = KERNEL$REGISTER_DEVICE(dev_name, "ATI.SYS", 0, NULL, NULL, NULL, NULL, NULL, ati_unload, &lnte, cons, NULL);
	if (r < 0) {
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "%s: COULD NOT REGISTER DEVICE: %s", dev_name, strerror(-r));
		goto ret3;
	}

	dlrq = KERNEL$TSR_IMAGE();
	strlcpy(KERNEL$ERROR_MSG(), dev_name, __MAX_STR_LEN);
	return 0;

	ret3:
	KERNEL$DCALL(cons, "CONSOLE", CONSOLE_CMD_RELEASE_DRIVER);
	ret2:
	PCI$UNMAP_MEM_RESOURCE(pci_id, pci_regs, R_SIZE);
	ret1:
	PCI$FREE_DEVICE(pci_id);
	ret0:
	return r;
}

static int ati_unload(void *p, void **release, const char * const argv[])
{
	int r;
	if ((r = KERNEL$DEVICE_UNLOAD(lnte, argv))) return r;
	KERNEL$DCALL(cons, "CONSOLE", CONSOLE_CMD_RELEASE_DRIVER);
	PCI$UNMAP_MEM_RESOURCE(pci_id, pci_regs, R_SIZE);
	PCI$FREE_DEVICE(pci_id);
	*release = dlrq;
	return 0;
}
