#include <STDLIB.H>

unsigned mclk;

#define BASE_FREQ	14318180

static int s3dacsfindclock(unsigned freq_in, unsigned min_m, unsigned min_n1, unsigned max_n1, unsigned min_n2, unsigned max_n2, unsigned freq_min, unsigned freq_max, unsigned *best_m_out, unsigned *best_n1_out, unsigned *best_n2_out)
{
	int diff, best_diff;
	int m;
	__u8 n1, n2;
	__u8 best_n1 = 16 + 2, best_n2 = 2, best_m = 125 + 2;
	unsigned ffreq_in = (__u64)freq_in * 1000000 / BASE_FREQ;
	unsigned ffreq_min = (__u64)freq_min * 1000000 / BASE_FREQ;
	unsigned ffreq_max = (__u64)freq_max * 1000000 / BASE_FREQ;
	unsigned ffreq_out;
	if (__unlikely(freq_in < freq_min >> max_n2)) {
		/*__debug_printf("too low freq\n");*/
		return -1;
	}
	if (__unlikely(freq_in > freq_max >> min_n2)) {
		/*__debug_printf("too high freq\n");*/
		return -1;
	}
	best_diff = ffreq_in;
	for (n2 = min_n2; n2 <= max_n2; n2++) {
		for (n1 = min_n1 + 2; n1 <= max_n1 + 2; n1++) {
			m = (__u64)(((ffreq_in * n1) << n2) + 500000) / 1000000;
			if (m < min_m + 2 || m > 127 + 2) continue;
			ffreq_out = (__u64)m * 1000000 / n1;
			if (ffreq_out >= ffreq_min && ffreq_out <= ffreq_max) {
				diff = abs((int)(ffreq_in - (ffreq_out >> n2)));
				if (diff < best_diff) {
					best_diff = diff;
					best_m = m;
					best_n1 = n1;
					best_n2 = n2;
				}
			}
		}
	}
	/*__debug_printf("m: %d, n1: %d, n2: %d\n", best_m, best_n1, best_n2);
	__debug_printf("%d -> %d\n", freq_in, (int)(((__u64)best_m * BASE_FREQ / best_n1) >> best_n2));*/
	*best_m_out = best_m;
	*best_n1_out = best_n1;
	*best_n2_out = best_n2;
	return 0;
}

static int gendac_sdac_probe(void)
{
	__u8 cr_55;
	__u32 clock01, clock23;
	int i;
	__u8 savelut[6];
	cr_55 = in_cr(0x55);
	out_cr(0x55, cr_55 & ~1);
	io_outb(VGA_DAC_READ_IDX, 0);
	for (i = 0; i < 6; i++) savelut[i] = io_inb(VGA_DAC_REG);
	io_outb(VGA_DAC_WRITE_IDX, 0);
	for (i = 0; i < 6; i++) io_outb(VGA_DAC_REG, 0);
	out_cr(0x55, cr_55 | 1);
	io_outb(VGA_DAC_READ_IDX, 0);
	clock01 = 0;
	for (i = 0; i < 4; i++) clock01 = (clock01 << 8) | io_inb(VGA_DAC_REG);
	clock23 = 0;
	for (i = 0; i < 4; i++) clock23 = (clock23 << 8) | io_inb(VGA_DAC_REG);
	out_cr(0x55, cr_55 & ~1);
	io_outb(VGA_DAC_WRITE_IDX, 0);
	for (i = 0; i < 6; i++) io_outb(VGA_DAC_REG, savelut[i]);
	out_cr(0x55, cr_55);
	/*__debug_printf("clk: %08x, %08x\n", clock01, clock23);*/
	if ((clock01 == 0x28613d62 || clock01 == 0x524a5d4a) || (clock01 == 0x7f7f7f7f && clock23 != 0x7f7f7f7f)) {
		io_inb(VGA_DAC_WRITE_IDX);
		io_inb(VGA_DAC_MASK);
		io_inb(VGA_DAC_MASK);
		io_inb(VGA_DAC_MASK);
		if ((io_inb(VGA_DAC_MASK) & 0xf0) == 0x70) return 2;
		else return 1;
	}
	return 0;
}

static int sdac_probe(int s3_chiptype, int pci_chiptype)
{
	return gendac_sdac_probe() == 2 ? 0 : -ENODEV;
}

static int gendac_probe(int s3_chiptype, int pci_chiptype)
{
	return gendac_sdac_probe() == 1 ? 0 : -ENODEV;
}

static unsigned gendac_sdac_calc_clock(unsigned bpp, unsigned x, unsigned pixel_clock, int gendac, int wr)
{
	unsigned min_m, min_n1, n2;
	if (!gendac) {
		if (bpp == 24) pixel_clock = pixel_clock * 3 / 2;
		if (bpp == 32) pixel_clock = pixel_clock * 2;
	} else {
		pixel_clock *= (bpp + 7) >> 3;
	}
	if (__unlikely(s3dacsfindclock(pixel_clock, 1, 1, 31, 0, 3, 100000000, 250000000, &min_m, &min_n1, &n2))) return 0;
	if (wr) {
		/*io_outb(VGA_DAC_READ_IDX, 2);
		__debug_printf("reg1: %x\n", io_inb(VGA_DAC_REG));
		__debug_printf("reg2: %x\n", io_inb(VGA_DAC_REG));*/
		io_outb(VGA_DAC_WRITE_IDX, 2);
		io_outb(VGA_DAC_REG, min_m - 2);
		io_outb(VGA_DAC_REG, (min_n1 - 2) | (n2 << 5));
		/*io_outb(VGA_DAC_READ_IDX, 2);
		__debug_printf("reg1: %x\n", io_inb(VGA_DAC_REG));
		__debug_printf("reg2: %x\n", io_inb(VGA_DAC_REG));*/
	}
	pixel_clock = ((__u64)min_m * BASE_FREQ / min_n1) >> n2;
	if (!gendac) {
		if (bpp == 24) pixel_clock = pixel_clock * 2 / 3;
		if (bpp == 32) pixel_clock = pixel_clock / 2;
	} else {
		pixel_clock /= (bpp + 7) >> 3;
	}
	return pixel_clock;
}

static unsigned sdac_get_pixel_clock(unsigned bpp, unsigned x, unsigned pixel_clock)
{
	return gendac_sdac_calc_clock(bpp, x, pixel_clock, 0, 0);
}

static unsigned gendac_get_pixel_clock(unsigned bpp, unsigned x, unsigned pixel_clock)
{
	return gendac_sdac_calc_clock(bpp, x, pixel_clock, 1, 0);
}

static unsigned gendac_sdac_set_clock(unsigned bpp, unsigned x, unsigned pixel_clock, int gendac)
{
	__u8 cr_55;
	__u8 pixmux;
	switch (bpp) {
		case 8:
/* I don't know the purpose of this condition, it was found experimentally.
 * It even fixes a bug in some S3 BIOSes (without this, the mode doesn't work)
 */
			if (!gendac && x >= 1600) pixmux = 0x10;
			else pixmux = 0x00;
			break;
		case 15:
			if (!gendac) pixmux = 0x30;
			else pixmux = 0x20;
			break;
		case 16:
			if (!gendac) pixmux = 0x50;
			else pixmux = 0x60;
			break;
		case 24:
			if (!gendac) pixmux = 0x90;
			else pixmux = 0x40;
			break;
		case 32:
			if (!gendac) pixmux = 0x70;
			else return 0;
			break;
		default:
			return 0;
	}
	cr_55 = in_cr(0x55) & 0xfc;
	out_cr(0x55, cr_55 | 0x01);
	io_outb(VGA_DAC_MASK, pixmux);
	pixel_clock = gendac_sdac_calc_clock(bpp, x, pixel_clock, gendac, 1);
	out_cr(0x55, cr_55);
	return pixel_clock;
}

static unsigned sdac_set_pixel_clock(unsigned bpp, unsigned x, unsigned pixel_clock)
{
	return gendac_sdac_set_clock(bpp, x, pixel_clock, 0);
}

static unsigned gendac_set_pixel_clock(unsigned bpp, unsigned x, unsigned pixel_clock)
{
	return gendac_sdac_set_clock(bpp, x, pixel_clock, 1);
}

static unsigned gendac_sdac_map_horizontal_crtc(unsigned bpp, unsigned x, unsigned pixelclock, unsigned htiming)
{
	/* I don't have a clue why.
	   Tested on two 864 cards. Maybe this needs more refining */
	if (__unlikely(bpp == 8) && __unlikely(x <= 320)) return htiming * 2;

	return htiming * ((bpp + 7) >> 3);
}

static unsigned char trio64_min_m, trio64_min_n1, trio64_max_n1, trio64_min_n2, trio64_max_n2;
static unsigned trio64_min_freq, trio64_max_freq;

static int trio64_probe(int s3_chiptype, int pci_chiptype)
{
	__u8 sr_8 = in_sr(0x08);
	__u8 m, n, n1, n2;
	out_sr(0x08, 0x06);
	m = in_sr(0x11);
	n = in_sr(0x10);
	out_sr(0x08, sr_8);
	m &= 0x7f;
	n1 = n & 0x1f;
	n2 = (n >> 5) & 0x03;
	mclk = (((BASE_FREQ / 10) * (m + 2)) / (n1 + 2) / (1 << n2) + 50) / 100;
	if (pci_chiptype == T_AURORA64VP) {
		__u8 sr27 = in_sr(0x27);
		in_sr(0x28);
		mclk /= ((sr27 >> 2) & 0x03) + 1;
	}

	trio64_min_m = 1;
	trio64_min_n1 = 1;
	trio64_max_n1 = 31;
	trio64_min_n2 = 0;
	trio64_max_n2 = 3;
	trio64_min_freq = 135000000;
	trio64_max_freq = 270000000;

	if (pci_chiptype == T_AURORA64VP) {
		trio64_max_n1 = 64;
	}
	if (pci_chiptype == T_TRIO64V2_DXGX) {
		trio64_min_freq = 170000000;
		trio64_max_freq = 270000000;
	}
	if (pci_chiptype == VIRGE_VX) {
		trio64_max_n2 = 4;
		trio64_min_freq = 220000000;
		trio64_max_freq = 440000000;
	}
	if (pci_chiptype == VIRGE_MX || pci_chiptype == VIRGE_MXP || pci_chiptype == VIRGE_GX_2 || pci_chiptype == VIRGE_TRIO_3D_2X) {
		trio64_max_n2 = 4;
		trio64_min_freq = 170000000;
		trio64_max_freq = 340000000;
	}
	if (pci_chiptype == VIRGE_TRIO_3D) {
		trio64_max_n2 = 4;
		trio64_min_freq = 230000000;
		trio64_max_freq = 460000000;
	}
	if (pci_chiptype >= SAVAGE_3D) {
		trio64_max_n1 = 127;
		trio64_max_n2 = 4;
		trio64_min_freq = 180000000;
		trio64_max_freq = 360000000;
	}
	return 0;
}

static unsigned trio64_map_horizontal_crtc(unsigned bpp, unsigned x, unsigned pixelclock, unsigned htiming)
{
	if (pci_chiptype == VIRGE_VX ||
	    pci_chiptype == VIRGE_MX ||
	    pci_chiptype == VIRGE_MXP ||
	    pci_chiptype == VIRGE_GX_2 ||
	    pci_chiptype == VIRGE_TRIO_3D_2X ||
	    pci_chiptype >= SAVAGE_3D)
		return htiming;
	if (pci_chiptype == VIRGE_TRIO_3D && bpp == 24)
		return htiming * 3 / 2;
	if (pci_chiptype == VIRGE_TRIO_3D && pixelclock > 115000000)
		return htiming;
	if (bpp == 15 || bpp == 16)
		return htiming * 2;
	return htiming;
}

static unsigned trio64_pixel_clock_multiply(unsigned bpp)
{
	if (__unlikely(pci_chiptype == VIRGE_TRIO_3D) && __unlikely(bpp == 24)) return 3;
	return 1;
}

static unsigned trio64_get_pixel_clock(unsigned bpp, unsigned x, unsigned pixel_clock)
{
	unsigned min_m, min_n1, n2;
	pixel_clock *= trio64_pixel_clock_multiply(bpp);
	if (__unlikely(s3dacsfindclock(pixel_clock, trio64_min_m, trio64_min_n1, trio64_max_n1, trio64_min_n2, trio64_max_n2, trio64_min_freq, trio64_max_freq, &min_m, &min_n1, &n2))) return 0;
	return (((__u64)min_m * BASE_FREQ / min_n1) >> n2) / trio64_pixel_clock_multiply(bpp);
}

static unsigned trio64_set_pixel_clock(unsigned bpp, unsigned x, unsigned pixel_clock)
{
	unsigned r;
	__u8 sr_8, sr_15, sr_18, cr_67;
	unsigned min_m, min_n1, n2;
	pixel_clock *= trio64_pixel_clock_multiply(bpp);
	if (__unlikely(s3dacsfindclock(pixel_clock, trio64_min_m, trio64_min_n1, trio64_max_n1, trio64_min_n2, trio64_max_n2, trio64_min_freq, trio64_max_freq, &min_m, &min_n1, &n2))) return 0;
	r = 0;
	sr_8 = in_sr(0x08);
	out_sr(0x08, 0x06);
	sr_15 = in_sr(0x15) & ~0x50;
	sr_18 = in_sr(0x18) & ~0x80;
	/*__debug_printf("bpp: %d, in_cr67: %02x\n", bpp, in_cr(0x67));*/
	if (bpp == 8) {
		cr_67 = 0x00;
	} else if (bpp == 15) {
		cr_67 = 0x20;
	} else if (bpp == 16) {
		cr_67 = 0x40;
	} else if (bpp == 24) {
		cr_67 = 0x70;
	} else if (bpp == 32) {
		cr_67 = 0xd0;
	} else {
		goto fail_unlock;
	}
	/*
	Leave what BIOS set there
	out_cr(0x67, cr_67);
	out_sr(0x15, sr_15);
	out_sr(0x18, sr_18);
	*/
	/*__debug_printf("sr12: %02x, sr13: %02x\n", in_sr(0x12), in_sr(0x13));
	__debug_printf("min_n1: %d, n2: %d, min_m: %d\n", min_n1, n2, min_m);
	__debug_printf("wr12: %02x, wr13: %02x\n", (min_n1 - 2) | (n2 * (trio64_max_n1 + 1)), min_m - 2);*/
	if (pci_chiptype == VIRGE_MX || pci_chiptype == VIRGE_MXP || pci_chiptype == VIRGE_GX_2 || pci_chiptype == VIRGE_TRIO_3D_2X) {
		out_sr(0x12, (min_n1 - 2) | (n2 * 64));
		out_sr(0x13, min_m - 2);
		out_sr(0x29, n2 >> 2);
	} else if (pci_chiptype >= SAVAGE_3D) {
		out_sr(0x12, ((min_n1 - 2) & 0x3f) | (n2 * 64));
		out_sr(0x13, min_m - 2);
		out_sr(0x29, (n2 & 0x04) | (((min_m - 2) >> 5) & 0x08) | (((min_n1 - 2) >> 2) & 0x10));
	} else {
		/*__debug_printf("was there: %02x %02x %d\n", in_sr(0x12), in_sr(0x13), trio64_max_n1);*/
		out_sr(0x12, (min_n1 - 2) | (n2 * (trio64_max_n1 + 1)));
		out_sr(0x13, min_m - 2);
		/*__debug_printf("is there: %02x %02x %d\n", in_sr(0x12), in_sr(0x13), trio64_max_n1);*/
	}
	sr_15 = in_sr(0x15);
	out_sr(0x15, sr_15 & ~0x20);
	out_sr(0x15, sr_15 | 0x20);
	out_sr(0x15, sr_15 & ~0x20);
	r = (((__u64)min_m * BASE_FREQ / min_n1) >> n2) / trio64_pixel_clock_multiply(bpp);
	fail_unlock:
	out_sr(0x08, sr_8);
	return r;
}

struct dac {
	int (*probe)(int s3_chip, int chip);
	unsigned (*get_pixel_clock)(unsigned bpp, unsigned x, unsigned pixel_clock);
	unsigned (*set_pixel_clock)(unsigned bpp, unsigned x, unsigned pixel_clock);
	unsigned (*map_horizontal_crtc)(unsigned bpp, unsigned x, unsigned pixelclock, unsigned htiming);
};

const struct dac s3_sdac = {
	sdac_probe,
	sdac_get_pixel_clock,
	sdac_set_pixel_clock,
	gendac_sdac_map_horizontal_crtc,
};

const struct dac s3_gendac = {
	gendac_probe,
	gendac_get_pixel_clock,
	gendac_set_pixel_clock,
	gendac_sdac_map_horizontal_crtc,
};

const struct dac s3_trio64_dac = {
	trio64_probe,
	trio64_get_pixel_clock,
	trio64_set_pixel_clock,
	trio64_map_horizontal_crtc,
};

