#include <STDIO.H>
#include <SPAD/CHARSET.H>

#include "VT100GR.I"

int main(void)
{
	int i, n;
	CHARSET_8B *cp437, *iso_8859_1;
	FALLBACK *fallback;
	FILE *out;
	cp437 = CHARSET$OPEN_8B("CP437");
	if (!cp437) {
		perror("CAN'T OPEN CP437");
		ret_1:
		return 1;
	}
	iso_8859_1 = CHARSET$OPEN_8B("8859-1");
	if (!iso_8859_1) {
		perror("CAN'T OPEN ISO-8859-1");
		ret_2:
		CHARSET$CLOSE_8B(cp437, 0);
		goto ret_1;
	}
	fallback = CHARSET$OPEN_FALLBACK(NULL);
	if (!fallback) {
		perror("CAN'T OPEN FALLBACK TABLE");
		ret_3:
		CHARSET$CLOSE_8B(iso_8859_1, 0);
		goto ret_2;
	}
	out = fopen("PCC_MAP.I", "w");
	if (!out) {
		perror("CAN'T CREATE PCC_MAP.I");
		ret_4:
		CHARSET$CLOSE_FALLBACK(fallback, 0);
		goto ret_3;
	}
	fprintf(out, "{\n");
	for (n = 0; n < 4; n++) {
		fprintf(out, "{");
		for (i = 0; i < 256; i++) {
			int val;
			fprintf(out, !(i & 7) ? "\n\t" : " ");
			if (n == 0) {
				lat1:
				val = CHARSET$8B28B_FALLBACK(iso_8859_1, cp437, fallback, i);
				if (val == -1) val = 0x20;
			} else if (n == 1) {
				__s32 uni = vt100gr[i];
				if (__likely(uni < 0)) goto lat1;
				val = CHARSET$UNI28B_FALLBACK(cp437, fallback, uni);
				if (val == -1) val = 0x20;
			} else if (n == 2) {
				val = i;
			} else {
				val = CHARSET$8B28B_FALLBACK(cp437, iso_8859_1, fallback, i);
				if (val == -1) val = 0x20;
			}
			fprintf(out, "0x%02x", val);
			fprintf(out, ",");
		}
		if (n != 3) fprintf(out, "\n}, ");
	}
	fprintf(out, "\n}\n}\n");
	if (ferror(out)) {
		fprintf(stderr, "WRITE ERROR WRITING PCC_MAP.I\n");
		fclose(out);
		goto ret_4;
	}
	fclose(out);
	CHARSET$CLOSE_FALLBACK(fallback, 0);
	CHARSET$CLOSE_8B(cp437, 0);
	CHARSET$CLOSE_8B(iso_8859_1, 0);
	return 0;
}
