#include <SYS/TYPES.H>

#include "VGAREG.H"

/* don't change */
#define H_BORDER	8
#define V_BORDER	2

static __finline__ __u8 in_cr(__u8 idx)
{
	io_outb(io_base + VGA_CRTC_IDX, idx);
	return io_inb(io_base + VGA_CRTC_REG);
}

static __finline__ void out_cr(__u8 idx, __u8 val)
{
#ifndef VGA_DWORD_IO
	io_outb(io_base + VGA_CRTC_IDX, idx);
	io_outb(io_base + VGA_CRTC_REG, val);
#else
	io_outw(io_base + VGA_CRTC_IDX, idx | (val << 8));
#endif
}

static __finline__ __u8 in_sr(__u8 idx)
{
	io_outb(VGA_TS_IDX, idx);
	return io_inb(VGA_TS_REG);
}

static __finline__ void out_sr(__u8 idx, __u8 val)
{
#ifndef VGA_DWORD_IO
	io_outb(VGA_TS_IDX, idx);
	io_outb(VGA_TS_REG, val);
#else
	io_outw(VGA_TS_IDX, idx | (val << 8));
#endif
}

/*
 Note: the blanking setup code from xfree/svgalib is bogus.
 It setups blank only during sync pulses. It works until you run program that
 sets non-black pallete entry 0 (i.e. border) --- for example dvisvga.
 Then you see these effects depending on monitor, video mode and rate:
 - nothing (if monitor sees data shortly after horizontal retrace, it just turns
   completely off)
 - displaying border color during horizontal retrace over existing screen
 - very bright white line at the top --- few first scans it doesn't advance
   vertically
 I modified it for nice little border 8 pixels horizontally and 2 pixels
 vertically. These show no problems.
 More than 2 pixels vertical border is not possible, because for many modes
 v_sync_start leaves only 2 lines at the bottom.
*/
	

static __finline__ void setup_vga_timing(struct video_mode *v, struct tty_videomode_params *p)
{
	unsigned h_blank_start = p->h + H_BORDER;
	unsigned h_blank_end = p->h_total - H_BORDER;
	unsigned v_blank_start = p->v + V_BORDER;
	unsigned v_blank_end = p->v_total - V_BORDER;
	if (__unlikely(h_blank_start > p->h_sync_start)) h_blank_start = p->h_sync_start;
	if (__unlikely((h_blank_end & ~7) >= (p->h_total & ~7))) h_blank_end = p->h_total - 8;	/* can't totally blank, there will be 1 char left */
	if (__unlikely(v_blank_start > p->v_sync_start)) v_blank_start = p->v_sync_start;
	if (__unlikely(v_blank_end >= p->v_total)) v_blank_end = 1;
	out_cr(0x11, 0x00);
	io_outb(VGA_OUTPUT_REG_WRITE, (io_inb(VGA_OUTPUT_REG) & ~(VGA_OUTPUT_REG_VS_NEGATIVE | VGA_OUTPUT_REG_HS_NEGATIVE)) | (p->flags & VIDEO_PARAMS_HSYNC_NEG ? VGA_OUTPUT_REG_HS_NEGATIVE : 0) | (p->flags & VIDEO_PARAMS_VSYNC_NEG ? VGA_OUTPUT_REG_VS_NEGATIVE : 0));
	out_cr(0x00, (p->h_total >> 3) - 5);
	out_cr(0x01, (p->h >> 3) - 1);
	out_cr(0x02, (h_blank_start >> 3) - 1);
	out_cr(0x03, (((h_blank_end >> 3) - 1) & 0x1f) | 0x80);
	out_cr(0x04, p->h_sync_start >> 3);
	out_cr(0x05, ((((h_blank_end >> 3) - 1) & 0x20) << 2) | ((p->h_sync_end >> 3) & 0x1f));
	out_cr(0x06, p->v_total - 2);
	out_cr(0x07, (((p->v_total - 2) & 0x100) >> 8) |
		     (((p->v - 1) & 0x100) >> 7) |
		     ((p->v_sync_start & 0x100) >> 6) |
		     ((p->v_sync_start & 0x100) >> 5) |
		     0x10 |
		     (((p->v_total - 2) & 0x200) >> 4) |
		     (((p->v - 1) & 0x200) >> 3) |
		     ((p->v_sync_start & 0x200) >> 2));
	out_cr(0x09, ((p->v_sync_start & 0x200) >> 4) | 0x40 | (p->flags & VIDEO_PARAMS_DOUBLE_SCAN ? 0x80 : 0x00));
	out_cr(0x10, p->v_sync_start);
	out_cr(0x11, (p->v_sync_end & 0x0f) | 0x20);
	out_cr(0x12, (p->v - 1));
	out_cr(0x15, v_blank_start - 1);
	out_cr(0x16, v_blank_end - 1);
}
