#ifndef __DISPLAY_VGAREG_H
#define __DISPLAY_VGAREG_H

#define VGA_BASE		0x3c0

#define VGA_ATC_IDX_REG		0x3c0
#define  VGA_ATC_IDX_REG_ADDR		0x1f
#define  VGA_ATC_IDX_REG_PAS		0x20
#define VGA_ATC_REG_READ	0x3c1
#define  VGA_ATC_INDEX			0x00
#define  VGA_ATC_CONTROL		0x10
#define   VGA_ATC_CONTROL_ATGE			0x01
#define   VGA_ATC_CONTROL_MONO			0x02
#define   VGA_ATC_CONTROL_LGE			0x04
#define   VGA_ATC_CONTROL_BLINK			0x08
#define   VGA_ATC_CONTROL_PPM			0x20
#define   VGA_ATC_CONTROL_8BIT			0x40
#define   VGA_ATC_CONTROL_P54S			0x80
#define  VGA_ATC_OVERSCAN_COLOR		0x11
#define  VGA_ATC_COLOR_PLANE_ENABLE	0x12
#define  VGA_ATC_H_PIXEL_PANNING	0x13
#define  VGA_ATC_COLOR_SELECT		0x14
#define   VGA_ATC_COLOR_SELECT_54		0x03
#define   VGA_ATC_COLOR_SELECT_67		0x0c
#define VGA_INPUT_STATUS_0	0x3c2
#define  VGA_INPUT_STATUS_0_SS		0x10
#define VGA_OUTPUT_REG_WRITE	0x3c2
#define VGA_TS_IDX		0x3c4
#define VGA_TS_REG		0x3c5
#define  VGA_TS_RESET			0x00
#define   VGA_TS_RESET_AR			0x01
#define   VGA_TS_RESET_SR			0x02
#define  VGA_TS_CLOCKING_MODE		0x01
#define   VGA_TS_CLOCKING_MODE_98DM		0x01
#define   VGA_TS_CLOCKING_MODE_SLR		0x04
#define   VGA_TS_CLOCKING_MODE_DCR		0x08
#define   VGA_TS_CLOCKING_MODE_S4		0x10
#define   VGA_TS_CLOCKING_MODE_SD		0x20
#define  VGA_TS_PLANE_WRITE_ENABLE	0x02
#define  VGA_TS_CHARACTER_MAP		0x03
#define   VGA_TS_CHARACTER_MAP_CSBS		0x03
#define   VGA_TS_CHARACTER_MAP_CSAS		0x0c
#define   VGA_TS_CHARACTER_MAP_CSBS2		0x10
#define   VGA_TS_CHARACTER_MAP_CSAS2		0x20
#define  VGA_TS_MEMORY_MODE		0x04
#define   VGA_TS_MEMORY_MODE_EXT_MEM		0x02
#define   VGA_TS_MEMORY_MODE_OE_DIS		0x04
#define   VGA_TS_MEMORY_MODE_CHAIN_4		0x08
#define VGA_DAC_MASK		0x3c6
#define VGA_DAC_STATE_READ	0x3c7
#define VGA_DAC_READ_IDX	0x3c7
#define VGA_DAC_WRITE_IDX	0x3c8
#define VGA_DAC_REG		0x3c9
#define VGA_FEATURE_READ	0x3ca
#define VGA_OUTPUT_REG		0x3cc
#define  VGA_OUTPUT_REG_COLOR		0x01
#define  VGA_OUTPUT_REG_ENABLE_RAM	0x02
#define  VGA_OUTPUT_REG_CLOCK_1		0x04
#define  VGA_OUTPUT_REG_CLOCK_2		0x08
#define  VGA_OUTPUT_REG_PAGE_A0000	0x20
#define  VGA_OUTPUT_REG_HS_NEGATIVE	0x40
#define  VGA_OUTPUT_REG_VS_NEGATIVE	0x80
#define VGA_GDC_IDX		0x3ce
#define VGA_GDC_REG		0x3cf
#define  VGA_GDC_SET_RESET		0x00
#define  VGA_GDC_ENABLE_SET_RESET	0x01
#define  VGA_GDC_COLOR_COMPARE		0x02
#define  VGA_GDC_DATA_ROTATE		0x03
#define   VGA_GDC_DATA_ROTATE_COUNT		0x07
#define   VGA_GDC_DATA_ROTATE_LOGICAL_OP	0x18
#define    VGA_GDC_DATA_ROTATE_LOGICAL_OP_COPY		0x00
#define    VGA_GDC_DATA_ROTATE_LOGICAL_OP_AND		0x08
#define    VGA_GDC_DATA_ROTATE_LOGICAL_OP_OR		0x10
#define    VGA_GDC_DATA_ROTATE_LOGICAL_OP_XOR		0x18
#define  VGA_GDC_READ_MAP		0x04
#define  VGA_GDC_GRAPHICS_MODE		0x05
#define   VGA_GDC_GRAPHICS_MODE_WRITE_MODE	0x03
#define   VGA_GDC_GRAPHICS_MODE_READ_MODE	0x08
#define   VGA_GDC_GRAPHICS_MODE_HOST_OE		0x10
#define   VGA_GDC_GRAPHICS_MODE_SHIFT_REG	0x20
#define   VGA_GDC_GRAPHICS_MODE_SHIFT_256	0x40
#define  VGA_GDC_MISC			0x06
#define   VGA_GDC_MISC_ALPHA_DIS		0x01
#define   VGA_GDC_MISC_CHAIN_OE			0x02
#define   VGA_GDC_MISC_MEMORY_MAP		0x0c
#define    VGA_GDC_MISC_MEMORY_MAP_A000_BFFF		0x00
#define    VGA_GDC_MISC_MEMORY_MAP_A000_AFFF		0x04
#define    VGA_GDC_MISC_MEMORY_MAP_B000_B7FF		0x08
#define    VGA_GDC_MISC_MEMORY_MAP_B800_BFFF		0x0c
#define  VGA_GDC_COLOR_DONT_CARE	0x07
#define  VGA_GDC_BIT_MASK		0x08

#define VGA_BASE_MONO		0x3b0
#define VGA_BASE_COLOR		0x3d0

#define VGA_CRTC_IDX		0x04
#define VGA_CRTC_REG		0x05
#define  VGA_CRTC_HTOTAL		0x00
#define  VGA_CRTC_HDISPLAY_END		0x01
#define  VGA_CRTC_HBLANK_START		0x02
#define  VGA_CRTC_HBLANK_END		0x03
#define  VGA_CRTC_HRETRACE_START	0x04
#define  VGA_CRTC_HRETRACE_END		0x05
#define  VGA_CRTC_VTOTAL		0x06
#define  VGA_CRTC_OVERFLOW		0x07
#define  VGA_CRTC_PRESET_ROW_SCAN	0x08
#define  VGA_CRTC_MAXIMUM_SCAN_LINE	0x09
#define   VGA_CRTC_MAXIMUM_SCAN_LINE_LINE	0x1f
#define   VGA_CRTC_MAXIMUM_SCAN_LINE_SVB9	0x20
#define   VGA_CRTC_MAXIMUM_SCAN_LINE_LC9	0x40
#define   VGA_CRTC_MAXIMUM_SCAN_LINE_SD		0x80
#define  VGA_CRTC_CURSOR_START		0x0a
#define   VGA_CRTC_CURSOR_START_START		0x1f
#define   VGA_CRTC_CURSOR_START_CD		0x20
#define  VGA_CRTC_CURSOR_END		0x0b
#define   VGA_CRTC_CURSOR_END_END		0x1f
#define   VGA_CRTC_CURSOR_END_SKEW		0x60
#define  VGA_CRTC_START_ADDRESS_HI	0x0c
#define  VGA_CRTC_START_ADDRESS_LO	0x0d
#define  VGA_CRTC_CURSOR_HI		0x0e
#define  VGA_CRTC_CURSOR_LO		0x0f
#define  VGA_CRTC_VRETRACE_START	0x10
#define  VGA_CRTC_VRETRACE_END		0x11
#define  VGA_CRTC_VDISPLAY_END		0x12
#define  VGA_CRTC_OFFSET		0x13
#define  VGA_CRTC_UNDERLINE_LOCATION	0x14
#define  VGA_CRTC_VBLANK_START		0x15
#define  VGA_CRTC_VBLANK_END		0x16
#define  VGA_CRTC_MODE			0x17
#define  VGA_CRTC_LINE_COMPARE		0x18
#define VGA_INPUT_REG		0x0a
#define  VGA_INPUT_REG_HRETRACE		0x01
#define  VGA_INPUT_REG_VRETRACE		0x08
#define VGA_FEATURE_WRITE	0x0a
#define  VGA_FEATURE_FC0		0x01
#define  VGA_FEATURE_FC1		0x02

#endif
