#include <SPAD/SYSLOG.H>
#include <STRING.H>

#include "STRUCT.H"
#include "CDFS.H"

void INIT_SUSP_STATE(CDFS *fs, SUSP_STATE *st, DIRECTORY_RECORD *dir, unsigned current_sector, unsigned current_offset)
{
	__u8 *susp_start, *dirent_end;
	st->pos = 0;
	st->len = 0;
	st->cont_sector = 0;
	st->cont_offset = 0;
	st->cont_len = 0;
	st->current_sector = current_sector;
	st->current_offset = current_offset;
	st->n_cont = 0;
	if (__likely(fs->flags & (CDFS_HIGH_SIERRA | CDFS_JOLIET | CDFS_DISABLE_ROCK_RIDGE))) return;
	susp_start = &dir->name[dir->name_len + !(dir->name_len & 1)] + fs->susp_offset;
	dirent_end = (__u8 *)dir + dir->length;
	if (__unlikely(susp_start + sizeof(SUSP) > dirent_end)) return;
	memcpy(st->buffer, susp_start, dirent_end - susp_start);
	st->len = dirent_end - susp_start;
	st->current_offset += susp_start - (__u8 *)dir;
}

SUSP *GET_SUSP_ENTRY(CDFS *fs, SUSP_STATE *st)
{
	SUSP *susp;
	again:
	if (__unlikely(st->pos + sizeof(SUSP) > st->len)) {
		return NULL;
	}
	susp = (SUSP *)(st->buffer + st->pos);
	if (__unlikely(!susp->signature[0]) || __unlikely(!susp->signature[1]) || __unlikely(!susp->len)) {
		/* DVDs have zero padding */
		return NULL;
	}
	if (__unlikely(susp->len < sizeof(SUSP))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "SUSP ERROR AT %"__d_off_format"X:%X: INVALID LENGTH %X", CDFS_GET_SECTOR(st->current_sector), st->current_offset + st->pos, susp->len);
		return NULL;
	}
	if (__unlikely(st->pos + susp->len > st->len)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "SUSP ERROR AT %"__d_off_format"X:%X: ENTRY OVER BLOCK END, LENGTH %X", CDFS_GET_SECTOR(st->current_sector), st->current_offset + st->pos, susp->len);
		return NULL;
	}
	st->pos += susp->len;
	if (__unlikely(TEST_SUSP(susp, 'C', 'E', 1))) {
		unsigned sector, offset, length;
		if (__unlikely(susp->len != sizeof(SUSP_CE))) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "SUSP ERROR AT %"__d_off_format"X:%X: CE ENTRY HAS INVALID LENGTH %X", CDFS_GET_SECTOR(st->current_sector), st->current_offset + st->pos, susp->len);
			goto again;
		}
		if (__unlikely(st->n_cont >= SUSP_MAX_CONT)) {
			goto again;
		}
#define	susp_ce	((SUSP_CE *)susp)
		sector = GET_LE_32_8(susp_ce->sector_le);
		offset = GET_LE_32_8(susp_ce->offset_le);
		length = GET_LE_32_8(susp_ce->length_le);
#undef susp_ce
		if (__unlikely(offset + length > CDFS_SECTOR_SIZE) || __unlikely(offset + length < offset)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "SUSP ERROR AT %"__d_off_format"X:%X: CE ENTRY HAS INVALID CONTENT: SECTOR %X, OFFSET %X, LENGTH %X", CDFS_GET_SECTOR(st->current_sector), st->current_offset + st->pos, sector, offset, length);
			goto again;
		}
		st->cont_sector = sector;
		st->cont_offset = offset;
		st->cont_len = length;
		goto again;
	}
	if (__unlikely(TEST_SUSP(susp, 'S', 'T', 1))) {
		if (__unlikely(susp->len != sizeof(SUSP_ST))) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "SUSP ERROR AT %"__d_off_format"X:%X: ST ENTRY HAS INVALID LENGTH %X", CDFS_GET_SECTOR(st->current_sector), st->current_offset + st->pos, susp->len);
		}
		return NULL;
	}
	return susp;
}

void SUSP_CONTINUE(CDFS *fs, SUSP_STATE *st, __u8 *new_sector)
{
	if (__unlikely(!st->cont_sector))
		KERNEL$SUICIDE("SUSP_CONTINUE: NO CONTINUATION AREA REQUESTED");
	memcpy(st->buffer, new_sector + st->cont_offset, st->cont_len);
	st->current_sector = st->cont_sector;
	st->current_offset = st->cont_offset;
	st->pos = 0;
	st->len = st->cont_len;
	st->cont_sector = 0;
	st->cont_offset = 0;
	st->cont_len = 0;
	st->n_cont++;
}
