#include <SYS/TYPES.H>

#include "STRUCT.H"
#include "CDFS.H"

static int GET_NUMBER(__u8 *num, unsigned len)
{
	int val = 0;
	while (len--) {
		__u8 c = *num++;
		if (__unlikely(c < '0') || __unlikely(c > '9')) continue;
		val = (val * 10) + c - '0';
	}
	return val;
}

time_t CDFS_TIME(__u8 *v, int format)
{
	static const __u16 months[13] =
		{ 0,
		  0,
		  31,
		  31 + 28,
		  31 + 28 + 31,
		  31 + 28 + 31 + 30,
		  31 + 28 + 31 + 30 + 31,
		  31 + 28 + 31 + 30 + 31 + 30,
		  31 + 28 + 31 + 30 + 31 + 30 + 31,
		  31 + 28 + 31 + 30 + 31 + 30 + 31 + 31,
		  31 + 28 + 31 + 30 + 31 + 30 + 31 + 31 + 30,
		  31 + 28 + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31,
		  31 + 28 + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31 + 30,
		/*31 + 28 + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31 + 30 + 31*/};
	int year, month, day, hour, minute, second;
	int zone;
	time_t days;
	if (__likely(format != CDFS_TIME_LONG)) {
		year = v[0] - 70;
		month = v[1];
		day = v[2];
		hour = v[3];
		minute = v[4];
		second = v[5];
		if (__likely(format == CDFS_TIME_SHORT)) zone = (__s8)v[6];
		else zone = 0;
	} else {
		year = GET_NUMBER(&v[0], 4) - 1970;
		month = GET_NUMBER(&v[4], 2);
		day = GET_NUMBER(&v[6], 2);
		hour = GET_NUMBER(&v[8], 2);
		minute = GET_NUMBER(&v[10], 2);
		second = GET_NUMBER(&v[12], 2);
		zone = (__s8)v[16];
	}
	if (__unlikely(zone < -48) || __unlikely(zone > 52)) zone = 0;
	/* algorith from Linux isofs */
	if (__unlikely(year < 0)) return 0;
	days = year * 365;
	if (__likely(year > 2)) days += (year + 1) >> 2;
	if (__likely((unsigned)month <= 12)) days += months[month];
	if (!((year + 2) & 3) && month > 2) days++;
	days += day - 1;
	return days * 86400 + hour * 3600 + minute * 60 + second - zone * 900;
}

static int GET_ROCK_ENTRY(__u8 **ptr, unsigned *len, unsigned flags, time_t *t)
{
	unsigned el = __unlikely(flags & SUSP_TF_LONG) ? SUSP_TF_LONG_TIME_LENGTH : SUSP_TF_SHORT_TIME_LENGTH;
	if (__unlikely(*len < el)) return -EFSERROR;
	*t = CDFS_TIME(*ptr, __unlikely(flags & SUSP_TF_LONG) ? CDFS_TIME_LONG : CDFS_TIME_SHORT);
	*ptr += el;
	*len -= el;
	return 0;
}

int ROCK_TIME(SUSP *susp, time_t *ctime, time_t *mtime)
{
#define susp_tf ((SUSP_TF *)susp)
	__u8 *ptr;
	unsigned len, flags;
	time_t sink;
	if (__unlikely(susp->len < SUSP_TF_OFFSET)) return -EFSERROR;
	flags = susp_tf->flags;
	ptr = susp_tf->data;
	len = susp_tf->len - SUSP_TF_OFFSET;
	if (flags & SUSP_TF_CREATE) if (__unlikely(GET_ROCK_ENTRY(&ptr, &len, flags, ctime))) return -EFSERROR;
	if (flags & SUSP_TF_MODIFY) if (__unlikely(GET_ROCK_ENTRY(&ptr, &len, flags, mtime))) return -EFSERROR;
	if (flags & SUSP_TF_ACCESS) if (__unlikely(GET_ROCK_ENTRY(&ptr, &len, flags, &sink))) return -EFSERROR;
	if (flags & SUSP_TF_CHANGE) if (__unlikely(GET_ROCK_ENTRY(&ptr, &len, flags, ctime))) return -EFSERROR;
	if (flags & SUSP_TF_BACKUP) if (__unlikely(GET_ROCK_ENTRY(&ptr, &len, flags, &sink))) return -EFSERROR;
	if (flags & SUSP_TF_EXPIRE) if (__unlikely(GET_ROCK_ENTRY(&ptr, &len, flags, &sink))) return -EFSERROR;
	if (flags & SUSP_TF_EFFECTIVE) if (__unlikely(GET_ROCK_ENTRY(&ptr, &len, flags, &sink))) return -EFSERROR;
	return 0;
#undef susp_tf
}

