/*
 *  linux/include/linux/ext2_fs_sb.h
 *
 * Copyright (C) 1992, 1993, 1994, 1995
 * Remy Card (card@masi.ibp.fr)
 * Laboratoire MASI - Institut Blaise Pascal
 * Universite Pierre et Marie Curie (Paris VI)
 *
 *  from
 *
 *  linux/include/linux/minix_fs_sb.h
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

#ifndef _LINUX_EXT2_FS_SB
#define _LINUX_EXT2_FS_SB

#include <SPAD/VFS.H>

#include "STRUCT.H"

typedef unsigned ext2_ino_t;
typedef unsigned ext2_blk_t;
#define u8 __u8
#define s8 __s8
#define u16 __u16
#define s16 __s16
#define u32 __u32
#define s32 __s32
#define u64 __u64
#define s64 __s64

#define ext2_uid_t __u32
#define ext2_gid_t __u32

#define INODE_HASH_SIZE		1024

#define INODE_HASH(i)		((i) & (INODE_HASH_SIZE - 1))

/*
 * second extended-fs super-block data in memory
 */
typedef struct super_block {
	FS_HEAD;
	unsigned s_frag_size;	/* Size of a fragment in bytes */
	unsigned s_frags_per_block;/* Number of fragments per block */
	unsigned s_inodes_per_block;/* Number of inodes per block */
	ext2_blk_t s_frags_per_group;/* Number of fragments in a group */
	ext2_blk_t s_blocks_per_group;/* Number of blocks in a group */
	ext2_ino_t s_inodes_per_group;/* Number of inodes in a group */
	ext2_ino_t s_itb_per_group;	/* Number of inode table blocks per group */
	ext2_blk_t s_gdb_count;	/* Number of group descriptor blocks */
	ext2_blk_t s_desc_per_block;	/* Number of group descriptors per block */
	ext2_blk_t s_groups_count;	/* Number of groups in the fs */
	unsigned s_mount_opt;
	ext2_uid_t s_resuid;
	ext2_gid_t s_resgid;
	unsigned short s_mount_state;
	unsigned short s_pad;
	int s_addr_per_block_bits;
	int s_desc_per_block_bits;
	int s_inode_size;
	int s_first_ino;
	u32 s_next_generation;
	ext2_ino_t s_dir_count;
	u8 *s_debts;

	unsigned s_blocksize;
	unsigned s_log_block_size;

	/* spad-only fields */
	ext2_blk_t overallocated_avg_blocks;
	ext2_blk_t overallocated_blocks;
	ext2_ino_t overallocated_inodes;

	ext2_blk_t prealloc_blk;
	unsigned prealloc_blk_len;
	unsigned new_prealloc_blk_len;
	ext2_ino_t prealloc_ino;
	unsigned prealloc_ino_len;
	unsigned new_prealloc_ino_len;

	struct ext2_group_desc *block_groups;
	__u8 sectors_per_block_bits;
	__u8 sectors_per_block;
	ext2_blk_t sb_block;
	unsigned sb_block_offset;

	struct ext2_super_block sblk;

	XLIST_HEAD inode_hash[INODE_HASH_SIZE];
} EXT2FS;

typedef struct inode {
	FNODE_HEAD;
	__u32	i_data[15];
	__u32	i_flags;
	__u32	i_faddr;
	__u8	i_frag_no;
	__u8	i_frag_size;
	/*__u16	i_state;*/
	__u32	i_file_acl;
	__u32	i_dir_acl;
	__u32	i_dtime;

	/*
	 * i_block_group is the number of the block group which contains
	 * this file's inode.  Constant across the lifetime of the inode,
	 * it is ued for making block allocation decisions - we try to
	 * place a file's data blocks near its inode block, and new inodes
	 * near to their parent directory's inode.
	 */
	/*__u32	i_block_group;*/

	/*
	 * i_next_alloc_block is the logical (file-relative) number of the
	 * most-recently-allocated block in this file.  Yes, it is misnamed.
	 * We use this for detecting linearly ascending allocation requests.
	 */
	/*__u32	i_next_alloc_block;*/

	/*
	 * i_next_alloc_goal is the *physical* companion to i_next_alloc_block.
	 * it the the physical block number of the block which was most-recently
	 * allocated to this file.  This give us the goal (target) for the next
	 * allocation when we detect linearly ascending requests.
	 */
	/*__u32	i_next_alloc_goal;
	__u32	i_prealloc_block;
	__u32	i_prealloc_count;
	__u32	i_dir_start_lookup;*/
#ifdef CONFIG_EXT2_FS_POSIX_ACL
	struct posix_acl	*i_acl;
	struct posix_acl	*i_default_acl;
#endif
	/*rwlock_t i_meta_lock;
	struct inode	vfs_inode;*/

	/* from inode.c */

	ext2_uid_t i_uid;
	ext2_gid_t i_gid;
	int i_nlink;
	unsigned i_mode;
	__u32 i_atime;
	__u32 i_generation;
	__u64 i_blocks;

	/* spad-only */
	__u32 i_ino;
	LIST_ENTRY inode_hash;
} EXT2FNODE;

#define ext2_inode_info inode

#define EXT2_I(x)	(x)

#endif	/* _LINUX_EXT2_FS_SB */
