#include <SPAD/SYSLOG.H>

#include "FAT.H"
#include "STRUCT.H"

/* if exact is set, it searches from (hint + 1) */

fat_sector_t FAT_ALLOC(FATFS *fs, fat_sector_t hint, fat_sector_t *n_clusters, int exact)
{
	fat_sector_t run_start, x;
	fat_sector_t best_run, best_len;
	if (hint < 2 || hint >= fs->clusters) hint = 2;
	if (__unlikely(!exact) && __likely(!FAT_READ(fs, hint))) {
		fat_sector_t i;
		do_alloc:
		for (i = 1; i < *n_clusters; i++)
			if (hint + i < fs->clusters && !FAT_READ(fs, hint + i)) {
				FAT_WRITE(fs, hint + i - 1, hint + i);
			} else break;
		FAT_WRITE(fs, hint + i - 1, CLUSTER_EOF);
		fs->free_clusters -= i;
		*n_clusters = i;
		FAT_WRITE_FSINFO(fs);
		return hint;
	}
	x = hint + 1;
	best_run = 0;
	best_len = 0;
	c1:
	if (x >= fs->clusters) x = 2;
	if (x == hint) {
		h:
		if (__unlikely(!best_len)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "CAN'T ALLOCATE %X CLUSTERS NEAR %08X", *n_clusters, hint);
			return 0;
		}
		hint = best_run;
		fs->max_free_run = best_len / 2 + 1;
		goto do_alloc;
	}
	if (__likely(FAT_READ(fs, x) != 0)) {
		x++;
		goto c1;
	}
	run_start = x;
	c2:
	x++;
	if (__unlikely(x == hint)) goto h;
	if (x - run_start >= *n_clusters || x - run_start >= fs->max_free_run) {
		hint = run_start;
		goto do_alloc;
	}
	if (x < fs->clusters && !FAT_READ(fs, x)) goto c2;
	if (x - run_start > best_len) best_run = run_start, best_len = x - run_start;
	goto c1;
}

void FAT_FREE(FATFS *fs, fat_sector_t cluster)
{
	fat_sector_t v;
	if (__unlikely(cluster < 2) || __unlikely(cluster >= fs->clusters)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FREEING CLUSTER %08X (FS CLUSTERS %08X)", cluster, fs->clusters);
		return;
	}
	if (fs->max_free_run < fs->clusters) fs->max_free_run <<= 1;
	again:
	v = FAT_READ(fs, cluster);
	if (__unlikely(IS_EOF(v))) {
		VFS$CLEAN_BUFFERS_SYNC((FS *)fs, FAT_CLUSTER_2_SECTOR(fs, cluster), fs->sectors_per_cluster);
		FAT_WRITE(fs, cluster, 0);
		fs->free_clusters++;
		FAT_WRITE_FSINFO(fs);
		return;
	}
	if (__unlikely(v < 2) || __unlikely(v >= fs->clusters)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "BAD CLUSTER %08X TO FREE AT POSITION %08X (FS CLUSTERS %08X)", v, cluster, fs->clusters);
		FAT_WRITE_FSINFO(fs);
		return;
	}
	VFS$CLEAN_BUFFERS_SYNC((FS *)fs, FAT_CLUSTER_2_SECTOR(fs, cluster), fs->sectors_per_cluster);
	FAT_WRITE(fs, cluster, 0);
	fs->free_clusters++;
	cluster = v;
	goto again;
}

