#ifndef _HPFS_HPFS_H
#define _HPFS_HPFS_H

#include <SPAD/VFS.H>
#include <SPAD/SYSLOG.H>
#include <ENDIAN.H>

#include "STRUCT.H"

#define OTHEZONE_THRESHOLD_BLOCKS	2048	/* 1MB */
#define PROPAGATE_HINT_TIME		3600

struct bmp_desc {
	unsigned sector;
	unsigned short max_free_run;
	unsigned short n_free;
};

typedef struct {
	FS_HEAD;
	struct bmp_desc *bmp_desc;
	unsigned n_bitmaps;
	unsigned root_fnode;
	unsigned bitmap_directory;
	unsigned dir_band_start;
	unsigned n_dir_band;
	unsigned dir_band_bitmap;
	unsigned dir_band_free;
	unsigned code_page_dir;
	unsigned n_code_pages;
	unsigned char upcase[128];
	unsigned free_space;
	unsigned free_dnodes;
	unsigned overallocated_space;
	unsigned overallocated_dnodes;
	unsigned overallocated_average;
	unsigned prealloc_fnode_sector;
	unsigned prealloc_fnode_length;
	unsigned prealloc_data_sector;
	unsigned prealloc_data_length;
	int timeshift;
	__u32 scratch[(2048 + 512) / 4];
} HPFSFS;

#define HPFS_ERROR_CONT	0x00000001
#define HPFS_WAS_ERROR	0x00000002
#define HPFS_SPARE_USED	0x00000004

typedef struct {
	FNODE_HEAD;
	__u8 flags1;
	__u8 flags2;
	unsigned fnode;
	unsigned ea_size;
} HPFSFNODE;

typedef struct {
	PAGEINRQ_HEAD;
	int state;
	unsigned dirptr;
	unsigned c[2];
	unsigned d[2];
	char cookie[256];
} HPFSPAGEINRQ;

void HPFS_ERROR(HPFSFS *fs);
int HPFS_VALIDATE_FILENAME(FS *fs, const char *filename);
void HPFS_LOOKUP(PAGEINRQ *p);
void HPFS_INIT_READDIR_COOKIE(struct readdir_buffer *rb, FNODE *f);
void HPFS_READDIR(PAGEINRQ *pgin, struct readdir_buffer *rb);
void HPFS_INIT_FNODE(FNODE *f);
int HPFS_CREATE_FNODE(FNODE *f);
int HPFS_WRITE_FNODE_DATA(FNODE *f);
int HPFS_ADD_FNODE_TO_DIRECTORY(FNODE *f);
int HPFS_DELETE_FNODE(FNODE *f);
int HPFS_REMOVE_FNODE_FROM_DIRECTORY(FNODE *f);
void HPFS_BMAP(PAGEINRQ *pgin);
int HPFS_SYNC_BMAP(FNODE *f, __d_off off, int try);
int HPFS_STOP_CYCLES(unsigned key, unsigned (*c)[2]);

__u8 *HPFS_MAP_BITMAP(HPFSFS *fs, int bmp, BUFFER **b, int *pos);
int FIND_MAX_RUN(__u8 *bmp);
unsigned HPFS_ALLOC(HPFSFS *fs, unsigned goal, unsigned *n);
void HPFS_FREE(HPFSFS *fs, unsigned sec, unsigned n);
unsigned HPFS_DIRECTORY_HINT(HPFSFNODE *f);

void HPFS_SPARE_MAKE_CHECKSUM(struct hpfs_spare_block *spare);
int HPFS_CHECK_DNODE(HPFSFS *fs, struct dnode *dnode, unsigned sec, int allow_empty);
int HPFS_CHECK_FNODE(HPFSFS *fs, struct fnode *fnode, unsigned sec);
int HPFS_CHECK_ANODE(HPFSFS *fs, struct anode *anode, unsigned sec);
struct hpfs_spare_block *HPFS_MAP_SPARE(HPFSFS *fs, BUFFER **b);
struct fnode *HPFS_MAP_FNODE(HPFSFNODE *f, BUFFER **b);
struct anode *HPFS_MAP_ANODE(HPFSFS *fs, unsigned ano, BUFFER **b);
struct dnode *HPFS_MAP_DNODE(HPFSFS *fs, unsigned dno, BUFFER **b, int allow_empty);
struct anode *HPFS_ALLOC_ANODE(HPFSFNODE *f, unsigned *ap);
int HPFS_IS_NAME_LONG(unsigned char *name, unsigned len);
void HPFS_UPCASE(HPFSFS *fs, unsigned char *name, unsigned len);
int HPFS_COMPARE(HPFSFS *fs, unsigned len1, unsigned char *s1, unsigned len2, unsigned char *s2);

int HPFS_EXTEND_FILE(HPFSFNODE *f, unsigned current_blocks, unsigned new_blocks);
int HPFS_TRUNCATE_FILE(HPFSFNODE *f, unsigned blocks);
void HPFS_ZAP_ANODE(HPFSFS *fs, unsigned ano);

void HPFS_DISCARD_PREALLOC_(HPFSFS *fs);
static __finline__ void HPFS_DISCARD_PREALLOC(HPFSFS *fs)
{
	if (fs->prealloc_fnode_length | fs->prealloc_data_length) HPFS_DISCARD_PREALLOC_(fs);
}

void HPFS_DO_PREALLOC_(HPFSFNODE *f);
static __finline__ void HPFS_DO_PREALLOC(HPFSFNODE *f)
{
	if (((HPFSFS *)f->fs)->prealloc_fnode_length | ((HPFSFS *)f->fs)->prealloc_data_length) HPFS_DO_PREALLOC_(f);
}

int HPFS_TEST_CONTIG_ALLOC(FNODE *f_);

static __finline__ unsigned dnode_readahead(HPFSFS *fs, unsigned dnode)
{
	if (__likely(dnode >= fs->dir_band_start) && __likely(dnode < fs->dir_band_start + fs->n_dir_band)) return fs->buffer_readahead;
	return 0;
}

static __finline__ time_t TIME_LOCAL_TO_GMT(HPFSFS *fs, __u32 tm)
{
	return (time_t)tm + fs->timeshift;
}

static __finline__ __u32 TIME_GMT_TO_LOCAL(HPFSFS *fs, time_t tm)
{
	return (__u32)tm - fs->timeshift;
}

#endif
