#include "HPFS.H"

#define is_bmap_invalid(f)		\
	(__unlikely(!(unsigned long)f->disk_blk) || __unlikely((unsigned long)f->disk_blk + (unsigned long)f->run_length > (unsigned long)f->fs->size) || __unlikely((unsigned long)f->disk_blk + (unsigned long)f->run_length <= (unsigned long)f->disk_blk))

static struct bplus_leaf_node *BPLUS_LOOKUP(struct bplus_header *bp, unsigned off, unsigned *d)
{
	int s = 0;
	int e = bp->n_used_nodes - 1;
	if (__unlikely(bp->flags1 & BP_1_INTERNAL)) {
		while (__likely(e >= s)) {
			int m = (e + s) >> 1;
			if (off >= __32LE2CPU(bp->u.internal[m].file_secno)) {
				s = m + 1;
				continue;
			}
			if (!m || off >= __32LE2CPU(bp->u.internal[m - 1].file_secno)) {
				*d = __32LE2CPU(bp->u.internal[m].down);
				return NULL;
			}
			e = m - 1;
		}
	} else {
		while (__likely(e >= s)) {
			int m = (e + s) >> 1;
			unsigned f_s = __32LE2CPU(bp->u.external[m].file_secno);
			if (__unlikely(off < f_s)) {
				e = m - 1;
				continue;
			}
			if (off < f_s + __32LE2CPU(bp->u.external[m].length))
				return &bp->u.external[m];
			s = m + 1;
		}
	}
	*d = NULL;
	return NULL;
}

static AST_STUB HPFS_BMAP_AST;

void HPFS_BMAP(PAGEINRQ *p_)
{
	HPFSPAGEINRQ *p = (HPFSPAGEINRQ *)p_;
	p->fn = HPFS_BMAP_AST;
	p->state = 0;
	p->c[1] = 0;
	CALL_AST(p);
}

static DECL_AST(HPFS_BMAP_AST, SPL_FS, HPFSPAGEINRQ)
{
	struct fnode *fnode;
	struct anode *anode;
	struct bplus_leaf_node *bp;
	HPFSFNODE *f;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_FS), RQ->caller);
	SWITCH_PROC_ACCOUNT(RQ->tag.proc, SPL_X(SPL_FS));
	if (__unlikely(RQ->status != 0)) {
		bd:
		VFS$BMAP_DONE((PAGEINRQ *)RQ);
		RETURN;
	}
	f = (HPFSFNODE *)RQ->fnode;
	if (__likely(!RQ->state)) {
		if (__unlikely(!(fnode = VFS$GET_BUFFER(RQ->fs, f->fnode, 1, (void *)&KERNEL$LIST_END, RQ->tag.proc)))) {
			VFS$READ_BUFFER(f->fnode, (PAGEINRQ *)RQ, 0);
			RETURN;
		}
		if (__unlikely(HPFS_CHECK_FNODE((HPFSFS *)RQ->fs, fnode, f->fnode))) {
			VFS$PUT_BUFFER(fnode);
			RQ->status = -EFSERROR;
			goto bd;
		}
		bp = BPLUS_LOOKUP(&fnode->btree, RQ->off, &RQ->dirptr);
		if (__likely(bp != NULL)) {
			f->disk_blk = __32LE2CPU(bp->disk_secno);
			f->file_blk = __32LE2CPU(bp->file_secno);
			f->run_length = __32LE2CPU(bp->length);
			VFS$PUT_BUFFER(fnode);
			check_z:
			if (is_bmap_invalid(f)) {
				KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "POINTER %08X OUT OF DISK, FNODE %08X, OFFSET %08X", (unsigned)f->disk_blk, ((HPFSFNODE *)RQ->fnode)->fnode, (unsigned)RQ->off);
				HPFS_ERROR((HPFSFS *)RQ->fs);
				RQ->status = -EFSERROR;
				f->run_length = 0;
			}
			goto bd;
		}
		VFS$PUT_BUFFER(fnode);
		if (__unlikely(!RQ->dirptr)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "CAN'T FIND BLOCK %08lX IN FNODE %08X", (unsigned long)RQ->off, f->fnode);
			HPFS_ERROR((HPFSFS *)RQ->fs);
			RQ->status = -EFSERROR;
			goto bd;
		}
		RQ->state = 1;
	}
	if (0) {
		go_sub:
		if (__unlikely(KERNEL$LOCKUP_LEVEL >= LOCKUP_LEVEL_ALL_IORQS)) {
			WQ_WAIT_PAGEINRQ(&KERNEL$LOCKUP_EVENTS, (PAGEINRQ *)RQ);
			RETURN;
		}
	}
	if (__unlikely(!(anode = VFS$GET_BUFFER(RQ->fs, RQ->dirptr, 1, (void *)&KERNEL$LIST_END, RQ->tag.proc)))) {
		VFS$READ_BUFFER(RQ->dirptr, (PAGEINRQ *)RQ, 0);
		RETURN;
	}
	if (__unlikely(HPFS_CHECK_ANODE((HPFSFS *)RQ->fs, anode, RQ->dirptr))) {
		VFS$PUT_BUFFER(anode);
		RQ->status = -EFSERROR;
		goto bd;
	}
	if (__unlikely(HPFS_STOP_CYCLES(RQ->dirptr, &RQ->c))) {
		VFS$PUT_BUFFER(anode);
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (ASYNC BMAP %08X)", RQ->dirptr, f->fnode, (unsigned)RQ->off);
		HPFS_ERROR((HPFSFS *)RQ->fs);
		RQ->status = -EFSERROR;
		goto bd;
	}
	bp = BPLUS_LOOKUP(&anode->btree, RQ->off, &RQ->dirptr);
	if (__likely(bp != NULL)) {
		f->disk_blk = __32LE2CPU(bp->disk_secno);
		f->file_blk = __32LE2CPU(bp->file_secno);
		f->run_length = __32LE2CPU(bp->length);
		VFS$PUT_BUFFER(anode);
		goto check_z;
	}
	VFS$PUT_BUFFER(anode);
	if (__unlikely(!RQ->dirptr)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, RQ->fs->filesystem_name, "CAN'T FIND BLOCK %08lX IN FNODE %08X (ANODE %08X)", (unsigned long)RQ->off, f->fnode, RQ->dirptr);
		HPFS_ERROR((HPFSFS *)RQ->fs);
		RQ->status = -EFSERROR;
		goto bd;
	}
	goto go_sub;

}

int HPFS_SYNC_BMAP(FNODE *f_, __d_off off, int try)
{
	HPFSFNODE *f = (HPFSFNODE *)f_;
	struct fnode *fnode;
	struct anode *anode;
	struct bplus_leaf_node *bp;
	unsigned ano;
	unsigned c[2];
	if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, __likely(!try) ? (void *)&KERNEL$LIST_END : NULL)))) return __PTR_ERR(fnode);
	bp = BPLUS_LOOKUP(&fnode->btree, off, &ano);
	if (__likely(bp != NULL)) {
		f->disk_blk = __32LE2CPU(bp->disk_secno);
		f->file_blk = __32LE2CPU(bp->file_secno);
		f->run_length = __32LE2CPU(bp->length);
		VFS$PUT_BUFFER(fnode);
		check_z:
		if (is_bmap_invalid(f)) {
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "POINTER %08X OUT OF DISK, FNODE %08X, OFFSET %08X", (unsigned)f->disk_blk, f->fnode, (unsigned)off);
			HPFS_ERROR((HPFSFS *)f->fs);
			f->run_length = 0;
			return -EFSERROR;
		}
		return 0;
	}
	VFS$PUT_BUFFER(fnode);
	if (__unlikely(!ano)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "CAN'T FIND BLOCK %08lX IN FNODE %08X", (unsigned long)off, f->fnode);
		HPFS_ERROR((HPFSFS *)f->fs);
		return -EFSERROR;
	}
	c[1] = 0;
	go_sub:
	if (__unlikely(HPFS_STOP_CYCLES(ano, &c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (SYNC BMAP %08X)", ano, f->fnode, (unsigned)off);
		HPFS_ERROR((HPFSFS *)f->fs);
		return -EFSERROR;
	}
	if (__unlikely(__IS_ERR(anode = HPFS_MAP_ANODE((HPFSFS *)f->fs, ano, __likely(!try) ? (void *)&KERNEL$LIST_END : NULL)))) return __PTR_ERR(anode);
	bp = BPLUS_LOOKUP(&anode->btree, off, &ano);
	if (__likely(bp != NULL)) {
		f->disk_blk = __32LE2CPU(bp->disk_secno);
		f->file_blk = __32LE2CPU(bp->file_secno);
		f->run_length = __32LE2CPU(bp->length);
		VFS$PUT_BUFFER(anode);
		goto check_z;
	}
	VFS$PUT_BUFFER(anode);
	if (__unlikely(!ano)) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "CAN'T FIND BLOCK %08lX IN FNODE %08X (ANODE %08X)", (unsigned long)off, f->fnode, ano);
		HPFS_ERROR((HPFSFS *)f->fs);
		return -EFSERROR;
	}
	goto go_sub;
}

static void FIX_ANODE_UP_POINTERS(HPFSFS *fs, struct anode *anode)
{
	int i;
	for (i = 0; i < anode->btree.n_used_nodes; i++) {
		struct anode *n_anode;
		BUFFER *b;
		if (__unlikely(__IS_ERR(n_anode = HPFS_MAP_ANODE(fs, __32LE2CPU(anode->u.internal[i].down), &b)))) continue;
		n_anode->up = anode->self;
		n_anode->btree.flags1 &= ~BP_1_FNODE_PARENT;
		VFS$MARK_BUFFER_DIRTY(b, __32LE2CPU(anode->u.internal[i].down) & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		VFS$PUT_BUFFER(n_anode);
	}
}

int HPFS_EXTEND_FILE(HPFSFNODE *f, unsigned current_blocks, unsigned new_blocks)
{
#define fs ((HPFSFS *)f->fs)
	unsigned alloc, nalloc;
	unsigned ano, n_ano, xano;
	struct fnode *fnode;
	struct anode *anode;
	BUFFER *b;
	unsigned c[2];
	union {
		char space[512];
		struct fnode fnode;
		struct anode anode;
	} scratch;
#define scratch_fnode	(&scratch.fnode)
#define scratch_anode	(&scratch.anode)
	again:
	if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, &b)))) return __PTR_ERR(fnode);
	if (!current_blocks) {
		unsigned goal;
		if (__unlikely(fnode->btree.n_used_nodes)) {
			VFS$PUT_BUFFER(fnode);
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "ZERO-SIZED FILE %08X HAS SOME ALLOCATIONS", f->fnode);
			HPFS_ERROR(fs);
			return -EFSERROR;
		}
		VFS$PUT_BUFFER(fnode);
		nalloc = new_blocks;
		goal = f->fnode;
		if (__unlikely(nalloc >= OTHEZONE_THRESHOLD_BLOCKS)) {
			goal = (goal + 0x4000) & ~0x3fff;
		} else {
			if (__likely(fs->prealloc_data_length) && __likely(f->flags & FNODE_UNCOMMITTED_PREALLOC_HINT)) {
				if (__unlikely(nalloc > fs->prealloc_data_length))
					nalloc = fs->prealloc_data_length;
				fs->prealloc_data_length -= nalloc;
				alloc = fs->prealloc_data_sector;
				fs->prealloc_data_sector += nalloc;
				goto allocated;
			}
		}
		if (__unlikely(!(alloc = HPFS_ALLOC(fs, goal, &nalloc)))) {
			return -ENOSPC;
		}
		allocated:
		if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, &b)))) {
			HPFS_FREE(fs, alloc, nalloc);
			return __PTR_ERR(fnode);
		}
		fnode->u.external[0].file_secno = __32CPU2LE(0);
		fnode->u.external[0].length = __32CPU2LE(nalloc);
		fnode->u.external[0].disk_secno = __32CPU2LE(alloc);
		fnode->btree.flags1 = 0;
		fnode->btree.n_free_nodes = 7;
		fnode->btree.n_used_nodes = 1;
		fnode->btree.first_free = __16CPU2LE(sizeof(struct bplus_header) + sizeof(struct bplus_leaf_node));
		VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		current_blocks += nalloc;
		if (__likely(!(new_blocks -= nalloc))) {
			VFS$PUT_BUFFER(fnode);
			return 0;
		}
	}
	if (__likely(!(fnode->btree.flags1 & BP_1_INTERNAL))) {
		again_x:
		VFS$PUT_BUFFER(fnode);
		nalloc = new_blocks;
		if (__unlikely(!(alloc = HPFS_ALLOC(fs, __32LE2CPU(fnode->u.external[fnode->btree.n_used_nodes - 1].disk_secno) + __32LE2CPU(fnode->u.external[fnode->btree.n_used_nodes - 1].length), &nalloc)))) {
			return -ENOSPC;
		}
		if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, &b)))) {
			HPFS_FREE(fs, alloc, nalloc);
			return __PTR_ERR(fnode);
		}
		if (__unlikely(!fnode->btree.n_used_nodes)) {
			VFS$PUT_BUFFER(fnode);
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "NON-ZERO-SIZED FILE %08X HAS NO ALLOCATIONS", f->fnode);
			HPFS_ERROR(fs);
			HPFS_FREE(fs, alloc, nalloc);
			return -EFSERROR;
		}
		if (__unlikely(fnode->btree.flags1 & BP_1_INTERNAL)) {
			VFS$PUT_BUFFER(fnode);
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FNODE BTREE INTERNAL FLAG CHANGED UNDER ALLOCATION");
			HPFS_ERROR(fs);
			HPFS_FREE(fs, alloc, nalloc);
			return -EFSERROR;
		}
		if (__likely(alloc == __32LE2CPU(fnode->u.external[fnode->btree.n_used_nodes - 1].disk_secno) + __32LE2CPU(fnode->u.external[fnode->btree.n_used_nodes - 1].length))) {
			fnode->u.external[fnode->btree.n_used_nodes - 1].length = __32CPU2LE(__32LE2CPU(fnode->u.external[fnode->btree.n_used_nodes - 1].length) + nalloc);
			VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
			current_blocks += nalloc;
			if (__unlikely((new_blocks -= nalloc) != 0)) goto again_x;
			VFS$PUT_BUFFER(fnode);
			return 0;
		}
		if (__likely(fnode->btree.n_free_nodes)) {
			fnode->u.external[fnode->btree.n_used_nodes].file_secno = __32CPU2LE(current_blocks);
			fnode->u.external[fnode->btree.n_used_nodes].length = __32CPU2LE(nalloc);
			fnode->u.external[fnode->btree.n_used_nodes].disk_secno = __32CPU2LE(alloc);
			fnode->btree.n_free_nodes--;
			fnode->btree.n_used_nodes++;
			fnode->btree.first_free = __16CPU2LE(__16LE2CPU(fnode->btree.first_free) + sizeof(struct bplus_leaf_node));
			VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
			current_blocks += nalloc;
			if (__likely(!(new_blocks -= nalloc))) {
				VFS$PUT_BUFFER(fnode);
				return 0;
			}
			goto again_x;
		}
		memcpy(scratch_fnode, fnode, 512);
		VFS$PUT_BUFFER(fnode);
		if (__unlikely(__IS_ERR(anode = HPFS_ALLOC_ANODE(f, &ano)))) return __PTR_ERR(anode);
		anode->up = __32CPU2LE(f->fnode);
		anode->btree.flags1 = BP_1_FNODE_PARENT;
		anode->btree.n_free_nodes = 40 - 9;
		anode->btree.n_used_nodes = 9;
		anode->btree.first_free = __16CPU2LE(sizeof(struct bplus_header) + 9 * sizeof(struct bplus_leaf_node));
		memcpy(anode->u.external, scratch_fnode->u.external, 8 * sizeof(struct bplus_leaf_node));
		anode->u.external[8].file_secno = __32CPU2LE(current_blocks);
		anode->u.external[8].length = __32CPU2LE(nalloc);
		anode->u.external[8].disk_secno = __32CPU2LE(alloc);
		VFS$PUT_BUFFER(anode);
		if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, &b)))) {
			HPFS_FREE(fs, alloc, nalloc);
			HPFS_FREE(fs, ano, 1);
			return __PTR_ERR(fnode);
		}
		memset(fnode->u.external, 0, sizeof fnode->u.external);
		fnode->btree.flags1 |= BP_1_INTERNAL;
		fnode->btree.n_free_nodes = 11;
		fnode->btree.n_used_nodes = 1;
		fnode->btree.first_free = __16CPU2LE(sizeof(struct bplus_header) + sizeof(struct bplus_internal_node));
		fnode->u.internal[0].file_secno = __32CPU2LE(-1);
		fnode->u.internal[0].down = __32CPU2LE(ano);
		VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		VFS$PUT_BUFFER(fnode);
		current_blocks += nalloc;
		if (__likely(!(new_blocks -= nalloc))) {
			return 0;
		}
		goto again;
	}
	again_fn_in:
	ano = __32LE2CPU(fnode->u.internal[fnode->btree.n_used_nodes - 1].down);
	VFS$PUT_BUFFER(fnode);
	c[1] = 0;
	subt:
	if (__unlikely(HPFS_STOP_CYCLES(ano, &c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (EXTEND - DOWN)", ano, f->fnode);
		HPFS_ERROR(fs);
		return -EFSERROR;
	}
	if (__unlikely(__IS_ERR(anode = HPFS_MAP_ANODE(fs, ano, &b))))
		return __PTR_ERR(anode);
	if (__unlikely(anode->btree.flags1 & BP_1_INTERNAL)) {
		ano = __32LE2CPU(anode->u.internal[anode->btree.n_used_nodes - 1].down);
		VFS$PUT_BUFFER(anode);
		goto subt;
	}
	add_to_anode:
	VFS$PUT_BUFFER(anode);
	nalloc = new_blocks;
	if (__unlikely(!(alloc = HPFS_ALLOC(fs, __32LE2CPU(anode->u.external[anode->btree.n_used_nodes - 1].disk_secno) + __32LE2CPU(anode->u.external[anode->btree.n_used_nodes - 1].length), &nalloc)))) {
		return -ENOSPC;
	}
	if (__unlikely(__IS_ERR(anode = HPFS_MAP_ANODE(fs, ano, &b)))) {
		HPFS_FREE(fs, alloc, nalloc);
		return __PTR_ERR(anode);
	}
	if (__unlikely(anode->btree.flags1 & BP_1_INTERNAL)) {
		VFS$PUT_BUFFER(anode);
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "ANODE BTREE INTERNAL FLAG CHANGED UNDER ALLOCATION");
		HPFS_ERROR(fs);
		HPFS_FREE(fs, alloc, nalloc);
		return -EFSERROR;
	}
	if (__likely(alloc == __32LE2CPU(anode->u.external[anode->btree.n_used_nodes - 1].disk_secno) + __32LE2CPU(anode->u.external[anode->btree.n_used_nodes - 1].length))) {
		anode->u.external[anode->btree.n_used_nodes - 1].length = __32CPU2LE(__32LE2CPU(anode->u.external[anode->btree.n_used_nodes - 1].length) + nalloc);
		VFS$MARK_BUFFER_DIRTY(b, ano & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		current_blocks += nalloc;
		if (__unlikely((new_blocks -= nalloc) != 0)) goto add_to_anode;
		VFS$PUT_BUFFER(anode);
		return 0;
	}
	if (__likely(anode->btree.n_free_nodes)) {
		anode->u.external[anode->btree.n_used_nodes].file_secno = __32CPU2LE(current_blocks);
		anode->u.external[anode->btree.n_used_nodes].length = __32CPU2LE(nalloc);
		anode->u.external[anode->btree.n_used_nodes].disk_secno = __32CPU2LE(alloc);
		anode->btree.n_free_nodes--;
		anode->btree.n_used_nodes++;
		anode->btree.first_free = __16CPU2LE(__16LE2CPU(anode->btree.first_free) + sizeof(struct bplus_leaf_node));
		VFS$MARK_BUFFER_DIRTY(b, ano & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		current_blocks += nalloc;
		if (__likely(!(new_blocks -= nalloc))) {
			VFS$PUT_BUFFER(anode);
			return 0;
		}
		goto add_to_anode;
	}
	if (__likely(anode->btree.flags1 & BP_1_FNODE_PARENT)) ano = 0;
	else ano = __32LE2CPU(anode->up);
	VFS$PUT_BUFFER(anode);
	if (__unlikely(__IS_ERR(anode = HPFS_ALLOC_ANODE(f, &n_ano)))) {
		HPFS_FREE(fs, alloc, nalloc);
		return __PTR_ERR(anode);
	}
	anode->up = __32CPU2LE(ano ? ano : f->fnode);
	anode->btree.flags1 = !ano ? BP_1_FNODE_PARENT : 0;
	anode->btree.n_free_nodes = 40 - 1;
	anode->btree.n_used_nodes = 1;
	anode->btree.first_free = __16CPU2LE(sizeof(struct bplus_header) + sizeof(struct bplus_leaf_node));
	anode->u.external[0].file_secno = __32CPU2LE(current_blocks);
	anode->u.external[0].length = __32CPU2LE(nalloc);
	anode->u.external[0].disk_secno = __32CPU2LE(alloc);
	VFS$PUT_BUFFER(anode);
	c[1] = 0;
	up_1:
	if (__unlikely(HPFS_STOP_CYCLES(ano, &c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (EXTEND - UP)", ano, f->fnode);
		HPFS_ERROR(fs);
		HPFS_FREE(fs, alloc, nalloc);
		HPFS_FREE(fs, n_ano, 1);
		return -EFSERROR;
	}
	if (__likely(!ano)) {
		if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, &b)))) {
			HPFS_FREE(fs, alloc, nalloc);
			HPFS_FREE(fs, n_ano, 1);
			return __PTR_ERR(fnode);
		}
		if (__unlikely(!(fnode->btree.flags1 & BP_1_INTERNAL))) {
			VFS$PUT_BUFFER(fnode);
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FNODE BTREE INTERNAL FLAG CHANGED UNDER TREE WALKING");
			HPFS_ERROR(fs);
			HPFS_FREE(fs, alloc, nalloc);
			HPFS_FREE(fs, n_ano, 1);
			return -EFSERROR;
		}
		if (__likely(fnode->btree.n_free_nodes)) {
			fnode->u.internal[fnode->btree.n_used_nodes - 1].file_secno = __32CPU2LE(current_blocks);
			fnode->u.internal[fnode->btree.n_used_nodes].file_secno = __32CPU2LE(-1);
			fnode->u.internal[fnode->btree.n_used_nodes].down = __32CPU2LE(n_ano);
			fnode->btree.n_free_nodes--;
			fnode->btree.n_used_nodes++;
			fnode->btree.first_free = __16CPU2LE(__16LE2CPU(fnode->btree.first_free) + sizeof(struct bplus_internal_node));
			VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
			ok_fnode_l:
			current_blocks += nalloc;
			if (!(new_blocks -= nalloc)) {
				VFS$PUT_BUFFER(fnode);
				return 0;
			}
			goto again_fn_in;
		}
		memcpy(scratch_fnode, fnode, 512);
		VFS$PUT_BUFFER(fnode);
		if (__unlikely(__IS_ERR(anode = HPFS_ALLOC_ANODE(f, &ano)))) {
			HPFS_FREE(fs, alloc, nalloc);
			HPFS_FREE(fs, n_ano, 1);
			return __PTR_ERR(anode);
		}
		anode->up = __32CPU2LE(f->fnode);
		anode->btree.flags1 = BP_1_FNODE_PARENT | BP_1_INTERNAL;
		anode->btree.n_free_nodes = 60 - 13;
		anode->btree.n_used_nodes = 13;
		anode->btree.first_free = __16CPU2LE(sizeof(struct bplus_header) + 13 * sizeof(struct bplus_internal_node));
		memcpy(anode->u.internal, scratch_fnode->u.internal, 12 * sizeof(struct bplus_internal_node));
		anode->u.internal[11].file_secno = __32CPU2LE(current_blocks);
		anode->u.internal[12].file_secno = __32CPU2LE(-1);
		anode->u.internal[12].down = __32CPU2LE(n_ano);
		VFS$PUT_BUFFER(anode);
		memcpy(scratch_anode, anode, 512);
		FIX_ANODE_UP_POINTERS(fs, scratch_anode);
		if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, &b)))) {
			HPFS_FREE(fs, alloc, nalloc);
			HPFS_FREE(fs, n_ano, 1);
			HPFS_FREE(fs, ano, 1);
			return __PTR_ERR(fnode);
		}
		if (__unlikely(!(fnode->btree.flags1 & BP_1_INTERNAL))) {
			VFS$PUT_BUFFER(fnode);
			KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "FNODE BTREE INTERNAL FLAG CHANGED UNDER ANODE ALLOCATION");
			HPFS_ERROR(fs);
			HPFS_FREE(fs, alloc, nalloc);
			HPFS_FREE(fs, n_ano, 1);
			HPFS_FREE(fs, ano, 1);
			return -EFSERROR;
		}
		memset(fnode->u.external, 0, sizeof fnode->u.external);
		fnode->btree.flags1 |= BP_1_INTERNAL;
		fnode->u.internal[0].file_secno = __32CPU2LE(-1);
		fnode->u.internal[0].down = __32CPU2LE(ano);
		fnode->btree.n_free_nodes = 12 - 1;
		fnode->btree.n_used_nodes = 1;
		fnode->btree.first_free = __16CPU2LE(sizeof(struct bplus_header) + sizeof(struct bplus_internal_node));
		VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		goto ok_fnode_l;
	}
	if (__unlikely(__IS_ERR(anode = HPFS_MAP_ANODE(fs, ano, &b)))) {
		HPFS_FREE(fs, alloc, nalloc);
		HPFS_FREE(fs, n_ano, 1);
		return __PTR_ERR(anode);
	}
	if (__unlikely(!(anode->btree.flags1 & BP_1_INTERNAL))) {
		VFS$PUT_BUFFER(anode);
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "ANODE BTREE INTERNAL FLAG CHANGED UNDER TREE WALKING");
		HPFS_ERROR(fs);
		HPFS_FREE(fs, alloc, nalloc);
		HPFS_FREE(fs, n_ano, 1);
		return -EFSERROR;
	}
	if (__likely(anode->btree.n_free_nodes)) {
		anode->u.internal[anode->btree.n_used_nodes - 1].file_secno = __32CPU2LE(current_blocks);
		anode->u.internal[anode->btree.n_used_nodes].file_secno = __32CPU2LE(-1);
		anode->u.internal[anode->btree.n_used_nodes].down = __32CPU2LE(n_ano);
		anode->btree.n_free_nodes--;
		anode->btree.n_used_nodes++;
		anode->btree.first_free = __16CPU2LE(__16LE2CPU(anode->btree.first_free) + sizeof(struct bplus_internal_node));
		VFS$MARK_BUFFER_DIRTY(b, ano & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		VFS$PUT_BUFFER(anode);
		current_blocks += nalloc;
		if (!(new_blocks -= nalloc)) return 0;
		goto again;
	}
	if (__likely(anode->btree.flags1 & BP_1_FNODE_PARENT)) ano = 0;
	else ano = __32LE2CPU(anode->up);
	VFS$PUT_BUFFER(anode);
	if (__unlikely(__IS_ERR(anode = HPFS_ALLOC_ANODE(f, &xano)))) {
		HPFS_FREE(fs, alloc, nalloc);
		HPFS_FREE(fs, n_ano, 1);
		return __PTR_ERR(anode);
	}
	anode->up = __32CPU2LE(ano ? ano : f->fnode);
	anode->btree.flags1 = (!ano ? BP_1_FNODE_PARENT : 0) | BP_1_INTERNAL;
	anode->btree.n_free_nodes = 60 - 1;
	anode->btree.n_used_nodes = 1;
	anode->btree.first_free = __16CPU2LE(sizeof(struct bplus_header) + sizeof(struct bplus_internal_node));
	anode->u.internal[0].file_secno = __32CPU2LE(-1);
	anode->u.internal[0].down = __32CPU2LE(n_ano);
	anode->btree.flags1 = BP_1_FNODE_PARENT | BP_1_INTERNAL;
	VFS$PUT_BUFFER(anode);
	if (__unlikely(!(anode = HPFS_MAP_ANODE(fs, n_ano, &b)))) {
		HPFS_FREE(fs, xano, 1);
		return __PTR_ERR(anode);
	}
	anode->up = __32CPU2LE(xano);
	VFS$MARK_BUFFER_DIRTY(b, n_ano & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
	VFS$PUT_BUFFER(anode);
	n_ano = xano;
	goto up_1;
#undef scratch_fnode
#undef scratch_anode
#undef fs
}

static void TRUNCATE_EXT_BTREE(struct bplus_header *bp, unsigned blocks)
{
	unsigned f_s, l;
	int i = 0;
	while (__likely(i < bp->n_used_nodes) && __unlikely(__32LE2CPU(f_s = bp->u.external[i].file_secno) < blocks)) {
		if (__unlikely(f_s + (l = __32LE2CPU(bp->u.external[i].length)) > blocks)) {
			bp->u.external[i++].length = __32CPU2LE(blocks - f_s);
			break;
		}
		i++;
	}
	memset(&bp->u.external[i], 0, (bp->n_used_nodes - i) * sizeof(struct bplus_leaf_node));
	bp->n_free_nodes += bp->n_used_nodes - i;
	bp->n_used_nodes = i;
	bp->first_free = __16CPU2LE((unsigned long)&((struct bplus_header *)NULL)->u.external[i]);
}

static void TRUNCATE_EXT_BTREE_CONTENTS(HPFSFS *fs, struct bplus_header *bp, unsigned blocks)
{
	unsigned f_s, l;
	int i;
	for (i = 0; i < bp->n_used_nodes; i++) {
		if (__unlikely((f_s = __32LE2CPU(bp->u.external[i].file_secno)) + (l = __32LE2CPU(bp->u.external[i].length)) <= blocks)) continue;
		if (__likely(blocks <= f_s)) {
			HPFS_FREE(fs, __32LE2CPU(bp->u.external[i].disk_secno), l);
		} else {
			HPFS_FREE(fs, __32LE2CPU(bp->u.external[i].disk_secno) + (blocks - f_s), l - (blocks - f_s));
		}
	}
}

static void TRUNCATE_INT_BTREE(struct bplus_header *bp, unsigned blocks, int *down, int *zap)
{
	unsigned tn;
	int i;
	if (__likely(!blocks)) {
		tn = bp->n_free_nodes + bp->n_used_nodes;
		memset((char *)bp + sizeof(struct bplus_header), 0, __16LE2CPU(bp->first_free) - sizeof(struct bplus_header));
		bp->flags1 &= ~BP_1_INTERNAL;
		bp->n_free_nodes = tn * sizeof(struct bplus_internal_node) / sizeof(struct bplus_leaf_node);
		bp->n_used_nodes = 0;
		bp->first_free = __16LE2CPU(sizeof(struct bplus_header));
		*down = -1;
		*zap = 0;
		return;
	}
	i = 0;
	while (__likely(i < bp->n_used_nodes) && __unlikely(__32LE2CPU(bp->u.internal[i].file_secno) < blocks)) i++;
	if (__unlikely(i == bp->n_used_nodes)) {
		*down = -1;
		*zap = i;
		return;
	}
	bp->u.internal[i].file_secno = __32CPU2LE(-1);
	tn = bp->n_free_nodes + bp->n_used_nodes;
	bp->n_free_nodes = tn - (bp->n_used_nodes = i + 1);
	bp->first_free = __16CPU2LE((unsigned long)&((struct bplus_header *)NULL)->u.internal[i + 1]);
	memset(&bp->u.internal[i + 1], 0, (bp->n_used_nodes - (i + 1)) * sizeof(struct bplus_internal_node));
	if (__unlikely(__32LE2CPU(bp->u.internal[i].file_secno) == blocks)) *down = -1;
	else *down = i;
	*zap = i + 1;
}

void HPFS_ZAP_ANODE(HPFSFS *fs, unsigned ano)
{
	int i;
	struct anode *anode;
	int level = 0;
	unsigned u_ano;
	unsigned c[2], d[2];
	union {
		char space[512];
		struct anode anode;
	} scratch;
#define scratch_anode	(&scratch.anode)
	c[1] = 0;
	d[1] = 0;
	down:
	if (__unlikely(HPFS_STOP_CYCLES(ano, &c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X (ZAP ANODE - DOWN)", ano);
		HPFS_ERROR(fs);
		return;
	}
	if (__unlikely(__IS_ERR(anode = HPFS_MAP_ANODE(fs, ano, (void *)&KERNEL$LIST_END))))
		return;
	if (__unlikely(anode->btree.flags1 & BP_1_INTERNAL)) {
		ano = __32LE2CPU(anode->u.internal[0].down);
		VFS$PUT_BUFFER(anode);
		level++;
		goto down;
	}
	memcpy(scratch_anode, anode, 512);
	u_ano = __32CPU2LE(anode->up);
	VFS$PUT_BUFFER(anode);
	TRUNCATE_EXT_BTREE_CONTENTS(fs, &scratch_anode->btree, 0);
	go_up:
	if (__unlikely(HPFS_STOP_CYCLES(ano, &d))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X (ZAP ANODE - UP)", ano);
		HPFS_ERROR(fs);
		return;
	}
	HPFS_FREE(fs, ano, 1);
	if (!level) return;
	if (__unlikely(__IS_ERR(anode = HPFS_MAP_ANODE(fs, u_ano, (void *)&KERNEL$LIST_END))))
		return;
	if (__unlikely(!(anode->btree.flags1 & BP_1_INTERNAL))) {
		VFS$PUT_BUFFER(anode);
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "PARENT ANODE IS NOT INTERNAL");
		HPFS_ERROR(fs);
		return;
	}
	for (i = 0; i < anode->btree.n_used_nodes; i++) {
		if (__32LE2CPU(anode->u.internal[i].down) == ano) {
			if (__unlikely(i == anode->btree.n_used_nodes - 1)) {
				ano = u_ano;
				level--;
				u_ano = __32CPU2LE(anode->up);
				VFS$PUT_BUFFER(anode);
				goto go_up;
			}
			ano = __32LE2CPU(anode->u.internal[i + 1].down);
			VFS$PUT_BUFFER(anode);
			goto down;
		}
	}
	VFS$PUT_BUFFER(anode);
	KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, fs->filesystem_name, "POINTER TO ANODE %08X NOT FOUND IN PARENT ANODE %08X", ano, u_ano);
	HPFS_ERROR(fs);
#undef scratch_anode
}

int HPFS_TRUNCATE_FILE(HPFSFNODE *f, unsigned blocks)
{
	BUFFER *b;
	struct fnode *fnode;
	struct anode *anode;
	unsigned ano;
	int down, zap, i;
	unsigned c[2];
	union {
		char space[512];
		struct fnode fnode;
		struct anode anode;
	} scratch;
#define scratch_fnode	(&scratch.fnode)
#define scratch_anode	(&scratch.anode)
	f->run_length = 0;
	if (__unlikely(__IS_ERR(fnode = HPFS_MAP_FNODE(f, &b)))) return __PTR_ERR(fnode);
	memcpy(scratch_fnode, fnode, 512);
	if (__likely(!(fnode->btree.flags1 & BP_1_INTERNAL))) {
		TRUNCATE_EXT_BTREE(&fnode->btree, blocks);
		VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		VFS$PUT_BUFFER(fnode);
		TRUNCATE_EXT_BTREE_CONTENTS((HPFSFS *)f->fs, &scratch_fnode->btree, blocks);
		return 0;
	}
	TRUNCATE_INT_BTREE(&fnode->btree, blocks, &down, &zap);
	VFS$MARK_BUFFER_DIRTY(b, f->fnode & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
	VFS$PUT_BUFFER(fnode);
	for (i = zap; i < scratch_fnode->btree.n_used_nodes; i++)
		HPFS_ZAP_ANODE((HPFSFS *)f->fs, __32LE2CPU(scratch_fnode->u.internal[i].down));
	c[1] = 0;
	if (down == -1) return 0;
	ano = __32LE2CPU(scratch_fnode->u.internal[down].down);
	down_tree:
	if (__unlikely(HPFS_STOP_CYCLES(ano, &c))) {
		KERNEL$SYSLOG(__SYSLOG_DATA_ERROR, f->fs->filesystem_name, "CYCLE DETECTED ON BLOCK %08X IN FNODE %08X (TRUNCATE %08X)", ano, f->fnode, blocks);
		HPFS_ERROR((HPFSFS *)f->fs);
		return -EFSERROR;
	}
	if (__unlikely(__IS_ERR(anode = HPFS_MAP_ANODE((HPFSFS *)f->fs, ano, &b)))) return __PTR_ERR(anode);
	memcpy(scratch_anode, anode, 512);
	if (__likely(!(anode->btree.flags1 & BP_1_INTERNAL))) {
		TRUNCATE_EXT_BTREE(&anode->btree, blocks);
		VFS$MARK_BUFFER_DIRTY(b, ano & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
		VFS$PUT_BUFFER(anode);
		TRUNCATE_EXT_BTREE_CONTENTS((HPFSFS *)f->fs, &scratch_anode->btree, blocks);
		return 0;
	}
	TRUNCATE_INT_BTREE(&anode->btree, blocks, &down, &zap);
	VFS$MARK_BUFFER_DIRTY(b, ano & __SECTORS_PER_PAGE_CLUSTER_MINUS_1, 1);
	VFS$PUT_BUFFER(anode);
	for (i = zap; i < scratch_anode->btree.n_used_nodes; i++)
		HPFS_ZAP_ANODE((HPFSFS *)f->fs, __32LE2CPU(scratch_anode->u.internal[i].down));
	if (down == -1) return 0;
	ano = __32LE2CPU(scratch_anode->u.internal[down].down);
	goto down_tree;
#undef scratch_fnode
#undef scratch_anode
}

