#include "HPFS.H"

void HPFS_DISCARD_PREALLOC_(HPFSFS *fs)
{
	/*__debug_printf("discard prealloc: %u, %u\n", fs->prealloc_fnode_length, fs->prealloc_data_length);*/
	HPFS_FREE(fs, fs->prealloc_fnode_sector, fs->prealloc_fnode_length);
	HPFS_FREE(fs, fs->prealloc_data_sector, fs->prealloc_data_length);
	fs->prealloc_fnode_length = 0;
	fs->prealloc_data_length = 0;
}

void HPFS_DO_PREALLOC_(HPFSFNODE *f)
{
#define fs ((HPFSFS *)f->fs)
	unsigned fnode_length;
	unsigned total_length = (fnode_length = fs->prealloc_fnode_length) + fs->prealloc_data_length;
	/*__debug_printf("do prealloc: %d\n", length);*/
	fs->prealloc_fnode_length = 0;
	fs->prealloc_data_length = 0;
	fs->prealloc_fnode_sector = HPFS_ALLOC(fs, ((HPFSFNODE *)f->parent)->fnode, &total_length);
	if (__likely(fs->prealloc_fnode_sector)) {
		if (total_length <= fnode_length) {
			fs->prealloc_fnode_length = total_length;
		} else {
			fs->prealloc_fnode_length = fnode_length;
			fs->prealloc_data_sector = fs->prealloc_fnode_sector + fnode_length;
			fs->prealloc_data_length = total_length - fnode_length;
		}
		fs->flags |= FS_COMMIT_FREES_DATA;
	}
#undef fs
}

int HPFS_TEST_CONTIG_ALLOC(FNODE *f_)
{
#define f ((HPFSFNODE *)f_)
#define fs ((HPFSFS *)f->fs)
	unsigned blocks = ((unsigned)f->size + 511) >> 9;
	if (__unlikely(blocks >= OTHEZONE_THRESHOLD_BLOCKS)) return 0;
	if (__unlikely(fs->prealloc_fnode_length + fs->prealloc_data_length + 1 + blocks > 0x3ffc)) return -1;
	fs->prealloc_fnode_length++;
	fs->prealloc_data_length += blocks;
	return 1;
#undef fs
#undef f
}
