#ifdef sio
#define DIO DIRECT_SIO
#define DIO_DONE DIRECT_SIO_DONE
#else
#define DIO DIRECT_AIO
#define DIO_DONE DIRECT_AIO_DONE
#endif
static AST_STUB DIO_DONE;

#ifdef sio
#define WFN KERNEL$WAKE_READ
DECL_IOCALL(VFS_FILE_READ, SPL_FS, SIORQ)
#else
#define WFN KERNEL$WAKE_AREAD
DECL_IOCALL(VFS_FILE_AREAD, SPL_FS, AIORQ)
#endif
{
	_u_off_t pos;
	unsigned ppos;
	HANDLE *h;
	FNODE *f;
#ifdef sio
	FFILE *file;
	vspace_unmap_t *funmap;
#endif
	PAGE *p;
	PAGEINRQ *pgin;
	FS *fs;
	WQ *wq;
	VBUF vbuf;
	char *v;
	unsigned long s;
	/*__debug_printf(" read ");*/
	retry:
	h = RQ->handle;
	if (__unlikely(h->op != &VFS_FILE_OPERATIONS)) goto x;
	RQ->tmp1 = (unsigned long)WFN;
	TEST_LOCKUP_ENTRY(RQ, RETURN);
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_FS));
	if (__unlikely(!HAS_CAPABILITY(h, CAP_READ))) {
		RQ->status = -EACCES;
		RETURN_AST(RQ);
	}
	/*__debug_printf(" dn ");*/
	f = h->fnode;
	CHECK_FNODE_HANDLE(f, h);
#ifdef sio
	file = KERNEL$MAP_FILE_STRUCT(h, (IORQ *)RQ, &funmap);
	if (__unlikely(!file)) RETURN;
#endif
	/*__debug_printf("FILE: u:%p, k:%p -> %d\n", h->file, file, file->flags);*/

	if (__unlikely(!RQ->v.len)) goto eof;

	if (__unlikely(HAS_CAPABILITY(h, CAP_DIRECT))) {
#ifdef sio
		pos = file->pos;
#else
		pos = RQ->pos;
#endif
		/* copy of this condition on other 2 places. keep them same */
		/*__debug_printf("dio read: %Lx, %Lx, %lx\n", pos, RQ->v.ptr, RQ->v.len);*/
		if (__likely(DIRECT_IO_CAPABLE(pos, (SIORQ *)RQ, f))) {
			if (f->flags & FNODE_HASH && (p = FIND_PAGE(pos, f, RQ->handle->name_addrspace))) {
				goto do_pageio;
			}
			do_dio:
#ifdef sio
			funmap(file);
			DIO(RQ, f, 0, pos);
#else
			DIO(RQ, f, 0);
#endif
			RETURN;
		}
	}

	if (__likely(f->flags & FNODE_SPAGE)) {
		if (__unlikely(f->u.s.s.flags & PAGE_BUSY)) {
			WQ_WAIT_F(&f->u.s.s.wait, RQ);
			unmap_return:
#ifdef sio
			funmap(file);
#endif
			RETURN;
		}
		RAISE_SPL(SPL_CACHE);
		KERNEL$CACHE_TOUCH_VM_ENTITY(&f->e, RQ->handle->name_addrspace);
		LOWER_SPL(SPL_FS);
		spage_again:
#ifdef sio
		pos = file->pos;
#else
		pos = RQ->pos;
#endif
		if (__unlikely(pos >= (unsigned long)f->size)) goto eof;
		ppos = pos;
		s = RQ->v.len;
		if (ppos + s > (unsigned long)f->size) s = (unsigned long)f->size - ppos;
		v = KERNEL$MAP_PHYSICAL_PAGE(f->u.s.s.page);
		vbuf.ptr = v + f->u.s.s.offset + ppos;
		vbuf.len = s;
		vbuf.spl = SPL_X(SPL_FS);
		RAISE_SPL(SPL_VSPACE);
		s = RQ->v.vspace->op->vspace_put(&RQ->v, &vbuf);
		KERNEL$UNMAP_PHYSICAL_BANK(v);
		if (__unlikely(!s)) goto pf;
		RQ->progress += s;
#ifdef sio
		file->pos += s;
#else
		RQ->pos += s;
#endif
		if (__unlikely(RQ->v.len != 0)) goto spage_again;
		goto eof;
	}
	if (__unlikely(!(f->flags & (FNODE_SPAGE | FNODE_HASH | FNODE_WANTFREE | FNODE_WRITELOCK))) && __likely(!f->dio_writers)) {
		if (__unlikely(!FNODE_MAPPING_ELIGIBLE_FOR_SPAGE(f))) goto no_spage;

		next_buffer:
#ifdef sio
		pos = file->pos;
#else
		pos = RQ->pos;
#endif
		if (__unlikely(pos >= (unsigned long)f->size)) goto eof;
		ppos = pos;
		if (__likely(ppos >> BIO_SECTOR_SIZE_BITS < f->run_length)) {
			BUFFER *buf;
			__d_off blk = f->disk_blk + (ppos >> BIO_SECTOR_SIZE_BITS);
			unsigned boff = (unsigned)blk & __SECTORS_PER_PAGE_CLUSTER_MINUS_1;
			__u8 *data = VFS$GET_BUFFER(f->fs, blk, GET_BUFFER_FILEDATA | 1, &buf, RQ->handle->name_addrspace);
			if (!data) goto no_buffer_take;
			VFS$PREFETCH_BUFFER(f->fs, blk + __SECTORS_PER_PAGE_CLUSTER, READ_BUFFER_FILEDATA, RQ->handle->name_addrspace);
			VFS$PREFETCH_BUFFER(f->fs, blk + 2 * __SECTORS_PER_PAGE_CLUSTER, READ_BUFFER_FILEDATA, RQ->handle->name_addrspace);
			vbuf.ptr = data + (ppos & (BIO_SECTOR_SIZE - 1));
			s = BIO_SECTOR_SIZE - (ppos & (BIO_SECTOR_SIZE - 1));
			while (1) {
				if (__unlikely(ppos + s > (unsigned long)f->size)) {
					s = (unsigned long)f->size - ppos;
					if (__unlikely(s >= RQ->v.len)) s = RQ->v.len;
					break;
				}
				if (__unlikely(s >= RQ->v.len)) {
					s = RQ->v.len;
					break;
				}
				if (__unlikely(++boff >= __SECTORS_PER_PAGE_CLUSTER)) break;
				if (buf->flags & B_PARTIAL && __unlikely(!BUFFER_VALIDMAP_TEST(buf, boff))) break;
				s += BIO_SECTOR_SIZE;
			}
			vbuf.len = s;
			vbuf.spl = SPL_X(SPL_FS);
			RAISE_SPL(SPL_VSPACE);
			s = RQ->v.vspace->op->vspace_put(&RQ->v, &vbuf);
			VFS$PUT_BUFFER(vbuf.ptr);
			if (__unlikely(!s)) goto pf;
			/*__debug_printf("%s: got %ld\n", f->name, s);*/
			RQ->progress += s;
#ifdef sio
			file->pos = (unsigned long)file->pos + s;
#else
			RQ->pos = (unsigned long)RQ->pos + s;
#endif
			if (__unlikely(RQ->v.len != 0)) goto next_buffer;
			/*__debug_printf("%s: got total\n", f->name);*/
			goto eof;
		}
		no_buffer_take:
		if (__likely(FNODE_SIZE_ELIGIBLE_FOR_SPAGE(f))) {
#ifdef sio
			funmap(file);
#endif
			if (__unlikely(VFS_ALLOC_SPAGE(f))) {
				goto wait;
			}
			GET_PAGEINRQ(pgin, f->fs, RQ->handle->name_addrspace, 0, 0, l1, {
				WQ_WAIT_F(wq, RQ);
				LOWER_SPL(SPL_FS);
				VFS_FREE_SPAGE(f);
				RETURN;
			});
			pgin->caller = (IORQ *)RQ;
#if __DEBUG >= 1
			pgin->page = NULL;
#endif
			pgin->fnode = f;
			RAISE_SPL(SPL_VSPACE);
			f->flags |= FNODE_SPAGE;
			LOWER_SPL(SPL_FS);
			VFS_READ_FNODE_SPAGE(pgin, 1);
			RETURN;
		}
	}
	no_spage:

#ifdef sio
	SET_HASH(RQ->handle->name_addrspace, {
		funmap(file);
		goto wait;
	}, {
		WQ_WAIT_F(xwq, RQ);
		goto unmap_return;
	});
#else
	SET_HASH(RQ->handle->name_addrspace, {
		goto wait;
	}, {
		WQ_WAIT_F(xwq, RQ);
		goto unmap_return;
	});
#endif

	next_page:
	/*__debug_printf(" next_page ");*/
#ifdef sio
	pos = file->pos;
#else
	pos = RQ->pos;
#endif
	/*__debug_printf("%s: %Lx, %Lx\n", f->name, pos, f->size);*/
	if (__unlikely(pos >= f->size)) goto eof;
	p = FIND_PAGE(pos, f, RQ->handle->name_addrspace);
	/*__debug_printf(" find ");*/
	if (__unlikely(!p)) goto create_page;
	if (__unlikely(p->prefetch_hint) && (__likely(!HAS_CAPABILITY(RQ->handle, CAP_DIRECT)))) {
		unsigned ph = p->prefetch_hint;
		p->prefetch_hint = 0;
		VFS$PREFETCH_FILE(p->id + ph, RQ->v.len + RQ->progress, f, RQ->handle->name_addrspace);
	}
	do_pageio:
	ppos = (unsigned)pos & __PAGE_CLUSTER_SIZE_MINUS_1;
	/*__debug_printf(" found ");*/
	if (__unlikely(ppos < p->valid_from) || __unlikely(ppos >= p->valid_to)) {
#ifdef sio
		funmap(file);
#endif
	/*__debug_printf(" read_more ");*/
		goto read_page;
	}
	{
		s = RQ->v.len;
		if (pos + (unsigned long)s > f->size) s = (unsigned)f->size - (unsigned)pos;
		if (__unlikely(ppos + s > p->valid_to)) s = p->valid_to - ppos;
		v = KERNEL$MAP_PHYSICAL_PAGE(p);
		vbuf.ptr = v + ppos;
		vbuf.len = s;
		vbuf.spl = SPL_X(SPL_FS);
		RAISE_SPL(SPL_VSPACE);
		/*__debug_printf(" put ");*/
		/*if (RQ->v.vspace != &KERNEL$PHYSICAL && RQ->v.vspace != &KERNEL$VIRTUAL) if (!(random() & 0x3f)) { KERNEL$UNMAP_PHYSICAL_BANK(v); goto pf; }*/
		s = RQ->v.vspace->op->vspace_put(&RQ->v, &vbuf);
		KERNEL$UNMAP_PHYSICAL_BANK(v);
		if (__unlikely(!s)) goto pf;
		/*__debug_printf(" put_done ");*/
		RQ->progress += s;
#ifdef sio
		file->pos += s;
#else
		RQ->pos += s;
#endif
	}
	SWITCH_PROC_ACCOUNT(RQ->handle->name_addrspace, SPL_X(SPL_FS));
	TEST_LOCKUP_LOOP(RQ, goto unmap_return;);
	if (RQ->v.len) goto next_page;
		/*__debug_printf(" eof ");*/
	eof:
	/* do not allow anybody with read-only access to flush cache */
	if (__unlikely(HAS_CAPABILITY(RQ->handle, CAP_DIRECT | CAP_WRITE))) {
		/* do not flush file when extending it, because it would cause
		   excessive fragmentation */
		/*if (f->disk_size == f->size) VFS$WRITE_AND_FREE_FNODE_PAGES(f);
		else VFS$FREE_CLEAN_PAGES(f);*/
		VFS$WRITE_AND_FREE_FNODE_PAGES(f);
	}
#ifdef sio
	funmap(file);
#endif
#if __DEBUG >= 1
	if (__unlikely(RQ->status == RQS_CHAINCANCELABLE)) 
		KERNEL$SUICIDE("VFS_FILE_READ: %s: CHAIN CANCELABLE STATE NOT REMOVED", VFS$FNODE_DESCRIPTION(f));
#endif
	if (__likely(RQ->progress >= 0)) RQ->status = RQ->progress;
	else RQ->status = -EOVERFLOW;
	RETURN_AST(RQ);

	pf:
#ifdef sio
	funmap(file);
#endif
	DO_PAGEIN(RQ, &RQ->v, PF_WRITE);

	create_page:
	if (__unlikely(HAS_CAPABILITY(RQ->handle, CAP_DIRECT)) && __likely(DIRECT_IO_CAPABLE(pos, (SIORQ *)RQ, f))) goto do_dio;
#ifdef sio
	funmap(file);
#endif
	if (__unlikely(f->flags & FNODE_WANTFREE)) {
		WQ_WAIT_F(&f->wait, RQ);
		RETURN;
	}
	if (__unlikely((wq = KERNEL$MAY_ALLOC(RQ->handle->name_addrspace, __PAGE_CLUSTER_SIZE)) != NULL)) goto wait_limit;
	p = PAGEZONE_ALLOC(&f->fs->z, KERNEL$ALLOC_IO_PAGE, 0);
	if (__unlikely(!p)) goto wait;
	INIT_PAGE(p, 0xa6);
	SETUP_FNODE_PAGE(f, p, pos, RQ->handle->name_addrspace);
	ppos = (unsigned)pos & __PAGE_CLUSTER_SIZE_MINUS_1;
	if (0) {
		read_page:
		if (__unlikely((p->flags & (PAGE_BUSY | PAGE_WANTFREE)) != 0)) {
			WQ_WAIT_F(&p->wait, RQ);
			RETURN;
		}
		if (__unlikely(HAS_CAPABILITY(RQ->handle, CAP_DIRECT)) && __likely(DIRECT_IO_CAPABLE(pos, (SIORQ *)RQ, f))) goto do_dio;
	}
	GET_PAGEINRQ(pgin, f->fs, RQ->handle->name_addrspace, 0, 0, l2, {
		WQ_WAIT_F(wq, RQ);
		LOWER_SPL(SPL_FS);
		RETURN;
	});
	pgin->caller = (IORQ *)RQ;
	pgin->page = p;
	pgin->fnode = f;
	pgin->vdesc.len = ((ppos & f->fs->pageio_mask) + RQ->v.len + BIO_SECTOR_SIZE - 1) >> BIO_SECTOR_SIZE_BITS;
	if (__unlikely(HAS_CAPABILITY(RQ->handle, CAP_DIRECT)) ||
	    (pos >= __PAGE_CLUSTER_SIZE && __unlikely(!FIND_PAGE(pos - __PAGE_CLUSTER_SIZE, f, RQ->handle->name_addrspace)))
	) {
		pgin->vdesc.len = -pgin->vdesc.len;
	}
	VFS_READ_FNODE_PAGE(pgin, ppos);
	RETURN;

	wait:
	/*__debug_printf(" wait ");*/
	fs = f->fs;
	if (__likely(VFS$FREE_SOME_DATA(fs))) goto retry;
	/*__debug_printf(" real_wait ");*/
	WQ_WAIT_F(&fs->freemem, RQ);
	RETURN;

	wait_limit:
	WQ_WAIT_F(wq, RQ);
	RETURN;

	x:
	RETURN_IORQ_LSTAT(RQ, WFN);
}

#undef WFN

#ifdef sio
#define WFN KERNEL$WAKE_WRITE
DECL_IOCALL(VFS_FILE_WRITE, SPL_FS, SIORQ)
#else
#define WFN KERNEL$WAKE_AWRITE
DECL_IOCALL(VFS_FILE_AWRITE, SPL_FS, AIORQ)
#endif
{
	_u_off_t pos;
	unsigned wfrom, wto;
	unsigned roff;
	unsigned sector_mask;
	HANDLE *h;
	FFILE *file;
	int fflags;
	vspace_unmap_t *funmap;
	FNODE *f;
	PAGE *p;
	WQ *wq;
	PAGEINRQ *pgin;
	long prefetch;
	FS *fs;
	VBUF vbuf;
	char *v;
	unsigned long s;
	retry:
	h = RQ->handle;
	if (__unlikely(h->op != &VFS_FILE_OPERATIONS)) goto x;
	RQ->tmp1 = (unsigned long)WFN;
	TEST_LOCKUP_ENTRY(RQ, RETURN);
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_FS));
	if (__unlikely(!HAS_CAPABILITY(h, CAP_APPEND))) {
		RQ->status = -EACCES;
		RETURN_AST(RQ);
	}
	f = h->fnode;
	CHECK_FNODE_HANDLE(f, h);
	if (__unlikely(f->fs->flags & FS_RO)) goto ro;
	if (__unlikely(f->flags & (FNODE_WANTFREE | FNODE_WRITEPAGES))) goto wait_on_fnode;
	file = KERNEL$MAP_FILE_STRUCT(h, (IORQ *)RQ, &funmap);
	if (__unlikely(!file)) RETURN;
	fflags = file->flags;

	if (__unlikely(!RQ->v.len)) goto ret_succ;

	if ((__unlikely(HAS_CAPABILITY(h, CAP_DIRECT | CAP_WRITE))) && __likely(!(fflags & O_APPEND))) {
#ifdef sio
		pos = file->pos;
#else
		pos = RQ->pos;
#endif
		/*__debug_printf("dio write: %Lx, %Lx, %lx\n", pos, RQ->v.ptr, RQ->v.len);*/
		if (__likely(DIRECT_IO_CAPABLE(pos, (SIORQ *)RQ, f))) {
			if (__unlikely(f->flags & FNODE_DIRTY)) {
				wq = VFS$MAY_DIRTY(RQ->handle->name_addrspace, f->fs);
				if (__unlikely(wq != NULL)) goto account;
			}
			funmap(file);
#ifdef sio
			DIO(RQ, f, 1, pos);
#else
			DIO(RQ, f, 1);
#endif
			RETURN;
		}
	}
	if (__unlikely(f->dio_writers)) {
		funmap(file);
		goto wait_on_fnode;
	}

	SET_HASH(RQ->handle->name_addrspace, {
		funmap(file);
		goto wait;
	}, {
		WQ_WAIT_F(xwq, RQ);
		goto unmap_return;
	});

	sector_mask = f->fs->pageio_mask;

	next_page:
	if (fflags & O_APPEND) {
		pos = f->size;
		goto append;
	} else
#ifdef sio
		pos = file->pos;
#else
		pos = RQ->pos;
#endif
	if (__likely(pos == f->size)) {
		append:
		extend_done:
		if (__unlikely(pos >= f->fs->max_filesize)) goto xfsz;
		/*if (!((unsigned)pos & __PAGE_CLUSTER_SIZE_MINUS_1)) goto create_page; clean pages after file end are allowed */
		p = FIND_PAGE(pos, f, RQ->handle->name_addrspace);
		if (__unlikely(!p)) goto create_page;
		if (__unlikely((p->flags & (PAGE_BUSY | PAGE_WANTFREE)) != 0)) goto wait_on_page;
		created_page_app:
		wfrom = (unsigned)pos & __PAGE_CLUSTER_SIZE_MINUS_1;
		if (__unlikely(p->valid_to < wfrom)) goto normal;
		if (RQ->v.len >= __PAGE_CLUSTER_SIZE) goto wps;
		else {
			wto = wfrom + RQ->v.len;
			if (wto > __PAGE_CLUSTER_SIZE) wps: wto = __PAGE_CLUSTER_SIZE;
		}
		goto tests_done;
	}
	if (__unlikely(!HAS_CAPABILITY(RQ->handle, CAP_WRITE))) goto eacces;
	if (__unlikely(pos >= f->fs->max_filesize)) goto xfsz;
	if (__unlikely(pos > f->size)) goto extend;
	p = FIND_PAGE(pos, f, RQ->handle->name_addrspace);
	if (__unlikely(!p)) goto create_page;
	if (__unlikely((p->flags & (PAGE_BUSY | PAGE_WANTFREE)) != 0)) goto wait_on_page;
	created_page_in:
	wfrom = (unsigned)pos & __PAGE_CLUSTER_SIZE_MINUS_1;
	normal:
	if (RQ->v.len >= __PAGE_CLUSTER_SIZE) goto wps2;
	else {
		wto = wfrom + RQ->v.len;
		if (wto > __PAGE_CLUSTER_SIZE) wps2: wto = __PAGE_CLUSTER_SIZE;
	}
	/*__debug_printf("wfrom=%d, wto=%d, vf=%d, vt=%d\n", wfrom, wto, p->valid_from, p->valid_to);*/

	if (wfrom < p->valid_from && __unlikely(wfrom & sector_mask)) {
		roff = wfrom;
		prefetch = 0;
		goto do_read;
	}
	if (wto > p->valid_to && __unlikely(wto & sector_mask)) {
		if (__unlikely((p->id | (unsigned)wto) < f->size)) {
			roff = p->valid_to;
			prefetch = (wto - p->valid_to + BIO_SECTOR_SIZE - 1) >> BIO_SECTOR_SIZE_BITS;
			goto do_read;
		}
	}
	if (p->valid_to) {
		if (__unlikely(wto < p->valid_from)) {
			roff = wto;
			prefetch = 0;
			goto do_read;
		}
		if (__unlikely(wfrom > p->valid_to)) {
			roff = p->valid_to;
			prefetch = (wfrom - p->valid_to + BIO_SECTOR_SIZE - 1) >> BIO_SECTOR_SIZE_BITS;
			goto do_read;
		}
	}
	tests_done:

	if (!(p->flags & PAGE_WRITEABLE)) {
		wq = VFS$MAY_DIRTY(RQ->handle->name_addrspace, f->fs);
		if (__unlikely(wq != NULL)) goto account;
		wq = f->fs->fsops->account(f, ACCOUNT_PAGE, p);
		if (__unlikely(wq != NULL)) goto account;
	}
	time(&f->mtime);
	VFS$SET_DIRTY(f);
	v = KERNEL$MAP_PHYSICAL_PAGE(p);
	vbuf.ptr = v + wfrom;
	vbuf.len = wto - wfrom;
	vbuf.spl = SPL_X(SPL_FS);
	RAISE_SPL(SPL_VSPACE);
	s = RQ->v.vspace->op->vspace_get(&RQ->v, &vbuf);
	KERNEL$UNMAP_PHYSICAL_BANK(v);
	if (__unlikely(s != vbuf.len)) {
		if (!s) {
			if (!(p->flags & PAGE_WRITEABLE)) f->fs->fsops->unaccount(f, ACCOUNT_PAGE, p);
			goto pf;
		}
			/* !!! TODO: unaligned write to existing file
			   will load pages without a reason --- maybe
			   retry vspace_get now */
		wto = wfrom + s;
		if (__likely(wto > p->valid_to) && __unlikely(pos + s < f->size)) {
			unsigned long d = wto & sector_mask;
			if (__unlikely(d > s)) d = s;
			s -= d;
			RQ->v.ptr -= d;
			RQ->v.len += d;
			wto -= d;
			if (!s) {
				roff = wfrom;
				dr2:
				prefetch = __SECTORS_PER_PAGE_CLUSTER - (roff >> BIO_SECTOR_SIZE_BITS);
				if (!(p->flags & PAGE_WRITEABLE)) f->fs->fsops->unaccount(f, ACCOUNT_PAGE, p);
				goto do_read;
			}
		}
		if (__likely(p->valid_to) && __unlikely(wto < p->valid_from)) {
			RQ->v.ptr -= s;
			RQ->v.len += s;
			roff = wto;
			goto dr2;
		}
	}
	RAISE_SPL(SPL_VSPACE);
	if (!(p->flags & PAGE_WRITEABLE)) {
		p->flags |= PAGE_WRITEABLE;
		DEL_FROM_LIST(&p->node_entry);
		ADD_TO_LIST_END(&f->u.h.dirty, &p->node_entry);
	}
	if (p->valid_from > wfrom) p->valid_from = wfrom;
	if (p->dirty_from > wfrom) p->dirty_from = wfrom;
	if (__likely(p->valid_to < wto)) p->valid_to = wto;
	if (__likely(p->dirty_to < wto)) p->dirty_to = wto;
	CHECK_PAGE(p, 0);
	LOWER_SPL(SPL_FS);
	RQ->progress += s;
	if (fflags & O_APPEND) {
		/*__debug_printf("fs1:  %p(%s)  %Lx - >%Lx (%d-%d,%d-%d)\n", f, f->name, f->size, f->size + s, p->valid_from, p->valid_to, p->dirty_from, p->dirty_to);*/
		f->size += (unsigned long)s;
#ifdef sio
		file->pos = f->size;
#else
		RQ->pos = f->size;
#endif
	} else {
		pos += (unsigned long)s;
#ifdef sio
		file->pos = pos;
#else
		RQ->pos = pos;
#endif
		if (__likely(pos > f->size)) {
		/*__debug_printf("fs2: %p(%s)  %Lx -> %Lx (%d-%d,%d-%d)\n", f, f->name, f->size, pos, p->valid_from, p->valid_to, p->dirty_from, p->dirty_to);*/
			f->size = pos;
			EXTEND_HASH(pos, RQ->handle->name_addrspace);
		}
	}

	SWITCH_PROC_ACCOUNT(RQ->handle->name_addrspace, SPL_X(SPL_FS));
	TEST_LOCKUP_LOOP(RQ, goto unmap_return;);
	if (RQ->v.len) goto next_page;

	ret_succ:
	if (__unlikely(HAS_CAPABILITY(RQ->handle, CAP_DIRECT))) {
		/* Do not flush file when extending it, because it would cause
		   excessive fragmentation.
		   On kernel-initiated IOs flush always because non-flushing
		   degrades swapper performance.
		*/
		if (__likely(f->disk_size == f->size) || __likely(RQ->handle->name_addrspace == &KERNEL$PROC_KERNEL)) VFS$WRITE_AND_FREE_FNODE_PAGES(f);
		else VFS$FREE_CLEAN_PAGES(f);
	}
	funmap(file);
#if __DEBUG >= 1
	if (__unlikely(RQ->status == RQS_CHAINCANCELABLE)) 
		KERNEL$SUICIDE("VFS_FILE_WRITE: %s: CHAIN CANCELABLE STATE NOT REMOVED", VFS$FNODE_DESCRIPTION(f));
#endif
	if (__likely(RQ->progress >= 0)) RQ->status = RQ->progress;
	else RQ->status = -EOVERFLOW;
	RETURN_AST(RQ);

	do_read:
	funmap(file);
	GET_PAGEINRQ(pgin, f->fs, RQ->handle->name_addrspace, 0, 0, l, {
		WQ_WAIT_F(wq, RQ);
		LOWER_SPL(SPL_FS);
		RETURN;
	});
	pgin->caller = (IORQ *)RQ;
	pgin->vdesc.len = -prefetch;
	pgin->fnode = f;
	pgin->page = p;
	VFS_READ_FNODE_PAGE(pgin, roff);
	RETURN;

	create_page:
	if (__unlikely((wq = KERNEL$MAY_ALLOC(RQ->handle->name_addrspace, __PAGE_CLUSTER_SIZE)) != NULL)) {
		funmap(file);
		goto wait_limit;
	}
	p = PAGEZONE_ALLOC(&f->fs->z, KERNEL$ALLOC_IO_PAGE, 0);
	if (__unlikely(!p)) {
		funmap(file);
		goto wait;
	}
	INIT_PAGE(p, 0xa7);
	SETUP_FNODE_PAGE(f, p, pos, RQ->handle->name_addrspace);
	if (__likely(pos == f->size)) goto created_page_app;
	goto created_page_in;

	pf:
	funmap(file);
	DO_PAGEIN(RQ, &RQ->v, PF_READ);

	extend:
	wq = VFS_EXTEND_FILE(f, pos, RQ->handle->name_addrspace);
/* VFS_EXTEND_FILE may leave SPL up when returning wq pointer */
	if (__likely(!wq)) goto extend_done;
	if (__likely(wq == (void *)2)) {
		funmap(file);
		goto retry;
	}
	if (__unlikely(wq == (void *)3)) {
		p = FIND_PAGE(f->size, f, RQ->handle->name_addrspace);
		if (__unlikely(!p))
			KERNEL$SUICIDE("VFS_FILE_WRITE: %s: PAGE NOT FOUND, BUT VFS_EXTEND_FILE RETURNED 3", VFS$FNODE_DESCRIPTION(f));
		roff = ((unsigned)f->size & __PAGE_CLUSTER_SIZE_MINUS_1) & ~f->fs->pageio_mask;
		prefetch = __SECTORS_PER_PAGE_CLUSTER;
		goto do_read;
	}

	account:
	/* SPL_FS or SPL_VSPACE may be here. Wait before lowering it */
	if (__IS_ERR(wq)) {
		RQ->status = __PTR_ERR(wq);
		CALL_AST(RQ);
	} else {
		WQ_WAIT_F(wq, RQ);
	}
	unmap_return:
	funmap(file);
	RETURN;

	xfsz:
	funmap(file);
	RQ->status = -EFBIG;
	RETURN_AST(RQ);

	eacces:
	funmap(file);
	RQ->status = -EACCES;
	RETURN_AST(RQ);

	wait_on_page:
	WQ_WAIT_F(&p->wait, RQ);
	goto unmap_return;

	wait:
	/*__debug_printf("fsd.");*/
	fs = f->fs;
	if (__likely(VFS$FREE_SOME_DATA(fs))) goto retry;
	/*__debug_printf("wait.");*/
	WQ_WAIT_F(&fs->freemem, RQ);
	RETURN;

	wait_limit:
	WQ_WAIT_F(wq, RQ);
	RETURN;


	ro:
	RQ->status = -EROFS;
	RETURN_AST(RQ);

	wait_on_fnode:
	WQ_WAIT_F(&f->wait, RQ);
	RETURN;

	x:
	RETURN_IORQ_LSTAT(RQ, WFN);
}

#undef WFN

#ifdef sio
static void DIO(SIORQ *rq, FNODE *f, int wr, _u_off_t pos)
#else
static void DIO(AIORQ *rq, FNODE *f, int wr)
#endif
{
	__d_off ll;
	unsigned long l;
	PAGEINRQ *pgin;
	WQ *wq;
	/* similar code in VFS_FILE_BIO */
	RAISE_SPL(SPL_VSPACE);
	if (__unlikely(f->flags & (FNODE_HASH | FNODE_SPAGE | FNODE_WRITELOCK | FNODE_UNCOMMITTED))) {
		if (__unlikely(f->flags & FNODE_WRITELOCK)) {
			LOWER_SPL(SPL_FS);
			WQ_WAIT_F(&f->wait, rq);
			return;
		}
		if (f->flags & FNODE_SPAGE) {
			if (!(wr & 1)) goto ok;
			goto free_fnode;
		}
		if (__unlikely(f->flags & FNODE_UNCOMMITTED) || __unlikely(!LIST_EMPTY(&f->u.h.dirty))) {
			WQ *wq;
			free_fnode:
			LOWER_SPL(SPL_FS);
			if (__likely((wq = VFS$FREE_FNODE(f)) != NULL)) {
				WQ_WAIT_F(wq, rq);
				LOWER_SPL(SPL_FS);
			} else {
				CALL_IORQ_LSTAT_EXPR(rq, (IO_STUB *)rq->tmp1);
			}
			return;
		}
		if (__likely(!LIST_EMPTY(&f->u.h.clean))) {
			if (__likely(!(wr & 1))) {
				if (__unlikely(f->pending_writes)) {
					LOWER_SPL(SPL_FS);
					WQ_WAIT_F(&f->pending_write_wait, rq);
					return;
				}
				goto ok;
			}
			LOWER_SPL(SPL_FS);
			VFS$WRITE_AND_FREE_FNODE_PAGES(f);
			RAISE_SPL(SPL_VSPACE);
			if (__unlikely(!LIST_EMPTY(&f->u.h.clean)) || __unlikely(!LIST_EMPTY(&f->u.h.dirty))) goto free_fnode;
		}
		f->flags &= ~FNODE_HASH;
		free_hash(f, f->u.h.hash);
		WQ_WAKE_ALL(&f->fs->freemem);
	}
	ok:
	if (__unlikely(f->size != f->disk_size) /* !!! FIXME: set fnode dirty if not valid, it may be EA_UNX prealloc */) goto free_fnode;
	GET_PAGEINRQ(pgin, f->fs, rq->handle->name_addrspace, 0, 1, l, {
		WQ_WAIT_F(wq, rq);
		LOWER_SPL(SPL_FS);
		return;
	});
	pgin->caller = (IORQ *)rq;
	pgin->fnode = f;
	pgin->page = NULL;
	LOWER_SPL(SPL_FS);
#ifdef sio
	pgin->off = pos >> BIO_SECTOR_SIZE_BITS;
#else
	pgin->off = rq->pos >> BIO_SECTOR_SIZE_BITS;
#endif
	f->readers++;
	if (__unlikely(!BMAP_TEST(f, pgin->off))) {
		f->fs->fsops->sync_bmap(f, pgin->off, 1);
		if (__unlikely(!BMAP_TEST(f, pgin->off))) {
			pgin->status = 0;
			f->fs->fsops->bmap(pgin);
			return;
		}
	}
	ll = f->run_length - (pgin->brq.rrq.sec = pgin->off - f->file_blk);
	if (__likely(ll > rq->v.len >> BIO_SECTOR_SIZE_BITS)) l = rq->v.len >> BIO_SECTOR_SIZE_BITS;
	else l = ll;
	if (__unlikely(pgin->off + l > f->size >> BIO_SECTOR_SIZE_BITS))
		l = (f->size >> BIO_SECTOR_SIZE_BITS) - pgin->off;
	if (__unlikely(l > VFS_MAX_PAGE_DIRECT_IO >> BIO_SECTOR_SIZE_BITS))
		l = VFS_MAX_PAGE_DIRECT_IO >> BIO_SECTOR_SIZE_BITS;
	if (__unlikely(wr & 2)) l = 1;
	f->dio_writers += wr &= 1;
	pgin->wr = wr;
	pgin->brq.rrq.fn = DIO_DONE;
	pgin->off = pgin->brq.rrq.sec += f->disk_blk;
	pgin->brq.rrq.nsec = l;
	pgin->brq.write_sec = l;
	pgin->brq.rrq.flags = wr * (BIO_WRITE - BIO_READ) + BIO_READ;
	pgin->brq.rrq.desc = &pgin->brq.rdesc;
	pgin->brq.rrq.proc = pgin->tag.proc;
	pgin->brq.rrq.fault_sec = -1;
	pgin->brq.rdesc.v.vspace = rq->v.vspace;
	pgin->brq.rdesc.v.ptr = rq->v.ptr;
	pgin->brq.rdesc.v.len = pgin->vdesc.len = l << BIO_SECTOR_SIZE_BITS;
	pgin->brq.rdesc.next = NULL;
	CALL_IORQ_CANCELABLE(&pgin->brq.rrq, KERNEL$BIO, pgin->caller);
}

static void DIO_OUT_SUICIDE(PAGEINRQ *pgin);

DECL_AST(DIO_DONE, SPL_FS, BIORQ)
{
#ifdef sio
	SIORQ *rq;
	FFILE *file;
	vspace_unmap_t *funmap;
	_u_off_t fpos;
#else
	AIORQ *rq;
#endif
	PAGEINRQ *pgin = GET_STRUCT(RQ, PAGEINRQ, brq.rrq);
	FNODE *f = pgin->fnode;
	/*__debug_printf("status: %x, fault_sec %Lx\n", pgin->brq.rrq.status, pgin->brq.rrq.fault_sec);*/
	pgin->brq.rdesc.v.vspace = &KERNEL$PHYSICAL;
	if (__unlikely(pgin->wr)) {
#if __DEBUG >= 1
		if (__unlikely(f->dio_writers <= 0))
			KERNEL$SUICIDE("DIRECT_SIO_DONE: %s: DIO_WRITERS UNDERFLOW: %d", VFS$FNODE_DESCRIPTION(f), f->dio_writers);
#endif
		if (__likely(!--f->dio_writers)) WQ_WAKE_ALL(&f->wait);
		VFS$INVALIDATE_FILEBUFFERS(f->fs, pgin->off, (unsigned long)pgin->brq.write_sec);
		time(&f->mtime);
		VFS$SET_DIRTY(f);
	}
	rq = (void *)pgin->caller;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_FS), rq);
	if (__unlikely(pgin->brq.rrq.status < 0)) {
		if (pgin->brq.rrq.status == -EVSPACEFAULT) {
			if (pgin->brq.rrq.fault_sec == -1) pgin->vdesc.len = 0;
			else {
				if (__unlikely((__usec_t)(pgin->brq.rrq.fault_sec - pgin->off)) >= ((unsigned long)pgin->vdesc.len >> BIO_SECTOR_SIZE_BITS)) {
					DIO_OUT_SUICIDE(pgin);
					RETURN;
				}
				pgin->vdesc.len = (pgin->brq.rrq.fault_sec - pgin->off) << BIO_SECTOR_SIZE_BITS;
			}
		} else {
			rq->status = pgin->brq.rrq.status;
			rq = (void *)VFS$FREE_PAGEIN(pgin);
			RETURN_AST(rq);
		}
	}
#ifdef sio
	file = KERNEL$MAP_FILE_STRUCT(rq->handle, (IORQ *)rq, &funmap);
	if (__unlikely(!file)) {
		VFS$FREE_PAGEIN(pgin);
		RETURN;
	}
	fpos = file->pos += pgin->vdesc.len;
	funmap(file);
#else
	rq->pos += pgin->vdesc.len;
#endif
	rq->progress += pgin->vdesc.len;
	rq->v.ptr += pgin->vdesc.len;
	rq->v.len -= pgin->vdesc.len;
	if (__unlikely(rq->v.len != 0)) {
		if (__unlikely(pgin->brq.rrq.status == -EVSPACEFAULT)) {
			int wr = pgin->wr;
			if (!pgin->vdesc.len && (unsigned long)pgin->brq.write_sec > 1 && !(random() & 63) /* try just one sector if we couldn't pagein full range */) {
				FNODE *f = pgin->fnode;
				rq = (void *)VFS$FREE_PAGEIN(pgin);
#ifdef sio
				DIO(rq, f, wr | 2, fpos);
#else
				DIO(rq, f, wr | 2);
#endif
				RETURN;
			}
			rq = (void *)VFS$FREE_PAGEIN(pgin);
			DO_PAGEIN(rq, &rq->v, PF_WRITE + wr * (PF_READ - PF_WRITE));
		}
		rq = (void *)VFS$FREE_PAGEIN(pgin);
		RETURN_IORQ_LSTAT(rq, (IO_STUB *)rq->tmp1);
	}
	rq = (void *)VFS$FREE_PAGEIN(pgin);
	if (__likely(rq->progress >= 0)) rq->status = rq->progress;
	else rq->status = -EOVERFLOW;
	RETURN_AST(rq);
}

#ifndef DIO_OUT_SUICIDE_DEFINED
#define DIO_OUT_SUICIDE_DEFINED
static void DIO_OUT_SUICIDE(PAGEINRQ *pgin)
{
	KERNEL$SUICIDE("DIRECT_IO_DONE: %s: BIO FAULT_SEC OUT OF REQUEST. FAULT_SEC %"__sec_t_format"X, RQ SEC %"__d_off_format"X, RQ LEN %lX", VFS$FNODE_DESCRIPTION(pgin->fnode), pgin->brq.rrq.fault_sec, pgin->off, pgin->vdesc.len >> BIO_SECTOR_SIZE_BITS);
}
#endif

#undef DIO
#undef DIO_DONE
