static void UNL(UNL_TYPE ptr);
static void UNL_SPAGE(UNL_TYPE ptr);

FN
{
	FNODE *f;
	PAGE *p;
	unsigned off;
	unsigned long l;
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_VSPACE)))
		KERNEL$SUICIDE(FN_NAME " AT SPL %08X", KERNEL$SPL);
#endif
	f = desc->vspace->fnode;
	if (__likely(!(rw & PF_WRITE))) {
		if (__unlikely(!HAS_CAPABILITY(desc->vspace, CAP_READ))) RET_ERROR(-EACCES);
	} else {
		if (__unlikely(!HAS_CAPABILITY(desc->vspace, CAP_READ | CAP_WRITE))) RET_ERROR(-EACCES);
		if (__unlikely(f->fs->flags & FS_RO)) RET_ERROR(-EROFS);
	}
	if (__unlikely((f->flags & (FNODE_HASH | FNODE_WANTFREE | FNODE_WRITEPAGES)) != FNODE_HASH)) {
		if (__likely((f->flags & (FNODE_SPAGE | FNODE_WANTFREE | FNODE_WRITEPAGES)) == FNODE_SPAGE)) {
			if (__unlikely(rw & PF_WRITE)) goto ret0;
			if (__unlikely(desc->ptr >= (unsigned long)f->size)) RET_ERROR(-EINVAL);
			l = desc->len;
			if (__unlikely(l > (f->u.s.s.n_pages << PG_SIZE_BITS) - (unsigned long)desc->ptr)) {
#if MAY_RETURN_LESS
				l = (f->u.s.s.n_pages << PG_SIZE_BITS) - (unsigned long)desc->ptr;
#else
				RET_ERROR(-EINVAL);
#endif
			}
			if (__unlikely((f->u.s.s.flags & (PAGE_BUSY | PAGE_WANTFREE)))) goto ret0;
			if (__unlikely((f->u.s.s.flags & PAGE_DMALOCKCOUNT) == PAGE_DMALOCKCOUNT)) goto ret0;
			f->u.s.s.flags += PAGE_DMALOCKCOUNT_1;
			RET_MAP(f->u.s.s.page, f->u.s.s.offset + (unsigned long)desc->ptr, l, rw, UNL_SPAGE);
		}
		ret0:
		RET_ZERO;
	}
	p = FIND_PAGE(desc->ptr, f, NULL);
	if (__unlikely(!p) || __unlikely(p->prefetch_hint)) goto ret0;
	if (__unlikely((p->flags & PAGE_DMALOCKCOUNT) == PAGE_DMALOCKCOUNT)) goto ret0;
	off = (unsigned long)desc->ptr & __PAGE_CLUSTER_SIZE_MINUS_1;
	if (__unlikely(off < p->valid_from) || __unlikely(off >= p->valid_to)) goto ret0;
	l = desc->len;
	if (l > __PAGE_CLUSTER_SIZE - off) {
#if MAY_RETURN_LESS
		l = __PAGE_CLUSTER_SIZE - off;
#else
		RET_ERROR(-EINVAL);
#endif
	}
	if (__unlikely(l > p->valid_to - off)) goto ret0;
	if (__unlikely(p->flags & PAGE_WANTFREE)) goto ret0;
	if (__unlikely(rw & PF_WRITE)) {
		if (__unlikely((p->flags & (PAGE_BUSY | PAGE_WRITEABLE)) != PAGE_WRITEABLE)) goto ret0;
		if (__unlikely(off < p->dirty_from)) p->dirty_from = off;
		if (__unlikely(off + l > p->dirty_to)) p->dirty_to = off + l;
	}
	p->flags += PAGE_DMALOCKCOUNT_1;
	RET_MAP(p, off, l, rw, UNL);
}

static void UNL(UNL_TYPE ptr)
{
	int spl;
	PAGE *p;
	p = DO_UNMAP(ptr);
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_VSPACE);
	if (__unlikely((p->flags & PAGE_DMALOCKCOUNT) == PAGE_DMALOCKCOUNT)) WQ_WAKE_ALL(&p->wait);
	if (__likely(!((p->flags -= PAGE_DMALOCKCOUNT_1) & PAGE_DMALOCKCOUNT))) WQ_WAKE_ALL(&p->wait);
	LOWER_SPLX(spl);
}

static void UNL_SPAGE(UNL_TYPE ptr)
{
	int spl;
	PAGE *p;
	unsigned pos;
	SPAGE *s;
	p = DO_UNMAP(ptr);
	pos = ((unsigned)ptr & __PAGE_CLUSTER_SIZE_MINUS_1) >> PG_SIZE_BITS;
	s = (SPAGE *)((SPAGES *)p->fnode)->s[pos + 1].freelist.next;
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_VSPACE);
	if (__unlikely((s->flags & PAGE_DMALOCKCOUNT) == PAGE_DMALOCKCOUNT)) WQ_WAKE_ALL(&s->wait);
	if (__likely(!((s->flags -= PAGE_DMALOCKCOUNT_1) & PAGE_DMALOCKCOUNT))) WQ_WAKE_ALL(&s->wait);
	LOWER_SPLX(spl);
}

#undef FN
#undef FN_NAME
#undef UNL
#undef UNL_SPAGE
#undef UNL_TYPE
#undef MAY_RETURN_LESS
#undef RET_ZERO
#undef RET_ERROR
#undef RET_MAP
#undef DO_UNMAP
