#ifndef _SPADFS_SFSFNODE_H
#define _SPADFS_SFSFNODE_H

#include <SPAD/VFS.H>

#include "SPADFS.H"

#define VALIDATE_FNODE(fs, fnode_block, fnode, size, ok, skip_free, bad_fnode)\
do {									\
	if (__unlikely((((unsigned long)(fnode) + (size) - 1) & ~(unsigned long)(FNODE_BLOCK_SIZE - 1)) != ((unsigned long)(fnode_block) & ~(unsigned long)(FNODE_BLOCK_SIZE - 1)))) goto bad_fnode;					\
	if ((SPAD2CPU16_LV(&(fnode)->next) & FNODE_NEXT_FREE) && CC_VALID((fs), &(fnode)->cc, &(fnode)->txc)) {						\
		if (__unlikely((size) < FNODE_HEAD_SIZE)) goto bad_fnode;\
		goto skip_free;						\
	}								\
	if (__unlikely((size) <= FNODE_NAME_POS) || __unlikely((unsigned)((size) - FNODE_EA_POS((fnode)->namelen)) > FNODE_MAX_EA_SIZE)) goto bad_fnode;\
	goto ok;							\
} while (0)

#endif
