#ifndef _SPADFS_UTILS_ENDIAN_H
#define _SPADFS_UTILS_ENDIAN_H

extern int endian_big;

#define SPAD2CPU16(x)		(!endian_big ? __16LE2CPU(x) : __16BE2CPU(x))
#define CPU2SPAD16(x)		(!endian_big ? __16CPU2LE(x) : __16CPU2BE(x))
#define SPAD2CPU32(x)		(!endian_big ? __32LE2CPU(x) : __32BE2CPU(x))
#define CPU2SPAD32(x)		(!endian_big ? __32CPU2LE(x) : __32CPU2BE(x))
#define SPAD2CPU64(x)		(!endian_big ? __64LE2CPU(x) : __64BE2CPU(x))
#define CPU2SPAD64(x)		(!endian_big ? __64CPU2LE(x) : __64CPU2BE(x))
#define SPAD2CPU16_LV(x)	(!endian_big ? __16LE2CPU_LV(x) : __16BE2CPU_LV(x))
#define CPU2SPAD16_LV(r, x)	do { if (!endian_big) __16CPU2LE_LV(r, x); else __16CPU2BE_LV(r, x); } while (0)
#define SPAD2CPU32_LV(x)	(!endian_big ? __32LE2CPU_LV(x) : __32BE2CPU_LV(x))
#define CPU2SPAD32_LV(r, x)	do { if (!endian_big) __32CPU2LE_LV(r, x); else __32CPU2BE_LV(r, x); } while (0)
#define SPAD2CPU64_LV(x)	(!endian_big ? __64LE2CPU_LV(x) : __64BE2CPU_LV(x))
#define CPU2SPAD64_LV(r, x)	do { if (!endian_big) __64CPU2LE_LV(r, x); else __64CPU2BE_LV(r, x); } while (0)
#define SPAD2CPU16_CONST(x)	(!endian_big ? __16LE2CPU_CONST(x) : __16BE2CPU_CONST(x))
#define CPU2SPAD16_CONST(x)	(!endian_big ? __16CPU2LE_CONST(x) : __16CPU2BE_CONST(x))
#define SPAD2CPU32_CONST(x)	(!endian_big ? __32LE2CPU_CONST(x) : __32BE2CPU_CONST(x))
#define CPU2SPAD32_CONST(x)	(!endian_big ? __32CPU2LE_CONST(x) : __32CPU2BE_CONST(x))
#define SPAD2CPU64_CONST(x)	(!endian_big ? __64LE2CPU_CONST(x) : __64BE2CPU_CONST(x))
#define CPU2SPAD64_CONST(x)	(!endian_big ? __64CPU2LE_CONST(x) : __64CPU2BE_CONST(x))

#endif
