#ifndef __SPAD_API_H
#define __SPAD_API_H

#ifdef __linux__
#ifdef __STRICT_ANSI__
#undef __STRICT_ANSI__
#endif
#include <asm/types.h>
#else
typedef signed char __s8;
typedef unsigned char __u8;
typedef short __s16;
typedef unsigned short __u16;
typedef int __s32;
typedef unsigned __u32;
typedef long long __s64;
typedef unsigned long long __u64;
#endif

#include <sys/types.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __GNUC__
#define __PRINTF_ATTR__(c, ch) __attribute__ ((__format__ (__printf__, c, ch)))
#define __NORET_ATTR__ __attribute__((__noreturn__))
#if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 1)
#define __finline__	__inline__ __attribute__((__always_inline__))
#else
#define __finline__	__inline__
#endif
#else
#define __PRINTF_ATTR__(c, ch)
#define __NORET_ATTR__
#define __finline__	inline
#endif

#if !defined(__GNUC__) || (__GNUC__ <= 2 && __GNUC_MINOR__ < 96)
#define __likely(x)	((int)(x))
#define __unlikely(x)	((int)(x))
#else
#define __likely(x)	(__builtin_expect((x),1))
#define __unlikely(x)	(__builtin_expect((x),0))
#endif

#define __MAX_STR_LEN	256

#ifndef EBADSYN
#define EBADSYN		EINVAL
#endif
#ifndef EEOF
#define EEOF		ERANGE
#endif

#define _snprintf	snprintf
#define __sync_malloc	malloc
#define _strcasecmp	strcasecmp

#ifndef MAXULONG
#define MAXULONG	((unsigned long)-1)
#endif

#if defined(__linux__) && !defined(__INTEL_COMPILER)
#define __64_format	"L"
#else
#define __64_format	"ll"
#endif

#define __make64(__lo, __hi)	(((__u64)(__hi) << 32) | (__lo))

static __finline__ __u16 __16CPU2LE(__u16 val)
{
	__u16 x;
	((__u8 *)&x)[0] = val;
	((__u8 *)&x)[1] = val >> 8;
	return x;
}

static __finline__ __u16 __16LE2CPU(__u16 val)
{
	return	((__u16)((__u8 *)&val)[0]) |
		((__u16)((__u8 *)&val)[1] << 8);
}

static __finline__ __u32 __32CPU2LE(__u32 val)
{
	__u32 x;
	((__u8 *)&x)[0] = val;
	((__u8 *)&x)[1] = val >> 8;
	((__u8 *)&x)[2] = val >> 16;
	((__u8 *)&x)[3] = val >> 24;
	return x;
}

static __finline__ __u32 __32LE2CPU(__u32 val)
{
	return	((__u32)((__u8 *)&val)[0]) |
		((__u32)((__u8 *)&val)[1] << 8) |
		((__u32)((__u8 *)&val)[2] << 16) |
		((__u32)((__u8 *)&val)[3] << 24);
}

static __finline__ __u64 __64CPU2LE(__u64 val)
{
	__u64 x;
	((__u8 *)&x)[0] = val;
	((__u8 *)&x)[1] = val >> 8;
	((__u8 *)&x)[2] = val >> 16;
	((__u8 *)&x)[3] = val >> 24;
	((__u8 *)&x)[4] = val >> 32;
	((__u8 *)&x)[5] = val >> 40;
	((__u8 *)&x)[6] = val >> 48;
	((__u8 *)&x)[7] = val >> 56;
	return x;
}

static __finline__ __u64 __64LE2CPU(__u64 val)
{
	return	((__u64)((__u8 *)&val)[0]) |
		((__u64)((__u8 *)&val)[1] << 8) |
		((__u64)((__u8 *)&val)[2] << 16) |
		((__u64)((__u8 *)&val)[3] << 24) |
		((__u64)((__u8 *)&val)[4] << 32) |
		((__u64)((__u8 *)&val)[5] << 40) |
		((__u64)((__u8 *)&val)[6] << 48) |
		((__u64)((__u8 *)&val)[7] << 56);
}

static __finline__ __u16 __16CPU2BE(__u16 val)
{
	__u16 x;
	((__u8 *)&x)[0] = val >> 8;
	((__u8 *)&x)[1] = val;
	return x;
}

static __finline__ __u16 __16BE2CPU(__u16 val)
{
	return	((__u16)((__u8 *)&val)[0] << 8) |
		((__u16)((__u8 *)&val)[1]);
}

static __finline__ __u32 __32CPU2BE(__u32 val)
{
	__u32 x;
	((__u8 *)&x)[0] = val >> 24;
	((__u8 *)&x)[1] = val >> 16;
	((__u8 *)&x)[2] = val >> 8;
	((__u8 *)&x)[3] = val;
	return x;
}

static __finline__ __u32 __32BE2CPU(__u32 val)
{
	return	((__u32)((__u8 *)&val)[0] << 24) |
		((__u32)((__u8 *)&val)[1] << 16) |
		((__u32)((__u8 *)&val)[2] << 8) |
		((__u32)((__u8 *)&val)[3]);
}

static __finline__ __u64 __64CPU2BE(__u64 val)
{
	__u64 x;
	((__u8 *)&x)[0] = val >> 56;
	((__u8 *)&x)[1] = val >> 48;
	((__u8 *)&x)[2] = val >> 40;
	((__u8 *)&x)[3] = val >> 32;
	((__u8 *)&x)[4] = val >> 24;
	((__u8 *)&x)[5] = val >> 16;
	((__u8 *)&x)[6] = val >> 8;
	((__u8 *)&x)[7] = val;
	return x;
}

static __finline__ __u64 __64BE2CPU(__u64 val)
{
	return	((__u64)((__u8 *)&val)[0] << 56) |
		((__u64)((__u8 *)&val)[1] << 48) |
		((__u64)((__u8 *)&val)[2] << 40) |
		((__u64)((__u8 *)&val)[3] << 32) |
		((__u64)((__u8 *)&val)[4] << 24) |
		((__u64)((__u8 *)&val)[5] << 16) |
		((__u64)((__u8 *)&val)[6] << 8) |
		((__u64)((__u8 *)&val)[7]);
}

#define __16LE2CPU_CONST(__x)		__16LE2CPU(__x)
#define __16CPU2LE_CONST(__x)		__16CPU2LE(__x)
#define __32LE2CPU_CONST(__x)		__32LE2CPU(__x)
#define __32CPU2LE_CONST(__x)		__32CPU2LE(__x)
#define __64LE2CPU_CONST(__x)		__64LE2CPU(__x)
#define __64CPU2LE_CONST(__x)		__64CPU2LE(__x)

#define __16BE2CPU_CONST(__x)		__16BE2CPU(__x)
#define __16CPU2BE_CONST(__x)		__16CPU2BE(__x)
#define __32BE2CPU_CONST(__x)		__32BE2CPU(__x)
#define __32CPU2BE_CONST(__x)		__32CPU2BE(__x)
#define __64BE2CPU_CONST(__x)		__64BE2CPU(__x)
#define __64CPU2BE_CONST(__x)		__64CPU2BE(__x)

#define __16LE2CPU_LV(__x)		__16LE2CPU(*(__x))
#define __16CPU2LE_LV(__x, __y)		(*(__x) = __16CPU2LE(__y))
#define __32LE2CPU_LV(__x)		__32LE2CPU(*(__x))
#define __32CPU2LE_LV(__x, __y)		(*(__x) = __32CPU2LE(__y))
#define	__64LE2CPU_LV(__x)		__64LE2CPU(*(__x))
#define __64CPU2LE_LV(__x, __y)		(*(__x) = __64CPU2LE(__y))

#define __16BE2CPU_LV(__x)		__16BE2CPU(*(__x))
#define __16CPU2BE_LV(__x, __y)		(*(__x) = __16CPU2BE(__y))
#define __32BE2CPU_LV(__x)		__32BE2CPU(*(__x))
#define __32CPU2BE_LV(__x, __y)		(*(__x) = __32CPU2BE(__y))
#define	__64BE2CPU_LV(__x)		__64BE2CPU(*(__x))
#define __64CPU2BE_LV(__x, __y)		(*(__x) = __64CPU2BE(__y))

static __finline__ int __BT(void *__ptr, int __bit)
{
	return (*((__u32 *)__ptr + (__bit >> 5)) >> (__bit & 31)) & 1;
}

static __finline__ int __BTS(void *__ptr, int __bit)
{
	int __r = __BT(__ptr, __bit);
	*((__u32 *)__ptr + (__bit >> 5)) |= 1 << (__bit & 31);
	return __r;
}

static __finline__ int __BTR(void *__ptr, int __bit)
{
	int __r = __BT(__ptr, __bit);
	*((__u32 *)__ptr + (__bit >> 5)) &= ~(1 << (__bit & 31));
	return __r;
}

static __finline__ int __BSR(unsigned long __x)
{
	int __i;
	for (__i = sizeof(unsigned long) * 8 - 1; __i > 0; __i--) if (__unlikely((__x & (1UL << __i)) != 0)) return __i;
	return 0;
}

static __finline__ int __BSF(unsigned long __x)
{
	int __i;
	for (__i = 0; __i < sizeof(unsigned long) * 8 - 1; __i++) if (__unlikely((__x & (1UL << __i)) != 0)) return __i;
	return sizeof(unsigned long) * 8 - 1;
}

int _memcasecmp(const void *__s1, const void *__s2, size_t __count);
size_t strlcpy(char *__dest, const char *__src, size_t __count);
size_t strlcat(char *__dest, const char *__src, size_t __count);

#define VM_TYPE_WIRED_MAPPED	0
__u64 KERNEL$GET_MEMORY_SIZE(int type);
char *KERNEL$ERROR_MSG(void);
int KERNEL$STDIN(void);
int KERNEL$STDOUT(void);
int KERNEL$STDERR(void);
void __PRINTF_ATTR__(1,2) __NORET_ATTR__ KERNEL$SUICIDE(const char *__fmt, ...);
int __PRINTF_ATTR__(1,2) _printf(const char *__fmt, ...);
int _vprintf(const char *__fmt, va_list __args);
int __PRINTF_ATTR__(1,2) _eprintf(const char *__fmt, ...);
int _veprintf(const char *__fmt, va_list __args);
int __PRINTF_ATTR__(2,3) _fprintf(int __h, const char *__fmt, ...);
int _vfprintf(int __h, const char *__fmt, va_list __args);

static __finline__ void __barrier(void) { __asm__ __volatile__ ("":::"memory"); }
static __finline__ void __PREFETCHT0(void *p) {}
static __finline__ void __PREFETCHT1(void *p) {}
static __finline__ void __PREFETCHT2(void *p) {}
static __finline__ void __PREFETCHNTA(void *p) {}

#ifdef __NOT_FROM_SPAD_TREE
#include "LIST.H"
#else
#include <SPAD/LIST.H>
#endif

#endif
