#!SHELL CALL
REM GENERATES ACCENT TABLES FROM UNICODEDATA*.TXT FILE. FILE NEEDS TO BE
REM IN CURRENT DIRECTORY
FOR I IN "MOD_ACUTE" "MOD_CARON" "MOD_RING_ABOVE" "MOD_DIAERESIS" "MOD_CIRCUMFLEX" "MOD_BREVE" "MOD_OGONEK" "MOD_DOT_ABOVE" "MOD_DOUBLE_ACUTE" "MOD_CEDILLA"
REDIR /OUTOVER=%I.I PRINT "/* Automatically generated by GEN-ACCENTS.CMD */"
REDIR /OUT=%I.I PRINT
LET MOD=RESUBST(RESUBST(I, "^MOD_", ""), "_", " ")
FOR L=1 TO 27
FOR C IN "SMALL" "CAPITAL"

IF L=27 THEN GO TO 70
LET LETTER=CHR$(L+64)
RM -f TMP.LETTERS
GREP ';LATIN %C LETTER %LETTER WITH %MOD;' UNICODEDATA*.TXT /MAP:STDOUT=TMP.LETTERS
REDIR /IN=TMP.LETTERS INPUT HEX
GO TO 80
70
IF C="CAPITAL" THEN GO TO 100
LET LETTER="SPACE"
RM -f TMP.LETTERS
GREP ';%MOD;' UNICODEDATA*.TXT /MAP:STDOUT=TMP.LETTERS
REDIR /IN=TMP.LETTERS INPUT HEX
IF HEX="" THEN GREP ';%MOD ACCENT;' UNICODEDATA*.TXT /MAP:STDOUT=TMP.LETTERS; REDIR /IN=TMP.LETTERS INPUT HEX
IF HEX="" THEN PRINT "ACCENT ",MOD," NOT FOUND"; EXIT 1

80
LET HEX="#"++RESUBST(HEX, ";.*", "")
IF HEX="#" THEN GO TO 100
IF C="SMALL" THEN LET MODSTR=I++", MOD_CTRL | MOD_ALTGR | MOD_CAPS"
IF C="CAPITAL" THEN LET MODSTR=I++" | MOD_CAPS, MOD_CTRL | MOD_ALTGR"
IF HEX<#80 THEN LET UTF8="\"++TO_BASE(HEX, 8); GO TO 90
IF HEX<#800 THEN LET UTF8="\"++TO_BASE(#c0+HEX/64, 8)++"\"++TO_BASE(128+HEX//64, 8); GO TO 90
IF HEX<#10000 THEN LET UTF8="\"++TO_BASE(#e0+HEX/64/64, 8)++"\"++TO_BASE(128+HEX/64//64, 8)++"\"++TO_BASE(128+HEX//64, 8); GO TO 90
IF HEX<#200000 THEN LET UTF8="\"++TO_BASE(#f0+HEX/64/64/64, 8)++"\"++TO_BASE(128+HEX/64/64//64, 8)++"\"++TO_BASE(128+HEX/64//64, 8)++"\"++TO_BASE(128+HEX//64, 8); GO TO 90
IF HEX<#4000000 THEN LET UTF8="\"++TO_BASE(#f8+HEX/64/64/64/64, 8)++"\"++TO_BASE(128+HEX/64/64/64//64, 8)++"\"++TO_BASE(128+HEX/64/64//64, 8)++"\"++TO_BASE(128+HEX/64//64, 8)++"\"++TO_BASE(128+HEX//64, 8); GO TO 90
LET UTF8="\"++TO_BASE(#fc+HEX/64/64/64/64/64, 8)++"\"++TO_BASE(128+HEX/64/64/64/64//64, 8)++"\"++TO_BASE(128+HEX/64/64/64//64, 8)++"\"++TO_BASE(128+HEX/64/64//64, 8)++"\"++TO_BASE(128+HEX/64//64, 8)++"\"++TO_BASE(128+HEX//64, 8); GO TO 90
90
REDIR /OUT=%I.I PRINT MODSTR, ", KEY | KC_", LETTER, ", SEQ_KEYS | SEQ_QUIT_PASS, """, UTF8, """", 0, 0,
100
NEXT C
NEXT L
NEXT I
RM -f TMP.LETTERS
BASH -c "echo '/* Automatically generated by GEN-ACCENTS.CMD */';echo;cat MOD_*.I|grep 'KC_[YZ]'|sed 's/KC_Y/KC_y/'|sed 's/KC_Z/KC_Y/'|sed 's/KC_y/KC_Z/';echo;cat YZSWAP.B" /MAPOVER:STDOUT=YZSWAP.I
