#define SEQ_INIT		0x08
#define SEQ_MODIF		0x10
#define SEQ_LOCK_KEYS		0x18
#define SEQ_META_MODIF		0x20
#define SEQ_KEYS		0x28
#define SEQ_CLEANUP		0x30

#define MOD_SHIFT		0x00000100
#define MOD_CTRL		0x00000200
#define MOD_ALT			0x00000400
#define MOD_CAPS		0x00000800
#define MOD_NUM			0x00001000

#define STRING_INS		"\e[2~"
#define STRING_DEL		"\e[3~"
#define STRING_HOME		"\e[1~"
#define STRING_END		"\e[4~"
#define STRING_PAGE_UP		"\e[5~"
#define STRING_PAGE_DOWN	"\e[6~"
#define STRING_LEFT		"\e[D"
#define STRING_RIGHT		"\e[C"
#define STRING_UP		"\e[A"
#define STRING_DOWN		"\e[B"
#define STRING_NUM_5		"\e[G"
#define STRING_TAB		"\t"
#define STRING_ENTER		"\r"
#define STRING_ESC		"\e"
#define STRING_SPACE		" "

#define GENCONTROLKEY(string)						\
0, 0, KEY | KC_##string, SEQ_KEYS | SEQ_QUIT_PASS, STRING_##string, 0, 0,

#define GENFUNCTIONKEY(key, str, shiftstr)				\
0, MOD_SHIFT, KEY | KC_##key, SEQ_KEYS | SEQ_QUIT_PASS, str, 0, 0,	\
MOD_SHIFT, 0, KEY | KC_##key, SEQ_KEYS | SEQ_QUIT_PASS, shiftstr, 0, 0,

#define GENFUNCTIONKEYNOSHIFT(key, str)					\
0, 0, KEY | KC_##key, SEQ_KEYS | SEQ_QUIT_PASS, str, 0, 0,

#define GENLETTER(capital, small)					\
0, MOD_CAPS | MOD_CTRL, KEY | KC_##capital, SEQ_KEYS | SEQ_QUIT_PASS, #small, 0, 0,\
MOD_CAPS, MOD_CTRL, KEY | KC_##capital, SEQ_KEYS | SEQ_QUIT_PASS, #capital, 0, 0,

#define GENCHAR(key, chr, shiftchr)					\
0, MOD_SHIFT | MOD_CTRL, KEY | KC_##key, SEQ_KEYS | SEQ_QUIT_PASS, chr, 0, 0,\
MOD_SHIFT, MOD_CTRL, KEY | KC_##key, SEQ_KEYS | SEQ_QUIT_PASS, shiftchr, 0, 0,

#define GENNUM(key, num, nonnum)					\
0, MOD_NUM | MOD_CTRL | MOD_ALT_NUM, KEY | KC_##key, SEQ_KEYS | SEQ_QUIT_PASS, nonnum, 0, 0,\
MOD_NUM, MOD_CTRL | MOD_ALT_NUM, KEY | KC_##key, SEQ_KEYS | SEQ_QUIT_PASS, num, 0, 0,


