#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <STRING.H>
#include <STDLIB.H>
#include <FCNTL.H>
#include <UNISTD.H>
#include <ENDIAN.H>
#include <VALUES.H>
#include <SPAD/IOCTL.H>
#include <SPAD/CHARSET.H>
#include <SPAD/TTY.H>

#include "KBDFMT.H"

#define KEYMAP_PREFIX	"ETC.:/KEYBOARD/"
#define KEYMAP_SUFFIX	".KBD"

static char *keymap = NULL;
static int dflt = 0;
static int pri_sec = -1;

static int SET_BLOB(int h, FBLOB *blob)
{
	/* copied from SETFONT.C */
	int r;
	char *str, *d, *a;
	if (__unlikely(h < 0)) return -EBADF;
	str = KERNEL$HANDLE_PATH(h);
	if (__unlikely(!str)) return -errno;
	d = strchr(str, ':');
	if (__unlikely(!d)) KERNEL$SUICIDE("SET_BLOB: INVALID HANDLE %d PATH: %s", h, str);
	a = alloca(d - str + 1);
	*(char *)mempcpy(a, str, d - str) = 0;
	r = KERNEL$SET_LOGICAL(a, 0, 0, NULL, NULL, blob);
	write(h, "", 0);
	return r;
}

static int set_keymap(void)
{
	struct keymap_header kh;
	char std_path;
	int r;
	int h;
	char *str = NULL;
	unsigned new_data_size;
	struct keymap_entry *new_data;
	unsigned data_size = 0;
	struct keymap_entry *data = NULL;
	struct keymap_entry *pd, *po, *pn;
	static char charset[__MAX_STR_LEN];
	iconv_t iconv;
	IOCTLRQ io;
	struct keymap_entry *p;
	struct keymap_blob *blob;
	io.h = KERNEL$STDOUT();
	if (__unlikely(io.h == -1)) io.h = KERNEL$STDERR();
	if (__unlikely(io.h == -1)) io.h = KERNEL$STDIN();
	try_get_charset:
	io.ioctl = IOCTL_TTY_GET_CHARSET;
	io.param = 0;
	io.v.ptr = (unsigned long)&charset;
	io.v.len = sizeof charset;
	io.v.vspace = &KERNEL$VIRTUAL;
	SYNC_IO(&io, KERNEL$IOCTL);
	if (__unlikely(io.status < 0)) {
		if (io.h == KERNEL$STDOUT() && io.h != KERNEL$STDERR()) io.h = KERNEL$STDERR();
		else if (io.h == KERNEL$STDERR() && io.h != KERNEL$STDIN() && KERNEL$STDIN() != KERNEL$STDOUT()) io.h = KERNEL$STDIN();
		else {
			r = -ENXIO;
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: TERMINAL DOESN'T SUPPORT KEYBOARD MAP MODIFICATION");
			goto ret0;
		}
		goto try_get_charset;
	}
	str = __sync_malloc(strlen(keymap) + strlen(KEYMAP_PREFIX) + strlen(KEYMAP_SUFFIX) + 1);
	if (__unlikely(!str)) {
		cant_malloc_ret0:
		r = -errno;
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: CAN'T ALLOC MEMORY: %s", strerror(-r));
		goto ret0;
	}
	if (!strpbrk(keymap, ":/.")) {
		stpcpy(stpcpy(stpcpy(str, KEYMAP_PREFIX), keymap), KEYMAP_SUFFIX);
		std_path = 1;
	} else {
		strcpy(str, keymap);
		std_path = 0;
	}
	h = open(str, O_RDONLY);
	if (__unlikely(h == -1)) {
		r = -errno;
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: CAN'T OPEN KEYBOARD FILE %s: %s", str, strerror(-r));
		goto ret0;
	}
	next_keymap:
	errno = EFTYPE;
	if (__unlikely(pread(h, &kh, sizeof kh, 0) != sizeof kh)) {
		cantread:
		r = -errno;
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: CAN'T READ KEYBOARD FILE HEADER: %s", strerror(-r));
		goto ret1;
	}
	if (__unlikely(memcmp(kh.signature, KEYMAP_SIGNATURE, sizeof kh.signature)) || __unlikely(kh.parent_keymap[sizeof(kh.parent_keymap) - 1])) {
		badf:
		r = -EFTYPE;
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: NOT A KEYBOARD FILE");
		goto ret1;
	}
	new_data_size = __32CPU2LE(kh.n_entries_le) * sizeof(struct keymap_entry);
	if (__unlikely(new_data_size / sizeof(struct keymap_entry) != __32CPU2LE(kh.n_entries_le)) || __unlikely((new_data_size | (data_size + new_data_size)) & __INT_SGN_BIT)) goto badf;
	new_data = __sync_malloc(new_data_size);
	if (__unlikely(!new_data)) {
		r = -errno;
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: CAN'T ALLOC MEMORY: %s", strerror(-r));
		goto ret1;
	}
	errno = EFTYPE;
	if (__unlikely(pread(h, new_data, new_data_size, sizeof kh + kh.reserved_bytes) != new_data_size)) {
		free(new_data);
		goto cantread;
	}
	close(h);
	pn = (struct keymap_entry *)((char *)new_data + new_data_size);
	while (pn > new_data) {
		pn--;
		pn->if_mod_set = __32LE2CPU(pn->if_mod_set);
		pn->if_mod_reset = __32LE2CPU(pn->if_mod_reset);
		pn->if_key = __16LE2CPU(pn->if_key);
		pn->do_mod_set = __32LE2CPU(pn->do_mod_set);
		pn->do_mod_reset = __32LE2CPU(pn->do_mod_reset);
		if (__likely(pn + 1 < (struct keymap_entry *)((char *)new_data + new_data_size))) {
			if (__unlikely((pn[0].seq & SEQ_MASK) > (pn[1].seq & SEQ_MASK))) {
				r = -EFTYPE;
				_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: NON-MONOTONIC SEQUENCE AT OFFSET %d", (int)(pn - new_data));
				free(new_data);
				goto ret0;
			}
		}
	}
	data = __sync_reallocf(data, data_size + new_data_size);
	if (__unlikely(!data)) {
		r = -errno;
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: CAN'T ALLOC MEMORY: %s", strerror(-r));
		free(new_data);
		goto ret0;
	}
	pd = (struct keymap_entry *)((char *)data + data_size + new_data_size);
	pn = (struct keymap_entry *)((char *)new_data + new_data_size);
	po = (struct keymap_entry *)((char *)data + data_size);
	while (pd > data) {
		int seqn = pn > new_data ? pn[-1].seq & SEQ_MASK : -1;
		int seqo = po > data ? po[-1].seq & SEQ_MASK : -1;
		if (__unlikely(seqn == -1) && __unlikely(seqo == -1))
			KERNEL$SUICIDE("set_keymap: I AM VERY LAME AND I CAN'T WORK WITH POINTERS");
		*--pd = seqn >= seqo ? *--pn : *--po;
	}
	free(new_data);
	data_size += new_data_size;
	if (kh.parent_keymap[0]) {
		char *dir = strrchr(str, '/');
		if (!dir) dir = strrchr(str, ':');
		if (dir) dir[1] = 0;
		else *str = 0;
		str = __sync_reallocf(str, strlen(str) + strlen(kh.parent_keymap) + strlen(KEYMAP_SUFFIX) + 1);
		if (__unlikely(!str)) goto cant_malloc_ret0;
		stpcpy(stpcat(str, kh.parent_keymap), KEYMAP_SUFFIX);
		h = open(str, O_RDONLY);
		if (__likely(h != -1)) goto next_keymap;
		r = -errno;
		if (__unlikely(r == -EINTR)) goto ret0;
		str = __sync_reallocf(str, strlen(kh.parent_keymap) + strlen(KEYMAP_PREFIX) + strlen(KEYMAP_SUFFIX) + 1);
		if (__unlikely(!str)) goto cant_malloc_ret0;
		stpcpy(stpcpy(stpcpy(str, KEYMAP_PREFIX), kh.parent_keymap), KEYMAP_SUFFIX);
		h = open(str, O_RDONLY);
		if (__likely(h != -1)) goto next_keymap;
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: CAN'T OPEN KEYBOARD SUBMAP FILE %s: %s", str, strerror(-r));
		goto ret0;
	}

	iconv = CHARSET$ICONV_OPEN(charset, "UTF-8", ICONV_ATTR_DELAYED_LOADING | ICONV_ATTR_PASS_CONTROL);
	if (__unlikely(!iconv)) {
		r = -errno;
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: CAN'T OPEN CHARSET CONVERSION FROM UTF-8 TO %s: %s", charset, strerror(-r));
		goto ret0;
	}
	for (p = data; p < (struct keymap_entry *)((char *)data + data_size); p++) {
		char seq[MAX_KEYMAP_SEQUENCE];
		char *inptr;
		size_t inlen;
		char *outptr;
		size_t outlen;
		if (!memcmp(p->do_sequence, STRING_NOCHANGE, MAX_KEYMAP_SEQUENCE)) continue;
		inptr = p->do_sequence;
		inlen = strnlen(p->do_sequence, MAX_KEYMAP_SEQUENCE);
		outptr = seq;
		outlen = MAX_KEYMAP_SEQUENCE;
		if (__unlikely(CHARSET$ICONV(iconv, &inptr, &inlen, &outptr, &outlen) == (size_t)-1)) {
			r = -errno;
			if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: CAN'T CONVERT STRING FROM UTF-8 TO %s: %s (%02X %02X %02X %02X %02X)", charset, strerror(-r), p->do_sequence[0], p->do_sequence[1], p->do_sequence[2], p->do_sequence[3], p->do_sequence[4]);
			goto ret2;
		}
		memset(p->do_sequence, 0, MAX_KEYMAP_SEQUENCE);
		memcpy(p->do_sequence, seq, outptr - seq);
	}
	CHARSET$ICONV_CLOSE(iconv);
	blob = __sync_calloc(1, sizeof(struct keymap_blob) + data_size);
	if (__unlikely(!blob)) goto cant_malloc_ret0;
	blob->size = sizeof(struct keymap_blob) + data_size;
	blob->type = BLOB_TTY_KEYMAP;
	blob->l_refcount = 1;
	if (std_path) {
		char *cn_end;
		char *cn_base = strrchr(keymap, '/');
		if (!cn_base) cn_base = strrchr(keymap, ':');
		else cn_base++;
		if (!cn_base) cn_base = keymap;
		else cn_base++;
		cn_end = strrchr(cn_base, '.');
		if (!cn_end) cn_end = cn_base + strlen(cn_base);
		if (__likely(cn_end - cn_base < sizeof(blob->keymap))) {
			*(char *)mempcpy(blob->keymap, cn_base, cn_end - cn_base) = 0;
			__upcase(blob->keymap);
		}
	}
	memcpy(blob + 1, data, data_size);
	/*{
		int b = open("blob", O_CREAT | O_WRONLY | O_TRUNC, 0600);
		write(b, blob, blob->size);
		close(b);
	}*/
	r = SET_BLOB(KERNEL$STDIN(), (FBLOB *)blob);
	if (__unlikely(r)) {
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: TERMINAL DOESN'T SUPPORT KEYBOARD MAP MODIFICATION");
		goto ret3;
	}
	SET_BLOB(KERNEL$STDOUT(), (FBLOB *)blob);
	SET_BLOB(KERNEL$STDERR(), (FBLOB *)blob);
	r = 0;
	ret3:
	KERNEL$UNREF_BLOB((FBLOB *)blob);
	goto ret0;
	ret2:
	CHARSET$ICONV_CLOSE(iconv);
	goto ret0;
	ret1:
	close(h);
	ret0:
	free(data);
	free(str);
	return r;
}

static const struct __param_table params[8] = {
	"", __PARAM_STRING, 1, __MAX_STR_LEN,
	"SYSDEFAULT", __PARAM_BOOL, ~0, 1,
	"DEFAULT", __PARAM_BOOL, ~0, 2,
	"PRIMARY", __PARAM_BOOL, ~0, 0,
	"SECONDARY", __PARAM_BOOL, ~0, 1,
	"PRI", __PARAM_BOOL, ~0, 0,
	"SEC", __PARAM_BOOL, ~0, 1,
	NULL, 0, 0, 0,
};

static void *const vars[8] = {
	&keymap,
	&dflt,
	&dflt,
	&pri_sec,
	&pri_sec,
	&pri_sec,
	&pri_sec,
	NULL,
};

int main(int argc, const char * const argv[])
{
	int r;
	const char * const *arg = argv;
	int state = 0;
	if (__unlikely(__parse_params(&arg, &state, params, vars, NULL, NULL, NULL))) {
		badsyn:
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: SYNTAX ERROR");
		r = -EBADSYN;
		goto ret0;
	}
	if (__unlikely(dflt) && __unlikely(keymap != NULL)) goto badsyn;
	if (__unlikely(KERNEL$STDIN() == -1)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: NO CONTROL TERMINAL");
		r = -EINVAL;
		goto ret0;
	}
	if (dflt) {
		FBLOB *blob;
		blob = __sync_calloc(1, sizeof(FBLOB));
		if (__unlikely(!blob)) {
			r = -errno;
			if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: CAN'T ALLOC MEMORY: %s", strerror(-r));
			goto ret0;
		}
		blob->size = dflt == 1 ? 0 : sizeof(FBLOB);
		blob->type = BLOB_TTY_KEYMAP;
		blob->l_refcount = 1;
		SET_BLOB(KERNEL$STDIN(), (FBLOB *)blob);
		SET_BLOB(KERNEL$STDOUT(), (FBLOB *)blob);
		SET_BLOB(KERNEL$STDERR(), (FBLOB *)blob);
		KERNEL$UNREF_BLOB((FBLOB *)blob);
	}
	if (keymap) if (__unlikely(r = set_keymap())) goto ret0;
	if (pri_sec != -1) {
		IOCTLRQ io;
		io.h = KERNEL$STDIN();
		io.ioctl = IOCTL_TTY_SET_KEYBOARD;
		io.param = !pri_sec ? PARAM_SET_KEYBOARD_PRIMARY : PARAM_SET_KEYBOARD_SECONDARY;
		io.v.ptr = 0;
		io.v.len = 0;
		io.v.vspace = &KERNEL$VIRTUAL;
		SYNC_IO_CANCELABLE(&io, KERNEL$IOCTL);
		if (__unlikely(io.status < 0)) {
			r = io.status;
			if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETKBD: TERMINAL DOESN'T SUPPORT KEYBOARD SWITCHING");
			goto ret0;
		}
	}
	r = 0;

	ret0:
	return r;
}
