#include <STRING.H>
#include <UNISTD.H>
#include <SPAD/LIBC.H>
#include <SPAD/DEV_KRNL.H>
#include <SPAD/SYNC.H>
#include <SPAD/TIMER.H>
#include <SPAD/TTY.H>
#include <TIME.H>

#define IGNORE_EVENTS_ERROR	7
#define IGNORE_EVENTS_SWITCH	10
#define N_ERRORS_TIMEOUT	(3 * JIFFIES_PER_SECOND)

static char port1str[__MAX_STR_LEN * 2];
static char port2str[__MAX_STR_LEN * 2];
static char dev_name[__MAX_STR_LEN];

static int h1;
static int h2;
static void *lnte, *dlrq;

static char kbd_dev_name[__MAX_STR_LEN];

kbdmouse_call_t *kbd_mouse_call;

static SIORQ sio;
static int outstanding = 0;

static char data_buffer[64];

static int mouse1_byte = 0;
static unsigned char packet_byte_1, packet_byte_2;

struct mouse_state mouse_state = { 0, 0, 0, 0, 0, 0, 0, 0 };
static int last_buttons = 0;

struct mouse_info mouse_info = { 3, 1, 2 };

static int was_3_button = 0, was_wheel = 0, ignore_wheel = -1;

#define MS		0
#define MOUSE_SYSTEMS	1
#define N_MOUSE_TYPES	2

static char auto_type;
static char mouse_type;

static u_jiffies_lo_t last_error;
static unsigned ignore_events;
static int n_errors = 0;

static int protocol_handle(void)
{
	switch (mouse_type) {
		case MS:
			return h1;
		case MOUSE_SYSTEMS:
			return h2;
		default:
			KERNEL$SUICIDE("protocol_handle: PROTOCOL %d", mouse_type);
	}
}

static int mouse_error(void)
{
	u_jiffies_lo_t tm = KERNEL$GET_JIFFIES_LO();
	if (tm - last_error > TIMEOUT_JIFFIES(N_ERRORS_TIMEOUT) && n_errors > 0) n_errors = 0;
	last_error = tm;
	n_errors++;
	/*__debug_printf("error (%d)\n", n_errors);*/
	if (ignore_events < IGNORE_EVENTS_ERROR) ignore_events = IGNORE_EVENTS_ERROR;
	if (__unlikely(n_errors > 1) && __likely(auto_type)) {
		mouse_type++;
		if (__unlikely(mouse_type == N_MOUSE_TYPES)) mouse_type = 0;
		/*__debug_printf("type: %d\n", mouse_type);*/
		n_errors = -10;
		ignore_events = IGNORE_EVENTS_SWITCH;
		sio.h = protocol_handle();
		mouse1_byte = 0;
		return 1;
	}
	return n_errors < 0;
}

static void send_mouse_state(void)
{
	if (__unlikely(!mouse_state.rx) && __unlikely(!mouse_state.ry) && __likely(!mouse_state.rz) && __likely(!mouse_state.wx) && __likely(!mouse_state.wy) && __likely(!mouse_state.wz) && __likely(mouse_state.buttons == last_buttons)) return;
	mouse_state.x = mouse_info.buttons;
	mouse_state.y = mouse_info.wheels;
	mouse_state.z = mouse_info.axes;
	if (!ignore_events) {
		/*__debug_printf("e (%d,%d  %d)\n", mouse_state.rx, mouse_state.ry, mouse_state.buttons);*/
		kbd_mouse_call(&mouse_state);
		last_buttons = mouse_state.buttons;
	} else {
		/*__debug_printf("x (%d,%d  %d)\n", mouse_state.rx, mouse_state.ry, mouse_state.buttons);*/
		ignore_events--;
	}
	mouse_state.rx = mouse_state.ry = mouse_state.rz = mouse_state.wx = mouse_state.wy = mouse_state.wz = 0;
}

static void clear_mouse_state(void)
{
	mouse_state.rx = mouse_state.ry = mouse_state.rz = mouse_state.wx = mouse_state.wy = mouse_state.wz = 0;
	last_buttons = mouse_state.buttons = 0;
}

static DECL_AST(got_mouse_data1, SPL_HID, SIORQ)
{
	int i;
	outstanding--;
	if (__unlikely(sio.status <= 0)) {
		RETURN;
	}
	/*
	for (i = 0; i < sio.status; i++) {
		__debug_printf("%02x ", (unsigned char)data_buffer[i]);
	}*/
	for (i = 0; i < sio.status; i++) {
		unsigned char c = data_buffer[i];
		int x, y;
		switch (mouse_type) {
			case MS:
			switch (mouse1_byte) {
				case 0:
					if (__unlikely(!(c & 0x40))) {
						if (mouse_error()) goto brk;
						continue;
					}
				byte0:
					packet_byte_1 = c;
					mouse1_byte = 1;
					continue;
				case 1:
					if (__unlikely(c & 0x40)) {
						if (mouse_error()) goto brk;
						mouse1_byte = 0;
						goto byte0;
					}
					packet_byte_2 = c;
					mouse1_byte = 2;
					continue;
				case 2:
					if (__unlikely(c & 0x40)) {
						if (mouse_error()) goto brk;
						mouse1_byte = 0;
						goto byte0;
					}
					if (__unlikely(packet_byte_1 & 0x20)) mouse_state.buttons |= 1;
					else mouse_state.buttons &= ~1;
					if (__unlikely(packet_byte_1 & 0x10)) mouse_state.buttons |= 2;
					else mouse_state.buttons &= ~2;
					x = ((packet_byte_1 & 0x3) << 6) | (packet_byte_2 & 0x3f);
					mouse_state.rx += (__s8)x;
					y = ((packet_byte_1 & 0xc) << 4) | (c & 0x3f);
					mouse_state.ry += (__s8)y;
					if (__unlikely(mouse_state.buttons != last_buttons)) send_mouse_state();
					mouse1_byte = 3;
					continue;
				case 3:
					if (c & 0x40) {
						if (__likely(!was_3_button) && __likely(!was_wheel)) mouse_info.buttons = 2, mouse_info.wheels = 0;
						mouse1_byte = 0;
						mouse_state.buttons &= ~4;
						goto byte0;
					}
					if (__unlikely(c & 0x20) && !was_wheel) {
			/* XFree86, mouse.c, CHRIS-211092 --- some
			   3-button mice send non-zero value in "wheel" field */
						mouse_info.wheels = 0;
						if (__unlikely(ignore_wheel == -1)) ignore_wheel = c & 0x0f;
					}
			/* XFree86, mouse.c --- there are some 4-button serial
			   mice but I don't have any of them. If someone needs
			   it, the option for 4th button may be added */
					if (__unlikely(c & 0x30)) mouse_state.buttons |= 4, was_3_button = 1, mouse_info.buttons = 3;
					else mouse_state.buttons &= ~4;
					if (__unlikely(c & 0xf)) {
						if (__unlikely((c & 0xf) == ignore_wheel)) goto do_ignore_wheel;
						ignore_wheel = 0;
						was_wheel = 1, mouse_info.wheels = 1, mouse_info.buttons = 3;
					}
			/* gpm 1.20.1, mice.c, M_ms3: gpm processes this as two
			   wheels, but I didn't find that in any other software
			   (svgalib and XFree86) --- so I don't know if it is
			   true and if some two-wheel serial mice exist */
					mouse_state.wy += (c & 0x7) - (c & 0x8);
					do_ignore_wheel:
					if (__unlikely(mouse_state.buttons != last_buttons)) send_mouse_state();
					mouse1_byte = 0;
					continue;
			}
			break;
			case MOUSE_SYSTEMS:
			mouse_info.buttons = 3, mouse_info.wheels = 0;
			/*__debug_printf("byte (%d): %02x\n", mouse1_byte, c);*/
			switch (mouse1_byte) {
				case 0:
					if (__unlikely((c & 0xf8) != 0x80)) {
						if (mouse_error()) goto brk;
						continue;
					}
					if (__likely(c & 0x4)) mouse_state.buttons &= ~0x1;
					else mouse_state.buttons |= 0x1;
					if (__likely(c & 0x1)) mouse_state.buttons &= ~0x2;
					else mouse_state.buttons |= 0x2;
					if (__likely(c & 0x2)) mouse_state.buttons &= ~0x4;
					else mouse_state.buttons |= 0x4;
					mouse1_byte = 1;
					continue;
				case 1:
					mouse_state.rx += (__s8)c;
					mouse1_byte = 2;
					continue;
				case 2:
					mouse_state.ry -= (__s8)c;
					if (__unlikely(mouse_state.buttons != last_buttons)) send_mouse_state();
					mouse1_byte = 3;
					continue;
				case 3:
					mouse_state.rx += (__s8)c;
					mouse1_byte = 4;
					continue;
				case 4:
					mouse_state.ry -= (__s8)c;
					mouse1_byte = 0;
					continue;
			}
			break;
		}
	}
	if (0) {
		brk:
		clear_mouse_state();
	} else {
		/*__debug_printf("%d %d %d %d %x\n", mouse_state.rx, mouse_state.ry, mouse_state.wx, mouse_state.wy, mouse_state.buttons);*/
		send_mouse_state();
	}
	sio.fn = got_mouse_data1;
	sio.v.ptr = (unsigned long)data_buffer;
	sio.v.len = sizeof data_buffer;
	sio.v.vspace = &KERNEL$VIRTUAL;
	sio.progress = 0;
	outstanding++;
	RETURN_IORQ(&sio, KERNEL$READ);
}

static int pathpart(char *path, char *part)
{
	int i;
	int pathl = strlen(path);
	int partl = strlen(part);
	for (i = 0; i < pathl - partl; i++) {
		if ((path[i] == ':' || path[i] == '/') && !_memcasecmp(path + i + 1, part, partl)) return 1;
	}
	return 0;
}

static int mouse_unload(void *p, void **release, const char * const argv[]);

int main(int argc, const char * const argv[])
{
	char scratch[__MAX_STR_LEN];
	int r;
	char *p;
	const char * const *arg;
	int state;
	char *protocol = NULL;
	char *port = "SIO$COM1:";
	char *keyboard = DEFAULT_KEYBOARD_NAME ":";
	static const struct __param_table params[4] = {
		"PORT", __PARAM_STRING, 1, __MAX_STR_LEN,
		"KEYBOARD", __PARAM_STRING, 1, __MAX_STR_LEN,
		"PROTOCOL", __PARAM_STRING, 1, __MAX_STR_LEN,
		NULL, 0, 0, 0,
	};
	void *vars[4];
	vars[0] = &port;
	vars[1] = &keyboard;
	vars[2] = &protocol;
	vars[3] = NULL;
	arg = argv;
	state = 0;
	if (__parse_params(&arg, &state, params, vars, NULL, NULL, NULL)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "MOUSE: SYNTAX ERROR");
		r = -EBADSYN;
		goto ret0;
	}
	if (!protocol || !_strcasecmp(protocol, "AUTO")) {
		mouse_type = MS;
		auto_type = 1;
	} else if (!_strcasecmp(protocol, "MICROSOFT")) {
		mouse_type = MS;
		auto_type = 0;
	} else if (!_strcasecmp(protocol, "MOUSE_SYSTEMS")) {
		mouse_type = MOUSE_SYSTEMS;
		auto_type = 0;
	} else {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "MOUSE: UNKNOWN PROTOCOL \"%s\"", protocol);
		r = -EBADSYN;
		goto ret0;
	}
	strcpy(port1str, port);
	if (!pathpart(port, "^BAUD=")) strcat(port1str, "/^BAUD=1200");
	if (!pathpart(port, "^STOP=")) strcat(port1str, "/^STOP=1");
	if (!pathpart(port, "^WORD=")) strcat(port1str, "/^WORD=7");
	if (!pathpart(port, "^PARITY=")) strcat(port1str, "/^PARITY=NONE");
	if (!pathpart(port, "^RTS=")) strcat(port1str, "/^RTS=HI");
	if (!pathpart(port, "^DTR=")) strcat(port1str, "/^DTR=HI");
	if (!pathpart(port, "^CTS=")) strcat(port1str, "/^CTS=IGNORE");
	if (!pathpart(port, "^DSR=")) strcat(port1str, "/^DSR=IGNORE");
	if (!pathpart(port, "^CD=")) strcat(port1str, "/^CD=IGNORE");
	if (!pathpart(port, "^TRIGGER=")) strcat(port1str, "/^TRIGGER=1");
	strcpy(port2str, port);
	if (!pathpart(port, "^BAUD=")) strcat(port2str, "/^BAUD=1200");
	if (!pathpart(port, "^STOP=")) strcat(port2str, "/^STOP=1");
	if (!pathpart(port, "^WORD=")) strcat(port2str, "/^WORD=8");
	if (!pathpart(port, "^PARITY=")) strcat(port2str, "/^PARITY=NONE");
	if (!pathpart(port, "^RTS=")) strcat(port2str, "/^RTS=HI");
	if (!pathpart(port, "^DTR=")) strcat(port2str, "/^DTR=HI");
	if (!pathpart(port, "^CTS=")) strcat(port2str, "/^CTS=IGNORE");
	if (!pathpart(port, "^DSR=")) strcat(port2str, "/^DSR=IGNORE");
	if (!pathpart(port, "^CD=")) strcat(port2str, "/^CD=IGNORE");
	if (!pathpart(port, "^TRIGGER=")) strcat(port2str, "/^TRIGGER=1");
	h1 = open(port1str, O_RDONLY);
	if (h1 == -1) {
		r = -errno;
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "MOUSE: CAN'T OPEN PORT %s: %s", port1str, strerror(errno));
		goto ret0;
	}
	h2 = open(port2str, O_RDONLY);
	if (h2 == -1) {
		r = -errno;
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "MOUSE: CAN'T OPEN PORT %s: %s", port2str, strerror(errno));
		goto ret05;
	}
	strcpy(scratch, port);
	if ((p = strchr(scratch, ':'))) *p = 0;
	if ((p = strchr(scratch, '/'))) *p = 0;
	_snprintf(dev_name, sizeof dev_name, "MOUSE$SERIAL@%s", scratch);

	strcpy(kbd_dev_name, keyboard);
	if ((r = KERNEL$DCALL(kbd_dev_name, "KEYBOARD", KEYBOARD_MOUSE_GET, &kbd_mouse_call))) {
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "MOUSE: CAN'T ATTACH TO KEYBOARD DEVICE %s", kbd_dev_name);
		goto ret1;
	}

	r = KERNEL$REGISTER_DEVICE(dev_name, "MOUSE.SYS", 0, NULL, NULL, NULL, NULL, NULL, mouse_unload, &lnte, KERNEL$HANDLE_PATH(h1), KERNEL$HANDLE_PATH(h2), NULL);
	if (r < 0) {
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "%s: COULD NOT REGISTER DEVICE: %s", dev_name, strerror(-r));
		goto ret2;
	}

	ignore_events = auto_type ? IGNORE_EVENTS_SWITCH : 0;
	last_error = KERNEL$GET_JIFFIES_LO();

	sio.fn = got_mouse_data1;
	sio.h = protocol_handle();
	sio.v.ptr = (unsigned long)data_buffer;
	sio.v.len = sizeof data_buffer;
	sio.v.vspace = &KERNEL$VIRTUAL;
	sio.progress = 0;
	outstanding++;
	CALL_IORQ(&sio, KERNEL$READ);

	dlrq = KERNEL$TSR_IMAGE();
	strcpy(KERNEL$ERROR_MSG(), dev_name);
	return 0;

	ret2:
	KERNEL$DCALL(kbd_dev_name, "KEYBOARD", KEYBOARD_MOUSE_PUT);
	ret1:
	close(h2);
	ret05:
	close(h1);
	ret0:
	return r;
}

static int mouse_unload(void *p, void **release, const char * const argv[])
{
	int r;
	if ((r = KERNEL$DEVICE_UNLOAD(lnte, argv))) return r;
	RAISE_SPL(SPL_HID);
	while (outstanding) KERNEL$CIO((IORQ *)(void *)&sio), KERNEL$SLEEP(1);
	if (__unlikely(mouse_state.buttons)) {
		mouse_state.buttons = 0;
		mouse_state.rx = mouse_state.ry = mouse_state.rz = mouse_state.wx = mouse_state.wy = mouse_state.wz = 0;
		kbd_mouse_call(&mouse_state);
	}
	LOWER_SPL(SPL_ZERO);
	if (__unlikely(r = KERNEL$DCALL(kbd_dev_name, "KEYBOARD", KEYBOARD_MOUSE_PUT))) KERNEL$SUICIDE("mouse_unload: CAN'T UNREGISTER AT KEYBOARD DEVICE %s: %s", kbd_dev_name, strerror(-r));
	close(h1);
	close(h2);
	*release = dlrq;
	return 0;
}
