#ifndef __EAP_ROOTER_H
#define __EAP_ROOTER_H

#include <SPAD/LIST.H>
#include <SYS/TYPES.H>
#include <PTHREAD.H>

#include <OPENSSL/SSL.H>

#include "EAP.H"

#define ERROR_MSG_SIZE		120

#define TLS_FRAGMENT_SIZE	1398	/* when modifying, make sure that overflow does not happen wrt. EAP_MAX_DATA_LENGTH */

/* ROOTER.C */

extern int errorlevel;
extern unsigned priority;

void * __MALLOC_ATTR__ xmalloc(size_t size);
void * __MALLOC_ATTR__ xrealloc(void *p, size_t size);
extern pthread_mutex_t ssl_lock;

struct instance {
	LIST_ENTRY list;
	int h;
	pthread_t pthread;
	__u64 magic;
	__u32 vendor;
	__u32 type;
	void *private;
	__s64 seq;
	struct algorithm *algorithm;
	__u64 offers_seq;
	__u64 *blacklist_config_seqs;
	unsigned n_blacklist_config_seqs;
	EAP_PACKET_REQUEST packet;
	char name[1];
};

/* ROOTSSL.C */

void lock_ssl(void);
void unlock_ssl(void);
void assert_ssl_lock(char *name);
void new_ssl_ctx(SSL_CTX **p);
void new_x509_store(X509_STORE **p);
void print_ssl_errors(void);
void clear_ssl_errors(void);

/* ROOTCFG.C */

struct stringlist {
	LIST_ENTRY list;
	char string[1];
};

struct config {
	LIST_ENTRY list;
	__s64 seq;
	char *user;
	char *password;
	X509_STORE *cert_store;
	char *cncheck;
	char cnexact;
	char hash;
	XLIST_HEAD devices;
	XLIST_HEAD algorithms;
	char *inner_algorithm;
};

extern LIST_HEAD config;

void clear_config(void);
int read_config(char *file);

/* ROOTINST.C */

#define AUTH_SUCCESS		0
#define AUTH_DONT_KNOW		1
#define AUTH_FAILURE		2
#define AUTH_PROTOCOL_VIOLATION	3

void *do_instance(void *inst_);
struct config *get_config(struct instance *inst, int (*is_suitable)(struct instance *inst, struct config *config));
int get_general_packet(struct instance *inst, EAP_PACKET_REQUEST *packet);
int get_packet(struct instance *inst, EAP_PACKET_REQUEST *packet);
int get_final_packet(struct instance *inst, EAP_PACKET_REQUEST *packet);
int send_general_packet(struct instance *inst, EAP_PACKET_REQUEST *packet);
int send_packet(struct instance *inst, EAP_PACKET_REQUEST *packet);
int send_final_packet(struct instance *inst, EAP_PACKET_REQUEST *packet, unsigned code);

/* ROOTTLS.C */

int eap_tls(struct instance *inst);

#endif
