#include <STRING.H>
#include <SPAD/LIBC.H>

#include <SPAD/PKT.H>
#include <SPAD/ETHERNET.H>
#include <ENDIAN.H>

int NET$PARSE_ETHERNET_ADDRESS(const char *str, __u8 address[6])
{
	int i;
	for (i = 0; i < 6; i++) {
		char c1, c2;
		if (__unlikely(!(c1 = str[0])) || __unlikely(!(c2 = str[1]))) return -1;
		if (__unlikely(str[2] != (i == 5 ? 0 : ':'))) return -1;
		if (c1 >= '0' && c1 <= '9') c1 -= '0';
		else if (c1 >= 'A' && c1 <= 'F') c1 -= 'A' - 10;
		else if (__likely(c1 >= 'a') && __likely(c1 <= 'f')) c1 -= 'a' - 10;
		else return -1;
		if (c2 >= '0' && c2 <= '9') c2 -= '0';
		else if (c2 >= 'A' && c2 <= 'F') c2 -= 'A' - 10;
		else if (__likely(c2 >= 'a') && __likely(c2 <= 'f')) c2 -= 'a' - 10;
		else return -1;
		address[i] = (c1 << 4) + c2;
		str += 3;
	}
	return 0;
}

int NET$VALID_ETHERNET_ADDRESS(__u8 address[6])
{
	if (__unlikely(address[0] & 1)) return 0;
	if (__unlikely(!(address[0] | address[1] | address[2] | address[3] | address[4] | address[5]))) return 0;
	return 1;
}

char *NET$PRINT_ETHERNET_ADDRESS(char str[ETHERNET_ADDRESS_STR_LEN], __u8 address[6])
{
	_snprintf(str, ETHERNET_ADDRESS_STR_LEN, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]);
	return str;
}

/* The following functions are from linux lib/crc32 file
   Public domain by linux@horizon.com and Matt Domsch <Matt_Domsch@dell.com>.
   Relicensed under GNU GPL v2.
   The performance is not very high --- it is used to compute multicast hash
   bitmaps.
   */

__u32 NET$ETHERNET_CRC(const __u8 *data, unsigned len)
{
	return NET$BITREVERSE32(NET$ETHERNET_CRC_LE(data, len));
}

__u32 NET$ETHERNET_CRC_LE(const __u8 *data, unsigned len)
{
	return NET$CRC32_LE(0xffffffff, data, len);
}

#define CRCPOLY_LE	0xedb88320

__u32 NET$CRC32_LE(__u32 crc, const __u8 *data, unsigned len)
{
	while (len--) {
		unsigned i;
		crc ^= *data++;
		for (i = 0; i < 8; i++)
			crc = (crc >> 1) ^ ((crc & 1) ? CRCPOLY_LE : 0);
	}
	return crc;
}

__u32 NET$BITREVERSE32(__u32 x)
{
	/*x = (x >> 16) | (x << 16);
	x = (x >> 8 & 0x00ff00ff) | (x << 8 & 0xff00ff00);*/
	x = __32swap(x);
	x = (x >> 4 & 0x0f0f0f0f) | (x << 4 & 0xf0f0f0f0);
	x = (x >> 2 & 0x33333333) | (x << 2 & 0xcccccccc);
	x = (x >> 1 & 0x55555555) | (x << 1 & 0xaaaaaaaa);
	return x;
}
