#include <SPAD/AC.H>
#include <SPAD/SYNC.H>
#include <SPAD/ALLOC.H>
#include <STDLIB.H>

#include <SPAD/PKT.H>

/* !!! FIXME: limit the size of the queue */

struct __pktqueue {
	LIST_HEAD queue;
};

int NETQUE$ALLOC_QUEUE(PKTQUEUE **qq)
{
	PKTQUEUE *q;
	MALLOC_REQUEST mrq;
	mrq.size = sizeof(PKTQUEUE);
	SYNC_IO_CANCELABLE(&mrq, KERNEL$UNIVERSAL_MALLOC);
	if (mrq.status < 0) return mrq.status;
	q = mrq.ptr;
	INIT_LIST(&q->queue);
	*qq = q;
	return 0;
}

void NETQUE$FREE_QUEUE(PKTQUEUE *q)
{
	NETQUE$DISCARD_PACKETS(q, -ENODEV);
	free(q);
}

void NETQUE$DISCARD_PACKETS(PKTQUEUE *q, int err)
{
	PACKET *p;
	while ((p = NETQUE$DEQUEUE(q))) {
		p->status = err;
		CALL_PKT(p);
	}
}

void NETQUE$ENQUEUE_PACKET(PKTQUEUE *q, PACKET *rq)
{
	ADD_TO_LIST_END(&q->queue, PKT_Q_ENTRY(rq));
}

int NETQUE$QUEUE_EMPTY(PKTQUEUE *q)
{
	return LIST_EMPTY(&q->queue);
}

PACKET *NETQUE$DEQUEUE(PKTQUEUE *q)
{
	LIST_ENTRY *h = q->queue.next;
	if (__unlikely(h == (LIST_ENTRY *)(void *)&q->queue)) return NULL;
	DEL_FROM_LIST(h);
	return PKT_Q_RQ(h);
}

void NETQUE$REQUEUE_DEQUEUED_PACKET(PKTQUEUE *q, PACKET *rq)
{
	ADD_TO_LIST(&q->queue, PKT_Q_ENTRY(rq));
}


