#include <SPAD/PKT.H>
#include <SPAD/LIBC.H>
#include <STRING.H>

char *NET$PRINT_STRING(char str[__MAX_STR_LEN], __u8 *string, unsigned len)
{
	unsigned i, j;
	for (i = 0, j = 0; i < __MAX_STR_LEN - 1 && j < len; j++) {
		if (__likely(string[j] >= ' ')) str[i++] = string[j];
		else if (string[j] == '\n') str[i++] = ' ';
	}
	str[i] = 0;
	return str;
}

char *NET$PRINT_HWADDR(char str[__MAX_STR_LEN], __u8 *hwaddr, int hwaddrlen)
{
	char *ostr, *e;
	if (__unlikely(!hwaddrlen)) {
		strlcpy(str, "NONE", __MAX_STR_LEN);
		return str;
	}
	ostr = str;
	e = str + __MAX_STR_LEN;
	*str = 0;
	while (hwaddrlen--) {
		_snprintf(str, e - str, "%02X%s", *hwaddr++, hwaddrlen ? ":" : "");
		str = strchr(str, 0);
	}
	return ostr;
}

char *NET$PRINT_LINK_STATE(char str[__MAX_STR_LEN], LINK_STATE_PHYS *ls)
{
	char *ostr, *e;
	ostr = str;
	e = str + __MAX_STR_LEN;
	str[0] = 0;
	if (__unlikely(!(ls->flags & (LINK_STATE_UP | LINK_STATE_UNKNOWN | LINK_STATE_CONNECTING)))) {
		_snprintf(str, e - str, "LINK DOWN");
		str = strchr(str, 0);
		if (__unlikely(ls->flags & LINK_STATE_AUTO_NEGOTIATION_FAILED)) {
			_snprintf(str, e - str, " AUTO-NEGOTIATION FAILED");
			str = strchr(str, 0);
		}
		goto failed_entries;
	} else if (__unlikely(ls->flags & LINK_STATE_CONNECTING)) {
		_snprintf(str, e - str, "LINK CONNECTING");
		str = strchr(str, 0);
	} else if (__unlikely(ls->flags & LINK_STATE_UNKNOWN)) {
		_snprintf(str, e - str, "LINK STATE UNKNOWN");
		str = strchr(str, 0);
	} else {
		_snprintf(str, e - str, "LINK UP");
		str = strchr(str, 0);
	}
	if (__likely(ls->speed != 0)) {
		if (ls->speed >= 1000000000) {
			_snprintf(str, e - str, " %luG", (unsigned long)(ls->speed >> 9) / (1000000000 >> 9));
			str = strchr(str, 0);
		} else if (ls->speed >= 1000000) {
			_snprintf(str, e - str, " %luM", (unsigned long)ls->speed / 1000000);
			str = strchr(str, 0);
		} else if (ls->speed >= 1000) {
			_snprintf(str, e - str, " %luK", (unsigned long)ls->speed / 1000);
			str = strchr(str, 0);
		} else {
			_snprintf(str, e - str, " %luB", (unsigned long)ls->speed);
			str = strchr(str, 0);
		}
	}
	if (__likely(ls->flags & LINK_STATE_FULL_DUPLEX)) {
		_snprintf(str, e - str, " FULL-DUPLEX");
		str = strchr(str, 0);
	} else if (__likely(ls->flags & LINK_STATE_HALF_DUPLEX)) {
		_snprintf(str, e - str, " HALF-DUPLEX");
		str = strchr(str, 0);
	}
	if (__likely(ls->flags & LINK_STATE_MASTER)) {
		_snprintf(str, e - str, " MASTER");
		str = strchr(str, 0);
	} else if (__likely(ls->flags & LINK_STATE_SLAVE)) {
		_snprintf(str, e - str, " SLAVE");
		str = strchr(str, 0);
	}
	if (__unlikely(ls->flags & LINK_STATE_AUTO_NEGOTIATION_FAILED)) {
		_snprintf(str, e - str, " AUTO-NEGOTIATION FAILED");
		str = strchr(str, 0);
	} else if (__likely(ls->flags & LINK_STATE_AUTO_NEGOTIATION)) {
		_snprintf(str, e - str, " AUTO-NEGOTIATION");
		str = strchr(str, 0);
	}
	failed_entries:
	if (__unlikely(ls->flags & LINK_STATE_ADAPTER_DEAD)) {
		_snprintf(str, e - str, " ADAPTER DEAD");
		str = strchr(str, 0);
	}
	if (__unlikely(ls->flags & LINK_STATE_REMOTE_FAULT)) {
		_snprintf(str, e - str, " REMOTE FAULT");
		str = strchr(str, 0);
	}
	if (__unlikely(ls->flags & LINK_STATE_JABBER)) {
		_snprintf(str, e - str, " JABBER");
		str = strchr(str, 0);
	}
	if (__likely(ls->desc[0])) {
		_snprintf(str, e - str, " %s", ls->desc);
		str = strchr(str, 0);
	}
	if (__unlikely(ls->flags & LINK_STATE_MEDIA_AUTOSELECT)) {
		_snprintf(str, e - str, " AUTOSELECT");
		str = strchr(str, 0);
	}
	return ostr;
}

