#define RECV_POLLING(xl)	(IS_V2(xl))
#define XMIT_POLLING(xl)	(IS_V2(xl))

static int WAIT(XL *xl, char *msg)
{
	unsigned cnt;
	READ_16(xl, EL_XL_IntStatusCmd);	/* I/O delay */
	cnt = 0;
	while (__unlikely(READ_16(xl, EL_XL_IntStatusCmd) & EL_XL_IntStatus_CmdInProgress)) {
		if (__unlikely(++cnt >= XL_COMMAND_TIMEOUT)) {
			if (__unlikely(READ_16(xl, EL_XL_IntStatusCmd) == 0xffff)) xl->flags2 |= FLAG2_DEAD;
			if (msg && !(xl->flags2 & FLAG2_DEAD)) KERNEL$SYSLOG(__SYSLOG_HW_BUG, xl->dev_name, "TIMED OUT WHEN WAITING FOR COMMAND %s", msg);
			return 1;
		}
		KERNEL$UDELAY(1);
	}
	return 0;
}

static __finline__ void WINDOW(XL *xl, unsigned win)
{
	if (__unlikely(win != xl->window)) {
		xl->window = win;
		WRITE_16(xl, EL_XL_IntStatusCmd, EL_XL_Cmd_SetRegisterWindow | win);
	}
}

static __finline__ void THE_PCMCIA_PEOPLE_ARE_IDIOTS(XL *xl)
{
/* I don't know what this does, but linux has it too ... with the comment
   about idiocy */
	if (__unlikely(xl->flags & CARDBUS)) mmio_outl(xl->cb_mem + 4, 0x8000);
}

