#ifndef __NIC_3CREG_H
#define __NIC_3CREG_H

#define PROBE_EL_READ_EEPROM	0x80
#define PROBE_EL_GLOBAL_RESET	0xc0
#define PROBE_EL_SET_TAG	0xd0
#define PROBE_EL_TEST_TAG	0xd8
#define PROBE_EL_ACTIVATE	0xe0
#define PROBE_EL_ACTIVATE_PRECF	0xff

#define REGSPACE_3C5X9		16
#define REGSPACE_3C90X		64
#define REGSPACE_3C90XB		128
#define REGSPACE_CB		8

#define EEPROM_SIZE		0x40

#define N_HW_MCAST		256

#define N_PHY			32
#define INTERNAL_PHY_ID		24

#define PCI_X1_InternalConfig		0x40
#define PCI_X1_ResetOptions		0x48
#define PCI_X1_EepromData		0x4c
#define PCI_X2_MedTestModeLo		0x50
#define PCI_X2_MedTestModeHi		0x54
#define PCI_X2_MedTestOutput		0x58
#define PCI_X2_MedTestPattern		0x5c
#define PCI_X2_CapID			0xdc
#define PCI_X2_NextPtr			0xdd
#define PCI_X2_PowerMgmtCap		0xde
#define  PCI_X2_PowerMgmtCap_Version		0x0003
#define  PCI_X2_PowerMgmtCap_D1Support		0x0200
#define  PCI_X2_PowerMgmtCap_D2Support		0x0400
#define  PCI_X2_PowerMgmtCap_PmeSupport		0xf800
#define PCI_X2_PowerMgmtCtrl		0xe0
#define  PCI_X2_PowerMgmtCtrl_PowerState	0x0003
#define  PCI_X2_PowerMgmtCtrl_PmeEn		0x0100
#define  PCI_X2_PowerMgmtCtrl_PmeStatus		0x8000

#define X2_DM_TxPktId			0x18
#define XL_DM_Timer			0x1a
#define XL_DM_TxStatus			0x1b
#define  EL_XL_TxStatus_TxReclaimError		0x02
#define  EL_XL_TxStatus_TxStatusOverflow	0x04
#define  EL_XL_TxStatus_MaxCollisions		0x08
#define  EL_XL_TxStatus_TxUnderrun		0x10
#define  EL_XL_TxStatus_TxJabber		0x20
#define  EL_XL_TxStatus_InterruptRequested	0x40
#define  EL_XL_TxStatus_TxComplete		0x80
#define XL_DM_IntStatusCmd		0x1e
#define XL_DM_DmaCtrl			0x20
#define  XL_DM_DmaCtrl_DnCmplReq		0x00000002
#define  XL_DM_DmaCtrl_DnStalled		0x00000004
#define  XL_DM_DmaCtrl_UpComplete		0x00000008
#define  XL_DM_DmaCtrl_DnComplete		0x00000010
#define  XL_DM_DmaCtrl_UpEarlyRxEnable		0x00000020
#define  XL_DM_DmaCtrl_ArmCountdown		0x00000040
#define  XL_DM_DmaCtrl_DnInProg			0x00000080
#define  XL_DM_DmaCtrl_CounterSpeed		0x00000100
#define  XL_DM_DmaCtrl_CounterMode		0x00000200
#define  X2_DM_DmaCtrl_UpAltSeqDisable		0x00010000
#define  X2_DM_DmaCtrl_DefeatMWI		0x00100000
#define  X2_DM_DmaCtrl_DefeatMRL		0x00200000
#define  X2_DM_DmaCtrl_UpOverDiskDisable	0x00400000
#define  XL_DM_DmaCtrl_TargetAbort		0x40000000
#define  XL_DM_DmaCtrl_MasterAbort		0x80000000
#define XL_DM_DnListPtr			0x24
#define X2_DM_DnBurstThresh		0x2a
#define  X2_DM_DnBurstThresh_Mask		0x1f
#define X2_DM_DnPriorityThresh		0x2c
#define  X2_DM_DnPriorityThresh_Mask		0x3f
#define X2_DM_DnPoll			0x2d
#define  X2_DM_DnPoll_Mask			0x7f
#define X1_DM_TxFreeThresh		0x2f
#define XL_DM_UpPktStatus		0x30
#define  XL_DM_UpPktStatus_UpPktLen		0x00001fff
#define  XL_DM_UpPktStatus_UpStalled		0x00002000
#define  XL_DM_UpPktStatus_UpError		0x00004000
#define  XL_DM_UpPktStatus_UpPktComplete	0x00008000
#define  XL_DM_UpPktStatus_UpOverrun		0x00010000
#define  XL_DM_UpPktStatus_UpRuntFrame		0x00020000
#define  XL_DM_UpPktStatus_UpAlignmentError	0x00040000
#define  XL_DM_UpPktStatus_UpCrcError		0x00080000
#define  XL_DM_UpPktStatus_UpOversizedFrame	0x00100000
#define  XL_DM_UpPktStatus_DribbleBits		0x00800000
#define  XL_DM_UpPktStatus_UpOverflow		0x01000000
#define  X2_DM_UpPktStatus_IpChecksumError	0x02000000
#define  X2_DM_UpPktStatus_TcpChecksumError	0x04000000
#define  X2_DM_UpPktStatus_UdpChecksumError	0x08000000
#define  X2_DM_UpPktStatus_IpChecksumChecked	0x20000000
#define  X2_DM_UpPktStatus_TcpChecksumChecked	0x40000000
#define  X2_DM_UpPktStatus_UdpChecksumChecked	0x80000000
#define XL_DM_FreeTimer			0x34
#define XL_DM_Countdown			0x36
#define XL_DM_UpListPtr			0x38
#define X2_DM_UpPriorityThresh		0x3c
#define  X2_DM_UpPriorityThresh_Mask		0x1f
#define X2_DM_UpPoll			0x3d
#define  X2_DM_UpPoll_Mask			0x7f
#define X2_DM_UpBurstThresh		0x3e
#define  X2_DM_UpBurstThresh_Mask		0x1f
#define X2_DM_RealTimeCnt		0x40
#define X2_DM_DebugData			0x70
#define X2_DM_DebugControl		0x74
#define  X2_DM_DebugControl_DebugSelect		0x001f
#define  X2_DM_DebugControl_DebugOverride	0x8000
#define X2_DM_DnMaxBurst		0x78
#define  X2_DM_DnMaxBurst_Mask			0x07e0
#define X2_DM_UpMaxBurst		0x7a
#define  X2_DM_UpMaxBurst_Mask			0x07e0
#define X2_DM_PowerMgmtCtrl		0x7c

#define EL_XL_IntStatusCmd		0x0e
#define  EL_XL_IntStatus_InterruptLatch		0x0001
#define  EL_XL_IntStatus_HostError		0x0002
#define  EL_XL_IntStatus_TxComplete		0x0004
#define  EL_IntStatus_TxAvailable		0x0008
#define  EL_XL_IntStatus_RxComplete		0x0010
#define  EL_XL_IntStatus_RxEarly		0x0020
#define  EL_XL_IntStatus_IntRequested		0x0040
#define  EL_XL_IntStatus_UpdateStats		0x0080
#define  XL_IntStatus_LinkEvent			0x0100
#define  XL_IntStatus_DnComplete		0x0200
#define  XL_IntStatus_UpComplete		0x0400
#define  EL_XL_IntStatus_CmdInProgress		0x1000
#define  EL_XL_IntStatus_WindowNumber		0xe000

#define  EL_XL_Cmd_GlobalReset			0x0000		/* wait */
#define   EL_XL_Cmd_GlobalReset_TpAuiReset		0x0001
#define   EL_XL_Cmd_GlobalReset_EndecReset		0x0002
#define   EL_XL_Cmd_GlobalReset_NetworkReset		0x0004
#define   EL_XL_Cmd_GlobalReset_FifoReset		0x0008
#define   EL_XL_Cmd_GlobalReset_AismReset		0x0010
#define   EL_XL_Cmd_GlobalReset_HostReset		0x0020
#define   XL_Cmd_GlobalReset_VcoReset			0x0080
#define   XL_Cmd_GlobalReset_UpDownReset		0x0100
#define  EL_XL_Cmd_SetRegisterWindow		0x0800
#define  EL_XL_Cmd_EnableDcConverter		0x1000
#define  EL_XL_Cmd_RxDisable			0x1800
#define  EL_XL_Cmd_RxEnable			0x2000
#define  EL_XL_Cmd_RxReset			0x2800		/* wait */
#define   E2_XL_Cmd_RxReset_TpAuiRxReset		0x0001
#define   E2_XL_Cmd_RxReset_EndecRxReset		0x0002
#define   E2_XL_Cmd_RxReset_NetworkRxReset		0x0004
#define   E2_XL_Cmd_RxReset_FifoRxReset			0x0008
#define   XL_Cmd_RxReset_UpRxReset			0x0100
#define  XL_Cmd_UpStall				0x3000		/* wait */
#define  XL_Cmd_UpUnStall			0x3001
#define  XL_Cmd_DnStall				0x3002		/* wait */
#define  XL_Cmd_DnUnStall			0x3003
#define  EL_Cmd_DiscardTopPacket		0x4000		/* wait */
#define  EL_XL_Cmd_TxEnable			0x4800
#define  EL_XL_Cmd_TxDisable			0x5000
#define  EL_XL_Cmd_TxReset			0x5800		/* wait */
#define   E2_XL_Cmd_TxReset_TpAuiTxReset		0x0001
#define   E2_XL_Cmd_TxReset_EndecTxReset		0x0002
#define   E2_XL_Cmd_TxReset_NetworkTxReset		0x0004
#define   E2_XL_Cmd_TxReset_FifoTxReset			0x0008
#define   XL_Cmd_TxReset_DnTxReset			0x0100
#define   EL_Cmd_TxReset_Immediate			0x0400
#define  EL_XL_Cmd_RequestInterrupt		0x6000
#define  EL_XL_Cmd_AcknowledgeInterrupt		0x6800
#define   EL_XL_Cmd_AcknowledgeInterrupt_InterruptLatchAck 0x0001
#define   X3_Cmd_AcknowledgeInterrupt_LinkEventAck	0x0002
#define   EL_Cmd_AcknowledgeInterrupt_AdapterFailure	0x0002
#define   EL_Cmd_AcknowledgeInterrupt_TxComplete	0x0004
#define   EL_Cmd_AcknowledgeInterrupt_TxAvailable	0x0008
#define   EL_XL_Cmd_AcknowledgeInterrupt_RxComplete	0x0010
#define   EL_XL_Cmd_AcknowledgeInterrupt_RxEarlyAck	0x0020
#define   EL_XL_Cmd_AcknowledgeInterrupt_IntRequestedAck 0x0040
#define   XL_EL_XL_Cmd_AcknowledgeInterrupt_UpdateStats	0x0080
#define   XL_Cmd_AcknowledgeInterrupt_DnCompleteAck	0x0200
#define   XL_Cmd_AcknowledgeInterrupt_UpCompleteAck	0x0400
#define  EL_XL_Cmd_SetInterruptEnable		0x7000
#define  EL_XL_Cmd_SetIndicationEnable		0x7800
#define  EL_XL_Cmd_SetRxFilter			0x8000
#define   EL_XL_Cmd_SetRxFilter_ReceiveIndividual	0x01
#define   EL_XL_Cmd_SetRxFilter_ReceiveMulticast	0x02
#define   EL_XL_Cmd_SetRxFilter_ReceiveBroadcast	0x04
#define   EL_XL_Cmd_SetRxFilter_ReceiveAllFrames	0x08
#define   X2_Cmd_SetRxFilter_ReceiveMulticastHash	0x10
#define  EL_XL_Cmd_SetRxEarlyThresh		0x8800
#define  EL_Cmd_SetTxAvailableThresh		0x9000
#define  EL_XL_Cmd_SetTxStartThresh		0x9800
#define  EL_XL_Cmd_StatisticsEnable		0xa800
#define  EL_XL_Cmd_StatisticsDisable		0xb000
#define  EL_XL_Cmd_DisableDcConverter		0xb800
#define  EM_X2_Cmd_SetTxReclaimThresh		0xc000
#define  X2_Cmd_ClearHashFilterBit		0xc800
#define  X2_Cmd_SetHashFilterBit		0xcc00
#define  E2_Cmd_PowerUp				0xd800		/* wait */
#define  E2_Cmd_PowerDownFull			0xe000
#define  E2_Cmd_PowerAuto			0xe800

#define EL_W0_ManufacturerID		0x00
#define EL_W0_ProductID			0x02
#define EL_W0_ConfigControl		0x04
#define  EL_W0_ConfigControl_ENA		0x0001
#define  EL_W0_ConfigControl_RST		0x0004
#define  EL_W0_ConfigControl_3C529		0x0080
#define  EL_W0_ConfigControl_Internal_EndecVco	0x0100
#define  EL_W0_ConfigControl_AvailTP		0x0200
#define  EL_W0_ConfigControl_AvailBNC		0x1000
#define  EL_W0_ConfigControl_AvailAUI		0x2000
#define  EL_W0_ConfigControl_ISA		0x4000
#define EL_W0_AddressConfiguration	0x06
#define EL_W0_ResourceConfiguration	0x08
#define X2_W0_BiosRomAddr		0x04
#define X2_W0_BiosRomData		0x08
#define EL_XL_W0_EepromCommand		0x0a
#define  EL_XL_W0_EepromCommand_EepromAddress	0x003f
#define  EL_XL_W0_EepromCommand_EepromOpcode	0x00c0
#define   EL_XL_W0_EepromCommand_WriteDisable	 0x0000
#define   EL_XL_W0_EepromCommand_WriteAll	 0x0010
#define   EL_XL_W0_EepromCommand_EraseAll	 0x0020
#define   EL_XL_W0_EepromCommand_WriteEmable	 0x0030
#define   EL_XL_W0_EepromCommand_WriteRegister	 0x0040
#define   EL_XL_W0_EepromCommand_ReadRegister	 0x0080
#define   EL_XL_W0_EepromCommand_EraseRegister	 0x00c0
#define    EL_XL_W0_EepromCommand_DataOffset	  0x0030
#define  EL_XL_W0_EepromCommand_EepromBusy	0x8000
#define EL_XL_W0_EepromData		0x0c

#define EL_W1_Pio			0x00
#define X1_W1_RxError			0x04
#define  X1_W1_RxError_RxOverrun		0x01
#define  X1_W1_RxError_RuntFrame		0x02
#define  X1_W1_RxError_AlignmentError		0x04
#define  X1_W1_RxError_CrcError			0x08
#define  X1_W1_RxError_OversizedFrame		0x10
#define  X1_W1_RxError_DribbleBits		0x80
#define EL_X1_W1_RxStatus		0x08
#define  EL_W1_RxStatus_RxBytes			0x07ff
#define  EL_W1_RxStatus_Code			0x3800
#define   EL_W1_RxStatus_Code_Overrun		0x0000
#define   EL_W1_RxStatus_Code_Oversized		0x0800
#define   EL_W1_RxStatus_Code_DribbleBits	0x1000
#define   EL_W1_RxStatus_Code_RuntPacket	0x1800
#define   EL_W1_RxStatus_Code_FramingError	0x2000
#define   EL_W1_RxStatus_Code_CrcError		0x2800
#define  X1_W1_RxStatus_RxBytes			0x1fff
#define  EL_X1_W1_RxStatus_RxError		0x4000
#define  EL_X1_W1_RxStatus_RxIncomplete		0x8000
#define EL_X1_W1_Timer			0x0a
#define EL_X1_W1_TxStatus		0x0b
#define  EL_X1_W1_TxStatus_TxReclaimError	0x02
#define  EL_X1_W1_TxStatus_TxStatusOverflow	0x04
#define  EL_X1_W1_TxStatus_MaxCollisions	0x08
#define  EL_X1_W1_TxStatus_Underrun		0x10
#define  EL_X1_W1_TxStatus_Jabber		0x20
#define  EL_X1_W1_TxStatus_InterruptRequested	0x40
#define  EL_X1_W1_TxStatus_Complete		0x80
#define EL_X1_W1_TxFree			0x0c

#define EL_XL_W2_StationAddressLo	0x00
#define EL_XL_W2_StationAddressMid	0x02
#define EL_XL_W2_StationAddressHi	0x04
#define XL_W2_StationMaskLo		0x06
#define XL_W2_StationMaskMid		0x08
#define XL_W2_StationMaskHi		0x0a
#define X2_W2_ResetOptions		0x0c
#define  X2_W2_ResetOptions_FeatureSet		0x0007
#define   X2_W2_ResetOptions_FeatureSet_AllExceptSched	0x0000
#define   X2_W2_ResetOptions_FeatureSet_None		0x0001
#define   X2_W2_ResetOptions_FeatureSet_AllStandard	0x0002
#define   X2_W2_ResetOptions_FeatureSet_AllServer	0x0004
#define  X2_W2_ResetOptions_D3ResetDisable	0x0008
#define  X2_W2_ResetOptions_DisableAdvFD	0x0010
#define  X2_W2_ResetOptions_CB_LedPwr		0x0010
#define  X2_W2_ResetOptions_DisableAdv100	0x0020
#define  X2_W2_ResetOptions_DisableAutoNeg	0x0040
#define  X2_W2_ResetOptions_DebugMode		0x0080
#define  X2_W2_ResetOptions_FastAutoNeg		0x0100
#define  X2_W2_ResetOptions_FastEE		0x0200
#define  X2_W2_ResetOptions_ForcedConfig	0x0400
#define  X2_W2_ResetOptions_TestPdtPdr		0x0800
#define  X2_W2_ResetOptions_Test100Tx		0x1000
#define  X2_W2_ResetOptions_Test100Rx		0x2000
#define  X2_W2_ResetOptions_CB_MiiPwr		0x4000

#define XL_W3_InternalConfig		0x00
#define  X1_InternalConfig_RamSize		0x00000007
#define   X1_InternalConfig_RamSize_8kb		 0x00000000
#define   X1_InternalConfig_RamSize_32kb	 0x00000002
#define   X1_InternalConfig_RamSize_64kb	 0x00000003
#define   X1_InternalConfig_RamSize_128kb	 0x00000004
#define  X1_InternalConfig_RamWidth		0x00000008
#define  XL_InternalConfig_RomSize		0x000000c0
#define   XL_InternalConfig_RomSize_8kb		 0x00000000
#define   XL_InternalConfig_RomSize_16kb	 0x00000040
#define   XL_InternalConfig_RomSize_32kb	 0x00000080
#define   XL_InternalConfig_RomSize_64kb	 0x000000c0
#define  XL_InternalConfig_DisableBadSsdDetect	0x00000100
#define  X1_InternalConfig_RamLocation		0x00000200
#define  X2_InternalConfig_EnableTxLarge	0x00004000
#define  X2_InternalConfig_EnableRxLarge	0x00008000
#define  XL_InternalConfig_RamPartition		0x00030000
#define   XL_InternalConfig_RamPartition_5_3	 0x00000000
#define   XL_InternalConfig_RamPartition_6_2	 0x00010000
#define   XL_InternalConfig_RamPartition_4_4	 0x00020000
#define   XL_InternalConfig_RamPartition_3_5	 0x00030000
#define  X1_InternalConfig_XcvrSelect		0x00700000
#define   X1_InternalConfig_XcvrSelect_10BASET	 0x00000000
#define   X1_InternalConfig_XcvrSelect_10AUI	 0x00100000
#define   X1_InternalConfig_XcvrSelect_10BASE2	 0x00300000
#define   X1_InternalConfig_XcvrSelect_100BASEFX 0x00500000
#define   X1_InternalConfig_XcvrSelect_MII	 0x00600000
#define  X2_InternalConfig_XcvrSelect		0x00f00000
#define   X2_InternalConfig_XcvrSelect_10BASET	 0x00000000
#define   X2_InternalConfig_XcvrSelect_10AUI	 0x00100000
#define   X2_InternalConfig_XcvrSelect_10BASE2	 0x00300000
#define   X2_InternalConfig_XcvrSelect_100BASETX 0x00400000
#define   X2_InternalConfig_XcvrSelect_100BASEFX 0x00500000
#define   X2_InternalConfig_XcvrSelect_MII	 0x00600000
#define   X2_InternalConfig_XcvrSelect_ANE	 0x00800000
#define   X2_InternalConfig_XcvrSelect_MII_EXT	 0x00900000
#define  XL_InternalConfig_AutoSelect		0x01000000
#define X2_W3_MaxPktSize		0x04
#define  X2_W3_MaxPktSize_Mask			0x1fff
#define XL_W3_MacControl		0x06
#define  XL_W3_MacControl_DeferExtendedEnable	0x0001
#define  XL_W3_MacControl_DeferTimerSelect	0x001e
#define  XL_W3_MacControl_FullDuplexEnable	0x0020
#define  XL_W3_MacControl_AllowLargePackets	0x0040
#define  X2_W3_MacControl_ExtendAfterCollision	0x0080
#define  X2_W3_MacControl_FlowControlEnable	0x0100
#define  X2_W3_MacControl_VltEnable		0x0200
#define E2_W2_TxReclaimTreshold		0x08
#define X1_W3_ResetOptions		0x08
#define  X1_W3_ResetOptions_BaseT4Available	0x0001
#define  X1_W3_ResetOptions_BaseTXAvailable	0x0002
#define  X1_W3_ResetOptions_BaseFXAvailable	0x0004
#define  X1_W3_ResetOptions_10bTAvailable	0x0008
#define  X1_W3_ResetOptions_CoaxAvailable	0x0010
#define  X1_W3_ResetOptions_AuiAvailable	0x0020
#define  X1_W3_ResetOptions_MiiConnector	0x0040
#define  X1_W3_ResetOptions_VcoConfig		0x0100
#define  X1_W3_ResetOptions_ForcedConfig	0x1000
#define  X1_W3_ResetOptions_TestMode		0xe000
#define   X1_W3_ResetOptions_TestMode_10Aui	 0x0000
#define   X1_W3_ResetOptions_TestMode_10Rx	 0x2000
#define   X1_W3_ResetOptions_TestMode_10Tx	 0x4000
#define   X1_W3_ResetOptions_TestMode_10BaseTRx	 0x6000
#define   X1_W3_ResetOptions_TestMode_10BaseTFId 0x8000
#define   X1_W3_ResetOptions_TestMode_Normal	 0xe000
#define X2_W3_MediaOptions		0x08
#define  X2_W3_MediaOptions_BaseT4Available	0x0001
#define  X2_W3_MediaOptions_BaseTXAvailable	0x0002
#define  X2_W3_MediaOptions_BaseFXAvailable	0x0004
#define  X2_W3_MediaOptions_10bTAvailable	0x0008
#define  X2_W3_MediaOptions_CoaxAvailable	0x0010
#define  X2_W3_MediaOptions_AuiAvailable	0x0020
#define  X2_W3_MediaOptions_MiiConnector	0x0040
#define  X2_W3_MediaOptions_10BaseFL		0x0100
#define EL_XL_W3_RxFree			0x0a
#define EL_XL_W3_TxFree			0x0c

#define XL_W4_VcoDignostic		0x02
#define EL_XL_W4_FifoDiagnostic		0x04
#define  EL_W4_FifoDiagnostic_TxBc		0x0001
#define  EL_W4_FifoDiagnostic_TxBf		0x0002
#define  EL_W4_FifoDiagnostic_TxBfc		0x0004
#define  EL_W4_FifoDiagnostic_TxBist		0x0008
#define  EL_W4_FifoDiagnostic_RxBc		0x0010
#define  EL_W4_FifoDiagnostic_RxBf		0x0020
#define  EL_W4_FifoDiagnostic_RxBfc		0x0040
#define  EL_W4_FifoDiagnostic_RxBist		0x0080
#define  X1_W4_FifoDiagnostic_RxTestMode	0x0001
#define  X1_W4_FifoDiagnostic_TxTestMode	0x0002
#define  X1_W4_FifoDiagnostic_InMemBIST		0x0004
#define  X1_W4_FifoDiagnostic_InMemBFC		0x0008
#define  X1_W4_FifoDiagnostic_InMemBF		0x0010
#define  X1_W4_FifoDiagnostic_InMemBC		0x0020
#define  EL_X1_W4_FifoDiagnostic_TxOverrun	0x0400
#define  EL_X1_W4_FifoDiagnostic_RxOverrun	0x0800
#define  EL_W4_FifoDiagnostic_RxStatusOverrun	0x1000
#define  EL_X1_W4_FifoDiagnostic_RxUnderrun	0x2000
#define  EL_XL_W4_FifoDiagnostic_Receiving	0x8000
#define  X2_W4_FifoDiagnostic_TxBistEnable	0x0001
#define  X2_W4_FifoDiagnostic_TxBistControl	0x0002
#define  X2_W4_FifoDiagnostic_TxBistFlag	0x0004
#define  X2_W4_FifoDiagnostic_TxBistComplete	0x0008
#define  X2_W4_FifoDiagnostic_RxBistEnable	0x0010
#define  X2_W4_FifoDiagnostic_RxBistControl	0x0020
#define  X2_W4_FifoDiagnostic_RxBistFlag	0x0040
#define  X2_W4_FifoDiagnostic_RxBistComplete	0x0080
#define  X2_W4_FifoDiagnostic_KeepRxOverrun	0x0200
#define  X2_W4_FifoDiagnostic_RxFull		0x0800
#define EL_XL_W4_NetworkDiagnostic	0x06
#define  EL_XL_W4_NetworkDiagnostic_TestLowVoltageDetector 0x0001
#define  EL_XL_W4_NetworkDiagnostic_AsicRevision	0x003e
#define  XL_W4_NetworkDiagnostic_UpperBytesEnable	0x0040
#define  EL_XL_W4_NetworkDiagnostic_StatisticsEnabled	0x0080
#define  EL_XL_W4_NetworkDiagnostic_TxFatalError	0x0100
#define  EL_XL_W4_NetworkDiagnostic_Transmitting	0x0200
#define  EL_XL_W4_NetworkDiagnostic_RxEnabled		0x0400
#define  EL_XL_W4_NetworkDiagnostic_TxEnabled		0x0800
#define  EL_XL_W4_NetworkDiagnostic_FifoLoopback	0x1000
#define  EL_XL_W4_NetworkDiagnostic_MacLoopback		0x2000
#define  EL_XL_W4_NetworkDiagnostic_EndecLoopback	0x4000
#define  EL_XL_W4_NetworkDiagnostic_ExternalLoopback	0x8000
#define EL_W4_ControllerStatus		0x08
#define  EL_W4_ControllerStatus_RxTestEn	0x0001
#define  EL_W4_ControllerStatus_RxShort		0x0002
#define  EL_W4_ControllerStatus_RxDribble	0x0004
#define  EL_W4_ControllerStatus_RxFcsErr	0x0008
#define  EL_W4_ControllerStatus_RxOverrun	0x0010
#define  EL_W4_ControllerStatus_RxFrameErr	0x0020
#define  EL_W4_ControllerStatus_RxDone		0x0040
#define  EL_W4_ControllerStatus_RxRejectOut	0x0080
#define  EL_W4_ControllerStatus_TxEndSltTime	0x0100
#define  EL_W4_ControllerStatus_TxLcar		0x0200
#define  EL_W4_ControllerStatus_TxSqeErr	0x0400
#define  EL_W4_ControllerStatus_TxLateColl	0x0800
#define  EL_W4_ControllerStatus_TxMaxColl	0x1000
#define  EL_W4_ControllerStatus_TxUnderrun	0x2000
#define  EL_W4_ControllerStatus_TxRetry		0x4000
#define  EL_W4_ControllerStatus_TxDone		0x8000
#define XL_W4_PhysicalMgmt		0x08
#define  XL_W4_PhysicalMgmt_MgmtClk		0x0001
#define  XL_W4_PhysicalMgmt_MgmtData		0x0002
#define  XL_W4_PhysicalMgmt_MgmtDir		0x0004
#define  XL_W4_PhysicalMgmt_Cat5LinkTestDefeat	0x8000
#define EL_XL_W4_MediaStatus		0x0a
#define  EL_X2_W4_MediaStatus_CrcStripDisable	0x0004
#define  EL_XL_W4_MediaStatus_EnableSqeStats	0x0008
#define  EL_XL_W4_MediaStatus_CollisionDetect	0x0010
#define  EL_XL_W4_MediaStatus_CarrierSense	0x0020
#define  EL_XL_W4_MediaStatus_JabberGuardEnable	0x0040
#define  EL_XL_W4_MediaStatus_LinkBeatEnable	0x0080
#define  EL_XL_W4_MediaStatus_JabberDetect	0x0200
#define  EL_XL_W4_MediaStatus_PolarityReversed	0x0400
#define  EL_XL_W4_MediaStatus_LinkDetect	0x0800
#define  EL_W4_MediaStatus_SqePresent		0x1000
#define  XL_W4_MediaStatus_TxInProg		0x1000
#define  EL_XL_W4_MediaStatus_DcConverterEnabled 0x4000
#define  EL_XL_W4_MediaStatus_AuiDisable	0x8000
#define XL_W4_BadSSD			0x0c
#define XL_W4_UpperBytesOK		0x0d

#define EL_XL_W5_TxStartThresh		0x00
#define  EL_XL_W5_TxStartThresh_Mask		0x1ffc
#define EL_X1_W5_TxAvailableThresh	0x02
#define EL_XL_W5_RxEarlyThresh		0x06
#define  EL_XL_W5_RxEarlyThresh_Mask		0x1ffc
#define EL_XL_W5_RxFilter		0x08
#define  EL_XL_W5_RxFilter_ReceiveIndividual	0x01
#define  EL_XL_W5_RxFilter_ReceiveMulticast	0x02
#define  EL_XL_W5_RxFilter_ReceiveBroadcast	0x04
#define  EL_XL_W5_RxFilter_ReceiveAllFrames	0x08
#define  X2_W5_RxFilter_ReceiveMulticastHash	0x10
#define X2_W5_TxReclaimThresh		0x09
#define EL_XL_W5_InterruptEnable	0x0a
#define EL_XL_W5_IndicationEnable	0x0c

#define EL_XL_W6_CarrierLost		0x00
#define EL_XL_W6_SqeErrors		0x01
#define EL_XL_W6_MultipleCollisions	0x02
#define EL_XL_W6_SingleCollisions	0x03
#define EL_XL_W6_LateCollisions		0x04
#define EL_XL_W6_RxOverruns		0x05
#define EL_XL_W6_FramesXmittedOk	0x06
#define EL_XL_W6_FramesRcvdOk		0x07
#define EL_XL_W6_FramesDeferred		0x08
#define XL_W6_UpperFramesOk		0x09
#define EL_XL_W6_BytesRcvdOk		0x0a
#define EL_XL_W6_BytesXmittedOk		0x0c

#define X2_W7_VlanMask			0x00
#define X2_W7_VlanEtherType		0x04
#define X1_W7_Timer			0x0a
#define X1_W7_TxStatus			0x0b
#define X2_W7_PowerMgmtEvent		0x0c
#define  X2_W7_PowerMgmtEvent_WakeppPktEnable	0x0001
#define  X2_W7_PowerMgmtEvent_MagicPktEnable	0x0002
#define  X2_W7_PowerMgmtEvent_LinkEventEnable	0x0004
#define  X2_W7_PowerMgmtEvent_WakeppPktEvent	0x0010
#define  X2_W7_PowerMgmtEvent_MagicPktEvent	0x0020
#define  X2_W7_PowerMgmtEvent_LinkEvent		0x0040

#define EE_EL_XL_3Com_Node_Address_0		0x00
#define EE_EL_XL_3Com_Node_Address_1		0x01
#define EE_EL_XL_3Com_Node_Address_2		0x02
#define EE_EL_XL_DeviceId			0x03
#define EE_EL_XL_Manufacturing_Date		0x04
#define EE_EL_XL_Manufacturing_Division		0x05
#define EE_EL_XL_Manufacturing_Product_Code	0x06
#define EE_EL_XL_ManufacturerId			0x07
#define  EE_EL_XL_ManufacturerIdValue			0x6d50
#define EE_EL_AddressConfiguration		0x08
#define  EE_EL_AddressConfiguration_Address		0x001f
#define  EE_EL_AddressConfiguration_AutoSelect		0x0080
#define  EE_EL_AddressConfiguration_ROMBase		0x0f00
#define  EE_EL_AddressConfiguration_ROMSize		0x3000
#define  EE_EL_AddressConfiguration_Xcvr		0xc000
#define   EE_EL_AddressConfiguration_Xcvr_TP			0x0000
#define   EE_EL_AddressConfiguration_Xcvr_AUI			0x4000
#define   EE_EL_AddressConfiguration_Xcvr_BNC			0xc000
#define EE_XL_PciParm				0x08
#define  EE_XL_PciParm_FastBackToBack			0x0001
#define  EE_XL_PciParm_D3Hot				0x0001
#define  EE_XL_PciParm_Lower1Meg			0x0002
#define  EE_XL_PciParm_DisableMemBase			0x0004
#define  EE_XL_PciParm_D3ColdPme			0x0008
#define  EE_XL_PciParm_D1Support			0x0010
#define  EE_XL_PciParm_D2Support			0x0020
#define  EE_XL_PciParm_MinGnt				0x03c0
#define  EE_XL_PciParm_MaxLat				0xfc00
#define EE_EL_ResourceConfiguration		0x09
#define  EE_EL_ResourceConfiguration_IRQ		0xf000
#define  EE_EL_ResourceConfiguration_SR			0x0040
#define EE_XL_RomInfo				0x09
#define  EE_XL_RomInfo_RomPresent			0x0800
#define  EE_XL_RomInfo_RomSize				0x3000
#define   EE_XL_RomInfo_RomSize_64			 0x0000
#define   EE_XL_RomInfo_RomSize_128			 0x1000
#define EE_EL_XL_OEM_Node_Address_0		0x0a
#define EE_EL_XL_OEM_Node_Address_1		0x0b
#define EE_EL_XL_OEM_Node_Address_2		0x0c
#define EE_EL_XL_Software_Information		0x0d
#define  EE_EL_XL_Software_Information_OptimizeFor	0x0030
#define   EE_EL_Software_Information_OptimizeFor_DOS	 0x0010
#define   EE_XL_Software_Information_OptimizeFor_Normal	 0x0010
#define   EE_EL_Software_Information_OptimizeFor_Windows 0x0020
#define   EE_XL_Software_Information_OptimizeFor_Net	 0x0020
#define   EE_EL_Software_Information_OptimizeFor_Server	 0x0030
#define   EE_XL_Software_Information_OptimizeFor_CPU	 0x0030
#define  EE_EL_Software_Information_InterruptDisable	0x3f00
#define  EE_EL_XL_Software_Information_LinkBeatDisable	0x4000
#define  EE_EL_XL_Software_Information_FullDuplex	0x8000
#define EE_EL_XL_Compatibility_Word		0x0e
#define  EE_EL_XL_Compatibility_Word_WarningLevel	0x00ff
#define  EE_EL_XL_Compatibility_Word_FailureLevel	0xff00
#define EE_EL_Checksum				0x0f
#define EE_XL_Software_Information_2		0x0f
#define  EE_XL_Software_Information_2_FixedBroadcastRxBug	0x0002
#define  EE_XL_Software_Information_2_FixedEndecLpbackBug	0x0004
#define  EE_XL_Software_Information_2_WolConnector		0x0008
#define  EE_XL_Software_Information_2_PmePulsed			0x0010
#define  EE_XL_Software_Information_2_FixedMWIBug		0x0020
#define EE_EL_XL_Capabilities_Word		0x10
#define  EE_EL_XL_Capabilities_Word_SupportsPlugNPlay	0x0001
#define  EE_EL_XL_Capabilities_Word_SupportsFullDuplex	0x0002
#define  EE_XL_Capabilities_Word_SupportsLargePackets	0x0004
#define  EE_XL_Capabilities_Word_SupportsSlaveDma	0x0008
#define  EE_XL_Capabilities_Word_SupportsSecondDma	0x0010
#define  EE_XL_Capabilities_Word_SupportsFullBusMaster	0x0020
#define  EE_XL_Capabilities_Word_SupportsFragBusMaster	0x0040
#define  EE_EL_XL_Capabilities_Word_SupportsCrcPassThru	0x0080
#define  EE_XL_Capabilities_Word_SupportsTxDone		0x0100
#define  EE_XL_Capabilities_Word_SupportsNoTxLength	0x0200
#define  EE_XL_Capabilities_Word_SupportsRxRepeat	0x0400
#define  EE_XL_Capabilities_Word_SupportsSnooping	0x0800
#define  EE_XL_Capabilities_Word_Supports100Mbps	0x1000
#define  EE_EL_XL_Capabilities_Word_SupportsPowerMgmt	0x2000
#define EE_XL_InternalConfig_0			0x12
#define EE_XL_InternalConfig_1			0x13
#define EE_EL_Software_Information_2		0x14
#define  EE_EL_Software_Information_2_Revision		0x000f
#define   EE_EL_Software_Information_2_Revision_A		0x0000
#define   EE_EL_Software_Information_2_Revision_B		0x0001
#define  EE_EL_Software_Information_2_BootROMSizeValid	0x0010
#define  EE_EL_Software_Information_2_AutoPowerDisable	0x4000
#define EE_X2_Analog_Diagnostic			0x14
#define EE_XL_Software_Information_3		0x15
#define  EE_XL_Software_Information_3_ForceXcvr		0x000f
#define  EE_XL_Software_Information_3_ForceXcvr_GenericMII	0x0000
#define  EE_XL_Software_Information_3_ForceXcvr_10BASET4_MII	0x0001
#define  EE_XL_Software_Information_3_ForceXcvr_10BASET_MII	0x0002
#define  EE_XL_Software_Information_3_ForceXcvr_10BASETX_MII	0x0003
#define  EE_XL_Software_Information_3_ForceXcvr_10BASET_AUTO	0x0004
#define  EE_XL_Software_Information_3_ForceXcvr_10BASETX_AUTO	0x0004
#define EE_X2_LANWorks_Data			0x16
#define EE_X1_Checksum				0x17
#define EE_X2_SubsystemVendorId			0x17
#define EE_X2_SubsystemId			0x18
#define EE_X2_MediaOptions			0x19
#define EE_X2_Checksum				0x20

typedef struct {
	__u32 DnNextPtr;
	__u32 FrameStartHeader;
} DPD;

typedef struct {
	__u32 DnFragAddr;
	__u32 DnFragLen;
} DPD_ENTRY;

#define X1_FSH_TxLength			0x00001fff
#define X2_FSH_RndupBndry		0x00000003
#define X2_FSH_PktId			0x000003fc
#define XL_FSH_CrcAppendDisable		0x00002000
#define XL_FSH_TxIndicate		0x00008000
#define X2_FSH_DnComplete		0x00010000
#define X2_FSH_AddIpChecksum		0x02000000
#define X2_FSH_AddTcpChecksum		0x04000000
#define X2_FSH_AddUdpChecksum		0x08000000
#define X2_FSH_RndupDefeat		0x10000000
#define X2_FSH_DpdEmpty			0x20000000
#define XL_FSH_DnIndicate		0x80000000

#define X2_SCH_ScheduleTime		0x00ffffff
#define X2_SCH_LoadTimeCnt		0x10000000
#define X2_SCH_ScheduleTimeValid	0x20000000
#define X2_SCH_IdBit			0x40000000

#define XL_DFL_DnFragLen		0x00001fff
#define XL_DFL_DnFragLast		0x80000000

typedef struct {
	__u32 UpNextPtr;
	__u32 UpPktStatus;
} UPD;

typedef struct {
	__u32 UpFragAddr;
	__u32 UpFragLen;
} UPD_ENTRY;

#define XL_UPS_UpPktLen			0x00001fff
#define XL_UPS_UpError			0x00004000
#define XL_UPS_UpComplete		0x00008000
#define XL_UPS_UpOverrun		0x00010000
#define XL_UPS_RuntFrame		0x00020000
#define XL_UPS_AlignmentError		0x00040000
#define XL_UPS_CrcError			0x00080000
#define XL_UPS_OversizedFrame		0x00100000
#define XL_UPS_DribbleBits		0x00800000
#define XL_UPS_UpOverflow		0x01000000
#define X2_UPS_IpChecksumError		0x02000000
#define X2_UPS_TcpChecksumError		0x04000000
#define X2_UPS_UdpChecksumError		0x08000000
#define X2_UPS_ImpliedBufferEnable	0x10000000
#define X2_UPS_IpChecksumChecked	0x20000000
#define X2_UPS_TcpChecksumChecked	0x40000000
#define X2_UPS_UdpChecksumChecked	0x80000000

#define XL_UFL_UpFragLen		0x00001fff
#define XL_UFL_UpFragLast		0x80000000

#endif
