#ifndef __NIC_IPG_H
#define __NIC_IPG_H

#include <SYS/TYPES.H>
#include <ARCH/IO.H>
#include <SPAD/IRQ.H>
#include <SPAD/PCI.H>
#include <ENDIAN.H>
#include <SPAD/TIMER.H>
#include <SPAD/PKT.H>
#include <SPAD/ETHERNET.H>

#include "IPGREG.H"

#define N_TX_DESCS		1024	/* must be multiple of 8 */
#define N_RX_DESCS		1024	/* must be multiple of 8 */
#define DESCS_ALIGN		128	/* 16 is minimum */
#define MULTICAST_OFFSET	0	/* 0 - 3 */
#define TX_INT_DELAY		16
#define TX_ABS_INT_DELAY	32
#define RX_INT_DELAY		3
#define RX_ABS_INT_DELAY	8
#define IPS_DEFAULT_1G		20000
#define IPS_DEFAULT_100M	2000
#define IPG_SUM_START		DEFAULT_CHECKSUM_POS
#define DEFAULT_MAX_SENT	16
#define WRITEBACK_STRIDE	16
#define IPG_MEDIA_TIME		(5 * JIFFIES_PER_SECOND)
#define IPG_TX_TIMEOUT		(5 * JIFFIES_PER_SECOND)
#define IPG_DECAY_TIME		(30 * JIFFIES_PER_SECOND)
#define IPG_HIGH_INTERRUPT

#define TX_DESCS(ipg)	((IPG_TX_DESC *)((char *)(ipg) + ((sizeof(IPG) + (DESCS_ALIGN - 1)) & ~(DESCS_ALIGN - 1))))
#define RX_DESCS(ipg)	((IPG_RX_DESC *)(TX_DESCS(ipg) + N_TX_DESCS))
#define IPG_SIZE	(((sizeof(IPG) + (DESCS_ALIGN - 1)) & ~(DESCS_ALIGN - 1)) + N_TX_DESCS * sizeof(IPG_TX_DESC) + N_RX_DESCS * sizeof(IPG_RX_DESC))
#define IPG_ALIGN	0x10000

#define SEND_DESCS	MAX_PACKET_FRAGMENTS(ETHERNET_JUMBO_MTU)

typedef struct {
	PACKET *p;
	vspace_dma64unlock_t *unlock;
} XMIT_PKT_INFO;

#define MCAST_ALL	4096
#define MCAST_PROMISC	4097
#define N_MCAST		4098

typedef struct {
	__u8 *mem;

	int packet_input;
	int outstanding;
	PKTQUEUE *queue;

	AST irq_ast;
	IRQ_HANDLE *irq_ctrl;

	unsigned char mac_type;
	unsigned char media;
	unsigned char bus_type;
	unsigned char link_mode;
	unsigned char flow_control;
	unsigned char rx_csum_general;

	pci_id_t id;

	__u32 icr;

	unsigned short rx_pkt_size;
	unsigned short first_recv;
	unsigned short n_recv;
	unsigned short recv_mask;
	unsigned short first_sent;
	unsigned short n_sent;
	unsigned short sent_mask;
	unsigned short max_sent;
	unsigned short tdht_add;

	unsigned char get_link_status;

	u_jiffies_lo_t tx_last_time;

	u_jiffies_lo_t last_decay_time;

	TIMER media_timer;

	PACKET *recv_packets[N_RX_DESCS];
	XMIT_PKT_INFO xmit_info[N_TX_DESCS];

	LINK_STATE link_state;
	WQ link_state_wait;

	__u16 current_ifs_val;
	__u16 fc_high_water_mark;
	__u16 fc_low_water_mark;

	unsigned char fiber_autoneg_failed;

	__u8 address[ETHERNET_ADDRLEN];
	unsigned short mtu;
	__u16 dev_id;
	__u8 rev_id;

	struct {
		__u32 id;
		__u8 revision;
		unsigned char type;
	} phy;
	io_t io;
	__u8 *flash_mem;
	unsigned flash_base_addr;
	unsigned flash_bank_size;
	struct {
		unsigned char type;
		unsigned use_eerd:1;
		unsigned short word_size;
		unsigned short opcode_bits;
		unsigned short address_bits;
		unsigned short delay_usec;
		unsigned short page_size;
	} eeprom;

	__u64 desc_dmaaddr;
	vspace_dma64unlock_t *desc_unlock;

	int ips;
	int ips_100;

	unsigned char errorlevel;
	unsigned char en_mng_pt;

	__u16 pci_cmd;
	
	int irq;
	void *lnte;
	void *dlrq;
	char *chip_name;
	IO_RANGE range;
	char dev_name[__MAX_STR_LEN];

	int mcast_state;
	WQ mcast_table[N_MCAST];
} IPG;

/* order is important */
#define MAC_MASK		0x1f
#define MAC_82542_rev2_0	1
#define MAC_82542_rev2_1	2	/* doesn't have HW checksum */
#define MAC_82543		3
#define MAC_82544		4
#define MAC_82540		5
#define MAC_82545		6
#define MAC_82545_rev_3		7
#define MAC_82546		8
#define MAC_82546_rev_3		9
#define MAC_82541		10
#define MAC_82541_rev_2		11
#define MAC_82547		12
#define MAC_82547_rev_2		13
#define MAC_82571		14
#define MAC_82572		15
#define MAC_82573		16
#define MAC_80003es2lan		17
#define MAC_ich8lan		18

#define MEDIA_SHIFT		5
#define MEDIA_MASK		3
#define MEDIA_FIBER		1
#define MEDIA_COPPER		2
#define MEDIA_SERDES		3

#define BUS_UNKNOWN		1
#define BUS_PCI			2
#define BUS_PCIX		3
#define BUS_PCI_EX		4

#define LINK_100		0x01
#define LINK_FD			0x02
#define LINK_AUTO		0x10

#define FC_NONE			0
#define FC_RX_PAUSE		1
#define FC_TX_PAUSE		2
#define FC_FULL			3
#define FC_DEFAULT		4

#define EEPROM_MICROWIRE	1
#define EEPROM_SPI		2
#define EEPROM_FLASH		3
#define EEPROM_ICH8		4

#define PHY_M88			1
#define PHY_IGP			2
#define PHY_IGP_2		3
#define PHY_GG82563		4
#define PHY_IGP_3		5
#define PHY_IFE			6

#define IPG_READ(ipg, reg)	mmio_inl((ipg)->mem + (reg))
#define IPG_WRITE(ipg, reg, val) mmio_outl((ipg)->mem + (reg), val)
#define IPG_FLUSH(ipg)		IPG_READ(ipg, IPG_STATUS)

#define INTERRUPT_MASK(ipg)		(IPG_ICR_TXDW | /* IPG_ICR_TXQE |*/ IPG_ICR_LSC | IPG_ICR_RXSEQ | IPG_ICR_RXDMT0 | IPG_ICR_RXTO)
#define IPG_RX_DESC_ERRORS_MASK		(IPG_RX_DESC_ERRORS_CE | IPG_RX_DESC_ERRORS_SE | IPG_RX_DESC_ERRORS_SEQ | IPG_RX_DESC_ERRORS_CXE | IPG_RX_DESC_ERRORS_RXE)

#define IPG_TBI(ipg)			(__unlikely((ipg)->mac_type == MAC_82543) && __likely((ipg)->media == MEDIA_COPPER))
#define IPG_RX_CHECKSUM(ipg)		((ipg)->mac_type >= MAC_82543)
#define IPG_ABS_TIMERS(ipg)		((ipg)->mac_type >= MAC_82540)
#define IPG_RAR_WORKAROUND(ipg)		(__unlikely((ipg)->mac_type == MAC_82571))
#define IPG_RX_RESET_WORKAROUND(ipg)	(__unlikely((ipg)->mac_type == MAC_82542_rev2_0))
#define IPG_ID(ipg)			(IDTYPE_PCI | ((ipg)->id & IDTYPE_MASK))

/* IPG.C */

__u16 ICH8_READ_16(IPG *ipg, unsigned reg);
void IPG_WRITE_IO(IPG *ipg, unsigned reg, __u32 val);
__u32 ICH8_READ_32(IPG *ipg, unsigned reg);
void ICH8_WRITE_16(IPG *ipg, unsigned reg, __u16 val);
void ICH8_WRITE_32(IPG *ipg, unsigned reg, __u32 val);
void MSLEEP(int syn, unsigned val);
void IPG_SET_ITR(IPG *ipg, int ips);
void IPG_ERROR_RESET(IPG *ipg);
void IPG_TIMEOUT(IPG *ipg);
extern IRQ_STUB IPG_IRQ_RT;
extern IO_STUB IPG_IOCTL;

/* IPGEPROM.C */

int IPG_INIT_EEPROM(IPG *ipg);
int IPG_READ_EEPROM(IPG *ipg, unsigned offset, unsigned len, __u16 *data);
int IPG_GET_SOFTWARE_FLAG(IPG *ipg);
void IPG_RELEASE_SOFTWARE_FLAG(IPG *ipg);
int IPG_SWFW_SYNC_ACQUIRE(IPG *ipg, __u16 mask);
void IPG_SWFW_SYNC_RELEASE(IPG *ipg, __u16 mask);

/* IPGPHY.C */

int IPG_CHECK_PHY_RESET_BLOCK(IPG *ipg);
int IPG_READ_PHY(IPG *ipg, unsigned addr, __u16 *data);
int IPG_WRITE_PHY(IPG *ipg, unsigned addr, __u16 data);
void IPG_PHY_DETECT(IPG *ipg);
void IPG_PHY_INIT_SCRIPT(IPG *ipg, int syn);
int IPG_PHY_HW_RESET(IPG *ipg, int syn);
int IPG_PHY_RESET(IPG *ipg, int syn);
int IPG_READ_KMRN(IPG *ipg, unsigned addr, __u16 *data);
int IPG_WRITE_KMRN(IPG *ipg, unsigned addr, __u16 data);
int IPG_CHECK_IAMT(IPG *ipg);
void IPG_POWERUP_PHY(IPG *ipg);
void IPG_POWERDOWN_PHY(IPG *ipg);

/* IPGLINK.C */

void IPG_SETUP_LINK(IPG *ipg, int syn);
int IPG_POLARITY_REVERSAL_WORKAROUND(IPG *ipg, int syn);
void IPG_SET_COLLISION_DIST(IPG *ipg);
void IPG_LINK_CHANGED(IPG *ipg, int link);

/* IPGCORE.C */

extern const HANDLE_OPERATIONS IPG_OPERATIONS;
extern AST_STUB IPG_IRQ;

void IPG_ADD_RECV_PACKET(IPG *ipg, PACKET *p);
void IPG_REAP_TX(IPG *ipg);
void IPG_TEAR_DOWN_RECV_PACKETS(IPG *ipg);
void IPG_TEAR_DOWN_SENT_PACKETS(IPG *ipg);
void IPG_REINIT_RX_RING(IPG *ipg);
void IPG_COPPER_MEDIA_TIMER(TIMER *t);
void IPG_FIBER_MEDIA_TIMER(TIMER *t);

#endif
