#include <SPAD/PKT.H>

#include "MIIREG.H"

__u16 MII_READ(void *p, unsigned idx);
void MII_WRITE(void *p, unsigned idx, __u16 val);
void MII_GET_MODE(void *p, LINK_STATE_PHYS *l);

void MII_GET_MODE(void *p, LINK_STATE_PHYS *l)
{
	unsigned bmsr, bmcr, cap;
	memset(l, 0, sizeof(LINK_STATE_PHYS));
	if (__unlikely(!p)) return;
	MII_READ(p, MII_BMSR);
	bmsr = MII_READ(p, MII_BMSR);
	if (__unlikely(bmsr & BMSR_JCD)) l->flags |= LINK_STATE_JABBER;
	if (__unlikely(bmsr & BMSR_RFAULT)) l->flags |= LINK_STATE_REMOTE_FAULT;
	if (__unlikely(!(bmsr & BMSR_LSTATUS))) {
		/*__debug_printf("link down\n");*/
		return;
	}
	l->flags |= LINK_STATE_UP;
	bmcr = MII_READ(p, MII_BMCR);
	if (__unlikely(!(bmcr & BMCR_ANENABLE))) {
		/*if (bmcr & BMCR_SPEED1000) {
			l->speed = 1000000000;
			strlcpy(l->desc, "1000BASE-T", sizeof(l->desc));
		} else*/ if (bmcr & BMCR_SPEED100) {
			l->speed = 100000000;
			strlcpy(l->desc, "100BASE-TX", sizeof(l->desc));
		} else {
			l->speed = 10000000;
			strlcpy(l->desc, "10BASE-T", sizeof(l->desc));
		}
		if (bmcr & BMCR_FULLDPLX) l->flags |= LINK_STATE_FULL_DUPLEX;
		else l->flags |= LINK_STATE_HALF_DUPLEX;
		/*__debug_printf("non-ane link: %Ld, %s\n", l->speed, l->flags & LINK_STATE_FULL_DUPLEX ? "full duplex" : "half duplex");*/
		return;
	}
	if (__unlikely(!(bmsr & BMSR_ANEGCOMPLETE))) {
		l->flags |= LINK_STATE_AUTO_NEGOTIATION_FAILED;
		goto l10;
	}
	l->flags |= LINK_STATE_AUTO_NEGOTIATION;
	cap = MII_READ(p, MII_ADVERTISE) & MII_READ(p, MII_LPA);
	if (cap & ADVERTISE_100FULL) {
		l->speed = 100000000;
		l->flags |= LINK_STATE_FULL_DUPLEX;
		strlcpy(l->desc, "100BASE-TX", sizeof(l->desc));
	} else if (cap & ADVERTISE_100BASE4) {
		l->speed = 100000000;
		l->flags |= LINK_STATE_HALF_DUPLEX;
		strlcpy(l->desc, "100BASE-T4", sizeof(l->desc));
	} else if (cap & ADVERTISE_100HALF) {
		l->speed = 100000000;
		l->flags |= LINK_STATE_HALF_DUPLEX;
		strlcpy(l->desc, "100BASE-TX", sizeof(l->desc));
	} else if (cap & ADVERTISE_10FULL) {
		l->speed = 10000000;
		l->flags |= LINK_STATE_FULL_DUPLEX;
		strlcpy(l->desc, "10BASE-T", sizeof(l->desc));
	} else {
		l10:
		l->speed = 10000000;
		l->flags |= LINK_STATE_HALF_DUPLEX;
		strlcpy(l->desc, "10BASE-T", sizeof(l->desc));
	}
	/*__debug_printf("ane link: %Ld, %s\n", l->speed, l->flags & LINK_STATE_FULL_DUPLEX ? "full duplex" : "half duplex");*/
}
