#ifndef __NIC_SKGMAC_H
#define __NIC_SKGMAC_H

/* GMAC */

#define GM_GP_STAT		0x0000
#define  GM_GPSR_SPEED			(1 << 15)
#define  GM_GPSR_DUPLEX			(1 << 14)
#define  GM_GPSR_FC_TX_DIS		(1 << 13)
#define  GM_GPSR_LINK_UP		(1 << 12)
#define  GM_GPSR_PAUSE			(1 << 11)
#define  GM_GPSR_TX_ACTIVE		(1 << 10)
#define  GM_GPSR_EXC_COL		(1 << 9)
#define  GM_GPSR_LAT_COL		(1 << 8)
#define  GM_GPSR_PHY_ST_CH		(1 << 5)
#define  GM_GPSR_GIG_SPEED		(1 << 4)
#define  GM_GPSR_PART_MODE		(1 << 3)
#define  GM_GPSR_FC_RX_DIS		(1 << 2)
#define  GM_GPSR_PROM_EN		(1 << 1)
#define GM_GP_CTRL		0x0004
#define  GM_GPCR_PROM_ENA		(1 << 14)
#define  GM_GPCR_FC_TX_DIS		(1 << 13)
#define  GM_GPCR_TX_ENA			(1 << 12)
#define  GM_GPCR_RX_ENA			(1 << 11)
#define  GM_GPCR_BURST_ENA		(1 << 10)
#define  GM_GPCR_LOOP_ENA		(1 << 9)
#define  GM_GPCR_PART_ENA		(1 << 8)
#define  GM_GPCR_GIGS_ENA		(1 << 7)
#define  GM_GPCR_FL_PASS		(1 << 6)
#define  GM_GPCR_DUP_FULL		(1 << 5)
#define  GM_GPCR_FC_RX_DIS		(1 << 4)
#define  GM_GPCR_SPEED_100		(1 << 3)
#define  GM_GPCR_AU_DUP_DIS		(1 << 2)
#define  GM_GPCR_AU_FCT_DIS		(1 << 1)
#define  GM_GPCR_AU_SPD_DIS		(1 << 0)
#define  GM_GPCR_SPEED_1000			(GM_GPCR_GIGS_ENA |\
						 GM_GPCR_SPEED_100)
#define  GM_GPCR_AU_ALL_DIS			(GM_GPCR_AU_DUP_DIS |\
						 GM_GPCR_AU_FCT_DIS |\
						 GM_GPCR_AU_SPD_DIS)
#define GM_TX_CTRL		0x0008
#define  GM_TXCR_FORCE_JAM		(1 << 15)
#define  GM_TXCR_CRC_DIS		(1 << 14)
#define  GM_TXCR_PAD_DIS		(1 << 13)
#define  GM_TXCR_COL_THR_MSK		(7 << 10)
#define  GM_TXCR_COL_THR_MSK_SHIFT		10
#define  TX_COL_DEF				4
#define GM_RX_CTRL		0x000c
#define  GM_RXCR_UCF_ENA		(1 << 15)
#define  GM_RXCR_MCF_ENA		(1 << 14)
#define  GM_RXCR_CRC_DIS		(1 << 13)
#define  GM_RXCR_PASS_FC		(1 << 12)
#define GM_TX_FLOW_CTRL		0x0010
#define GM_TX_PARAM		0x0014
#define  GM_TXPA_JAMLEN_MSK		(3 << 14)
#define   GM_TXPA_JAMLEN_MSK_SHIFT		14
#define   TX_JAM_LEN_DEF			0x03
#define  GM_TXPA_JAMIPG_MSK		(0x1f << 9)
#define   GM_TXPA_JAMIPG_MSK_SHIFT		9
#define   TX_JAM_IPG_DEF			0x0b
#define  GM_TXPA_JAMDAT_MSK		(0x1f << 4)
#define   GM_TXPA_JAMDAT_MSK_SHIFT		4
#define   TX_IPG_JAM_DEF			0x1c
#define GM_SERIAL_MODE		0x0018
#define  GM_SMOD_DATABL_MSK		(0x1f << 11)
#define   GM_SMOD_DATABL_MSK_SHIFT		11
#define   DATA_BLIND_DEF			0x04
#define  GM_SMOD_LIMIT_4		(1 << 10)
#define  GM_SMOD_VLAN_ENA		(1 << 9)
#define  GM_SMOD_JUMBO_ENA		(1 << 8)
#define  GM_SMOD_IPG_MSK		(0x1f << 0)
#define   GM_SMOD_IPG_MSK_SHIFT			0
#define   IPG_DATA_DEF				0x1e
#define GM_SRC_ADDR_1L		0x001c
#define GM_SRC_ADDR_1M		0x0020
#define GM_SRC_ADDR_1H		0x0024
#define GM_SRC_ADDR_2L		0x0028
#define GM_SRC_ADDR_2M		0x002c
#define GM_SRC_ADDR_2H		0x0030
#define GM_MC_ADDR_H1		0x0034
#define GM_MC_ADDR_H2		0x0038
#define GM_MC_ADDR_H3		0x003c
#define GM_MC_ADDR_H4		0x0040
#define GM_TX_IRQ_SRC		0x0044
#define GM_RX_IRQ_SRC		0x0048
#define GM_TR_IRQ_SRC		0x004c
#define GM_TX_IRQ_MSK		0x0050
#define GM_RX_IRQ_MSK		0x0054
#define GM_TR_IRQ_MSK		0x0058
#define GM_SMI_CTRL		0x0080
#define  GM_SMI_CT_PHY_A_MSK		(0x1f << 11)
#define   GM_SMI_CT_PHY_A_MSK_SHIFT		11
#define   PHY_ADDR_MARV				0
#define  GM_SMI_CT_REG_A_MSK		(0x1f << 6)
#define   GM_SMI_CT_REG_A_MSK_SHIFT		6
#define  GM_SMI_CT_OP_RD		(1 << 5)
#define  GM_SMI_CT_RD_VAL		(1 << 4)
#define  GM_SMI_CT_BUSY			(1 << 3)
#define GM_SMI_DATA		0x0084
#define GM_PHY_ADDR		0x0088
#define  GM_PAR_MIB_CLR			(1 << 5)
#define  GM_PAR_MIB_TST			(1 << 4)
#define GM_MIB_CNT_BASE		0x0100
#define GM_MIB_CNT_SIZE			44
#define GM_RXF_UC_OK		(GM_MIB_CNT_BASE + 0)
#define GM_RXF_BC_OK		(GM_MIB_CNT_BASE + 8)
#define GM_RXF_MPAUSE		(GM_MIB_CNT_BASE + 16)
#define GM_RXF_MC_OK		(GM_MIB_CNT_BASE + 24)
#define GM_RXF_FCS_ERR		(GM_MIB_CNT_BASE + 32)
#define GM_RXO_OK_LO		(GM_MIB_CNT_BASE + 48)
#define GM_RXO_OK_HI		(GM_MIB_CNT_BASE + 56)
#define GM_RXO_ERR_LO		(GM_MIB_CNT_BASE + 64)
#define GM_RXO_ERR_HI		(GM_MIB_CNT_BASE + 72)
#define GM_RXF_SHT		(GM_MIB_CNT_BASE + 80)
#define GM_RXE_FRAG		(GM_MIB_CNT_BASE + 88)
#define GM_RXF_64B		(GM_MIB_CNT_BASE + 96)
#define GM_RXF_127B		(GM_MIB_CNT_BASE + 104)
#define GM_RXF_255B		(GM_MIB_CNT_BASE + 112)
#define GM_RXF_511B		(GM_MIB_CNT_BASE + 120)
#define GM_RXF_1023B		(GM_MIB_CNT_BASE + 128)
#define GM_RXF_1518B		(GM_MIB_CNT_BASE + 136)
#define GM_RXF_MAX_SZ		(GM_MIB_CNT_BASE + 144)
#define GM_RXF_LNG_ERR		(GM_MIB_CNT_BASE + 152)
#define GM_RXF_JAB_PKT		(GM_MIB_CNT_BASE + 160)
#define GM_RXE_FIFO_OV		(GM_MIB_CNT_BASE + 176)
#define GM_TXF_UC_OK		(GM_MIB_CNT_BASE + 192)
#define GM_TXF_BC_OK		(GM_MIB_CNT_BASE + 200)
#define GM_TXF_MPAUSE		(GM_MIB_CNT_BASE + 208)
#define GM_TXF_MC_OK		(GM_MIB_CNT_BASE + 216)
#define GM_TXO_OK_LO		(GM_MIB_CNT_BASE + 224)
#define GM_TXO_OK_HI		(GM_MIB_CNT_BASE + 232)
#define GM_TXF_64B		(GM_MIB_CNT_BASE + 240)
#define GM_TXF_127B		(GM_MIB_CNT_BASE + 248)
#define GM_TXF_255B		(GM_MIB_CNT_BASE + 256)
#define GM_TXF_511B		(GM_MIB_CNT_BASE + 264)
#define GM_TXF_1023B		(GM_MIB_CNT_BASE + 272)
#define GM_TXF_1518B		(GM_MIB_CNT_BASE + 280)
#define GM_TXF_MAX_SZ		(GM_MIB_CNT_BASE + 288)
#define GM_TXF_COL		(GM_MIB_CNT_BASE + 304)
#define GM_TXF_LAT_COL		(GM_MIB_CNT_BASE + 312)
#define GM_TXF_ABO_COL		(GM_MIB_CNT_BASE + 320)
#define GM_TXF_MUL_COL		(GM_MIB_CNT_BASE + 328)
#define GM_TXF_SNG_COL		(GM_MIB_CNT_BASE + 336)
#define GM_TXE_FIFO_UR		(GM_MIB_CNT_BASE + 344)

/* GMAC receive frame status */
#define GMR_FS_LEN		(0xffff << 16)
#define  GMR_FS_LEN_SHIFT		16
#define GMR_FS_VLAN		(1 << 13)
#define GMR_FS_JABBER		(1 << 12)
#define GMR_FS_UN_SIZE		(1 << 11)
#define GMR_FS_MC		(1 << 10)
#define GMR_FS_BC		(1 << 9)
#define GMR_FS_RX_OK		(1 << 8)
#define GMR_FS_GOOD_FC		(1 << 7)
#define GMR_FS_BAD_FC		(1 << 6)
#define GMR_FS_MII_ERR		(1 << 5)
#define GMR_FS_LONG_ERR		(1 << 4)
#define GMR_FS_FRAGMENT		(1 << 3)
#define GMR_FS_CRC_ERR		(1 << 1)
#define GMR_FS_RX_FF_OV		(1 << 0)

#endif
