#ifndef __NIC_SKPHY_H
#define __NIC_SKPHY_H

/* XMAC-II PHY */

#define PHY_XMAC_CTRL		0x00
#define PHY_XMAC_STAT		0x01
#define PHY_XMAC_ID0		0x02
#define PHY_XMAC_ID1		0x03
#define PHY_XMAC_AUNE_ADV	0x04
#define PHY_XMAC_AUNE_LP	0x05
#define PHY_XMAC_AUNE_EXP	0x06
#define PHY_XMAC_NEPG		0x07
#define PHY_XMAC_NEPG_LP	0x08
#define PHY_XMAC_EXT_STAT	0x0f
#define PHY_XMAC_RES_ABI	0x10

/* BCOM PHY */

#define PHY_BCOM_CTRL		0x00
#define PHY_BCOM_STAT		0x01
#define PHY_BCOM_ID0		0x02
#define PHY_BCOM_ID1		0x03
#define PHY_BCOM_AUNE_ADV	0x04
#define PHY_BCOM_AUNE_LP	0x05
#define PHY_BCOM_AUNE_EXP	0x06
#define PHY_BCOM_NEPG		0x07
#define PHY_BCOM_NEPG_LP	0x08
#define PHY_BCOM_1000T_CTRL	0x09
#define PHY_BCOM_1000T_STAT	0x0a
#define PHY_BCOM_EXT_STAT	0x0f
#define PHY_BCOM_P_EXT_CTRL	0x10
#define PHY_BCOM_P_EXT_STAT	0x11
#define PHY_BCOM_RE_CTR		0x12
#define PHY_BCOM_FC_CTR		0x13
#define PHY_BCOM_RNO_CTR	0x14
#define PHY_BCOM_AUX_CTRL	0x18
#define PHY_BCOM_AUX_STAT	0x19
#define PHY_BCOM_INT_STAT	0x1a
#define PHY_BCOM_INT_MASK	0x1b

/* Marvell PHY */

#define PHY_MARV_CTRL		0x00
#define PHY_MARV_STAT		0x01
#define PHY_MARV_ID0		0x02
#define PHY_MARV_ID1		0x03
#define PHY_MARV_AUNE_ADV	0x04
#define PHY_MARV_AUNE_LP	0x05
#define PHY_MARV_AUNE_EXP	0x06
#define PHY_MARV_NEPG		0x07
#define PHY_MARV_NEPG_LP	0x08
#define PHY_MARV_1000T_CTRL	0x09
#define PHY_MARV_1000T_STAT	0x0a
#define PHY_MARV_EXT_STAT	0x0f
#define PHY_MARV_PHY_CTRL	0x10
#define PHY_MARV_PHY_STAT	0x11
#define PHY_MARV_INT_MASK	0x12
#define PHY_MARV_INT_STAT	0x13
#define PHY_MARV_EXT_CTRL	0x14
#define PHY_MARV_RXE_CNT	0x15
#define PHY_MARV_EXT_ADR	0x16
#define PHY_MARV_LED_CTRL	0x18
#define PHY_MARV_LED_OVER	0x19
#define PHY_MARV_EXT_CTRL_2	0x1a
#define PHY_MARV_EXT_P_STAT	0x1b
#define PHY_MARV_CABLE_DIAG	0x1c
#define PHY_MARV_PAGE_ADDR	0x1d
#define PHY_MARV_PAGE_DATA	0x1e

#define PHY_MARV_FE_LED_PAR	0x16
#define  LED_PAR_CTRL_COLX		0x00
#define  LED_PAR_CTRL_ERROR		0x01
#define  LED_PAR_CTRL_DUPLEX		0x02
#define  LED_PAR_CTRL_DP_COL		0x03
#define  LED_PAR_CTRL_SPEED		0x04
#define  LED_PAR_CTRL_LINK		0x05
#define  LED_PAR_CTRL_TX		0x06
#define  LED_PAR_CTRL_RX		0x07
#define  LED_PAR_CTRL_ACT		0x08
#define  LED_PAR_CTRL_LNK_RX		0x09
#define  LED_PAR_CTRL_LNK_AC		0x0a
#define  LED_PAR_CTRL_ACT_BL		0x0b
#define  LED_PAR_CTRL_TX_BL		0x0c
#define  LED_PAR_CTRL_RX_BL		0x0d
#define  LED_PAR_CTRL_COL_BL		0x0e
#define  LED_PAR_CTRL_INACT		0x0f
#define  PHY_M_FELP_LED0_CTRL_SHIFT	0
#define  PHY_M_FELP_LED1_CTRL_SHIFT	4
#define  PHY_M_FELP_LED2_CTRL_SHIFT	8
#define PHY_MARV_FE_LED_SER	0x17
#define PHY_MARV_FE_VCT_TX	0x1a
#define PHY_MARV_FE_VCT_RX	0x1b
#define PHY_MARV_FE_SPEC_2	0x1c
#define  PHY_M_FESC_DIS_WAIT		(1 << 2)
#define  PHY_M_FESC_ENA_MCLK		(1 << 1)
#define  PHY_M_FESC_SEL_CL_A		(1 << 0)

#define  PHY_CT_RESET			(1 << 15)
#define  PHY_CT_LOOP			(1 << 14)
#define  PHY_CT_SPS_LSB			(1 << 13)
#define  PHY_CT_ANE			(1 << 12)
#define  PHY_CT_PDOWN			(1 << 11)
#define  PHY_CT_ISOL			(1 << 10)
#define  PHY_CT_RE_CFG			(1 << 9)
#define  PHY_CT_DUP_MD			(1 << 8)
#define  PHY_CT_COL_TST			(1 << 7)
#define  PHY_CT_SPS_MSB			(1 << 6)
#define   PHY_CT_SP1000				PHY_CT_SPS_MSB
#define   PHY_CT_SP100				PHY_CT_SPS_LSB
#define   PHY_CT_SP10				0

#define  PHY_ST_EXT_ST			(1 << 8)
#define  PHY_ST_PRE_SUP			(1 << 6)
#define  PHY_ST_AN_OVER			(1 << 5)
#define  PHY_ST_REM_FLT			(1 << 4)
#define  PHY_ST_AN_CAP			(1 << 3)
#define  PHY_ST_LSYNC			(1 << 2)
#define  PHY_ST_JAB_DET			(1 << 1)
#define  PHY_ST_EXT_REG			(1 << 0)

#define  PHY_I1_OUI_MSK			(0x3f << 10)
#define  PHY_I1_MOD_NUM			(0x3f << 4)
#define  PHY_I1_REV_MSK			0xf

#define  PHY_AN_NXT_PG			(1 << 15)
#define  PHY_X_AN_ACK			(1 << 14)
#define  PHY_X_AN_RFB			(3 << 12)
#define  PHY_X_AN_PAUSE			(3 << 7)
#define  PHY_X_AN_HD			(1 << 6)
#define  PHY_X_AN_FD			(1 << 5)
#define  PHY_B_AN_RF			(1 << 13)
#define  PHY_B_AN_ASP			(1 << 11)
#define  PHY_B_AN_PC			(1 << 10)
#define  PHY_B_AN_SEL			0x1f
#define  PHY_L_AN_RF			(1 << 13)
#define  PHY_L_AN_ASP			(1 << 11)
#define  PHY_L_AN_PC			(1 << 10)
#define  PHY_L_AN_SEL			0x1f
#define  PHY_N_AN_RF			(1 << 13)
#define  PHY_N_AN_100F			(1 << 11)
#define  PHY_N_AN_100H			(1 << 10)
#define  PHY_N_AN_SEL			0x1f
#define  PHY_SEL_TYPE			0x01
#define  PHY_ANE_LP_NP			(1 << 3)
#define  PHY_ANE_LOC_NP			(1 << 2)
#define  PHY_ANE_RX_PG			(1 << 1)
#define  PHY_ANE_PAR_DF			(1 << 4)
#define  PHY_ANE_LP_CAP			(1 << 0)
#define  PHY_NP_MORE			(1 << 15)
#define  PHY_NP_ACK1			(1 << 14)
#define  PHY_NP_MSG_VAL			(1 << 13)
#define  PHY_NP_ACK2			(1 << 12)
#define  PHY_NP_TOG			(1 << 11)
#define  PHY_NP_MSG			0x07ff

#define  PHY_X_EX_FD			(1 << 15)
#define  PHY_X_EX_HD			(1 << 14)

#define  PHY_X_RS_PAUSE			(3 << 7)
#define  PHY_X_RS_HD			(1 << 6)
#define  PHY_X_RS_FD			(1 << 5)
#define  PHY_X_RS_ABLMIS 		(1 << 4)
#define  PHY_X_RS_PAUMIS 		(1 << 3)

#define  X_RFB_OK			(0 << 12)
#define  X_RFB_LF			(1 << 12)
#define  X_RFB_OFF			(2 << 12)
#define  X_RFB_AN_ERR			(3 << 12)

#define  PHY_X_P_NO_PAUSE		(0 << 7)
#define  PHY_X_P_SYM_MD			(1 << 7)
#define  PHY_X_P_ASYM_MD		(2 << 7)
#define  PHY_X_P_BOTH_MD		(3 << 7)

#define  PHY_B_1000C_TEST		(7 << 13)
#define  PHY_B_1000C_MSE		(1 << 12)
#define  PHY_B_1000C_MSC		(1 << 11)
#define  PHY_B_1000C_RD			(1 << 10)
#define  PHY_B_1000C_AFD		(1 << 9)
#define  PHY_B_1000C_AHD		(1 << 8)

#define  PHY_B_1000S_MSF		(1 << 15)
#define  PHY_B_1000S_MSR		(1 << 14)
#define  PHY_B_1000S_LRS		(1 << 13)
#define  PHY_B_1000S_RRS		(1 << 12)
#define  PHY_B_1000S_LP_FD		(1 << 11)
#define  PHY_B_1000S_LP_HD		(1 << 10)
#define  PHY_B_1000S_IEC		0xff

#define  PHY_B_ES_X_FD_CAP		(1 << 15)
#define  PHY_B_ES_X_HD_CAP		(1 << 14)
#define  PHY_B_ES_T_FD_CAP		(1 << 13)
#define  PHY_B_ES_T_HD_CAP		(1 << 12)

#define  PHY_B_PEC_MAC_PHY		(1 << 15)
#define  PHY_B_PEC_DIS_CROSS		(1 << 14)
#define  PHY_B_PEC_TX_DIS		(1 << 13)
#define  PHY_B_PEC_INT_DIS		(1 << 12)
#define  PHY_B_PEC_F_INT		(1 << 11)
#define  PHY_B_PEC_BY_45		(1 << 10)
#define  PHY_B_PEC_BY_SCR		(1 << 9)
#define  PHY_B_PEC_BY_MLT3		(1 << 8)
#define  PHY_B_PEC_BY_RXA		(1 << 7)
#define  PHY_B_PEC_RES_SCR		(1 << 6)
#define  PHY_B_PEC_EN_LTR		(1 << 5)
#define  PHY_B_PEC_LED_ON		(1 << 4)
#define  PHY_B_PEC_LED_OFF		(1 << 3)
#define  PHY_B_PEC_EX_IPG		(1 << 2)
#define  PHY_B_PEC_3_LED		(1 << 1)
#define  PHY_B_PEC_HIGH_LA		(1 << 0)

#define  PHY_B_PES_CROSS_STAT		(1 << 13)
#define  PHY_B_PES_INT_STAT		(1 << 12)
#define  PHY_B_PES_RRS			(1 << 11)
#define  PHY_B_PES_LRS			(1 << 10)
#define  PHY_B_PES_LOCKED		(1 << 9)
#define  PHY_B_PES_LS			(1 << 8)
#define  PHY_B_PES_RF			(1 << 7)
#define  PHY_B_PES_CE_ER		(1 << 6)
#define  PHY_B_PES_BAD_SSD		(1 << 5)
#define  PHY_B_PES_BAD_ESD		(1 << 4)
#define  PHY_B_PES_RX_ER		(1 << 3)
#define  PHY_B_PES_TX_ER		(1 << 2)
#define  PHY_B_PES_LOCK_ER		(1 << 1)
#define  PHY_B_PES_MLT3_ER		(1 << 0)

#define  PHY_B_FC_CTR			0xff

#define  PHY_B_RC_LOC_MSK		0xff00
#define  PHY_B_RC_REM_MSK		0x00ff

#define  PHY_B_AC_L_SQE			(1 << 15)
#define  PHY_B_AC_LONG_PACK		(1 << 14)
#define  PHY_B_AC_ER_CTRL		(3 << 12)
#define  PHY_B_AC_TX_TST		(1 << 10)
#define  PHY_B_AC_DIS_PRF		(1 << 7)
#define  PHY_B_AC_DIS_PM		(1 << 5)
#define  PHY_B_AC_DIAG			(1 << 3)

#define  PHY_B_AS_AN_C			(1 << 15)
#define  PHY_B_AS_AN_CA			(1 << 14)
#define  PHY_B_AS_ANACK_D		(1 << 13)
#define  PHY_B_AS_ANAB_D		(1 << 12)
#define  PHY_B_AS_NPW			(1 << 11)
#define  PHY_B_AS_AN_RES_MSK		(7 << 8)
#define  PHY_B_AS_PDF			(1 << 7)
#define  PHY_B_AS_RF			(1 << 6)
#define  PHY_B_AS_ANP_R			(1 << 5)
#define  PHY_B_AS_LP_ANAB		(1 << 4)
#define  PHY_B_AS_LP_NPAB		(1 << 3)
#define  PHY_B_AS_LS			(1 << 2)
#define  PHY_B_AS_PRR			(1 << 1)
#define  PHY_B_AS_PRT			(1 << 0)

#define  PHY_B_IS_PSE			(1 << 14)
#define  PHY_B_IS_MDXI_SC		(1 << 13)
#define  PHY_B_IS_HCT			(1 << 12)
#define  PHY_B_IS_LCT			(1 << 11)
#define  PHY_B_IS_AN_PR			(1 << 10)
#define  PHY_B_IS_NO_HDCL		(1 << 9)
#define  PHY_B_IS_NO_HDC		(1 << 8)
#define  PHY_B_IS_NEG_USHDC		(1 << 7)
#define  PHY_B_IS_SCR_S_ER		(1 << 6)
#define  PHY_B_IS_RRS_CHANGE		(1 << 5)
#define  PHY_B_IS_LRS_CHANGE		(1 << 4)
#define  PHY_B_IS_DUP_CHANGE		(1 << 3)
#define  PHY_B_IS_LSP_CHANGE		(1 << 2)
#define  PHY_B_IS_LST_CHANGE		(1 << 1)
#define  PHY_B_IS_CRC_ER		(1 << 0)

#define  PHY_B_P_NO_PAUSE		(0 << 10)
#define  PHY_B_P_SYM_MD			(1 << 10)
#define  PHY_B_P_ASYM_MD		(2 << 10)
#define  PHY_B_P_BOTH_MD		(3 << 10)

#define  PHY_B_RES_1000FD		(7 << 8)
#define  PHY_B_RES_1000HD		(6 << 8)

#define  PHY_M_AN_NXT_PG		(1 << 15)
#define  PHY_M_AN_ACK			(1 << 14)
#define  PHY_M_AN_RF			(1 << 13)
#define  PHY_M_AN_ASP			(1 << 11)
#define  PHY_M_AN_PC			(1 << 10)
#define  PHY_M_AN_100_T4		(1 << 9)
#define  PHY_M_AN_100_FD		(1 << 8)
#define  PHY_M_AN_100_HD		(1 << 7)
#define  PHY_M_AN_10_FD			(1 << 6)
#define  PHY_M_AN_10_HD			(1 << 5)
#define  PHY_M_AN_SEL_MSK		(0x1f << 4)
#define  PHY_M_AN_ASP_X			(1 << 8)
#define  PHY_M_AN_PC_X			(1 << 7)
#define  PHY_M_AN_1000X_AHD		(1 << 6)
#define  PHY_M_AN_1000X_AFD		(1 << 5)

#define  PHY_M_P_NO_PAUSE_X		(0 << 7)
#define  PHY_M_P_SYM_MD_X		(1 << 7)
#define  PHY_M_P_ASYM_MD_X		(2 << 7)
#define  PHY_M_P_BOTH_MD_X		(3 << 7)

#define  PHY_M_1000C_TEST		(7 << 13)
#define  PHY_M_1000C_MSE		(1 << 12)
#define  PHY_M_1000C_MSC		(1 << 11)
#define  PHY_M_1000C_MPD		(1 << 10)
#define  PHY_M_1000C_AFD		(1 << 9)
#define  PHY_M_1000C_AHD		(1 << 8)

#define  PHY_M_PC_TX_FFD_MSK		(3 << 14)
#define  PHY_M_PC_RX_FFD_MSK		(3 << 12)
#define  PHY_M_PC_ASS_CRS_TX		(1 << 11)
#define  PHY_M_PC_FL_GOOD		(1 << 10)
#define  PHY_M_PC_EN_DET_MSK		(3 << 8)
#define   PHY_M_PC_EN_DET			(2 << 8)
#define   PHY_M_PC_EN_DET_PLUS			(3 << 8)
#define  PHY_M_PC_ENA_EXT_D		(1 << 7)
#define  PHY_M_PC_MDIX_MSK		(3 << 5)
#define   PHY_M_PC_MDIX_MSK_SHIFT		5
#define   PHY_M_PC_ENA_MDI			0
#define   PHY_M_PC_ENA_MDIX			1
#define   PHY_M_PC_ENA_AUTO			3
#define  PHY_M_PC_DIS_125CLK		(1 << 4)
#define  PHY_M_PC_MAC_POW_UP		(1 << 3)
#define  PHY_M_PC_SQE_T_ENA		(1 << 2)
#define  PHY_M_PC_POL_R_DIS		(1 << 1)
#define  PHY_M_PC_DIS_JABBER		(1 << 0)

#define  PHY_M_PC_ENA_DTE_DT		(1 << 15)
#define  PHY_M_PC_ENA_ENE_DT		(1 << 14)
#define  PHY_M_PC_DIS_NLP_CK		(1 << 13)
#define  PHY_M_PC_ENA_LIP_NP		(1 << 12)
#define  PHY_M_PC_DIS_NLP_GN		(1 << 11)
#define  PHY_M_PC_DIS_SCRAMB		(1 << 9)
#define  PHY_M_PC_DIS_FEFI		(1 << 8)
#define  PHY_M_PC_SH_TP_SEL		(1 << 6)
#define  PHY_M_PC_RX_FD_MSK		(3 << 2)

#define  PHY_M_PS_SPEED_MSK		(3 << 14)
#define   PHY_M_PS_SPEED_1000			(1 << 15)
#define   PHY_M_PS_SPEED_100			(1 << 14)
#define   PHY_M_PS_SPEED_10			(0)
#define  PHY_M_PS_FULL_DUP		(1 << 13)
#define  PHY_M_PS_PAGE_REC		(1 << 12)
#define  PHY_M_PS_SPDUP_RES		(1 << 11)
#define  PHY_M_PS_LINK_UP		(1 << 10)
#define  PHY_M_PS_CABLE_MSK		(7 << 7)
#define  PHY_M_PS_MDI_X_STAT		(1 << 6)
#define  PHY_M_PS_DOWNS_STAT		(1 << 5)
#define  PHY_M_PS_ENDET_STAT		(1 << 4)
#define  PHY_M_PS_TX_P_EN		(1 << 3)
#define  PHY_M_PS_RX_P_EN		(1 << 2)
#define   PHY_M_PS_PAUSE_MSK			(PHY_M_PS_TX_P_EN |\
						 PHY_M_PS_RX_P_EN)
#define  PHY_M_PS_POL_REV		(1 << 1)
#define  PHY_M_PS_JABBER		(1 << 0)

#define  PHY_M_IS_AN_ERROR		(1 << 15)
#define  PHY_M_IS_LSP_CHANGE		(1 << 14)
#define  PHY_M_IS_DUP_CHANGE		(1 << 13)
#define  PHY_M_IS_AN_PR			(1 << 12)
#define  PHY_M_IS_AN_COMPL		(1 << 11)
#define  PHY_M_IS_LST_CHANGE		(1 << 10)
#define  PHY_M_IS_SYMB_ERROR		(1 << 9)
#define  PHY_M_IS_FALSE_CARR		(1 << 8)
#define  PHY_M_IS_FIFO_ERROR		(1 << 7)
#define  PHY_M_IS_MDI_CHANGE		(1 << 6)
#define  PHY_M_IS_DOWNSH_DET		(1 << 5)
#define  PHY_M_IS_END_CHANGE		(1 << 4)
#define  PHY_M_IS_POL_CHANGE		(1 << 1)
#define  PHY_M_IS_JABBER		(1 << 0)

#define  PHY_M_PC_DIS_LINK_Pa		(1 << 15)
#define  PHY_M_PC_DSC_MSK		(7 << 12)
#define   PHY_M_PC_DSC_MSK_SHIFT		12
#define  PHY_M_PC_DOWN_S_ENA		(1 << 11)
#define  PHY_M_EC_M_DSC_MSK		(3 << 10)
#define   PHY_M_EC_M_DSC_MSK_SHIFT		10
#define  PHY_M_EC_S_DSC_MSK		(3 << 8)
#define   PHY_M_EC_S_DSC_MSK_SHIFT		8
#define  PHY_M_EC_MAC_S_MSK		(7 << 4)
#define   PHY_M_EC_MAC_S_MSK_SHIFT		4
#define   MAC_TX_CLK_0_MHZ			2
#define   MAC_TX_CLK_2_5_MHZ			6
#define   MAC_TX_CLK_25_MHZ			7
#define  PHY_M_EC_FIB_AN_ENA		(1 << 3)
#define  PHY_M_EC_DOWN_S_ENA		(1 << 8)
#define  PHY_M_EC_M_DSC_2_MSK		(3 << 9)
#define   PHY_M_EC_M_DSC_2_SHIFT		9

#define  PHY_M_MAC_MD_MSK		(7 << 7)
#define   PHY_M_MAC_MD_MSK_SHIFT		7
#define   PHY_M_MAC_MD_AUTO			3
#define   PHY_M_MAC_MD_COPPER			5
#define   PHY_M_MAC_MD_1000BX			7
#define  PHY_M_MAC_GMIF_PUP		(1 << 3)

#define  PHY_M_FIB_FORCE_LNK		(1 << 10)
#define  PHY_M_FIB_SIGD_POL		(1 << 9)
#define  PHY_M_FIB_TX_DIS		(1 << 3)

#define  PHY_M_LEDC_DIS_LED		(1 << 15)
#define  PHY_M_LEDC_PULS_MSK		(7 << 12)
#define   PHY_M_LEDC_PULS_MSK_SHIFT		12
#define   PULS_NO_STR				0
#define   PULS_21MS				1
#define   PULS_42MS				2
#define   PULS_84MS				3
#define   PULS_170MS				4
#define   PULS_340MS				5
#define   PULS_670MS				6
#define   PULS_1300MS				7
#define  PHY_M_LEDC_F_INT		(1 << 11)
#define  PHY_M_LEDC_BL_R_MSK		(7 << 8)
#define   PHY_M_LEDC_BL_R_MSK_SHIFT		8
#define   BLINK_42MS				0
#define   BLINK_84MS				1
#define   BLINK_170MS				2
#define   BLINK_340MS				3
#define   BLINK_670MS				4
#define  PHY_M_LEDC_LINK_MSK		(3 << 3)
#define  PHY_M_LEDC_DP_CTRL		(1 << 2)
#define  PHY_M_LEDC_RX_CTRL		(1 << 1)
#define  PHY_M_LEDC_TX_CTRL		(1 << 0)

#define  PHY_M_LED_MO_DUP_SHIFT		10
#define  PHY_M_LED_MO_10_SHIFT		8
#define  PHY_M_LED_MO_100_SHIFT		6
#define  PHY_M_LED_MO_1000_SHIFT	4
#define  PHY_M_LED_MO_RX_SHIFT		2
#define  PHY_M_LED_MO_TX_SHIFT		0

#define   MO_LED_NORM				0
#define   MO_LED_BLINK				1
#define   MO_LED_OFF				2
#define   MO_LED_ON				3

#define  PHY_M_LEDC_LOS_MSK		(15 << 12)
#define   PHY_M_LEDC_LOS_MSK_SHIFT		12
#define  PHY_M_LEDC_INIT_MSK		(15 << 8)
#define   PHY_M_LEDC_INIT_MSK_SHIFT		8
#define  PHY_M_LEDC_STA1_MSK		(15 << 4)
#define   PHY_M_LEDC_STA1_MSK_SHIFT		4
#define  PHY_M_LEDC_STA0_MSK		(15 << 0)
#define   PHY_M_LEDC_STA0_MSK_SHIFT		0
#define  PHY_M_POLC_LS1M_MSK		(15 << 12)
#define   PHY_M_POLC_LS1M_MSK_SHIFT		12
#define  PHY_M_POLC_IS0M_MSK		(15 << 8)
#define   PHY_M_POLC_IS0M_MSK_SHIFT		8
#define  PHY_M_POLC_LOS_MSK		(3 << 6)
#define   PHY_M_POLC_LOS_MSK_SHIFT		6
#define  PHY_M_POLC_INIT_MSK		(3 << 4)
#define   PHY_M_POLC_INIT_MSK_SHIFT		4
#define  PHY_M_POLC_STA1_MSK		(3 << 2)
#define   PHY_M_POLC_STA1_MSK_SHIFT		2
#define  PHY_M_POLC_STA0_MSK		(3 << 0)
#define   PHY_M_POLC_STA0_MSK_SHIFT		0

#define  PHY_M_EC2_FI_IMPED		(1 << 6)
#define  PHY_M_EC2_FO_IMPED		(1 << 5)
#define  PHY_M_EC2_FO_M_CLK		(1 << 4)
#define  PHY_M_EC2_FO_BOOST		(1 << 3)
#define  PHY_M_EC2_FO_AM_MSK		(7 << 0)

#define  PHY_M_FC_AUTO_SEL		(1 << 15)
#define  PHY_M_FC_AN_REG_ACC		(1 << 14)
#define  PHY_M_FC_RESOLUTION		(1 << 13)
#define  PHY_M_SER_IF_AN_BP		(1 << 12)
#define  PHY_M_SER_IF_BP_ST		(1 << 11)
#define  PHY_M_IRQ_POLARITY		(1 << 10)
#define  PHY_M_UNDOC1			(1 << 7)
#define  PHY_M_MODE_MASK		(15 << 0)

#define  PHY_M_CABD_ENA_TEST		(1 << 15)
#define  PHY_M_CABD_STAT_MSK		(3 << 13)
#define  PHY_M_CABD_DIST_MSK		0xff

#define  CABD_STAT_NORMAL		0
#define  CABD_STAT_SHORT		1
#define  CABD_STAT_OPEN			2
#define  CABD_STAT_FAIL			3

#define PHY_MARV_ID0_VAL	0x0141
#define PHY_BCOM_ID1_A1		0x6041
#define PHY_BCOM_ID1_B2		0x6043
#define PHY_BCOM_ID1_C0		0x6044
#define PHY_BCOM_ID1_C5		0x6047
#define PHY_MARV_ID1_B0		0x0C23
#define PHY_MARV_ID1_B2		0x0C25
#define PHY_MARV_ID1_C2		0x0CC2
#define PHY_MARV_ID1_Y2		0x0C91
#define PHY_MARV_ID1_FE		0x0C83
#define PHY_MARV_ID1_ECU	0x0CB0

#endif
