#ifndef _TCPIP_IP_H
#define _TCPIP_IP_H

#include <SPAD/PKT.H>

void INVALID_UDP_CHECKSUM(PACKET *p);

#define REMOVE_IP_OPTIONS						\
do {									\
	if (__unlikely(ip(p)->ip_vhl != IP_VHL)) {			\
		unsigned hlen;						\
		CLONE_PACKET(p, NET$DELAYED_OOM();goto drop);		\
		hlen = IP_HLEN(ip(p)->ip_vhl);				\
		memmove(ip(p) + 1, (__u8 *)ip(p) + hlen, p->data_length - hlen);\
		ip(p)->ip_len = htons(p->data_length -= hlen - sizeof(struct ip));									\
		p->flags &= ~(PKT_OUTPUT_CHECKSUM | PKT_INPUT_CHECKSUM);\
	}								\
} while (0)

/* This macro is big, however the fast path is only 76 bytes --- calling
   a function would be overkill */

#define CHECK_CHECKSUM(magic, ip_offs, invl_label, comp_label, invl_fn)	\
do {									\
	checksum_t ps_checksum = (magic);				\
	if (__likely(p->flags & PKT_INPUT_CHECKSUM)) {			\
		ps_checksum += CHECKSUM_VAL(p);				\
		if (__likely(CHECKSUM_FROM(p) == sizeof(struct ip) - (ip_offs))) {									\
			if (__unlikely(IP_CHECKSUM_FOLD_INVERT(ps_checksum) != 0)) goto invl_label;							\
		} else if (__likely(CHECKSUM_FROM(p) < sizeof(struct ip) - (ip_offs))) {								\
			if (__unlikely(IP_CHECKSUM_FOLD_INVERT(NET$IP_CHECKSUM(IP_CHECKSUM_FOLD_INVERT(ps_checksum), (__u8 *)ip(p) + CHECKSUM_FROM(p), sizeof(struct ip) - (ip_offs) - CHECKSUM_FROM(p))) != 0)) goto invl_label;	\
		} else if (__likely(CHECKSUM_FROM(p) + 1 < p->data_length)) {\
			if (__unlikely(IP_CHECKSUM_FOLD_INVERT(NET$IP_CHECKSUM(ps_checksum, (__u8 *)tcp(p) - (ip_offs), CHECKSUM_FROM(p) - (sizeof(struct ip) - (ip_offs)))) != 0)) goto invl_label;					\
		} else {						\
			ps_checksum -= CHECKSUM_VAL(p);			\
			goto comp_label;				\
		}							\
	} else {							\
		comp_label:						\
		if (__unlikely(IP_CHECKSUM_FOLD_INVERT(NET$IP_CHECKSUM(ps_checksum, (__u8 *)udp(p) - (ip_offs), p->data_length - sizeof(struct ip) + (ip_offs))) != 0)) {								\
			invl_label:					\
			invl_fn(p);					\
			goto drop;					\
		}							\
	}								\
} while (0)

#define CHECK_UDP_CHECKSUM						\
do {									\
	if (__unlikely(!(p->flags & PKT_TCPUDP_CHECKSUM_OK) && __likely(udp(p)->uh_sum))) {								\
		CHECK_CHECKSUM(TCPUDP_MAGIC_CHECKSUM_UNFOLDED(IPPROTO_UDP, p->data_length - sizeof(struct ip)), 2 * sizeof(in_addr_t), invl_udp, comp_udp, INVALID_UDP_CHECKSUM);							\
	}								\
} while (0)

#endif
