#include <STDLIB.H>

#include "TCPIP.H"

#define COUNT_DIV	4

#define TCP_OFFSENSIVE_SIZE	(1 << TCP_OFFENSIVE_ADDRESS_BITS)
#define TCP_OFFSENSIVE_STEPS	((32 + TCP_OFFENSIVE_ADDRESS_BITS - 1) / TCP_OFFENSIVE_ADDRESS_BITS)

typedef struct {
	unsigned seq;
	unsigned idx;
} IPTABLE;
static IPTABLE iptable[TCP_OFFSENSIVE_SIZE] = { 0, 0 };

static unsigned current_seq = 0;
static unsigned level = 0;

typedef struct {
	XLIST_HEAD sockets;
	unsigned long used_size;
} SOCKTABLE;
static SOCKTABLE socktable[TCP_OFFSENSIVE_STEPS][TCP_OFFSENSIVE_SIZE];

static int SOCKTABLE_CMP(const void *s1_, const void *s2_)
{
	const SOCKTABLE *s1 = s1_;
	const SOCKTABLE *s2 = s2_;
	if (sizeof(long) == sizeof(int)) return s2->used_size - s1->used_size;
	if (s1->used_size > s2->used_size) return -1;
	if (s1->used_size < s2->used_size) return 1;
	return 0;
}

static unsigned long COUNT_PKTQ(LIST_HEAD *l)
{
	PACKET *p;
	unsigned long cnt = 0;
	LIST_FOR_EACH(p, l, PACKET, list) cnt += (unsigned long)pkt_allocated(p) / COUNT_DIV;
	return cnt;
}

static void ZAP_SOCKETS(XLIST_HEAD *list, unsigned long need_to_zap)
{
	SOCKTABLE *st;
	unsigned idx;
	unsigned i;
	unsigned long sum;
	TCPIP_SOCKET *s;
	if (__unlikely(level >= TCP_OFFSENSIVE_STEPS)) {
		/*{
			s = LIST_STRUCT(list->next, TCPIP_SOCKET, node_entry);
			__debug_printf("zapping: %08X\n", ntohl(s->remote_addr));
		}*/
		while (!XLIST_EMPTY(list)) {
			s = LIST_STRUCT(list->next, TCPIP_SOCKET, node_entry);
			TCPIP_DESTROY_SOCKET((SOCKET *)s);
		}
		return;
	}
	if (__unlikely(!++current_seq)) {
		memset(iptable, 0, sizeof iptable);
		current_seq = 1;
	}
	st = socktable[level];
	idx = 0;
	while (!XLIST_EMPTY(list)) {
		unsigned n;
		s = LIST_STRUCT(list->next, TCPIP_SOCKET, node_entry);
		DEL_FROM_LIST(&s->node_entry);
#if TCP_OFFSENSIVE_STEPS * TCP_OFFENSIVE_ADDRESS_BITS != 32
		if (__unlikely(level == TCP_OFFSENSIVE_STEPS - 1))
			n = s->remote_addr << (TCP_OFFSENSIVE_STEPS * TCP_OFFENSIVE_ADDRESS_BITS - 32);
		else
#endif
			n = (s->remote_addr >> (32 - TCP_OFFENSIVE_ADDRESS_BITS - level / TCP_OFFENSIVE_ADDRESS_BITS));
		n &= (TCP_OFFSENSIVE_SIZE - 1);
		if (__unlikely(iptable[n].seq != current_seq)) {
			if (__unlikely(idx >= TCP_OFFSENSIVE_SIZE))
				KERNEL$SUICIDE("ZAP_SOCKETS: OVERFLOW ON LEVEL %u, IDX %u", level, idx);
			iptable[n].seq = current_seq;
			iptable[n].idx = idx;
			INIT_XLIST(&st[idx].sockets);
			st[idx].used_size = 0;
			i = idx++;
		} else {
			i = iptable[n].idx;
		}
		ADD_TO_XLIST(&st[i].sockets, &s->node_entry);
		st[i].used_size += s->used_size;
	}
	qsort(st, idx, sizeof(SOCKTABLE), SOCKTABLE_CMP);
	sum = 0;
	for (i = 0; i < idx; i++) {
		st[i].sockets.next->prev = (LIST_ENTRY *)(void *)&st[i].sockets;
		if (sum - i * st[i].used_size >= need_to_zap) {
			/* sum is now used completely differently --- for level to zap */
			sum = (sum - need_to_zap) / i;
			goto found;
		} else {
			sum += st[i].used_size;
		}
	}
	sum = 0;
	found:
	for (; i < idx; i++) {
		st[i].sockets.next->prev = (LIST_ENTRY *)(void *)&st[i].sockets;
	}
	level++;
	for (i = 0; i < idx && st[i].used_size > sum; i++) {
		ZAP_SOCKETS(&st[i].sockets, st[i].used_size - sum);
	}
	level--;
	for (i = 0; i < idx; i++) {
		while (!XLIST_EMPTY(&st[i].sockets)) {
			s = LIST_STRUCT(st[i].sockets.next, TCPIP_SOCKET, node_entry);
			DEL_FROM_LIST(&s->node_entry);
			ADD_TO_XLIST(list, &s->node_entry);
		}
	}
}



void TCPIP_DELETE_OFFENSIVE_SOCKETS(LIST_HEAD *socket_list)
{
	XLIST_HEAD x;
	TCPIP_SOCKET *s;
	unsigned long total_size;
#if __DEBUG_USER_ERRORS
	__critical_printf("NETWORK OUT OF LIMIT\n");
#endif
	total_size = 0;
	LIST_FOR_EACH(s, socket_list, TCPIP_SOCKET, node_entry) {
		total_size += s->used_size = sizeof(TCPIP_SOCKET) / COUNT_DIV
				+ COUNT_PKTQ(&s->sent_queue)
				+ COUNT_PKTQ(&s->out_queue)
				+ COUNT_PKTQ(&s->in_queue)
				+ COUNT_PKTQ(&s->in_ooo_queue);
	}
	socket_list->prev->next = &KERNEL$LIST_END;
	(x.next = socket_list->next)->prev = (LIST_ENTRY *)(void *)&x;
	ZAP_SOCKETS(&x, total_size - (total_size / TCP_OFFENSIVE_ZAP_PART));
	if (__unlikely(XLIST_EMPTY(&x))) {
		INIT_LIST(socket_list);
	} else {
		LIST_ENTRY *l;
		l = x.next;
		while (l->next != &KERNEL$LIST_END) {
			l = l->next;
		}
		(socket_list->next = x.next)->prev = (LIST_ENTRY *)socket_list;
		(socket_list->prev = l)->next = (LIST_ENTRY *)socket_list;
	}
}

