#include <ARCH/IPCHECKS.H>

#include "TCPIP.H"

void UDP_NULL_PACKET(PACKET *p)
{
	ICMP_SEND(p, ICMP_TYPECODE(ICMP_UNREACH, ICMP_UNREACH_PORT), 0);
	p->status = 0;
	CALL_PKT(p);
}

void UDP_PACKET(TCPIP_SOCKET *s, PACKET *p)
{
	if (__unlikely(p->data_length <= sizeof(struct ip) + sizeof(struct udphdr)))
		goto drop;
	DUP_PACKET(p, NULL, NET$DELAYED_OOM(); goto drop);
	if (__unlikely(NET$QALLOC((SOCKET *)s, pkt_allocated(p)))) goto drop;
	if (!s->out_queue_length) {
		s->out_queue_length = pkt_allocated(p);
	} else {
		s->out_queue_length += pkt_allocated(p);
		if (__unlikely(s->out_queue_length >= UDP_MAX_RECEIVE_QUEUE)) {
			s->out_queue_length -= pkt_allocated(p);
			goto drop;
		}
	}
	ADD_TO_LIST_END(&s->in_queue, &p->list);
	WQ_WAKE_ALL_PL(&s->read_wait);
	return;
	drop:
	p->status = 0;
	CALL_PKT(p);
}

#define sio
#include "IPUDP_RW.I"

#undef sio
#include "IPUDP_RW.I"

