#ifndef _TCPIP_SETUP_H
#define _TCPIP_SETUP_H

#include <KERNEL/TIMER.H>
#include <ARCH/BSF.H>

/*
#define RESET_PING_SIZE		737
#define RESET_PING_IP		0xc3711477
#define __IP_LOG		"FS:/LOG.PKT"
*/

#define SOCKET_MCAST_GROUPS	8
#define SOCKET_HASH_DIV		128

#define IP_MIN_MTU		576
#define IP_ID_POOL_SIZE		65536
#define IP_TTL			0xff

#define IPFRAG_MAX_AGE		(JIFFIES_PER_SECOND * 15)
#define IPFRAG_MAX_SIZE		131072

#define ARP_TIMEOUT		(JIFFIES_PER_SECOND / 5 + 1)
#define ARP_TRIES		5
#define ARP_MAX_OUTSTANDING	64
#define ARP_INIT_TIME_TO_LIVE	(JIFFIES_PER_SECOND * 30)
#define ARP_REVALIDATE_TIME	(JIFFIES_PER_SECOND)

/* note: various broken sites send window-scale option but do not understand
   window scales. To keep most of these sites at least somehow operational,
   you must make sure that
   	TCP_INIT_WINDOW / TCP_WINDOW_SCALE > MSS (1460)
   otherwise, the connection hangs or slows down terribly.
   list of buggy sites:
   http://washingtontimes.com/		(?)
   http://ardownload.adobe.com/pub/adobe/reader/win/6.x/6.0/cze/AdbeRdr602_cze_full.exe
   					(?)
   http://www.digitaldogma.org/		(OpenBSD 3.X with pf "scrub in all")
   http://www.rdwarf.com/~kioh/		(Linux 2.4 - 2.6)
   http://www.linuxhardware.net/	(Linux 2.2)
   http://www.testdrive.hp.com/		(True64 Unix 5)
   http://www.osronline.com/ddkx/appendix/imeimes2_35ph.htm
   					(?)
   http://www.dailypennsylvanian.com/	(Sun Solaris 8)
   http://www.brno.cz/			(IPCop 1.20 Linux 2.2 | Sun Solaris 9)
*/

#define TCP_INIT_RTT		(JIFFIES_PER_SECOND * 2 + JIFFIES_PER_SECOND / 2)
#define TCP_MAX_RTT		(JIFFIES_PER_SECOND * 30)
#define TCP_MIN_RTT		(JIFFIES_PER_SECOND / 5 + 1)
#define TCP_CONNECT_TIMEOUT	(JIFFIES_PER_SECOND * 60)
#define TCP_WRITE_TIMEOUT	(JIFFIES_PER_SECOND * 300)
#define TCP_SHUTDOWN_TIMEOUT	(JIFFIES_PER_SECOND * 10)
#define TCP_INIT_WINDOW		24576
#define TCP_MAX_WINDOW		524288
#define TCP_MAX_WRITE_BUFFER	524288
#define TCP_WINDOW_SCALE	(__BSR_CONST(TCP_MAX_WINDOW - 1) > 15 ? __BSR_CONST(TCP_MAX_WINDOW - 1) - 15 : 0)

#define TCP_WRITE_BUFFER_TIME		(JIFFIES_PER_SECOND * 10)
#define TCP_READ_BUFFER_TIME		(JIFFIES_PER_SECOND * 10)
#define TCP_WRITE_BUFFER_FRACT_BITS	8
#define TCP_READ_BUFFER_FRACT_BITS	8
#define TCP_ACK_BACKWARD		(1460 * 5)
#define TCP_RST_REPEATS			3
#define TCP_OFFENSIVE_ADDRESS_BITS	8
#define TCP_OFFENSIVE_ZAP_PART		4	/* zap 1/4 of sockets */

#define UDP_MAX_RECEIVE_QUEUE	65536

#define IGMP_RETRY_TIME		(JIFFIES_PER_SECOND * 5)
#define IGMP_LINKCHG_TIME	(JIFFIES_PER_SECOND * 4)
#define IGMP_V1_PRESENT_TIMEOUT	(JIFFIES_PER_SECOND * 400)

#define RND_REKEY_TIME		300	/* 5 minutes */
#define RND_HASH_BITS		30

#define DHCP_FIRST_TIMEOUT	(JIFFIES_PER_SECOND * 4)
#define DHCP_TIMEOUT_FUZZ	(JIFFIES_PER_SECOND * 1)
#define DHCP_MAX_TIMEOUT	(JIFFIES_PER_SECOND * 64)
#define DHCP_LINKCHG_TIME	(JIFFIES_PER_SECOND / 2) /* should not be too low, because SK card drops packets some time after link change */
#define DHCP_LINKCHG_T1		(JIFFIES_PER_SECOND / 2)
#define DHCP_LINKCHG_T2		(JIFFIES_PER_SECOND)
#define DHCP_LINKCHG_LEASE	(JIFFIES_PER_SECOND * 3)
#define DHCP_TIMEOUT_BACKOFF	* 2
#define DHCP_WAIT_FOR_OFFERS	(JIFFIES_PER_SECOND)
#define DHCP_RESTART_TIME	(JIFFIES_PER_SECOND * 10 + DHCP_TIMEOUT_FUZZ)
#define DHCP_SEC_RESTART_TIME	(JIFFIES_PER_SECOND * 60 * 5)
#define DHCP_REQUEST_RETRIES	4
#define DHCP_MIN_RENEW_TIME	(JIFFIES_PER_SECOND * 60)
#define DHCP_LAST_TRY_TIME	(JIFFIES_PER_SECOND * 2)
#define DHCP_RESERVED_ROUTES	61

#endif
