#ifndef __PORT_PIOREG_H
#define __PORT_PIOREG_H

#include <SPAD/PIO.H>

#define BIOS_LPT_PORTS	3

#define SPP_REGSPACE	3
#define EPP_REGSPACE	5
#define ECP_REGSPACE	3

#define PIO_DATA	0x000
#define PIO_STATUS	0x001
#define  PIO_STATUS_EPP_TIMEOUT	0x01
#define  PIO_STATUS_IRQ		0x04
    /* more in INCLUDE/SPAD/PIO.H */
#define PIO_CTL		0x002
    /* more in INCLUDE/SPAD/PIO.H */
#define  PIO_CTL_IRQ		0x10
#define  PIO_CTL_BIDI		0x20
#define PIO_EPP_ADDR	0x003
#define PIO_EPP_DATA	0x004

#define PIO_ECP_PORTS	0x400

#define PIO_DATA_FIFO	0x400
#define PIO_CFG_A	0x400
#define  PIO_CFG_A_UNSENT	0x03
#define  PIO_CFG_A_BYTE		0x04
#define  PIO_CFG_A_WORD_WIDTH	0x70
#define  PIO_CFG_A_WORD_WIDTH_16	0x00
#define  PIO_CFG_A_WORD_WIDTH_8		0x10
#define  PIO_CFG_A_WORD_WIDTH_32	0x20
#define  PIO_CFG_A_IRQ_LEVEL_TR	0x80
#define PIO_CFG_B	0x401
#define  PIO_CFG_B_DMA		0x07
#define  PIO_CFG_B_DMA_JUMPER_8		0x00
#define  PIO_CFG_B_DMA_1		0x01
#define  PIO_CFG_B_DMA_2		0x02
#define  PIO_CFG_B_DMA_3		0x03
#define  PIO_CFG_B_DMA_JUMPER_16	0x04
#define  PIO_CFG_B_DMA_5		0x05
#define  PIO_CFG_B_DMA_6		0x06
#define  PIO_CFG_B_DMA_7		0x07
#define  PIO_CFG_B_IRQ		0x38
#define  PIO_CFG_B_IRQ_JUMPER		0x00
#define  PIO_CFG_B_IRQ_7		0x08
#define  PIO_CFG_B_IRQ_9		0x10
#define  PIO_CFG_B_IRQ_10		0x18
#define  PIO_CFG_B_IRQ_11		0x20
#define  PIO_CFG_B_IRQ_14		0x28
#define  PIO_CFG_B_IRQ_15		0x30
#define  PIO_CFG_B_IRQ_5		0x38
#define  PIO_CFG_B_IRQ_STATUS	0x40
#define  PIO_CFG_B_COMPRESS	0x80
#define PIO_ECR		0x402
#define  PIO_ECR_FIFO_EMPTY	0x01
#define  PIO_ECR_FIFO_FULL	0x02
#define  PIO_ECR_SERVICE	0x04
#define  PIO_ECR_DMA_ENABLE	0x08
#define  PIO_ECR_ECP_IRQ	0x10
#define  PIO_ECR_MODE		0xe0
    /* more in INCLUDE/SPAD/PIO.H */
#define   PIO_ECR_MODE_FIFO_TEST	0xc0
#define   PIO_ECR_MODE_CONFIGURATION	0xe0

#define PIO_ECP_MAXPORT	0x402

#endif
