static unsigned xpand_str(unsigned char *dst, unsigned char *src, unsigned len, int was_cr, unsigned char *stop)
{
	unsigned char *orig_str = src;
	unsigned char *orig_dst = dst;
	while (len--) {
		if (*src == '\n' && !was_cr) {
			*dst++ = '\r';
			if (__unlikely(dst == stop)) return src - orig_str;
		}
		was_cr = (*dst++ = *src++) == '\r';
		if (__unlikely(dst == stop)) return src - orig_str;
	}
	if (__unlikely(stop != NULL))
		KERNEL$SUICIDE("xpand_str: POSITION NOT FOUND (orig_src %p, src %p, dst %p, stop %p", orig_str, src, dst, stop);
	return dst - orig_dst;
}

