#ifndef __SOUND_HDACODEC_H
#define __SOUND_HDACODEC_H

#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>

void HDA_CODEC_RESPONSE(unsigned codec, __u32 response, int unsolicited);
int HDA_CODEC_REQUEST(unsigned codec, unsigned node, unsigned verb);

int HDA_CODEC_INIT(unsigned codec);
void HDA_CODEC_DESTROY(void);

void HDA_CODEC_SET_FORMAT(int record, unsigned fmt);

#define PLAYBACK_STREAM_ID	0
#define RECORD_STREAM_ID	8

#define HDA_PARAM_LONG_MASK			0x0ffff
#define HDA_PARAM_SHORT_MASK			0x000ff
#define HDA_PARAM_AMP_GAIN_MASK			0x000ff

#define HDA_SET_STREAM_FORMAT			0x20000
#define HDA_SET_AMPLIFIER_GAIN			0x30000
#define  HDA_SET_AMPLIFIER_GAIN_MASK			0x007f
#define  HDA_SET_AMPLIFIER_GAIN_MUTE			0x0080
#define  HDA_SET_AMPLIFIER_GAIN_INDEX_MASK		0x0f00
#define  HDA_SET_AMPLIFIER_GAIN_INDEX_SHIFT		8
#define  HDA_SET_AMPLIFIER_GAIN_SET_RIGHT		0x1000
#define  HDA_SET_AMPLIFIER_GAIN_SET_LEFT		0x2000
#define  HDA_SET_AMPLIFIER_GAIN_SET_INPUT		0x4000
#define  HDA_SET_AMPLIFIER_GAIN_SET_OUTPUT		0x8000
#define HDA_SET_PROCESSING_COEFFICIENT		0x40000
#define HDA_SET_COEFFICIENT_INDEX		0x50000
#define HDA_SET_CONNECTION_SELECT		0x70100
#define HDA_SET_PROCESSING_STATE		0x70300
#define HDA_SET_SDI_SELECT			0x70400
#define HDA_SET_POWER_STATE			0x70500
#define HDA_SET_CHANNEL_STREAM			0x70600
#define  HDA_SET_CHANNEL_SHIFT				0
#define  HDA_SET_STREAM_SHIFT				4
#define HDA_SET_PIN_WIDGET_CONTROL		0x70700
#define  HDA_SET_PIN_WIDGET_CONTROL_H_PHN		0x80
#define  HDA_SET_PIN_WIDGET_CONTROL_OUT			0x40
#define  HDA_SET_PIN_WIDGET_CONTROL_IN			0x20
#define  HDA_SET_PIN_WIDGET_CONTROL_VREF_MASK		0x07
#define HDA_SET_UNSOLICITED_ENABLE		0x70800
#define HDA_SET_PIN_SENSE			0x70900
#define HDA_SET_BEEP_GENERATION_CONTROL		0x70A00
#define HDA_SET_EAPD_BTLENABLE			0x70C00
#define HDA_SET_DIGITAL_CONVERTER_1		0x70D00
#define HDA_SET_DIGITAL_CONVERTER_2		0x70E00
#define HDA_SET_VOLUME_KNOB_CONTROL		0x70F00
#define HDA_SET_GPI_DATA			0x71000
#define HDA_SET_GPI_WAKE_ENABLE_MASK		0x71100
#define HDA_SET_GPI_UNSOLICITED_ENABLE_MASK	0x71200
#define HDA_SET_GPI_STICKY_MASK			0x71300
#define HDA_SET_GPO_DATA			0x71400
#define HDA_SET_GPIO_DATA			0x71500
#define HDA_SET_GPIO_ENABLE_MASK		0x71600
#define HDA_SET_GPIO_DIRECTION			0x71700
#define HDA_SET_GPIO_WAKE_ENABLE_MASK		0x71800
#define HDA_SET_GPIO_UNSOLICITED_ENABLE_MASK	0x71900
#define HDA_SET_GPIO_STICKY_MASK		0x71A00
#define HDA_SET_CONFIG_DEFAULT_BYTES_0		0x71C00
#define HDA_SET_CONFIG_DEFAULT_BYTES_1		0x71D00
#define HDA_SET_CONFIG_DEFAULT_BYTES_2		0x71E00
#define HDA_SET_CONFIG_DEFAULT_BYTES_3		0x71F00
#define HDA_SET_SUBSYSTEM_ID_0			0x72000
#define HDA_SET_SUBSYSTEM_ID_1			0x72100
#define HDA_SET_SUBSYSTEM_ID_2			0x72200
#define HDA_SET_SUBSYSTEM_ID_3			0x72300
#define HDA_SET_STRIPE_CONTROL			0x72400
#define HDA_SET_CODEC_RESET			0x7FF00

#define HDA_GET_STREAM_FORMAT			0xA0000
#define HDA_GET_AMPLIFIER_GAIN			0xB0000
#define  HDA_GET_AMPLIFIER_GAIN_INDEX_MASK		0x000f
#define  HDA_GET_AMPLIFIER_GAIN_INDEX_SHIFT		0
#define  HDA_GET_AMPLIFIER_GAIN_LEFT			0x2000
#define  HDA_GET_AMPLIFIER_GAIN_RIGHT			0
#define  HDA_GET_AMPLIFIER_GAIN_OUTPUT			0x8000
#define  HDA_GET_AMPLIFIER_GAIN_INPUT			0
#define  HDA_GET_AMPLIFIER_GAIN_RESPONSE_MASK		0x0000007f
#define  HDA_GET_AMPLIFIER_GAIN_RESPONSE_MUTE		0x00000080
#define HDA_GET_PROCESSING_COEFICIENT		0xC0000
#define HDA_GET_COEFFICIENT_INDEX		0xD0000
#define HDA_GET_PARAMETER			0xF0000
#define HDA_GET_CONNECTION_SELECT		0xF0100
#define HDA_GET_CONNECTION_LIST_ENTRY		0xF0200
#define HDA_GET_PROCESSING_STATE		0xF0300
#define HDA_GET_SDI_SELECT			0xF0400
#define HDA_GET_POWER_STATE			0xF0500
#define HDA_GET_CHANNEL_STREAM			0xF0600
#define HDA_GET_PIN_WIDGET_CONTROL		0xF0700
#define HDA_GET_UNSOLICITED_ENABLE		0xF0800
#define HDA_GET_PIN_SENSE			0xF0900
#define HDA_GET_BEEP_GENERATION_CONTROL		0xF0A00
#define HDA_GET_EAPD_BTLENABLE			0xF0C00
#define HDA_GET_DIGITAL_CONVERTER		0xF0D00
#define HDA_GET_VOLUME_KNOB_CONTROL		0xF0F00
#define HDA_GET_GPI_DATA			0xF1000
#define HDA_GET_GPI_WAKE_ENABLE_MASK		0xF1100
#define HDA_GET_GPI_UNSOLICITED_ENABLE_MASK	0xF1200
#define HDA_GET_GPI_STICKY_MASK			0xF1300
#define HDA_GET_GPO_DATA			0xF1400
#define HDA_GET_GPIO_DATA			0xF1500
#define HDA_GET_GPIO_ENABLE_MASK		0xF1600
#define HDA_GET_GPIO_DIRECTION			0xF1700
#define HDA_GET_GPIO_WAKE_ENABLE_MASK		0xF1800
#define HDA_GET_GPIO_UNSOLICITED_ENABLE_MASK	0xF1900
#define HDA_GET_GPIO_STICKY_MASK		0xF1A00
#define HDA_GET_CONFIG_DEFAULT_BYTES		0xF1C00
#define  HDA_CONFIG_JACK_SEQUENCE_MASK			0x0000000f
#define  HDA_CONFIG_JACK_SEQUENCE_SHIFT			0
#define  HDA_CONFIG_JACK_DEFAULT_ASSOCIATION_MASK	0x000000f0
#define  HDA_CONFIG_JACK_DEFAULT_ASSOCIATION_SHIFT	4
#define  HDA_CONFIG_JACK_DETECT_OVERRIDE		0x00000100
#define  HDA_CONFIG_COLOR_MASK				0x0000f000
#define  HDA_CONFIG_COLOR_UNKNOWN			0x00000000
#define  HDA_CONFIG_COLOR_BLACK				0x00001000
#define  HDA_CONFIG_COLOR_GREY				0x00002000
#define  HDA_CONFIG_COLOR_BLUE				0x00003000
#define  HDA_CONFIG_COLOR_GREEN				0x00004000
#define  HDA_CONFIG_COLOR_RED				0x00005000
#define  HDA_CONFIG_COLOR_ORANGE			0x00006000
#define  HDA_CONFIG_COLOR_YELLOW			0x00007000
#define  HDA_CONFIG_COLOR_PURPLE			0x00008000
#define  HDA_CONFIG_COLOR_PINK				0x00009000
#define  HDA_CONFIG_COLOR_WHITE				0x0000E000
#define  HDA_CONFIG_COLOR_OTHER				0x0000F000
#define  HDA_CONFIG_CONNECTION_MASK			0x000F0000
#define  HDA_CONFIG_CONNECTION_UNKNOWN			0x00000000
#define  HDA_CONFIG_CONNECTION_1_8			0x00010000
#define  HDA_CONFIG_CONNECTION_1_4			0x00020000
#define  HDA_CONFIG_CONNECTION_ATAPI_INTERNAL		0x00030000
#define  HDA_CONFIG_CONNECTION_RCA			0x00040000
#define  HDA_CONFIG_CONNECTION_OPTICAL			0x00050000
#define  HDA_CONFIG_CONNECTION_OTHER_DIGITAL		0x00060000
#define  HDA_CONFIG_CONNECTION_OTHER_ANALOG		0x00070000
#define  HDA_CONFIG_CONNECTION_MULTICHANNEL_ANALOG	0x00080000
#define  HDA_CONFIG_CONNECTION_XLR_PROFESSIONAL		0x00090000
#define  HDA_CONFIG_CONNECTION_RJ_11_MODEM		0x000a0000
#define  HDA_CONFIG_CONNECTION_COMBINATION		0x000b0000
#define  HDA_CONFIG_CONNECTION_OTHER			0x000f0000
#define  HDA_CONFIG_DEFAULT_DEVICE_MASK			0x00f00000
#define  HDA_CONFIG_DEFAULT_DEVICE_LINE_OUT		0x00000000
#define  HDA_CONFIG_DEFAULT_DEVICE_SPEAKER		0x00100000
#define  HDA_CONFIG_DEFAULT_DEVICE_HP_OUT		0x00200000
#define  HDA_CONFIG_DEFAULT_DEVICE_CD			0x00300000
#define  HDA_CONFIG_DEFAULT_DEVICE_SPDIF_OUT		0x00400000
#define  HDA_CONFIG_DEFAULT_DEVICE_DIGITAL_OTHER_OUT	0x00500000
#define  HDA_CONFIG_DEFAULT_DEVICE_MODEM_LINE_SIDE	0x00600000
#define  HDA_CONFIG_DEFAULT_DEVICE_MODEM_HANDSET_SIDE	0x00700000
#define  HDA_CONFIG_DEFAULT_DEVICE_LINE_IN		0x00800000
#define  HDA_CONFIG_DEFAULT_DEVICE_AUX			0x00900000
#define  HDA_CONFIG_DEFAULT_DEVICE_MIC_IN		0x00a00000
#define  HDA_CONFIG_DEFAULT_DEVICE_TELEPHONY		0x00b00000
#define  HDA_CONFIG_DEFAULT_DEVICE_SPDIF_IN		0x00c00000
#define  HDA_CONFIG_DEFAULT_DEVICE_DIGITAL_OTHER_IN	0x00d00000
#define  HDA_CONFIG_DEFAULT_DEVICE_OTHER		0x00f00000
#define  HDA_CONFIG_LOCATION_MASK			0x3f000000
#define  HDA_CONFIG_LOCATION_PRIMARY_N_A		0x00000000
#define  HDA_CONFIG_LOCATION_PRIMARY_REAR		0x01000000
#define  HDA_CONFIG_LOCATION_PRIMARY_FRONT		0x02000000
#define  HDA_CONFIG_LOCATION_PRIMARY_LEFT		0x03000000
#define  HDA_CONFIG_LOCATION_PRIMARY_RIGHT		0x04000000
#define  HDA_CONFIG_LOCATION_PRIMARY_TOP		0x05000000
#define  HDA_CONFIG_LOCATION_PRIMARY_BOTTOM		0x06000000
#define  HDA_CONFIG_LOCATION_PRIMARY_REAR_PANEL		0x07000000
#define  HDA_CONFIG_LOCATION_PRIMARY_DRIVE_BAY		0x08000000
#define  HDA_CONFIG_LOCATION_INTERNAL_N_A		0x10000000
#define  HDA_CONFIG_LOCATION_INTERNAL_RISER		0x17000000
#define  HDA_CONFIG_LOCATION_INTERNAL_HDMI		0x18000000
#define  HDA_CONFIG_LOCATION_INTERNAL_ATAPI		0x19000000
#define  HDA_CONFIG_LOCATION_SEPARATE_N_A		0x20000000
#define  HDA_CONFIG_LOCATION_SEPARATE_REAR		0x21000000
#define  HDA_CONFIG_LOCATION_SEPARATE_FRONT		0x22000000
#define  HDA_CONFIG_LOCATION_SEPARATE_LEFT		0x23000000
#define  HDA_CONFIG_LOCATION_SEPARATE_RIGHT		0x24000000
#define  HDA_CONFIG_LOCATION_SEPARATE_TOP		0x25000000
#define  HDA_CONFIG_LOCATION_SEPARATE_BOTTOM		0x26000000
#define  HDA_CONFIG_LOCATION_OTHER_N_A			0x30000000
#define  HDA_CONFIG_LOCATION_OTHER_BOTTOM		0x36000000
#define  HDA_CONFIG_LOCATION_OTHER_MOBILE_INSIDE_LID	0x37000000
#define  HDA_CONFIG_LOCATION_OTHER_MOBILE_OUTSIDE_LID	0x38000000
#define  HDA_CONFIG_LOCATION_HI_MASK			0x30000000
#define  HDA_CONFIG_LOCATION_HI_PRIMARY			0x00000000
#define  HDA_CONFIG_LOCATION_HI_INTERNAL		0x10000000
#define  HDA_CONFIG_LOCATION_HI_SEPARATE		0x20000000
#define  HDA_CONFIG_LOCATION_HI_OTHER			0x30000000
#define  HDA_CONFIG_CONNECTIVITY_MASK			0xc0000000
#define  HDA_CONFIG_CONNECTIVITY_JACK			0x00000000
#define  HDA_CONFIG_CONNECTIVITY_NONE			0x40000000
#define  HDA_CONFIG_CONNECTIVITY_FIXED			0x80000000
#define  HDA_CONFIG_CONNECTIVITY_JACK_AND_FIXED		0xc0000000
#define HDA_GET_SUBSYSTEM_ID			0xF2000
#define HDA_GET_STRIPE_CONTROL			0xF2400

#define HDA_VID				0x00
#define HDA_SSID			0x01
#define HDA_RID				0x02
#define HDA_GET_SUBSYSTEM_ID			0xF2000
#define HDA_GET_STRIPE_CONTROL			0xF2400

#define HDA_VID				0x00
#define HDA_SSID			0x01
#define HDA_RID				0x02
#define HDA_SUB_NODE_COUNT		0x04
#define  HDA_SUB_NODE_COUNT_NODES_MASK		0x000000ff
#define  HDA_SUB_NODE_COUNT_NODES_SHIFT		0
#define  HDA_SUB_NODE_COUNT_START_MASK		0x00ff0000
#define  HDA_SUB_NODE_COUNT_START_SHIFT		16
#define HDA_FUNC_GRP_TYPE		0x05
#define  HDA_FUNC_GRP_TYPE_MASK			0x0ff
#define  HDA_FUNC_GRP_TYPE_AUDIO		0x001
#define  HDA_FUNC_GRP_TYPE_MODEM		0x002
#define  HDA_FUNC_GRP_TYPE_UNSOL_CAPABLE	0x100
#define HDA_AUD_FG_CAP			0x08
#define  HDA_AUD_FG_CAP_OUTPUT_DELAY_MASK	0x0000f
#define  HDA_AUD_FG_CAP_OUTPUT_DELAY_SHIFT	0
#define  HDA_AUD_FG_CAP_INPUT_DELAY_MASK	0x00f00
#define  HDA_AUD_FG_CAP_INPUT_DELAY_SHIFT	8
#define  HDA_AUD_FG_CAP_BEEP_GEN		0x10000
#define HDA_AUD_WIDGET_CAP		0x09
#define  HDA_AUD_WIDGET_CAP_STEREO		0x00000001
#define  HDA_AUD_WIDGET_CAP_IN_AMP_PRESENT	0x00000002
#define  HDA_AUD_WIDGET_CAP_OUT_AMP_PRESENT	0x00000004
#define  HDA_AUD_WIDGET_CAP_AMP_PARAM_OVERRIDE	0x00000008
#define  HDA_AUD_WIDGET_CAP_FORMAT_OVERRIDE	0x00000010
#define  HDA_AUD_WIDGET_CAP_STRIPE		0x00000020
#define  HDA_AUD_WIDGET_CAP_PROC_WIDGET		0x00000040
#define  HDA_AUD_WIDGET_CAP_UNSOL_CAPABLE	0x00000080
#define  HDA_AUD_WIDGET_CAP_CONN_LIST		0x00000100
#define  HDA_AUD_WIDGET_CAP_DIGITAL		0x00000200
#define  HDA_AUD_WIDGET_CAP_POWER_CNTRL		0x00000400
#define  HDA_AUD_WIDGET_CAP_L_R_SWAP		0x00000800
#define  HDA_AUD_WIDGET_CAP_DELAY_MASK		0x000f0000
#define  HDA_AUD_WIDGET_CAP_DELAY_SHIFT		16
#define  HDA_AUD_WIDGET_CAP_TYPE_MASK		0x00f00000
#define  HDA_AUD_WIDGET_CAP_TYPE_AUDIO_OUTPUT	0x00000000
#define  HDA_AUD_WIDGET_CAP_TYPE_AUDIO_INPUT	0x00100000
#define  HDA_AUD_WIDGET_CAP_TYPE_AUDIO_MIXER	0x00200000
#define  HDA_AUD_WIDGET_CAP_TYPE_AUDIO_SELECTOR	0x00300000
#define  HDA_AUD_WIDGET_CAP_TYPE_PIN_COMPLEX	0x00400000
#define  HDA_AUD_WIDGET_CAP_TYPE_POWER_WIDGET	0x00500000
#define  HDA_AUD_WIDGET_CAP_TYPE_VOLUME_KNOB	0x00600000
#define  HDA_AUD_WIDGET_CAP_TYPE_BEEP_GENERATOR	0x00700000
#define  HDA_AUD_WIDGET_CAP_TYPE_VENDOR_DEFINED	0x00f00000
#define HDA_SAMPLE_SZ_RATE_CAP		0x0A
#define  HDA_SAMPLE_SZ_RATE_CAP_8000		0x00000001
#define  HDA_SAMPLE_SZ_RATE_CAP_11025		0x00000002
#define  HDA_SAMPLE_SZ_RATE_CAP_16000		0x00000004
#define  HDA_SAMPLE_SZ_RATE_CAP_22050		0x00000008
#define  HDA_SAMPLE_SZ_RATE_CAP_32000		0x00000010
#define  HDA_SAMPLE_SZ_RATE_CAP_44100		0x00000020
#define  HDA_SAMPLE_SZ_RATE_CAP_48000		0x00000040
#define  HDA_SAMPLE_SZ_RATE_CAP_88200		0x00000080
#define  HDA_SAMPLE_SZ_RATE_CAP_96000		0x00000100
#define  HDA_SAMPLE_SZ_RATE_CAP_176400		0x00000200
#define  HDA_SAMPLE_SZ_RATE_CAP_192000		0x00000400
#define  HDA_SAMPLE_SZ_RATE_CAP_384000		0x00000800
#define  HDA_SAMPLE_SZ_RATE_CAP_8B		0x00010000
#define  HDA_SAMPLE_SZ_RATE_CAP_16B		0x00020000
#define  HDA_SAMPLE_SZ_RATE_CAP_20B		0x00040000
#define  HDA_SAMPLE_SZ_RATE_CAP_24B		0x00080000
#define  HDA_SAMPLE_SZ_RATE_CAP_32B		0x00100000
#define HDA_STREAM_FMT			0x0B
#define  HDA_STREAM_FMT_PCM			0x00000001
#define  HDA_STREAM_FMT_FLOAT32			0x00000002
#define  HDA_STREAM_FMT_AC3			0x00000004
#define HDA_PIN_CAP			0x0C
#define  HDA_PIN_CAP_IMPEDANCE_SENSE		0x00000001
#define  HDA_PIN_CAP_TRIGGER_REQUIRED		0x00000002
#define  HDA_PIN_CAP_PRESENCE_DETECT		0x00000004
#define  HDA_PIN_CAP_HEADPHONE_DRIVE		0x00000008
#define  HDA_PIN_CAP_OUTPUT			0x00000010
#define  HDA_PIN_CAP_INPUT			0x00000020
#define  HDA_PIN_CAP_BALANCED_IO_PINS		0x00000040
#define  HDA_PIN_CAP_VREF_MASK			0x0000ff00
#define  HDA_PIN_CAP_VREF_HI_Z			0x00000100
#define  HDA_PIN_CAP_VREF_50			0x00000200
#define  HDA_PIN_CAP_VREF_GROUND		0x00000400
#define  HDA_PIN_CAP_VREF_80			0x00001000
#define  HDA_PIN_CAP_VREF_100			0x00002000
#define  HDA_PIN_CAP_EAPD			0x00010000
#define HDA_IN_AMP_CAP			0x0D
#define  HDA_AMP_CAP_OFFSET_MASK		0x0000007f
#define  HDA_AMP_CAP_OFFSET_SHIFT		0
#define  HDA_AMP_CAP_STEPS_MASK			0x00007f00
#define  HDA_AMP_CAP_STEPS_SHIFT		8
#define  HDA_AMP_CAP_STEP_SIZE_MASK		0x007f0000
#define  HDA_AMP_CAP_STEP_SIZE_SHIFT		16
#define  HDA_AMP_CAP_MUTE			0x80000000
#define HDA_CONNECTION_LIST_LENGTH	0x0E
#define  HDA_CONNECTION_LIST_LENGTH_MASK	0x0000007f
#define  HDA_CONNECTION_LIST_LENGTH_LONG	0x00000080
#define HDA_SUPPORTED_POWER_STATE	0x0F
#define  HDA_SUPPORTED_POWER_STATE_D0		0x00000001
#define  HDA_SUPPORTED_POWER_STATE_D1		0x00000002
#define  HDA_SUPPORTED_POWER_STATE_D2		0x00000004
#define  HDA_SUPPORTED_POWER_STATE_D3		0x00000008
#define HDA_PROCESSING_CAP		0x10
#define  HDA_PROCESSING_CAP_BENIGN		0x00000001
#define  HDA_PROCESSING_CAP_NUM_COEF_MASK	0x0000ff00
#define  HDA_PROCESSING_CAP_NUM_COEF_SHIFT	8
#define HDA_GPIO_COUNT			0x11
#define  HDA_GPIO_COUNT_NUM_GPIOS_MASK		0x000000ff
#define  HDA_GPIO_COUNT_NUM_GPIOS_SHIFT		0
#define  HDA_GPIO_COUNT_NUM_GPOS_MASK		0x0000ff00
#define  HDA_GPIO_COUNT_NUM_GPOS_SHIFT		8
#define  HDA_GPIO_COUNT_NUM_GPIS_MASK		0x00ff0000
#define  HDA_GPIO_COUNT_NUM_GPIS_SHIFT		16
#define  HDA_GPIO_COUNT_NUM_GPI_UNSOL		0x40000000
#define  HDA_GPIO_COUNT_NUM_GPI_WAKE		0x80000000
#define HDA_OUT_AMP_CAP			0x12
#define HDA_VOLUME_KNOB_CAP		0x13
#define  HDA_VOLUME_KNOB_CAP_NUM_STEPS_MASK	0x0000007f
#define  HDA_VOLUME_KNOB_CAP_DELTA		0x00000080

#endif
