#ifndef __SOUND_OSS_H
#define __SOUND_OSS_H

#include <SPAD/DEV_KRNL.H>

extern IO_STUB OSS_READ;
extern IO_STUB OSS_WRITE;
extern IO_STUB OSS_IOCTL;

void *OSS_LOOKUP(HANDLE *h, char *str, int open_flags);
void OSS_LOOKUP_IO(HANDLE *h, char *str, IORQ *rq, int open_flags);
void *OSS_INSTANTIATE(HANDLE *h, IORQ *rq, int open_flags);
int OSS_CLOSE(HANDLE *h, IORQ *rq);
PAGE *OSS_GET_PAGE(HANDLE *h, __v_off idx, int wr);
IORQ *OSS_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int wr);
void OSS_SET_ROOT(HANDLE *h, void *f);

#define FORMAT_RATE(h)		((h)->flags & 0x7ffff)
#define FORMAT_CHANNELS(h)	(((h)->flags >> 19) & 1)
#define FORMAT_FRAGS(h)		(((h)->flags >> 20) & 0xfff)
#define FORMAT_FORMAT(h)	((h)->flags2 & 0xf)
#define FORMAT_FRAGSIZE(h)	(((h)->flags2 >> 4) & 0x1f)
#define FORMAT_NONBLOCK(h)	(((h)->flags2 >> 9) & 1)
#define FORMAT_SUBDIVIDE(h)	(((h)->flags2 >> 10) & 0x3fff)

#define FORMAT_SETRATE(h, r)	((h)->flags = ((h)->flags & ~0x7ffffL) | (r))
#define FORMAT_SETCHANNELS(h, c) ((h)->flags = ((h)->flags & ~0x80000L) | (c) << 19)
#define FORMAT_SETFRAGS(h, f)	((h)->flags = ((h)->flags & ~0xfff00000L) | (f) << 20)
#define FORMAT_SETFORMAT(h, f)	((h)->flags2 = ((h)->flags2 & ~0xfL) | (f))
#define FORMAT_SETFRAGSIZE(h, f) ((h)->flags2 = ((h)->flags2 & ~0x1f0L) | (f) << 4)
#define FORMAT_SETNONBLOCK(h, b) ((h)->flags2 = ((h)->flags2 & ~0x200L) | (b) << 9)
#define FORMAT_SETSUBDIVIDE(h, s) ((h)->flags2 = ((h)->flags2 & ~0xfffc00L) | (s) << 10)

#define FORMAT_MAXRATE		0x7ffff
#define FORMAT_MAXCHANNELS	0x1
#define FORMAT_MAXFRAGS		0xfff
#define FORMAT_MAXFORMAT	0xf
#define FORMAT_MAXFRAGSIZE	0x1f
#define FORMAT_MAXNONBLOCK	0x1
#define FORMAT_MAXSUBDIVIDE	0x3fff

extern int OSS_STREAM_FLAGS[OSS_N_STREAMS];
#define OSS_RUNNING		0x01
#define OSS_CONTENTION_STOP	0x02
#define OSS_BLOCK		0x04
#define OSS_LOOP		0x08

extern int oss_frags[OSS_N_STREAMS], oss_fragsize_bits[OSS_N_STREAMS];
extern int oss_fragment[OSS_N_STREAMS], oss_buf_fragments[OSS_N_STREAMS];
extern int oss_rate[OSS_N_STREAMS], oss_channels[OSS_N_STREAMS], oss_format[OSS_N_STREAMS];
extern off_t oss_file_pos[OSS_N_STREAMS];

extern int oss_stat_bytes[OSS_N_STREAMS], oss_stat_frags[OSS_N_STREAMS];
extern unsigned long oss_stat_bytes_drop[OSS_N_STREAMS];
extern int oss_stat_underruns[OSS_N_STREAMS];

extern WQ OSS_STREAM_WAIT[OSS_N_STREAMS];

int OSS_ALLOC_DMAPAGES(unsigned n_pages, unsigned page_size);
void OSS_FREE_DMAPAGES(void);
extern unsigned N_PAGES, PAGESIZE_BITS;

struct page_desc {
	void *virtual;
#if defined(OSS_ISA_DMA)
	unsigned physical;
#else
	__p_addr physical;
#if defined(OSS_DMA_CAPABLE_64)
	__u64 device;
#else
	__u32 device;
#endif
	union {
		vspace_dmaunlock_t *unlock32;
#if defined(OSS_DMA_CAPABLE_64)
		vspace_dma64unlock_t *unlock64;
#endif
	} u;
#endif
};

extern struct page_desc *DATA_PAGES[OSS_N_STREAMS];

void SND_FIXUP_PARAMS(HANDLE *h, int open_flags);
void SND_STOP(int stream);
void SND_START(int stream);
void SND_PAUSE(int stream);
void SND_RESUME(int stream);
void SND_SUBMIT_FRAGMENT(int stream, int frag);
unsigned SND_GET_PTR(int stream);

long SND_MIXER_READ(unsigned mix);
void SND_MIXER_WRITE(unsigned mix, unsigned long val);
long SND_MIXER_READ_RECSRC(void);
void SND_MIXER_WRITE_RECSRC(unsigned long mask);
long SND_MIXER_READ_OUTSRC(void);
void SND_MIXER_WRITE_OUTSRC(unsigned long mask);

void OSS_INIT(void);
void OSS_STOP_ALL(int except);
void OSS_STOP(int stream);
int OSS_STREAM_INTR(int stream);

#ifndef OSS_FIXED_RATES
#define OSS_GET_RATE(x)		(x)
#else
#define OSS_GET_RATE(x)		((OSS_FIXED_RATES) ? (RATELIST[x]) : (x))
#endif

#ifdef OSS_DEFINE_TIMEOUT
jiffies_t RAW_TIMEOUT(int fragsize_bits, int format, int channels, int rate);
jiffies_t OSS_STREAM_TIMEOUT(int stream);
#endif
#ifdef OSS_DEFINE_FRAGINTR
jiffies_t RAW_FRAGINTR(int fragsize_bits, int format, int channels, int rate);
jiffies_t OSS_STREAM_FRAGINTR(int stream);
#endif

#define STREAM_IS_RECORD(stream)	(stream)

#define ASSERT_PLAYBACK_STREAM(stream)				\
do {								\
	if (__DEBUG >= 2 && __unlikely((stream) != 0))		\
		KERNEL$SUICIDE("ASSERT_PLAYBACK_STREAM: FAILED FOR STREAM %d", stream);								\
	(stream) = 0;						\
} while (0)

#define ASSERT_RECORD_STREAM(stream)				\
do {								\
	if (__DEBUG >= 2 && __unlikely((stream) != 1))		\
		KERNEL$SUICIDE("ASSERT_RECORD_STREAM: FAILED FOR STREAM %d", stream);								\
	(stream) = 1;						\
} while (0)

#endif

