#ifndef __SOUND_SBREG_H
#define __SOUND_SBREG_H

#define SB_REGSPACE	0x10

#define SB_MIXER_ADDR	0x04
#define SB_MIXER_DATA	0x05
#define SB_RESET	0x06
#define SB_READ		0x0a
#define SB_WRITE	0x0c
#define SB_WRITE_STATUS	0x0c
#define  SB_WRITE_BUSY		0x80
#define SB_READ_STATUS	0x0e
#define  SB_READ_READY		0x80
#define SB_ACK_INTR16	0x0f

/* SB 1.0 ... */

#define SBCMD_8BIT_DIRECT_OUTPUT		0x10
#define SBCMD_8BIT_SINGLE_DMA_OUTPUT		0x14
#define SBCMD_ADPCM2_SINGLE_DMA_OUTPUT		0x16
#define SBCMD_ADPCM2REF_SINGLE_DMA_OUTPUT	0x17
#define SBCMD_8BIT_DIRECT_INPUT			0x20
#define SBCMD_8BIT_SINGLE_DMA_INPUT		0x24
#define SBCMD_MIDI_POLLING_INPUT		0x30
#define SBCMD_MIDI_INTERRUPT_INPUT		0x31
#define SBCMD_MIDI_OUTPUT			0x38
#define SBCMD_SET_TIME_CONSTANT			0x40
#define SBCMD_ADPCM4_SINGLE_DMA_OUTPUT		0x74
#define SBCMD_ADPCM4REF_SINGLE_DMA_OUTPUT	0x75
#define SBCMD_ADPCM3_SINGLE_DMA_OUTPUT		0x76
#define SBCMD_ADPCM3REF_SINGLE_DMA_OUTPUT	0x77
#define SBCMD_PAUSE_OUTPUT_FOR_A_DURATION	0x80
#define SBCMD_8BIT_PAUSE_DMA			0xd0
#define SBCMD_SPEAKER_ON			0xd1
#define SBCMD_SPEAKER_OFF			0xd3
#define SBCMD_8BIT_CONTINUE_DMA			0xd4
#define SBCMD_GET_DSP_VERSION			0xe1

/* SB 2.0 ... */

#define SBCMD_8BIT_AUTO_DMA_OUTPUT		0x1c
#define SBCMD_ADPCM2REF_AUTO_DMA_OUTPUT		0x1f
#define SBCMD_8BIT_AUTO_DMA_INPUT		0x2c
#define SBCMD_UART_POLLING_MODE			0x34
#define SBCMD_UART_INTERRUPT_MODE		0x35
#define SBCMD_UART_POLLING_TIMESTAMP_MODE	0x36
#define SBCMD_UART_INTERRUPT_TIMESTAMP_MODE	0x37
#define SBCMD_SET_TRANSFER_SIZE			0x48
#define SBCMD_ADPCM4REF_AUTO_DMA_OUTPUT		0x7d
#define SBCMD_ADPCM3REF_AUTO_DMA_OUTPUT		0x7f
#define SBCMD_GET_SPEAKER_STATUS		0xd8
#define SBCMD_8BIT_EXIT_AUTO_DMA		0xda

/* SB 2.01, SB 3.x */

#define SBCMD_8BIT_HIGHSPEED_AUTO_DMA_OUTPUT	0x90
#define SBCMD_8BIT_HIGHSPEED_SINGLE_DMA_OUTPUT	0x91
#define SBCMD_8BIT_HIGHSPEED_AUTO_DMA_INPUT	0x98
#define SBCMD_8BIT_HIGHSPEED_SINGLE_DMA_INPUT	0x99

/* SB 3.x */

#define SBCMD_INPUT_MONO			0xa0
#define SBCMD_INPUT_STEREO			0xa8

/* SB 4.x */

#define SBCMD_SET_OUTPUT_SAMPLING_RATE		0x41
#define SBCMD_SET_INPUT_SAMPLING_RATE		0x42
#define SBCMD_16BIT_IO				0xb0
#define SBCMD_8BIT_IO				0xc0
#define  SBCMD_IO_FIFO					0x02
#define  SBCMD_IO_AUTO_DMA				0x04
#define  SBCMD_IO_INPUT					0x08
#define  SBCMD_IOMODE_SIGNED				0x10
#define  SBCMD_IOMODE_STEREO				0x20
#define SBCMD_16BIT_PAUSE_DMA			0xd5
#define SBCMD_16BIT_CONTINUE_DMA		0xd6
#define SBCMD_16BIT_EXIT_AUTO_DMA		0xd9

/* Mixer */

#define SBMIXER_RESET			0x00
#define SBMIXER2_MASTER			0x02
#define  SBMIXER2_MASTER_MASK			0x0e
#define SBMIXER34_VOICE			0x04
#define  SBMIXER34_VOICE_RIGHT_MASK		0x0e
#define  SBMIXER34_VOICE_LEFT_MASK		0xe0
#define SBMIXER2_MIDI			0x06
#define  SBMIXER2_MIDI_MASK			0x0e
#define SBMIXER2_CD			0x08
#define  SBMIXER2_CD_MASK			0x0e
#define SBMIXER2_VOICE			0x0a
#define  SBMIXER2_VOICE_MASK			0x06
#define SBMIXER34_MIC			0x0a
#define  SBMIXER34_MIC_MASK			0x06
#define SBMIXER3_INPUT			0x0c
#define  SBMIXER3_INPUT_SOURCE_MASK		0x06
#define  SBMIXER3_INPUT_SOURCE_MIC		0x00
#define  SBMIXER3_INPUT_SOURCE_CD		0x02
#define  SBMIXER3_INPUT_SOURCE_MIC2		0x04
#define  SBMIXER3_INPUT_SOURCE_LINE		0x06
#define  SBMIXER3_INPUT_LOW_PASS_8		0x08
#define  SBMIXER3_INPUT_LOW_PASS_DIS		0x20
#define SBMIXER3_OUTPUT			0x0e
#define  SBMIXER3_OUTPUT_STEREO			0x02
#define  SBMIXER3_OUTPUT_LOW_PASS_DIS		0x20
#define SBMIXER34_MASTER			0x22
#define  SBMIXER34_MASTER_RIGHT_MASK		0x0e
#define  SBMIXER34_MASTER_LEFT_MASK		0xe0
#define SBMIXER34_MIDI			0x26
#define  SBMIXER34_MIDI_RIGHT_MASK		0x0e
#define  SBMIXER34_MIDI_LEFT_MASK		0xe0
#define SBMIXER34_CD			0x28
#define  SBMIXER34_CD_RIGHT_MASK		0x0e
#define  SBMIXER34_CD_LEFT_MASK			0xe0
#define SBMIXER34_LINE			0x2e
#define  SBMIXER34_LINE_RIGHT_MASK		0x0e
#define  SBMIXER34_LINE_LEFT_MASK		0xe0
#define SBMIXER4_MASTER_LEFT		0x30
#define  SBMIXER4_MASTER_LEFT_MASK		0xf8
#define SBMIXER4_MASTER_RIGHT		0x31
#define  SBMIXER4_MASTER_RIGHT_MASK		0xf8
#define SBMIXER4_VOICE_LEFT		0x32
#define  SBMIXER4_VOICE_LEFT_MASK		0xf8
#define SBMIXER4_VOICE_RIGHT		0x33
#define  SBMIXER4_VOICE_RIGHT_MASK		0xf8
#define SBMIXER4_MIDI_LEFT		0x34
#define  SBMIXER4_MIDI_LEFT_MASK		0xf8
#define SBMIXER4_MIDI_RIGHT		0x35
#define  SBMIXER4_MIDI_RIGHT_MASK		0xf8
#define SBMIXER4_CD_LEFT		0x36
#define  SBMIXER4_CD_LEFT_MASK			0xf8
#define SBMIXER4_CD_RIGHT		0x37
#define  SBMIXER4_CD_RIGHT_MASK			0xf8
#define SBMIXER4_LINE_LEFT		0x38
#define  SBMIXER4_LINE_LEFT_MASK		0xf8
#define SBMIXER4_LINE_RIGHT		0x39
#define  SBMIXER4_LINE_RIGHT_MASK		0xf8
#define SBMIXER4_MIC			0x3a
#define  SBMIXER4_MIC_MASK			0xf8
#define SBMIXER4_SPEAKER		0x3b
#define  SBMIXER4_SPEAKER_MASK			0xc0
#define SBMIXER4_OUTPUT_SWITCH		0x3c
#define  SBMIXER4_OUTPUT_SWITCH_MIC		0x01
#define  SBMIXER4_OUTPUT_SWITCH_CD_R		0x02
#define  SBMIXER4_OUTPUT_SWITCH_CD_L		0x04
#define  SBMIXER4_OUTPUT_SWITCH_LINE_R		0x08
#define  SBMIXER4_OUTPUT_SWITCH_LINE_L		0x10
#define SBMIXER4_INPUT_LEFT_SWITCH	0x3d
#define SBMIXER4_INPUT_RIGHT_SWITCH	0x3e
#define  SBMIXER4_INPUT_SWITCH_MIC		0x01
#define  SBMIXER4_INPUT_SWITCH_CD_R		0x02
#define  SBMIXER4_INPUT_SWITCH_CD_L		0x04
#define  SBMIXER4_INPUT_SWITCH_LINE_R		0x08
#define  SBMIXER4_INPUT_SWITCH_LINE_L		0x10
#define  SBMIXER4_INPUT_SWITCH_MIDI_R		0x20
#define  SBMIXER4_INPUT_SWITCH_MIDI_L		0x40
#define SBMIXER4_INPUT_GAIN_LEFT	0x3f
#define  SBMIXER4_INPUT_GAIN_LEFT_MASK		0xc0
#define SBMIXER4_INPUT_GAIN_RIGHT	0x40
#define  SBMIXER4_INPUT_GAIN_RIGHT_MASK		0xc0
#define SBMIXER4_OUTPUT_GAIN_LEFT	0x41
#define  SBMIXER4_OUTPUT_GAIN_LEFT_MASK		0xc0
#define SBMIXER4_OUTPUT_GAIN_RIGHT	0x42
#define  SBMIXER4_OUTPUT_GAIN_RIGHT_MASK	0xc0
#define SBMIXER4_AGC			0x43
#define  SBMIXER4_AGC_BIT			0x01
#define SBMIXER4_TREBLE_LEFT		0x44
#define  SBMIXER4_TREBLE_LEFT_MASK		0xf0
#define SBMIXER4_TREBLE_RIGHT		0x45
#define  SBMIXER4_TREBLE_RIGHT_MASK		0xf0
#define SBMIXER4_BASS_LEFT		0x46
#define  SBMIXER4_BASS_LEFT_MASK		0xf0
#define SBMIXER4_BASS_RIGHT		0x47
#define  SBMIXER4_BASS_RIGHT_MASK		0xf0
#define SBMIXER_IRQ_STAT		0x82

#endif
